/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.alignment;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.biojava.nbio.core.alignment.template.AlignedSequence;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.Strand;
import org.biojava.nbio.core.sequence.location.SimpleLocation;
import org.biojava.nbio.core.sequence.location.template.Location;
import org.biojava.nbio.core.sequence.location.template.Point;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.core.sequence.template.SequenceMixin;
import org.biojava.nbio.core.sequence.template.SequenceView;
import org.biojava.nbio.core.util.Equals;

public class SimpleAlignedSequence<S extends Sequence<C>, C extends Compound>
implements Serializable,
AlignedSequence<S, C> {
    private static final long serialVersionUID = 1L;
    private static final String gap = "-";
    private AlignedSequence<S, C> prev;
    private S original;
    private int length;
    private int numBefore;
    private int numAfter;
    private Location location;
    private int numGaps = -1;
    private int numGapPositions = -1;
    private int[] alignmentFromSequence;
    private int[] sequenceFromAlignment;

    public SimpleAlignedSequence(S original, List<AlignedSequence.Step> steps) {
        this(original, steps, 0, 0);
    }

    public SimpleAlignedSequence(S original, List<AlignedSequence.Step> steps, int numBefore, int numAfter) {
        this.original = original;
        this.numBefore = numBefore;
        this.numAfter = numAfter;
        this.length = steps.size();
        this.setLocation(steps);
    }

    public SimpleAlignedSequence(AlignedSequence<S, C> prev, List<AlignedSequence.Step> steps) {
        this(prev, steps, 0, 0);
    }

    public SimpleAlignedSequence(AlignedSequence<S, C> prev, List<AlignedSequence.Step> steps, int numBefore, int numAfter) {
        this.prev = prev;
        this.original = prev.getOriginalSequence();
        this.numBefore = numBefore;
        this.numAfter = numAfter;
        if (prev instanceof SimpleAlignedSequence) {
            SimpleAlignedSequence p = (SimpleAlignedSequence)prev;
            this.numBefore += p.numBefore;
            this.numAfter += p.numAfter;
        }
        this.length = steps.size();
        this.setLocation(steps);
    }

    @Override
    public void clearCache() {
        this.alignmentFromSequence = null;
        this.sequenceFromAlignment = null;
    }

    private void setAlignmentFromSequence() {
        this.alignmentFromSequence = new int[this.original.getLength()];
        int s = 1;
        int a = 1;
        int i = 0;
        while (i < this.numBefore) {
            this.alignmentFromSequence[s - 1] = a;
            ++i;
            ++s;
        }
        while (s <= this.alignmentFromSequence.length && a <= this.length) {
            while (a <= this.length && this.isGap(a)) {
                ++a;
            }
            this.alignmentFromSequence[s - 1] = a++;
            ++s;
        }
        --a;
        i = 0;
        while (i < this.numAfter) {
            this.alignmentFromSequence[s - 1] = a;
            ++i;
            ++s;
        }
    }

    @Override
    public int[] getAlignmentFromSequence() {
        if (this.alignmentFromSequence == null) {
            this.setAlignmentFromSequence();
        }
        return this.alignmentFromSequence;
    }

    @Override
    public int getAlignmentIndexAt(int sequenceIndex) {
        if (this.alignmentFromSequence == null) {
            this.setAlignmentFromSequence();
        }
        return this.alignmentFromSequence[sequenceIndex - 1];
    }

    @Override
    public Point getEnd() {
        return this.location.getEnd();
    }

    @Override
    public Location getLocationInAlignment() {
        return this.location;
    }

    @Override
    public int getNumGaps() {
        if (this.numGaps == -1) {
            this.numGaps = 0;
            this.numGapPositions = 0;
            C cGap = this.getCompoundSet().getCompoundForString(gap);
            boolean inGap = false;
            for (Compound compound : this.getAsList()) {
                if (compound == null || compound.equalsIgnoreCase((Compound)cGap)) {
                    if (!inGap) {
                        ++this.numGaps;
                        inGap = true;
                    }
                    ++this.numGapPositions;
                    continue;
                }
                inGap = false;
            }
        }
        return this.numGaps;
    }

    @Override
    public S getOriginalSequence() {
        return this.original;
    }

    @Override
    public int getOverlapCount() {
        return 1;
    }

    private void setSequenceFromAlignment() {
        this.sequenceFromAlignment = new int[this.length];
        int a = 1;
        int s = this.numBefore + 1;
        int i = 0;
        while (i < this.getStart().getPosition()) {
            this.sequenceFromAlignment[a - 1] = s;
            ++i;
            ++a;
        }
        while (a <= this.length) {
            if (!this.isGap(a)) {
                // empty if block
            }
            this.sequenceFromAlignment[a - 1] = ++s;
            ++a;
        }
    }

    @Override
    public int[] getSequenceFromAlignment() {
        if (this.sequenceFromAlignment == null) {
            this.setSequenceFromAlignment();
        }
        return this.sequenceFromAlignment;
    }

    @Override
    public int getSequenceIndexAt(int alignmentIndex) {
        if (this.sequenceFromAlignment == null) {
            this.setSequenceFromAlignment();
        }
        return this.sequenceFromAlignment[alignmentIndex - 1];
    }

    @Override
    public Point getStart() {
        return this.location.getStart();
    }

    @Override
    public boolean isCircular() {
        return this.location.isCircular();
    }

    @Override
    public boolean isGap(int alignmentIndex) {
        if (this.getStart().getPosition() <= alignmentIndex && alignmentIndex <= this.getEnd().getPosition()) {
            if (!this.location.isComplex()) {
                return false;
            }
            for (Location sublocation : this.location) {
                if (sublocation.getStart().getPosition() > alignmentIndex || alignmentIndex > sublocation.getEnd().getPosition()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int countCompounds(C ... compounds) {
        int count = 0;
        List<C> search = Arrays.asList(compounds);
        for (Compound compound : this.getAsList()) {
            if (!search.contains(compound)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public AccessionID getAccession() {
        return this.original.getAccession();
    }

    @Override
    public List<C> getAsList() {
        ArrayList<C> compounds = new ArrayList<C>();
        for (int i = 1; i <= this.length; ++i) {
            compounds.add(this.getCompoundAt(i));
        }
        return compounds;
    }

    public boolean equals(Object o) {
        if (!Equals.classEqual(this, o)) {
            return false;
        }
        Sequence other = (Sequence)o;
        if (this.original.getAsList().size() != other.getAsList().size()) {
            return false;
        }
        for (int i = 0; i < this.original.getAsList().size(); ++i) {
            if (((Compound)this.original.getAsList().get(i)).equalsIgnoreCase((Compound)other.getAsList().get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        String s = this.getSequenceAsString();
        return s.hashCode();
    }

    @Override
    public C getCompoundAt(int alignmentIndex) {
        return alignmentIndex >= 1 && alignmentIndex <= this.length && this.isGap(alignmentIndex) ? this.getCompoundSet().getCompoundForString(gap) : this.original.getCompoundAt(this.getSequenceIndexAt(alignmentIndex));
    }

    @Override
    public CompoundSet<C> getCompoundSet() {
        return this.original.getCompoundSet();
    }

    @Override
    public int getIndexOf(C compound) {
        for (int i = 1; i <= this.length; ++i) {
            if (!compound.equals(this.getCompoundAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getLastIndexOf(C compound) {
        for (int i = this.length; i >= 1; --i) {
            if (!compound.equals(this.getCompoundAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public String getSequenceAsString() {
        return SequenceMixin.toString(this);
    }

    @Override
    public SequenceView<C> getSubSequence(Integer start, Integer end) {
        return SequenceMixin.createSubSequence(this, start, end);
    }

    @Override
    public Iterator<C> iterator() {
        return this.getAsList().iterator();
    }

    public String toString() {
        return this.getSequenceAsString();
    }

    private void setLocation(List<AlignedSequence.Step> steps) {
        int step;
        ArrayList<Location> sublocations = new ArrayList<Location>();
        int start = 0;
        int oStep = this.numBefore + this.numAfter;
        int oMax = this.original.getLength();
        int pStep = 0;
        int pMax = this.prev == null ? 0 : this.prev.getLength();
        boolean inGap = true;
        for (step = 0; step < this.length; ++step) {
            boolean isGapPrev;
            boolean isGapStep = steps.get(step) == AlignedSequence.Step.GAP;
            boolean bl = isGapPrev = pStep < pMax && this.prev.isGap(pStep + 1);
            if (!isGapStep && !isGapPrev) {
                ++oStep;
                if (inGap) {
                    inGap = false;
                    start = step + 1;
                }
            } else if (!inGap) {
                inGap = true;
                sublocations.add(new SimpleLocation(start, step, Strand.UNDEFINED));
            }
            if (this.prev == null || isGapStep) continue;
            ++pStep;
        }
        if (!inGap) {
            sublocations.add(new SimpleLocation(start, step, Strand.UNDEFINED));
        }
        this.location = sublocations.isEmpty() ? null : (sublocations.size() == 1 ? (Location)sublocations.get(0) : new SimpleLocation(((Location)sublocations.get(0)).getStart(), ((Location)sublocations.get(sublocations.size() - 1)).getEnd(), Strand.UNDEFINED, false, sublocations));
        if (step != this.length || oStep != oMax || pStep != pMax) {
            throw new IllegalArgumentException("Given sequence does not fit in alignment.");
        }
    }

    @Override
    public SequenceView<C> getInverse() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getNumGapPositions() {
        if (this.numGapPositions == -1) {
            this.getNumGaps();
        }
        return this.numGapPositions;
    }

    @Override
    public double getCoverage() {
        double coverage = this.getLength() - this.getNumGapPositions();
        return coverage / (double)this.getOriginalSequence().getLength();
    }
}

