/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm.drude;

import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMDrudeLibrary;
import ffx.openmm.Context;
import ffx.openmm.Force;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;

public class DrudeForce
extends Force {
    public DrudeForce() {
        super(OpenMMDrudeLibrary.OpenMM_DrudeForce_create());
    }

    public int addParticle(int particle, int particle1, int particle2, int particle3, int particle4, double charge, double polarizability, double aniso12, double aniso34) {
        return OpenMMDrudeLibrary.OpenMM_DrudeForce_addParticle((PointerByReference)this.pointer, (int)particle, (int)particle1, (int)particle2, (int)particle3, (int)particle4, (double)charge, (double)polarizability, (double)aniso12, (double)aniso34);
    }

    public int addScreenedPair(int particle1, int particle2, double thole) {
        return OpenMMDrudeLibrary.OpenMM_DrudeForce_addScreenedPair((PointerByReference)this.pointer, (int)particle1, (int)particle2, (double)thole);
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMDrudeLibrary.OpenMM_DrudeForce_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public int getNumParticles() {
        return OpenMMDrudeLibrary.OpenMM_DrudeForce_getNumParticles((PointerByReference)this.pointer);
    }

    public int getNumScreenedPairs() {
        return OpenMMDrudeLibrary.OpenMM_DrudeForce_getNumScreenedPairs((PointerByReference)this.pointer);
    }

    public void getParticleParameters(int index, IntByReference particle, IntByReference particle1, IntByReference particle2, IntByReference particle3, IntByReference particle4, DoubleByReference charge, DoubleByReference polarizability, DoubleByReference aniso12, DoubleByReference aniso34) {
        OpenMMDrudeLibrary.OpenMM_DrudeForce_getParticleParameters((PointerByReference)this.pointer, (int)index, (IntByReference)particle, (IntByReference)particle1, (IntByReference)particle2, (IntByReference)particle3, (IntByReference)particle4, (DoubleByReference)charge, (DoubleByReference)polarizability, (DoubleByReference)aniso12, (DoubleByReference)aniso34);
    }

    public void getScreenedPairParameters(int index, IntByReference particle1, IntByReference particle2, DoubleByReference thole) {
        OpenMMDrudeLibrary.OpenMM_DrudeForce_getScreenedPairParameters((PointerByReference)this.pointer, (int)index, (IntByReference)particle1, (IntByReference)particle2, (DoubleByReference)thole);
    }

    public void getScreenedPairParameters(int index, IntBuffer particle1, IntBuffer particle2, DoubleBuffer thole) {
        OpenMMDrudeLibrary.OpenMM_DrudeForce_getScreenedPairParameters((PointerByReference)this.pointer, (int)index, (IntBuffer)particle1, (IntBuffer)particle2, (DoubleBuffer)thole);
    }

    public void setParticleParameters(int index, int particle, int particle1, int particle2, int particle3, int particle4, double charge, double polarizability, double aniso12, double aniso34) {
        OpenMMDrudeLibrary.OpenMM_DrudeForce_setParticleParameters((PointerByReference)this.pointer, (int)index, (int)particle, (int)particle1, (int)particle2, (int)particle3, (int)particle4, (double)charge, (double)polarizability, (double)aniso12, (double)aniso34);
    }

    public void setScreenedPairParameters(int index, int particle1, int particle2, double thole) {
        OpenMMDrudeLibrary.OpenMM_DrudeForce_setScreenedPairParameters((PointerByReference)this.pointer, (int)index, (int)particle1, (int)particle2, (double)thole);
    }

    public void setUsesPeriodicBoundaryConditions(boolean periodic) {
        OpenMMDrudeLibrary.OpenMM_DrudeForce_setUsesPeriodicBoundaryConditions((PointerByReference)this.pointer, (int)(periodic ? 1 : 0));
    }

    public void updateParametersInContext(Context context) {
        if (context.hasContextPointer()) {
            OpenMMDrudeLibrary.OpenMM_DrudeForce_updateParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer());
        }
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMDrudeLibrary.OpenMM_DrudeForce_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc == 1;
    }
}

