/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm.amoeba;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMAmoebaLibrary;
import ffx.openmm.Context;
import ffx.openmm.Force;
import ffx.openmm.IntArray;

public class VdwForce
extends Force {
    public VdwForce() {
        super(OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_create());
    }

    public int addParticle(int parentIndex, double sigma, double epsilon, double reductionFactor, int isAlchemical, double scaleFactor) {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_addParticle((PointerByReference)this.pointer, (int)parentIndex, (double)sigma, (double)epsilon, (double)reductionFactor, (int)isAlchemical, (double)scaleFactor);
    }

    public int addParticle(int parentIndex, int typeIndex, double reductionFactor, int isAlchemical, double scaleFactor) {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_addParticle_1((PointerByReference)this.pointer, (int)parentIndex, (int)typeIndex, (double)reductionFactor, (int)isAlchemical, (double)scaleFactor);
    }

    public int addParticleType(double sigma, double epsilon) {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_addParticleType((PointerByReference)this.pointer, (double)sigma, (double)epsilon);
    }

    public int addTypePair(int type1, int type2, double sigma, double epsilon) {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_addTypePair((PointerByReference)this.pointer, (int)type1, (int)type2, (double)sigma, (double)epsilon);
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public int getAlchemicalMethod() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_getAlchemicalMethod((PointerByReference)this.pointer);
    }

    @Deprecated
    public double getCutoff() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_getCutoff((PointerByReference)this.pointer);
    }

    public double getCutoffDistance() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_getCutoffDistance((PointerByReference)this.pointer);
    }

    public String getEpsilonCombiningRule() {
        Pointer rule = OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_getEpsilonCombiningRule((PointerByReference)this.pointer);
        if (rule == null) {
            return null;
        }
        return rule.getString(0L);
    }

    public Pointer getLambda() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_Lambda((PointerByReference)this.pointer);
    }

    public int getNonbondedMethod() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_getNonbondedMethod((PointerByReference)this.pointer);
    }

    public int getNumParticles() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_getNumParticles((PointerByReference)this.pointer);
    }

    public int getNumParticleTypes() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_getNumParticleTypes((PointerByReference)this.pointer);
    }

    public int getNumTypePairs() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_getNumTypePairs((PointerByReference)this.pointer);
    }

    public IntArray getParticleExclusions(int i) {
        IntArray exclusions = new IntArray(0);
        if (this.pointer != null) {
            OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_getParticleExclusions((PointerByReference)this.pointer, (int)i, (PointerByReference)exclusions.getPointer());
        }
        return exclusions;
    }

    public void getParticleParameters(int index, IntByReference ired, DoubleByReference rad, DoubleByReference eps, DoubleByReference reductionFactor, IntByReference isAlchemical, IntByReference type, DoubleByReference scaleFactor) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_getParticleParameters((PointerByReference)this.pointer, (int)index, (IntByReference)ired, (DoubleByReference)rad, (DoubleByReference)eps, (DoubleByReference)reductionFactor, (IntByReference)isAlchemical, (IntByReference)type, (DoubleByReference)scaleFactor);
    }

    public void getParticleTypeParameters(int index, DoubleByReference rad, DoubleByReference eps) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_getParticleTypeParameters((PointerByReference)this.pointer, (int)index, (DoubleByReference)rad, (DoubleByReference)eps);
    }

    public int getPotentialFunction() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_getPotentialFunction((PointerByReference)this.pointer);
    }

    public String getSigmaCombiningRule() {
        Pointer rule = OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_getSigmaCombiningRule((PointerByReference)this.pointer);
        if (rule == null) {
            return null;
        }
        return rule.getString(0L);
    }

    public double getSoftcoreAlpha() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_getSoftcoreAlpha((PointerByReference)this.pointer);
    }

    public int getSoftcorePower() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_getSoftcorePower((PointerByReference)this.pointer);
    }

    public void getTypePairParameters(int index, IntByReference type1, IntByReference type2, DoubleByReference rad, DoubleByReference eps) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_getTypePairParameters((PointerByReference)this.pointer, (int)index, (IntByReference)type1, (IntByReference)type2, (DoubleByReference)rad, (DoubleByReference)eps);
    }

    public boolean getUseDispersionCorrection() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_getUseDispersionCorrection((PointerByReference)this.pointer) != 0;
    }

    public int getUseParticleTypes() {
        return OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_getUseParticleTypes((PointerByReference)this.pointer);
    }

    public void setAlchemicalMethod(int method) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_setAlchemicalMethod((PointerByReference)this.pointer, (int)method);
    }

    @Deprecated
    public void setCutoff(double cutoff) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_setCutoff((PointerByReference)this.pointer, (double)cutoff);
    }

    public void setCutoffDistance(double distance) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_setCutoffDistance((PointerByReference)this.pointer, (double)distance);
    }

    public void setEpsilonCombiningRule(String rule) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_setEpsilonCombiningRule((PointerByReference)this.pointer, (String)rule);
    }

    public void setLambdaName(String name) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_setLambdaName((PointerByReference)this.pointer, (String)name);
    }

    public void setNonbondedMethod(int method) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_setNonbondedMethod((PointerByReference)this.pointer, (int)method);
    }

    public void setParticleExclusions(int i, IntArray exclusions) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_setParticleExclusions((PointerByReference)this.pointer, (int)i, (PointerByReference)exclusions.getPointer());
    }

    public void setParticleParameters(int index, int ired, double rad, double eps, double reductionFactor, int isAlchemical, int type, double scaleFactor) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_setParticleParameters((PointerByReference)this.pointer, (int)index, (int)ired, (double)rad, (double)eps, (double)reductionFactor, (int)isAlchemical, (int)type, (double)scaleFactor);
    }

    public void setParticleTypeParameters(int index, double rad, double eps) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_setParticleTypeParameters((PointerByReference)this.pointer, (int)index, (double)rad, (double)eps);
    }

    public void setPotentialFunction(int function) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_setPotentialFunction((PointerByReference)this.pointer, (int)function);
    }

    public void setSigmaCombiningRule(String rule) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_setSigmaCombiningRule((PointerByReference)this.pointer, (String)rule);
    }

    public void setSoftcoreAlpha(double vdWSoftcoreAlpha) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_setSoftcoreAlpha((PointerByReference)this.pointer, (double)vdWSoftcoreAlpha);
    }

    public void setSoftcorePower(int vdwSoftcorePower) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_setSoftcorePower((PointerByReference)this.pointer, (int)vdwSoftcorePower);
    }

    public void setTypePairParameters(int index, int type1, int type2, double rad, double eps) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_setTypePairParameters((PointerByReference)this.pointer, (int)index, (int)type1, (int)type2, (double)rad, (double)eps);
    }

    public void setUseDispersionCorrection(boolean useCorrection) {
        OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_setUseDispersionCorrection((PointerByReference)this.pointer, (int)(useCorrection ? 1 : 0));
    }

    public void updateParametersInContext(Context context) {
        if (context.hasContextPointer()) {
            OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_updateParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer());
        }
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMAmoebaLibrary.OpenMM_AmoebaVdwForce_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc == 1;
    }
}

