/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import edu.uiowa.jopenmm.OpenMM_Vec3;

public class Vec3Array {
    private PointerByReference pointer;

    public Vec3Array(int size) {
        this.pointer = OpenMMLibrary.OpenMM_Vec3Array_create((int)size);
    }

    public Vec3Array(PointerByReference pointer) {
        this.pointer = pointer;
    }

    public void append(OpenMM_Vec3.ByValue vec3) {
        OpenMMLibrary.OpenMM_Vec3Array_append((PointerByReference)this.pointer, (OpenMM_Vec3.ByValue)vec3);
    }

    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_Vec3Array_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public OpenMM_Vec3 get(int i) {
        return OpenMMLibrary.OpenMM_Vec3Array_get((PointerByReference)this.pointer, (int)i);
    }

    public double[] getArray() {
        int size = this.getSize();
        double[] array = new double[size * 3];
        for (int i = 0; i < size; ++i) {
            OpenMM_Vec3 vec3 = this.get(i);
            int index = i * 3;
            array[index] = vec3.x;
            array[index + 1] = vec3.y;
            array[index + 2] = vec3.z;
        }
        return array;
    }

    public PointerByReference getPointer() {
        return this.pointer;
    }

    public int getSize() {
        return OpenMMLibrary.OpenMM_Vec3Array_getSize((PointerByReference)this.pointer);
    }

    public void resize(int size) {
        OpenMMLibrary.OpenMM_Vec3Array_resize((PointerByReference)this.pointer, (int)size);
    }

    public void set(int i, OpenMM_Vec3.ByValue vec3) {
        OpenMMLibrary.OpenMM_Vec3Array_set((PointerByReference)this.pointer, (int)i, (OpenMM_Vec3.ByValue)vec3);
    }

    public static Vec3Array toVec3Array(double[] array) {
        Vec3Array vec3Array = new Vec3Array(0);
        OpenMM_Vec3.ByValue vec3 = new OpenMM_Vec3.ByValue();
        for (int i = 0; i < array.length; i += 3) {
            vec3.x = array[i];
            vec3.y = array[i + 1];
            vec3.z = array[i + 2];
            vec3Array.append(vec3);
        }
        return vec3Array;
    }
}

