/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import edu.uiowa.jopenmm.OpenMM_Vec3;
import ffx.openmm.Vec3Array;

public class State {
    PointerByReference pointer;

    public State(PointerByReference pointer) {
        this.pointer = pointer;
    }

    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_State_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public int getDataTypes() {
        return OpenMMLibrary.OpenMM_State_getDataTypes((PointerByReference)this.pointer);
    }

    public PointerByReference getEnergyParameterDerivatives() {
        return OpenMMLibrary.OpenMM_State_getEnergyParameterDerivatives((PointerByReference)this.pointer);
    }

    public double[] getForces() {
        Vec3Array forces = new Vec3Array(OpenMMLibrary.OpenMM_State_getForces((PointerByReference)this.pointer));
        return forces.getArray();
    }

    public double getKineticEnergy() {
        return OpenMMLibrary.OpenMM_State_getKineticEnergy((PointerByReference)this.pointer);
    }

    public PointerByReference getParameters() {
        return OpenMMLibrary.OpenMM_State_getParameters((PointerByReference)this.pointer);
    }

    public double[][] getPeriodicBoxVectors() {
        OpenMM_Vec3 a = new OpenMM_Vec3();
        OpenMM_Vec3 b = new OpenMM_Vec3();
        OpenMM_Vec3 c = new OpenMM_Vec3();
        OpenMMLibrary.OpenMM_State_getPeriodicBoxVectors((PointerByReference)this.pointer, (OpenMM_Vec3)a, (OpenMM_Vec3)b, (OpenMM_Vec3)c);
        double[][] latticeVectors = new double[3][3];
        latticeVectors[0][0] = a.x;
        latticeVectors[0][1] = a.y;
        latticeVectors[0][2] = a.z;
        latticeVectors[1][0] = b.x;
        latticeVectors[1][1] = b.y;
        latticeVectors[1][2] = b.z;
        latticeVectors[2][0] = c.x;
        latticeVectors[2][1] = c.y;
        latticeVectors[2][2] = c.z;
        return latticeVectors;
    }

    public double getPeriodicBoxVolume() {
        return OpenMMLibrary.OpenMM_State_getPeriodicBoxVolume((PointerByReference)this.pointer);
    }

    public PointerByReference getPointer() {
        return this.pointer;
    }

    public double[] getPositions() {
        Vec3Array positions = new Vec3Array(OpenMMLibrary.OpenMM_State_getPositions((PointerByReference)this.pointer));
        return positions.getArray();
    }

    public double getPotentialEnergy() {
        return OpenMMLibrary.OpenMM_State_getPotentialEnergy((PointerByReference)this.pointer);
    }

    public long getStepCount() {
        return OpenMMLibrary.OpenMM_State_getStepCount((PointerByReference)this.pointer);
    }

    public double getTime() {
        return OpenMMLibrary.OpenMM_State_getTime((PointerByReference)this.pointer);
    }

    public double[] getVelocities() {
        Vec3Array velocities = new Vec3Array(OpenMMLibrary.OpenMM_State_getVelocities((PointerByReference)this.pointer));
        return velocities.getArray();
    }
}

