/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import ffx.openmm.Context;
import ffx.openmm.StringArray;

public class Platform {
    private PointerByReference pointer;

    public Platform(PointerByReference pointer) {
        this.pointer = pointer;
    }

    public Platform(String platformName) {
        this.pointer = OpenMMLibrary.OpenMM_Platform_getPlatformByName((String)platformName);
    }

    public Platform() {
        this.pointer = null;
    }

    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_Platform_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public static Platform findPlatform(StringArray kernelNames) {
        PointerByReference platformPointer = OpenMMLibrary.OpenMM_Platform_findPlatform((PointerByReference)kernelNames.getPointer());
        return new Platform(platformPointer);
    }

    public static String getDefaultPluginsDirectory() {
        Pointer directory = OpenMMLibrary.OpenMM_Platform_getDefaultPluginsDirectory();
        return directory.getString(0L);
    }

    public String getName() {
        Pointer name = OpenMMLibrary.OpenMM_Platform_getName((PointerByReference)this.pointer);
        return name.getString(0L);
    }

    public static int getNumPlatforms() {
        return OpenMMLibrary.OpenMM_Platform_getNumPlatforms();
    }

    public static String getOpenMMVersion() {
        Pointer version = OpenMMLibrary.OpenMM_Platform_getOpenMMVersion();
        return version.getString(0L);
    }

    public PointerByReference getPointer() {
        return this.pointer;
    }

    public static Platform getPlatform(int index) {
        PointerByReference platformPointer = OpenMMLibrary.OpenMM_Platform_getPlatform((int)index);
        return new Platform(platformPointer);
    }

    public static Platform getPlatform_1(String name) {
        PointerByReference platformPointer = OpenMMLibrary.OpenMM_Platform_getPlatform_1((String)name);
        return new Platform(platformPointer);
    }

    public static StringArray getPluginLoadFailures() {
        return new StringArray(OpenMMLibrary.OpenMM_Platform_getPluginLoadFailures());
    }

    public String getPropertyDefaultValue(String property) {
        Pointer propertyPointer = Platform.pointerForString(property);
        Pointer value = OpenMMLibrary.OpenMM_Platform_getPropertyDefaultValue((PointerByReference)this.pointer, (Pointer)propertyPointer);
        if (value == null) {
            return null;
        }
        return value.getString(0L);
    }

    public StringArray getPropertyNames() {
        return new StringArray(OpenMMLibrary.OpenMM_Platform_getPropertyNames((PointerByReference)this.pointer));
    }

    public String getPropertyValue(Context context, String property) {
        Pointer propertyPointer = Platform.pointerForString(property);
        Pointer value = OpenMMLibrary.OpenMM_Platform_getPropertyValue((PointerByReference)this.pointer, (PointerByReference)context.getPointer(), (Pointer)propertyPointer);
        if (value == null) {
            return null;
        }
        return value.getString(0L);
    }

    public double getSpeed() {
        return OpenMMLibrary.OpenMM_Platform_getSpeed((PointerByReference)this.pointer);
    }

    public static StringArray loadPluginsFromDirectory(String directory) {
        return new StringArray(OpenMMLibrary.OpenMM_Platform_loadPluginsFromDirectory((String)directory));
    }

    public static void loadPluginLibrary(String file) {
        OpenMMLibrary.OpenMM_Platform_loadPluginLibrary((String)file);
    }

    public static void registerPlatform(Platform platform) {
        OpenMMLibrary.OpenMM_Platform_registerPlatform((PointerByReference)platform.getPointer());
    }

    public void setPropertyDefaultValue(String property, String value) {
        Pointer propertyPointer = Platform.pointerForString(property);
        Pointer valuePointer = Platform.pointerForString(value);
        OpenMMLibrary.OpenMM_Platform_setPropertyDefaultValue((PointerByReference)this.pointer, (Pointer)propertyPointer, (Pointer)valuePointer);
    }

    public void setPropertyValue(Context context, String property, String value) {
        Pointer propertyPointer = Platform.pointerForString(property);
        Pointer valuePointer = Platform.pointerForString(value);
        OpenMMLibrary.OpenMM_Platform_setPropertyValue((PointerByReference)this.pointer, (PointerByReference)context.getPointer(), (Pointer)propertyPointer, (Pointer)valuePointer);
    }

    public boolean supportsDoublePrecision() {
        int result = OpenMMLibrary.OpenMM_Platform_supportsDoublePrecision((PointerByReference)this.pointer);
        return result != 0;
    }

    public boolean supportsKernels(StringArray kernelNames) {
        int result = OpenMMLibrary.OpenMM_Platform_supportsKernels((PointerByReference)this.pointer, (PointerByReference)kernelNames.getPointer());
        return result != 0;
    }

    private static Pointer pointerForString(String string) {
        Memory pointer = new Memory((long)(string.length() + 1));
        pointer.setString(0L, string);
        return pointer;
    }
}

