/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import ffx.openmm.Integrator;

public class NoseHooverIntegrator
extends Integrator {
    public NoseHooverIntegrator(PointerByReference pointer) {
        super(pointer);
    }

    public NoseHooverIntegrator(double stepSize) {
        super(OpenMMLibrary.OpenMM_NoseHooverIntegrator_create((double)stepSize));
    }

    public NoseHooverIntegrator(double stepSize, double temperature, double collisionFrequency, int numMTS, int numYoshidaSuzuki, int numNoseHoover) {
        super(OpenMMLibrary.OpenMM_NoseHooverIntegrator_create_2((double)stepSize, (double)temperature, (double)collisionFrequency, (int)numMTS, (int)numYoshidaSuzuki, (int)numNoseHoover));
    }

    public int addSubsystemThermostat(PointerByReference particles, PointerByReference chainWeights, double temperature, double collisionFrequency, double relativeTemperature, double relativeCollisionFrequency, int numMTS, int numYoshidaSuzuki, int numNoseHoover) {
        return OpenMMLibrary.OpenMM_NoseHooverIntegrator_addSubsystemThermostat((PointerByReference)this.pointer, (PointerByReference)particles, (PointerByReference)chainWeights, (double)temperature, (double)collisionFrequency, (double)relativeTemperature, (double)relativeCollisionFrequency, (int)numMTS, (int)numYoshidaSuzuki, (int)numNoseHoover);
    }

    public int addThermostat(double temperature, double collisionFrequency, int numMTS, int numYoshidaSuzuki, int numNoseHoover) {
        return OpenMMLibrary.OpenMM_NoseHooverIntegrator_addThermostat((PointerByReference)this.pointer, (double)temperature, (double)collisionFrequency, (int)numMTS, (int)numYoshidaSuzuki, (int)numNoseHoover);
    }

    public double computeHeatBathEnergy() {
        return OpenMMLibrary.OpenMM_NoseHooverIntegrator_computeHeatBathEnergy((PointerByReference)this.pointer);
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_NoseHooverIntegrator_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public double getCollisionFrequency(int thermostat) {
        return OpenMMLibrary.OpenMM_NoseHooverIntegrator_getCollisionFrequency((PointerByReference)this.pointer, (int)thermostat);
    }

    public double getMaximumPairDistance() {
        return OpenMMLibrary.OpenMM_NoseHooverIntegrator_getMaximumPairDistance((PointerByReference)this.pointer);
    }

    public int getNumThermostats() {
        return OpenMMLibrary.OpenMM_NoseHooverIntegrator_getNumThermostats((PointerByReference)this.pointer);
    }

    public double getRelativeCollisionFrequency(int thermostat) {
        return OpenMMLibrary.OpenMM_NoseHooverIntegrator_getRelativeCollisionFrequency((PointerByReference)this.pointer, (int)thermostat);
    }

    public double getRelativeTemperature(int thermostat) {
        return OpenMMLibrary.OpenMM_NoseHooverIntegrator_getRelativeTemperature((PointerByReference)this.pointer, (int)thermostat);
    }

    public double getTemperature(int thermostat) {
        return OpenMMLibrary.OpenMM_NoseHooverIntegrator_getTemperature((PointerByReference)this.pointer, (int)thermostat);
    }

    public PointerByReference getThermostat(int thermostat) {
        return OpenMMLibrary.OpenMM_NoseHooverIntegrator_getThermostat((PointerByReference)this.pointer, (int)thermostat);
    }

    public int hasSubsystemThermostats() {
        return OpenMMLibrary.OpenMM_NoseHooverIntegrator_hasSubsystemThermostats((PointerByReference)this.pointer);
    }

    public void setCollisionFrequency(double collisionFrequency, int thermostat) {
        OpenMMLibrary.OpenMM_NoseHooverIntegrator_setCollisionFrequency((PointerByReference)this.pointer, (double)collisionFrequency, (int)thermostat);
    }

    public void setMaximumPairDistance(double distance) {
        OpenMMLibrary.OpenMM_NoseHooverIntegrator_setMaximumPairDistance((PointerByReference)this.pointer, (double)distance);
    }

    public void setRelativeCollisionFrequency(double relativeCollisionFrequency, int thermostat) {
        OpenMMLibrary.OpenMM_NoseHooverIntegrator_setRelativeCollisionFrequency((PointerByReference)this.pointer, (double)relativeCollisionFrequency, (int)thermostat);
    }

    public void setRelativeTemperature(double relativeTemperature, int thermostat) {
        OpenMMLibrary.OpenMM_NoseHooverIntegrator_setRelativeTemperature((PointerByReference)this.pointer, (double)relativeTemperature, (int)thermostat);
    }

    public void setTemperature(double temperature, int thermostat) {
        OpenMMLibrary.OpenMM_NoseHooverIntegrator_setTemperature((PointerByReference)this.pointer, (double)temperature, (int)thermostat);
    }

    @Override
    public void step(int steps) {
        OpenMMLibrary.OpenMM_NoseHooverIntegrator_step((PointerByReference)this.pointer, (int)steps);
    }
}

