/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import ffx.openmm.Context;
import ffx.openmm.Force;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;

public class HarmonicBondForce
extends Force {
    public HarmonicBondForce() {
        super(OpenMMLibrary.OpenMM_HarmonicBondForce_create());
    }

    public int addBond(int i1, int i2, double length, double k) {
        return OpenMMLibrary.OpenMM_HarmonicBondForce_addBond((PointerByReference)this.pointer, (int)i1, (int)i2, (double)length, (double)k);
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_HarmonicBondForce_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public void getBondParameters(int index, IntByReference i1, IntByReference i2, DoubleByReference length, DoubleByReference k) {
        OpenMMLibrary.OpenMM_HarmonicBondForce_getBondParameters((PointerByReference)this.pointer, (int)index, (IntByReference)i1, (IntByReference)i2, (DoubleByReference)length, (DoubleByReference)k);
    }

    public void getBondParameters(int index, IntBuffer i1, IntBuffer i2, DoubleBuffer length, DoubleBuffer k) {
        OpenMMLibrary.OpenMM_HarmonicBondForce_getBondParameters((PointerByReference)this.pointer, (int)index, (IntBuffer)i1, (IntBuffer)i2, (DoubleBuffer)length, (DoubleBuffer)k);
    }

    public int getNumBonds() {
        return OpenMMLibrary.OpenMM_HarmonicBondForce_getNumBonds((PointerByReference)this.pointer);
    }

    public void setBondParameters(int i, int i1, int i2, double length, double k) {
        OpenMMLibrary.OpenMM_HarmonicBondForce_setBondParameters((PointerByReference)this.pointer, (int)i, (int)i1, (int)i2, (double)length, (double)k);
    }

    public void setUsesPeriodicBoundaryConditions(boolean periodic) {
        OpenMMLibrary.OpenMM_HarmonicBondForce_setUsesPeriodicBoundaryConditions((PointerByReference)this.pointer, (int)(periodic ? 1 : 0));
    }

    public void updateParametersInContext(Context context) {
        if (context.hasContextPointer()) {
            OpenMMLibrary.OpenMM_HarmonicBondForce_updateParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer());
        }
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMLibrary.OpenMM_HarmonicBondForce_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc == 1;
    }
}

