/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import ffx.openmm.Context;
import ffx.openmm.Force;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;

public class HarmonicAngleForce
extends Force {
    public HarmonicAngleForce() {
        super(OpenMMLibrary.OpenMM_HarmonicAngleForce_create());
    }

    public int addAngle(int particle1, int particle2, int particle3, double angle, double k) {
        return OpenMMLibrary.OpenMM_HarmonicAngleForce_addAngle((PointerByReference)this.pointer, (int)particle1, (int)particle2, (int)particle3, (double)angle, (double)k);
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_HarmonicAngleForce_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public void getAngleParameters(int index, IntByReference particle1, IntByReference particle2, IntByReference particle3, DoubleByReference angle, DoubleByReference k) {
        OpenMMLibrary.OpenMM_HarmonicAngleForce_getAngleParameters((PointerByReference)this.pointer, (int)index, (IntByReference)particle1, (IntByReference)particle2, (IntByReference)particle3, (DoubleByReference)angle, (DoubleByReference)k);
    }

    public void getAngleParameters(int index, IntBuffer particle1, IntBuffer particle2, IntBuffer particle3, DoubleBuffer angle, DoubleBuffer k) {
        OpenMMLibrary.OpenMM_HarmonicAngleForce_getAngleParameters((PointerByReference)this.pointer, (int)index, (IntBuffer)particle1, (IntBuffer)particle2, (IntBuffer)particle3, (DoubleBuffer)angle, (DoubleBuffer)k);
    }

    public int getNumAngles() {
        return OpenMMLibrary.OpenMM_HarmonicAngleForce_getNumAngles((PointerByReference)this.pointer);
    }

    public void setAngleParameters(int index, int particle1, int particle2, int particle3, double angle, double k) {
        OpenMMLibrary.OpenMM_HarmonicAngleForce_setAngleParameters((PointerByReference)this.pointer, (int)index, (int)particle1, (int)particle2, (int)particle3, (double)angle, (double)k);
    }

    public void setUsesPeriodicBoundaryConditions(boolean periodic) {
        OpenMMLibrary.OpenMM_HarmonicAngleForce_setUsesPeriodicBoundaryConditions((PointerByReference)this.pointer, (int)(periodic ? 1 : 0));
    }

    public void updateParametersInContext(Context context) {
        if (context.hasContextPointer()) {
            OpenMMLibrary.OpenMM_HarmonicAngleForce_updateParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer());
        }
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMLibrary.OpenMM_HarmonicAngleForce_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc == 1;
    }
}

