/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import ffx.openmm.BondArray;
import ffx.openmm.Context;
import ffx.openmm.DoubleArray;
import ffx.openmm.Force;
import ffx.openmm.IntSet;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;

public class CustomNonbondedForce
extends Force {
    public CustomNonbondedForce(String energy) {
        super(OpenMMLibrary.OpenMM_CustomNonbondedForce_create((String)energy));
    }

    public int addComputedValue(String name, String expression) {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_addComputedValue((PointerByReference)this.pointer, (String)name, (String)expression);
    }

    public void addEnergyParameterDerivative(String name) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_addEnergyParameterDerivative((PointerByReference)this.pointer, (String)name);
    }

    public int addExclusion(int particle1, int particle2) {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_addExclusion((PointerByReference)this.pointer, (int)particle1, (int)particle2);
    }

    public int addFunction(String name, PointerByReference function, double min, double max) {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_addFunction((PointerByReference)this.pointer, (String)name, (PointerByReference)function, (double)min, (double)max);
    }

    public int addGlobalParameter(String name, double value) {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_addGlobalParameter((PointerByReference)this.pointer, (String)name, (double)value);
    }

    public int addInteractionGroup(IntSet group1, IntSet group2) {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_addInteractionGroup((PointerByReference)this.pointer, (PointerByReference)group1.getPointer(), (PointerByReference)group2.getPointer());
    }

    public int addParticle(DoubleArray parameters) {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_addParticle((PointerByReference)this.pointer, (PointerByReference)parameters.getPointer());
    }

    public int addPerParticleParameter(String name) {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_addPerParticleParameter((PointerByReference)this.pointer, (String)name);
    }

    public int addTabulatedFunction(String name, PointerByReference function) {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_addTabulatedFunction((PointerByReference)this.pointer, (String)name, (PointerByReference)function);
    }

    public void createExclusionsFromBonds(BondArray bonds, int bondCutoff) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_createExclusionsFromBonds((PointerByReference)this.pointer, (PointerByReference)bonds.getPointer(), (int)bondCutoff);
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_CustomNonbondedForce_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public void getComputedValueParameters(int index, PointerByReference name, PointerByReference expression) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_getComputedValueParameters((PointerByReference)this.pointer, (int)index, (PointerByReference)name, (PointerByReference)expression);
    }

    public double getCutoffDistance() {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_getCutoffDistance((PointerByReference)this.pointer);
    }

    public String getEnergyFunction() {
        Pointer p = OpenMMLibrary.OpenMM_CustomNonbondedForce_getEnergyFunction((PointerByReference)this.pointer);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public String getEnergyParameterDerivativeName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomNonbondedForce_getEnergyParameterDerivativeName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public void getExclusionParticles(int index, IntByReference particle1, IntByReference particle2) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_getExclusionParticles((PointerByReference)this.pointer, (int)index, (IntByReference)particle1, (IntByReference)particle2);
    }

    public void getExclusionParticles(int index, IntBuffer particle1, IntBuffer particle2) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_getExclusionParticles((PointerByReference)this.pointer, (int)index, (IntBuffer)particle1, (IntBuffer)particle2);
    }

    public void getFunctionParameters(int index, PointerByReference name, PointerByReference function, DoubleByReference min, DoubleByReference max) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_getFunctionParameters((PointerByReference)this.pointer, (int)index, (PointerByReference)name, (PointerByReference)function, (DoubleByReference)min, (DoubleByReference)max);
    }

    public void getFunctionParameters(int index, PointerByReference name, PointerByReference function, DoubleBuffer min, DoubleBuffer max) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_getFunctionParameters((PointerByReference)this.pointer, (int)index, (PointerByReference)name, (PointerByReference)function, (DoubleBuffer)min, (DoubleBuffer)max);
    }

    public double getGlobalParameterDefaultValue(int index) {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_getGlobalParameterDefaultValue((PointerByReference)this.pointer, (int)index);
    }

    public String getGlobalParameterName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomNonbondedForce_getGlobalParameterName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public void getInteractionGroupParameters(int index, PointerByReference group1, PointerByReference group2) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_getInteractionGroupParameters((PointerByReference)this.pointer, (int)index, (PointerByReference)group1, (PointerByReference)group2);
    }

    public int getNonbondedMethod() {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_getNonbondedMethod((PointerByReference)this.pointer);
    }

    public int getNumComputedValues() {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_getNumComputedValues((PointerByReference)this.pointer);
    }

    public int getNumEnergyParameterDerivatives() {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_getNumEnergyParameterDerivatives((PointerByReference)this.pointer);
    }

    public int getNumExclusions() {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_getNumExclusions((PointerByReference)this.pointer);
    }

    @Deprecated
    public int getNumFunctions() {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_getNumFunctions((PointerByReference)this.pointer);
    }

    public int getNumGlobalParameters() {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_getNumGlobalParameters((PointerByReference)this.pointer);
    }

    public int getNumInteractionGroups() {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_getNumInteractionGroups((PointerByReference)this.pointer);
    }

    public int getNumParticles() {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_getNumParticles((PointerByReference)this.pointer);
    }

    public int getNumPerParticleParameters() {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_getNumPerParticleParameters((PointerByReference)this.pointer);
    }

    public int getNumTabulatedFunctions() {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_getNumTabulatedFunctions((PointerByReference)this.pointer);
    }

    public void getParticleParameters(int index, PointerByReference parameters) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_getParticleParameters((PointerByReference)this.pointer, (int)index, (PointerByReference)parameters);
    }

    public String getPerParticleParameterName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomNonbondedForce_getPerParticleParameterName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public double getSwitchingDistance() {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_getSwitchingDistance((PointerByReference)this.pointer);
    }

    public PointerByReference getTabulatedFunction(int index) {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_getTabulatedFunction((PointerByReference)this.pointer, (int)index);
    }

    public String getTabulatedFunctionName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomNonbondedForce_getTabulatedFunctionName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public int getUseLongRangeCorrection() {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_getUseLongRangeCorrection((PointerByReference)this.pointer);
    }

    public int getUseSwitchingFunction() {
        return OpenMMLibrary.OpenMM_CustomNonbondedForce_getUseSwitchingFunction((PointerByReference)this.pointer);
    }

    public void setComputedValueParameters(int index, String name, String expression) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_setComputedValueParameters((PointerByReference)this.pointer, (int)index, (String)name, (String)expression);
    }

    public void setCutoffDistance(double distance) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_setCutoffDistance((PointerByReference)this.pointer, (double)distance);
    }

    public void setEnergyFunction(String expression) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_setEnergyFunction((PointerByReference)this.pointer, (String)expression);
    }

    public void setExclusionParticles(int index, int particle1, int particle2) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_setExclusionParticles((PointerByReference)this.pointer, (int)index, (int)particle1, (int)particle2);
    }

    public void setFunctionParameters(int index, String name, PointerByReference function, double min, double max) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_setFunctionParameters((PointerByReference)this.pointer, (int)index, (String)name, (PointerByReference)function, (double)min, (double)max);
    }

    public void setGlobalParameterDefaultValue(int index, double value) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_setGlobalParameterDefaultValue((PointerByReference)this.pointer, (int)index, (double)value);
    }

    public void setGlobalParameterName(int index, String name) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_setGlobalParameterName((PointerByReference)this.pointer, (int)index, (String)name);
    }

    public void setInteractionGroupParameters(int index, PointerByReference group1, PointerByReference group2) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_setInteractionGroupParameters((PointerByReference)this.pointer, (int)index, (PointerByReference)group1, (PointerByReference)group2);
    }

    public void setNonbondedMethod(int method) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_setNonbondedMethod((PointerByReference)this.pointer, (int)method);
    }

    public void setParticleParameters(int index, PointerByReference parameters) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_setParticleParameters((PointerByReference)this.pointer, (int)index, (PointerByReference)parameters);
    }

    public void setPerParticleParameterName(int index, String name) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_setPerParticleParameterName((PointerByReference)this.pointer, (int)index, (String)name);
    }

    public void setSwitchingDistance(double distance) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_setSwitchingDistance((PointerByReference)this.pointer, (double)distance);
    }

    public void setUseLongRangeCorrection(int use) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_setUseLongRangeCorrection((PointerByReference)this.pointer, (int)use);
    }

    public void setUseSwitchingFunction(int use) {
        OpenMMLibrary.OpenMM_CustomNonbondedForce_setUseSwitchingFunction((PointerByReference)this.pointer, (int)use);
    }

    public void updateParametersInContext(Context context) {
        if (context.hasContextPointer()) {
            OpenMMLibrary.OpenMM_CustomNonbondedForce_updateParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer());
        }
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMLibrary.OpenMM_CustomNonbondedForce_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc == 1;
    }
}

