/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import ffx.openmm.Context;
import ffx.openmm.Force;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;

public class CustomHbondForce
extends Force {
    public CustomHbondForce(String energy) {
        super(OpenMMLibrary.OpenMM_CustomHbondForce_create((String)energy));
    }

    public int addAcceptor(int a1, int a2, int a3, PointerByReference parameters) {
        return OpenMMLibrary.OpenMM_CustomHbondForce_addAcceptor((PointerByReference)this.pointer, (int)a1, (int)a2, (int)a3, (PointerByReference)parameters);
    }

    public int addDonor(int d1, int d2, int d3, PointerByReference parameters) {
        return OpenMMLibrary.OpenMM_CustomHbondForce_addDonor((PointerByReference)this.pointer, (int)d1, (int)d2, (int)d3, (PointerByReference)parameters);
    }

    public int addExclusion(int donor, int acceptor) {
        return OpenMMLibrary.OpenMM_CustomHbondForce_addExclusion((PointerByReference)this.pointer, (int)donor, (int)acceptor);
    }

    public int addFunction(String name, PointerByReference function, double min, double max) {
        return OpenMMLibrary.OpenMM_CustomHbondForce_addFunction((PointerByReference)this.pointer, (String)name, (PointerByReference)function, (double)min, (double)max);
    }

    public int addFunction(Pointer name, PointerByReference function, double min, double max) {
        return OpenMMLibrary.OpenMM_CustomHbondForce_addFunction((PointerByReference)this.pointer, (Pointer)name, (PointerByReference)function, (double)min, (double)max);
    }

    public int addGlobalParameter(String name, double defaultValue) {
        return OpenMMLibrary.OpenMM_CustomHbondForce_addGlobalParameter((PointerByReference)this.pointer, (String)name, (double)defaultValue);
    }

    public int addGlobalParameter(Pointer name, double defaultValue) {
        return OpenMMLibrary.OpenMM_CustomHbondForce_addGlobalParameter((PointerByReference)this.pointer, (Pointer)name, (double)defaultValue);
    }

    public int addPerAcceptorParameter(String name) {
        return OpenMMLibrary.OpenMM_CustomHbondForce_addPerAcceptorParameter((PointerByReference)this.pointer, (String)name);
    }

    public int addPerAcceptorParameter(Pointer name) {
        return OpenMMLibrary.OpenMM_CustomHbondForce_addPerAcceptorParameter((PointerByReference)this.pointer, (Pointer)name);
    }

    public int addPerDonorParameter(String name) {
        return OpenMMLibrary.OpenMM_CustomHbondForce_addPerDonorParameter((PointerByReference)this.pointer, (String)name);
    }

    public int addPerDonorParameter(Pointer name) {
        return OpenMMLibrary.OpenMM_CustomHbondForce_addPerDonorParameter((PointerByReference)this.pointer, (Pointer)name);
    }

    public int addTabulatedFunction(String name, PointerByReference function) {
        return OpenMMLibrary.OpenMM_CustomHbondForce_addTabulatedFunction((PointerByReference)this.pointer, (String)name, (PointerByReference)function);
    }

    public int addTabulatedFunction(Pointer name, PointerByReference function) {
        return OpenMMLibrary.OpenMM_CustomHbondForce_addTabulatedFunction((PointerByReference)this.pointer, (Pointer)name, (PointerByReference)function);
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_CustomHbondForce_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public void getAcceptorParameters(int index, IntByReference a1, IntByReference a2, IntByReference a3, PointerByReference parameters) {
        OpenMMLibrary.OpenMM_CustomHbondForce_getAcceptorParameters((PointerByReference)this.pointer, (int)index, (IntByReference)a1, (IntByReference)a2, (IntByReference)a3, (PointerByReference)parameters);
    }

    public void getAcceptorParameters(int index, IntBuffer a1, IntBuffer a2, IntBuffer a3, PointerByReference parameters) {
        OpenMMLibrary.OpenMM_CustomHbondForce_getAcceptorParameters((PointerByReference)this.pointer, (int)index, (IntBuffer)a1, (IntBuffer)a2, (IntBuffer)a3, (PointerByReference)parameters);
    }

    public double getCutoffDistance() {
        return OpenMMLibrary.OpenMM_CustomHbondForce_getCutoffDistance((PointerByReference)this.pointer);
    }

    public void getDonorParameters(int index, IntByReference d1, IntByReference d2, IntByReference d3, PointerByReference parameters) {
        OpenMMLibrary.OpenMM_CustomHbondForce_getDonorParameters((PointerByReference)this.pointer, (int)index, (IntByReference)d1, (IntByReference)d2, (IntByReference)d3, (PointerByReference)parameters);
    }

    public void getDonorParameters(int index, IntBuffer d1, IntBuffer d2, IntBuffer d3, PointerByReference parameters) {
        OpenMMLibrary.OpenMM_CustomHbondForce_getDonorParameters((PointerByReference)this.pointer, (int)index, (IntBuffer)d1, (IntBuffer)d2, (IntBuffer)d3, (PointerByReference)parameters);
    }

    public String getEnergyFunction() {
        Pointer p = OpenMMLibrary.OpenMM_CustomHbondForce_getEnergyFunction((PointerByReference)this.pointer);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public void getExclusionParticles(int index, IntByReference donor, IntByReference acceptor) {
        OpenMMLibrary.OpenMM_CustomHbondForce_getExclusionParticles((PointerByReference)this.pointer, (int)index, (IntByReference)donor, (IntByReference)acceptor);
    }

    public void getExclusionParticles(int index, IntBuffer donor, IntBuffer acceptor) {
        OpenMMLibrary.OpenMM_CustomHbondForce_getExclusionParticles((PointerByReference)this.pointer, (int)index, (IntBuffer)donor, (IntBuffer)acceptor);
    }

    public void getFunctionParameters(int index, PointerByReference name, PointerByReference function, DoubleByReference min, DoubleByReference max) {
        OpenMMLibrary.OpenMM_CustomHbondForce_getFunctionParameters((PointerByReference)this.pointer, (int)index, (PointerByReference)name, (PointerByReference)function, (DoubleByReference)min, (DoubleByReference)max);
    }

    public void getFunctionParameters(int index, PointerByReference name, PointerByReference function, DoubleBuffer min, DoubleBuffer max) {
        OpenMMLibrary.OpenMM_CustomHbondForce_getFunctionParameters((PointerByReference)this.pointer, (int)index, (PointerByReference)name, (PointerByReference)function, (DoubleBuffer)min, (DoubleBuffer)max);
    }

    public double getGlobalParameterDefaultValue(int index) {
        return OpenMMLibrary.OpenMM_CustomHbondForce_getGlobalParameterDefaultValue((PointerByReference)this.pointer, (int)index);
    }

    public String getGlobalParameterName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomHbondForce_getGlobalParameterName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public int getNonbondedMethod() {
        return OpenMMLibrary.OpenMM_CustomHbondForce_getNonbondedMethod((PointerByReference)this.pointer);
    }

    public int getNumAcceptors() {
        return OpenMMLibrary.OpenMM_CustomHbondForce_getNumAcceptors((PointerByReference)this.pointer);
    }

    public int getNumDonors() {
        return OpenMMLibrary.OpenMM_CustomHbondForce_getNumDonors((PointerByReference)this.pointer);
    }

    public int getNumExclusions() {
        return OpenMMLibrary.OpenMM_CustomHbondForce_getNumExclusions((PointerByReference)this.pointer);
    }

    @Deprecated
    public int getNumFunctions() {
        return OpenMMLibrary.OpenMM_CustomHbondForce_getNumFunctions((PointerByReference)this.pointer);
    }

    public int getNumGlobalParameters() {
        return OpenMMLibrary.OpenMM_CustomHbondForce_getNumGlobalParameters((PointerByReference)this.pointer);
    }

    public int getNumPerAcceptorParameters() {
        return OpenMMLibrary.OpenMM_CustomHbondForce_getNumPerAcceptorParameters((PointerByReference)this.pointer);
    }

    public int getNumPerDonorParameters() {
        return OpenMMLibrary.OpenMM_CustomHbondForce_getNumPerDonorParameters((PointerByReference)this.pointer);
    }

    public int getNumTabulatedFunctions() {
        return OpenMMLibrary.OpenMM_CustomHbondForce_getNumTabulatedFunctions((PointerByReference)this.pointer);
    }

    public String getPerAcceptorParameterName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomHbondForce_getPerAcceptorParameterName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public String getPerDonorParameterName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomHbondForce_getPerDonorParameterName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public PointerByReference getTabulatedFunction(int index) {
        return OpenMMLibrary.OpenMM_CustomHbondForce_getTabulatedFunction((PointerByReference)this.pointer, (int)index);
    }

    public String getTabulatedFunctionName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomHbondForce_getTabulatedFunctionName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public void setAcceptorParameters(int index, int a1, int a2, int a3, PointerByReference parameters) {
        OpenMMLibrary.OpenMM_CustomHbondForce_setAcceptorParameters((PointerByReference)this.pointer, (int)index, (int)a1, (int)a2, (int)a3, (PointerByReference)parameters);
    }

    public void setCutoffDistance(double distance) {
        OpenMMLibrary.OpenMM_CustomHbondForce_setCutoffDistance((PointerByReference)this.pointer, (double)distance);
    }

    public void setDonorParameters(int index, int d1, int d2, int d3, PointerByReference parameters) {
        OpenMMLibrary.OpenMM_CustomHbondForce_setDonorParameters((PointerByReference)this.pointer, (int)index, (int)d1, (int)d2, (int)d3, (PointerByReference)parameters);
    }

    public void setEnergyFunction(String energy) {
        OpenMMLibrary.OpenMM_CustomHbondForce_setEnergyFunction((PointerByReference)this.pointer, (String)energy);
    }

    public void setEnergyFunction(Pointer energy) {
        OpenMMLibrary.OpenMM_CustomHbondForce_setEnergyFunction((PointerByReference)this.pointer, (Pointer)energy);
    }

    public void setExclusionParticles(int index, int donor, int acceptor) {
        OpenMMLibrary.OpenMM_CustomHbondForce_setExclusionParticles((PointerByReference)this.pointer, (int)index, (int)donor, (int)acceptor);
    }

    public void setFunctionParameters(int index, String name, PointerByReference function, double min, double max) {
        OpenMMLibrary.OpenMM_CustomHbondForce_setFunctionParameters((PointerByReference)this.pointer, (int)index, (String)name, (PointerByReference)function, (double)min, (double)max);
    }

    public void setFunctionParameters(int index, Pointer name, PointerByReference function, double min, double max) {
        OpenMMLibrary.OpenMM_CustomHbondForce_setFunctionParameters((PointerByReference)this.pointer, (int)index, (Pointer)name, (PointerByReference)function, (double)min, (double)max);
    }

    public void setGlobalParameterDefaultValue(int index, double defaultValue) {
        OpenMMLibrary.OpenMM_CustomHbondForce_setGlobalParameterDefaultValue((PointerByReference)this.pointer, (int)index, (double)defaultValue);
    }

    public void setGlobalParameterName(int index, String name) {
        OpenMMLibrary.OpenMM_CustomHbondForce_setGlobalParameterName((PointerByReference)this.pointer, (int)index, (String)name);
    }

    public void setGlobalParameterName(int index, Pointer name) {
        OpenMMLibrary.OpenMM_CustomHbondForce_setGlobalParameterName((PointerByReference)this.pointer, (int)index, (Pointer)name);
    }

    public void setNonbondedMethod(int method) {
        OpenMMLibrary.OpenMM_CustomHbondForce_setNonbondedMethod((PointerByReference)this.pointer, (int)method);
    }

    public void setPerAcceptorParameterName(int index, String name) {
        OpenMMLibrary.OpenMM_CustomHbondForce_setPerAcceptorParameterName((PointerByReference)this.pointer, (int)index, (String)name);
    }

    public void setPerAcceptorParameterName(int index, Pointer name) {
        OpenMMLibrary.OpenMM_CustomHbondForce_setPerAcceptorParameterName((PointerByReference)this.pointer, (int)index, (Pointer)name);
    }

    public void setPerDonorParameterName(int index, String name) {
        OpenMMLibrary.OpenMM_CustomHbondForce_setPerDonorParameterName((PointerByReference)this.pointer, (int)index, (String)name);
    }

    public void setPerDonorParameterName(int index, Pointer name) {
        OpenMMLibrary.OpenMM_CustomHbondForce_setPerDonorParameterName((PointerByReference)this.pointer, (int)index, (Pointer)name);
    }

    public void updateParametersInContext(Context context) {
        if (context.hasContextPointer()) {
            OpenMMLibrary.OpenMM_CustomHbondForce_updateParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer());
        }
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMLibrary.OpenMM_CustomHbondForce_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc == 1;
    }
}

