/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import ffx.openmm.Context;
import ffx.openmm.DoubleArray;
import ffx.openmm.Force;
import java.nio.IntBuffer;

public class CustomExternalForce
extends Force {
    public CustomExternalForce(String energy) {
        super(OpenMMLibrary.OpenMM_CustomExternalForce_create((String)energy));
    }

    public int addGlobalParameter(String name, double defaultValue) {
        return OpenMMLibrary.OpenMM_CustomExternalForce_addGlobalParameter((PointerByReference)this.pointer, (String)name, (double)defaultValue);
    }

    public int addParticle(int index, DoubleArray particleParameters) {
        return OpenMMLibrary.OpenMM_CustomExternalForce_addParticle((PointerByReference)this.pointer, (int)index, (PointerByReference)particleParameters.getPointer());
    }

    public int addPerParticleParameter(String name) {
        return OpenMMLibrary.OpenMM_CustomExternalForce_addPerParticleParameter((PointerByReference)this.pointer, (String)name);
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_CustomExternalForce_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public String getEnergyFunction() {
        Pointer p = OpenMMLibrary.OpenMM_CustomExternalForce_getEnergyFunction((PointerByReference)this.pointer);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public double getGlobalParameterDefaultValue(int index) {
        return OpenMMLibrary.OpenMM_CustomExternalForce_getGlobalParameterDefaultValue((PointerByReference)this.pointer, (int)index);
    }

    public String getGlobalParameterName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomExternalForce_getGlobalParameterName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public int getNumGlobalParameters() {
        return OpenMMLibrary.OpenMM_CustomExternalForce_getNumGlobalParameters((PointerByReference)this.pointer);
    }

    public int getNumParticles() {
        return OpenMMLibrary.OpenMM_CustomExternalForce_getNumParticles((PointerByReference)this.pointer);
    }

    public int getNumPerParticleParameters() {
        return OpenMMLibrary.OpenMM_CustomExternalForce_getNumPerParticleParameters((PointerByReference)this.pointer);
    }

    public void getParticleParameters(int index, IntBuffer particle, DoubleArray particleParameters) {
        OpenMMLibrary.OpenMM_CustomExternalForce_getParticleParameters((PointerByReference)this.pointer, (int)index, (IntBuffer)particle, (PointerByReference)particleParameters.getPointer());
    }

    public void getParticleParameters(int index, IntByReference particle, DoubleArray particleParameters) {
        OpenMMLibrary.OpenMM_CustomExternalForce_getParticleParameters((PointerByReference)this.pointer, (int)index, (IntByReference)particle, (PointerByReference)particleParameters.getPointer());
    }

    public String getPerParticleParameterName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomExternalForce_getPerParticleParameterName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public void setEnergyFunction(String energy) {
        OpenMMLibrary.OpenMM_CustomExternalForce_setEnergyFunction((PointerByReference)this.pointer, (String)energy);
    }

    public void setGlobalParameterDefaultValue(int index, double defaultValue) {
        OpenMMLibrary.OpenMM_CustomExternalForce_setGlobalParameterDefaultValue((PointerByReference)this.pointer, (int)index, (double)defaultValue);
    }

    public void setGlobalParameterName(int index, String name) {
        OpenMMLibrary.OpenMM_CustomExternalForce_setGlobalParameterName((PointerByReference)this.pointer, (int)index, (String)name);
    }

    public void setParticleParameters(int index, int particle, DoubleArray particleParameters) {
        OpenMMLibrary.OpenMM_CustomExternalForce_setParticleParameters((PointerByReference)this.pointer, (int)index, (int)particle, (PointerByReference)particleParameters.getPointer());
    }

    public void setPerParticleParameterName(int index, String name) {
        OpenMMLibrary.OpenMM_CustomExternalForce_setPerParticleParameterName((PointerByReference)this.pointer, (int)index, (String)name);
    }

    public void updateParametersInContext(Context context) {
        if (context.hasContextPointer()) {
            OpenMMLibrary.OpenMM_CustomExternalForce_updateParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer());
        }
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMLibrary.OpenMM_CustomExternalForce_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc == 1;
    }
}

