/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import ffx.openmm.Context;
import ffx.openmm.Force;
import ffx.openmm.TabulatedFunction;

public class CustomCVForce
extends Force {
    public CustomCVForce(String energy) {
        super(OpenMMLibrary.OpenMM_CustomCVForce_create((String)energy));
    }

    public int addCollectiveVariable(String name, PointerByReference force) {
        return OpenMMLibrary.OpenMM_CustomCVForce_addCollectiveVariable((PointerByReference)this.pointer, (String)name, (PointerByReference)force);
    }

    public int addCollectiveVariable(Pointer name, PointerByReference force) {
        return OpenMMLibrary.OpenMM_CustomCVForce_addCollectiveVariable((PointerByReference)this.pointer, (Pointer)name, (PointerByReference)force);
    }

    public void addEnergyParameterDerivative(String name) {
        OpenMMLibrary.OpenMM_CustomCVForce_addEnergyParameterDerivative((PointerByReference)this.pointer, (String)name);
    }

    public void addEnergyParameterDerivative(Pointer name) {
        OpenMMLibrary.OpenMM_CustomCVForce_addEnergyParameterDerivative((PointerByReference)this.pointer, (Pointer)name);
    }

    public int addGlobalParameter(String name, double defaultValue) {
        return OpenMMLibrary.OpenMM_CustomCVForce_addGlobalParameter((PointerByReference)this.pointer, (String)name, (double)defaultValue);
    }

    public int addGlobalParameter(Pointer name, double defaultValue) {
        return OpenMMLibrary.OpenMM_CustomCVForce_addGlobalParameter((PointerByReference)this.pointer, (Pointer)name, (double)defaultValue);
    }

    public int addTabulatedFunction(String name, TabulatedFunction function) {
        return OpenMMLibrary.OpenMM_CustomCVForce_addTabulatedFunction((PointerByReference)this.pointer, (String)name, (PointerByReference)function.getPointer());
    }

    public int addTabulatedFunction(Pointer name, TabulatedFunction function) {
        return OpenMMLibrary.OpenMM_CustomCVForce_addTabulatedFunction((PointerByReference)this.pointer, (Pointer)name, (PointerByReference)function.getPointer());
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_CustomCVForce_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public PointerByReference getCollectiveVariable(int index) {
        return OpenMMLibrary.OpenMM_CustomCVForce_getCollectiveVariable((PointerByReference)this.pointer, (int)index);
    }

    public String getCollectiveVariableName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomCVForce_getCollectiveVariableName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public void getCollectiveVariableValues(Context context, PointerByReference values) {
        OpenMMLibrary.OpenMM_CustomCVForce_getCollectiveVariableValues((PointerByReference)this.pointer, (PointerByReference)context.getPointer(), (PointerByReference)values);
    }

    public String getEnergyFunction() {
        Pointer p = OpenMMLibrary.OpenMM_CustomCVForce_getEnergyFunction((PointerByReference)this.pointer);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public String getEnergyParameterDerivativeName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomCVForce_getEnergyParameterDerivativeName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public double getGlobalParameterDefaultValue(int index) {
        return OpenMMLibrary.OpenMM_CustomCVForce_getGlobalParameterDefaultValue((PointerByReference)this.pointer, (int)index);
    }

    public String getGlobalParameterName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomCVForce_getGlobalParameterName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public PointerByReference getInnerContext(Context context) {
        return OpenMMLibrary.OpenMM_CustomCVForce_getInnerContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer());
    }

    public int getNumCollectiveVariables() {
        return OpenMMLibrary.OpenMM_CustomCVForce_getNumCollectiveVariables((PointerByReference)this.pointer);
    }

    public int getNumEnergyParameterDerivatives() {
        return OpenMMLibrary.OpenMM_CustomCVForce_getNumEnergyParameterDerivatives((PointerByReference)this.pointer);
    }

    public int getNumGlobalParameters() {
        return OpenMMLibrary.OpenMM_CustomCVForce_getNumGlobalParameters((PointerByReference)this.pointer);
    }

    public int getNumTabulatedFunctions() {
        return OpenMMLibrary.OpenMM_CustomCVForce_getNumTabulatedFunctions((PointerByReference)this.pointer);
    }

    public PointerByReference getTabulatedFunction(int index) {
        return OpenMMLibrary.OpenMM_CustomCVForce_getTabulatedFunction((PointerByReference)this.pointer, (int)index);
    }

    public String getTabulatedFunctionName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomCVForce_getTabulatedFunctionName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public void setEnergyFunction(String energy) {
        OpenMMLibrary.OpenMM_CustomCVForce_setEnergyFunction((PointerByReference)this.pointer, (String)energy);
    }

    public void setEnergyFunction(Pointer energy) {
        OpenMMLibrary.OpenMM_CustomCVForce_setEnergyFunction((PointerByReference)this.pointer, (Pointer)energy);
    }

    public void setGlobalParameterDefaultValue(int index, double defaultValue) {
        OpenMMLibrary.OpenMM_CustomCVForce_setGlobalParameterDefaultValue((PointerByReference)this.pointer, (int)index, (double)defaultValue);
    }

    public void setGlobalParameterName(int index, String name) {
        OpenMMLibrary.OpenMM_CustomCVForce_setGlobalParameterName((PointerByReference)this.pointer, (int)index, (String)name);
    }

    public void setGlobalParameterName(int index, Pointer name) {
        OpenMMLibrary.OpenMM_CustomCVForce_setGlobalParameterName((PointerByReference)this.pointer, (int)index, (Pointer)name);
    }

    public void updateParametersInContext(Context context) {
        if (context.hasContextPointer()) {
            OpenMMLibrary.OpenMM_CustomCVForce_updateParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer());
        }
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMLibrary.OpenMM_CustomCVForce_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc == 1;
    }
}

