/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import ffx.openmm.Context;
import ffx.openmm.DoubleArray;
import ffx.openmm.Force;
import java.nio.IntBuffer;

public class CustomAngleForce
extends Force {
    public CustomAngleForce(String energy) {
        super(OpenMMLibrary.OpenMM_CustomAngleForce_create((String)energy));
    }

    public int addAngle(int i1, int i2, int i3, DoubleArray parameters) {
        return OpenMMLibrary.OpenMM_CustomAngleForce_addAngle((PointerByReference)this.pointer, (int)i1, (int)i2, (int)i3, (PointerByReference)parameters.getPointer());
    }

    public void addEnergyParameterDerivative(String name) {
        OpenMMLibrary.OpenMM_CustomAngleForce_addEnergyParameterDerivative((PointerByReference)this.pointer, (String)name);
    }

    public int addGlobalParameter(String name, double value) {
        return OpenMMLibrary.OpenMM_CustomAngleForce_addGlobalParameter((PointerByReference)this.pointer, (String)name, (double)value);
    }

    public int addPerAngleParameter(String name) {
        return OpenMMLibrary.OpenMM_CustomAngleForce_addPerAngleParameter((PointerByReference)this.pointer, (String)name);
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_CustomAngleForce_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public void getAngleParameters(int index, IntBuffer i1, IntBuffer i2, IntBuffer i3, DoubleArray parameters) {
        OpenMMLibrary.OpenMM_CustomAngleForce_getAngleParameters((PointerByReference)this.pointer, (int)index, (IntBuffer)i1, (IntBuffer)i2, (IntBuffer)i3, (PointerByReference)parameters.getPointer());
    }

    public void getAngleParameters(int index, IntByReference i1, IntByReference i2, IntByReference i3, DoubleArray parameters) {
        OpenMMLibrary.OpenMM_CustomAngleForce_getAngleParameters((PointerByReference)this.pointer, (int)index, (IntByReference)i1, (IntByReference)i2, (IntByReference)i3, (PointerByReference)parameters.getPointer());
    }

    public String getEnergyFunction() {
        Pointer p = OpenMMLibrary.OpenMM_CustomAngleForce_getEnergyFunction((PointerByReference)this.pointer);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public String getEnergyParameterDerivativeName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomAngleForce_getEnergyParameterDerivativeName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public double getGlobalParameterDefaultValue(int index) {
        return OpenMMLibrary.OpenMM_CustomAngleForce_getGlobalParameterDefaultValue((PointerByReference)this.pointer, (int)index);
    }

    public String getGlobalParameterName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomAngleForce_getGlobalParameterName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public int getNumAngles() {
        return OpenMMLibrary.OpenMM_CustomAngleForce_getNumAngles((PointerByReference)this.pointer);
    }

    public int getNumEnergyParameterDerivatives() {
        return OpenMMLibrary.OpenMM_CustomAngleForce_getNumEnergyParameterDerivatives((PointerByReference)this.pointer);
    }

    public int getNumGlobalParameters() {
        return OpenMMLibrary.OpenMM_CustomAngleForce_getNumGlobalParameters((PointerByReference)this.pointer);
    }

    public int getNumPerAngleParameters() {
        return OpenMMLibrary.OpenMM_CustomAngleForce_getNumPerAngleParameters((PointerByReference)this.pointer);
    }

    public String getPerAngleParameterName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_CustomAngleForce_getPerAngleParameterName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public void setAngleParameters(int index, int i1, int i2, int i3, DoubleArray parameters) {
        OpenMMLibrary.OpenMM_CustomAngleForce_setAngleParameters((PointerByReference)this.pointer, (int)index, (int)i1, (int)i2, (int)i3, (PointerByReference)parameters.getPointer());
    }

    public void setEnergyFunction(String energy) {
        OpenMMLibrary.OpenMM_CustomAngleForce_setEnergyFunction((PointerByReference)this.pointer, (String)energy);
    }

    public void setGlobalParameterDefaultValue(int index, double value) {
        OpenMMLibrary.OpenMM_CustomAngleForce_setGlobalParameterDefaultValue((PointerByReference)this.pointer, (int)index, (double)value);
    }

    public void setGlobalParameterName(int index, String name) {
        OpenMMLibrary.OpenMM_CustomAngleForce_setGlobalParameterName((PointerByReference)this.pointer, (int)index, (String)name);
    }

    public void setPerAngleParameterName(int index, String name) {
        OpenMMLibrary.OpenMM_CustomAngleForce_setPerAngleParameterName((PointerByReference)this.pointer, (int)index, (String)name);
    }

    public void setUsesPeriodicBoundaryConditions(boolean periodic) {
        OpenMMLibrary.OpenMM_CustomAngleForce_setUsesPeriodicBoundaryConditions((PointerByReference)this.pointer, (int)(periodic ? 1 : 0));
    }

    public void updateParametersInContext(Context context) {
        if (context.hasContextPointer()) {
            OpenMMLibrary.OpenMM_CustomAngleForce_updateParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer());
        }
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMLibrary.OpenMM_CustomAngleForce_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc == 1;
    }
}

