/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import edu.uiowa.jopenmm.OpenMM_Vec3;
import ffx.openmm.Integrator;
import ffx.openmm.Platform;
import ffx.openmm.State;
import ffx.openmm.System;
import ffx.openmm.Vec3Array;

public class Context {
    private PointerByReference pointer;
    protected Integrator integrator;
    protected Platform platform;

    public Context() {
        this.pointer = null;
        this.integrator = null;
        this.platform = null;
    }

    public Context(System system, Integrator integrator, Platform platform) {
        this.pointer = OpenMMLibrary.OpenMM_Context_create_2((PointerByReference)system.getPointer(), (PointerByReference)integrator.getPointer(), (PointerByReference)platform.getPointer());
        this.integrator = integrator;
        this.platform = platform;
    }

    public void applyConstraints(double tol) {
        OpenMMLibrary.OpenMM_Context_applyConstraints((PointerByReference)this.pointer, (double)tol);
    }

    public void applyVelocityConstraints(double tol) {
        OpenMMLibrary.OpenMM_Context_applyVelocityConstraints((PointerByReference)this.pointer, (double)tol);
    }

    public void computeVirtualSites() {
        OpenMMLibrary.OpenMM_Context_computeVirtualSites((PointerByReference)this.pointer);
    }

    public void destroy() {
        if (this.integrator != null) {
            this.integrator.destroy();
            this.integrator = null;
        }
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_Context_destroy((PointerByReference)this.pointer);
            this.pointer = null;
            this.platform = null;
        }
    }

    public double getParameter(String name) {
        return OpenMMLibrary.OpenMM_Context_getParameter((PointerByReference)this.pointer, (String)name);
    }

    public double getParameter(Pointer name) {
        return OpenMMLibrary.OpenMM_Context_getParameter((PointerByReference)this.pointer, (Pointer)name);
    }

    public PointerByReference getParameters() {
        return OpenMMLibrary.OpenMM_Context_getParameters((PointerByReference)this.pointer);
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public Integrator getIntegrator() {
        return this.integrator;
    }

    public PointerByReference getPointer() {
        return this.pointer;
    }

    public State getState(int types, int enforcePeriodicBox) {
        return new State(OpenMMLibrary.OpenMM_Context_getState((PointerByReference)this.pointer, (int)types, (int)enforcePeriodicBox));
    }

    public State getState(int types, int enforcePeriodicBox, int groups) {
        return new State(OpenMMLibrary.OpenMM_Context_getState_2((PointerByReference)this.pointer, (int)types, (int)enforcePeriodicBox, (int)groups));
    }

    public long getStepCount() {
        return OpenMMLibrary.OpenMM_Context_getStepCount((PointerByReference)this.pointer);
    }

    public System getSystem() {
        PointerByReference systemPointer = OpenMMLibrary.OpenMM_Context_getSystem((PointerByReference)this.pointer);
        return new System(systemPointer);
    }

    public double getTime() {
        return OpenMMLibrary.OpenMM_Context_getTime((PointerByReference)this.pointer);
    }

    public boolean hasContextPointer() {
        return this.pointer != null;
    }

    public void reinitialize(int preserveState) {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_Context_reinitialize((PointerByReference)this.pointer, (int)preserveState);
        }
    }

    public void setParameter(String name, double value) {
        OpenMMLibrary.OpenMM_Context_setParameter((PointerByReference)this.pointer, (String)name, (double)value);
    }

    public void setParameter(Pointer name, double value) {
        OpenMMLibrary.OpenMM_Context_setParameter((PointerByReference)this.pointer, (Pointer)name, (double)value);
    }

    public void setPeriodicBoxVectors(OpenMM_Vec3 a, OpenMM_Vec3 b, OpenMM_Vec3 c) {
        OpenMMLibrary.OpenMM_Context_setPeriodicBoxVectors((PointerByReference)this.pointer, (OpenMM_Vec3)a, (OpenMM_Vec3)b, (OpenMM_Vec3)c);
    }

    public void setPositions(double[] positions) {
        Vec3Array vec3Array = Vec3Array.toVec3Array(positions);
        OpenMMLibrary.OpenMM_Context_setPositions((PointerByReference)this.pointer, (PointerByReference)vec3Array.getPointer());
        vec3Array.destroy();
    }

    public void setState(State state) {
        OpenMMLibrary.OpenMM_Context_setState((PointerByReference)this.pointer, (PointerByReference)state.getPointer());
    }

    public void setStepCount(long steps) {
        OpenMMLibrary.OpenMM_Context_setStepCount((PointerByReference)this.pointer, (long)steps);
    }

    public void setTime(double time) {
        OpenMMLibrary.OpenMM_Context_setTime((PointerByReference)this.pointer, (double)time);
    }

    public void setVelocities(double[] velocities) {
        Vec3Array velArray = Vec3Array.toVec3Array(velocities);
        OpenMMLibrary.OpenMM_Context_setVelocities((PointerByReference)this.pointer, (PointerByReference)velArray.getPointer());
        velArray.destroy();
    }

    public void setVelocitiesToTemperature(double temperature, int randomSeed) {
        OpenMMLibrary.OpenMM_Context_setVelocitiesToTemperature((PointerByReference)this.pointer, (double)temperature, (int)randomSeed);
    }

    public void updateContext(System system, Integrator integrator, Platform platform) {
        this.destroy();
        this.pointer = OpenMMLibrary.OpenMM_Context_create_2((PointerByReference)system.getPointer(), (PointerByReference)integrator.getPointer(), (PointerByReference)platform.getPointer());
        this.integrator = integrator;
        this.platform = platform;
    }
}

