/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import ffx.openmm.Integrator;

public class BrownianIntegrator
extends Integrator {
    public BrownianIntegrator(double temperature, double frictionCoeff, double stepSize) {
        super(OpenMMLibrary.OpenMM_BrownianIntegrator_create((double)temperature, (double)frictionCoeff, (double)stepSize));
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_BrownianIntegrator_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public double getFriction() {
        return OpenMMLibrary.OpenMM_BrownianIntegrator_getFriction((PointerByReference)this.pointer);
    }

    public int getRandomNumberSeed() {
        return OpenMMLibrary.OpenMM_BrownianIntegrator_getRandomNumberSeed((PointerByReference)this.pointer);
    }

    public double getTemperature() {
        return OpenMMLibrary.OpenMM_BrownianIntegrator_getTemperature((PointerByReference)this.pointer);
    }

    public void setFriction(double coeff) {
        OpenMMLibrary.OpenMM_BrownianIntegrator_setFriction((PointerByReference)this.pointer, (double)coeff);
    }

    public void setRandomNumberSeed(int seed) {
        OpenMMLibrary.OpenMM_BrownianIntegrator_setRandomNumberSeed((PointerByReference)this.pointer, (int)seed);
    }

    public void setTemperature(double temp) {
        OpenMMLibrary.OpenMM_BrownianIntegrator_setTemperature((PointerByReference)this.pointer, (double)temp);
    }

    @Override
    public void step(int steps) {
        OpenMMLibrary.OpenMM_BrownianIntegrator_step((PointerByReference)this.pointer, (int)steps);
    }
}

