/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import ffx.openmm.Force;

public class AndersenThermostat
extends Force {
    public AndersenThermostat(double defaultTemperature, double defaultCollisionFrequency) {
        super(OpenMMLibrary.OpenMM_AndersenThermostat_create((double)defaultTemperature, (double)defaultCollisionFrequency));
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_AndersenThermostat_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public double getDefaultCollisionFrequency() {
        return OpenMMLibrary.OpenMM_AndersenThermostat_getDefaultCollisionFrequency((PointerByReference)this.pointer);
    }

    public double getDefaultTemperature() {
        return OpenMMLibrary.OpenMM_AndersenThermostat_getDefaultTemperature((PointerByReference)this.pointer);
    }

    public int getRandomNumberSeed() {
        return OpenMMLibrary.OpenMM_AndersenThermostat_getRandomNumberSeed((PointerByReference)this.pointer);
    }

    public void setDefaultCollisionFrequency(double frequency) {
        OpenMMLibrary.OpenMM_AndersenThermostat_setDefaultCollisionFrequency((PointerByReference)this.pointer, (double)frequency);
    }

    public void setDefaultTemperature(double temperature) {
        OpenMMLibrary.OpenMM_AndersenThermostat_setDefaultTemperature((PointerByReference)this.pointer, (double)temperature);
    }

    public void setRandomNumberSeed(int seed) {
        OpenMMLibrary.OpenMM_AndersenThermostat_setRandomNumberSeed((PointerByReference)this.pointer, (int)seed);
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMLibrary.OpenMM_AndersenThermostat_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc != 0;
    }
}

