/*
 * Decompiled with CFR 0.152.
 */
package ffx.openmm;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.PointerByReference;
import edu.uiowa.jopenmm.OpenMMLibrary;
import edu.uiowa.jopenmm.OpenMM_Vec3;
import ffx.openmm.Context;
import ffx.openmm.Force;
import java.nio.DoubleBuffer;

public class ATMForce
extends Force {
    public ATMForce(String energy) {
        super(OpenMMLibrary.OpenMM_ATMForce_create((String)energy));
    }

    public ATMForce(double lambda1, double lambda2, double alpha, double uh, double w0, double umax, double ubcore, double acore, double direction) {
        super(OpenMMLibrary.OpenMM_ATMForce_create_2((double)lambda1, (double)lambda2, (double)alpha, (double)uh, (double)w0, (double)umax, (double)ubcore, (double)acore, (double)direction));
    }

    public void addEnergyParameterDerivative(String name) {
        OpenMMLibrary.OpenMM_ATMForce_addEnergyParameterDerivative((PointerByReference)this.pointer, (String)name);
    }

    public void addEnergyParameterDerivative(Pointer name) {
        OpenMMLibrary.OpenMM_ATMForce_addEnergyParameterDerivative((PointerByReference)this.pointer, (Pointer)name);
    }

    public int addForce(Force force) {
        return OpenMMLibrary.OpenMM_ATMForce_addForce((PointerByReference)this.pointer, (PointerByReference)force.getPointer());
    }

    public int addGlobalParameter(String name, double defaultValue) {
        return OpenMMLibrary.OpenMM_ATMForce_addGlobalParameter((PointerByReference)this.pointer, (String)name, (double)defaultValue);
    }

    public int addGlobalParameter(Pointer name, double defaultValue) {
        return OpenMMLibrary.OpenMM_ATMForce_addGlobalParameter((PointerByReference)this.pointer, (Pointer)name, (double)defaultValue);
    }

    public int addParticle(OpenMM_Vec3 displacement1, OpenMM_Vec3 displacement0) {
        return OpenMMLibrary.OpenMM_ATMForce_addParticle((PointerByReference)this.pointer, (OpenMM_Vec3)displacement1, (OpenMM_Vec3)displacement0);
    }

    @Override
    public void destroy() {
        if (this.pointer != null) {
            OpenMMLibrary.OpenMM_ATMForce_destroy((PointerByReference)this.pointer);
            this.pointer = null;
        }
    }

    public String getEnergyFunction() {
        Pointer p = OpenMMLibrary.OpenMM_ATMForce_getEnergyFunction((PointerByReference)this.pointer);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public String getEnergyParameterDerivativeName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_ATMForce_getEnergyParameterDerivativeName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public PointerByReference getForce(int index) {
        return OpenMMLibrary.OpenMM_ATMForce_getForce((PointerByReference)this.pointer, (int)index);
    }

    public double getGlobalParameterDefaultValue(int index) {
        return OpenMMLibrary.OpenMM_ATMForce_getGlobalParameterDefaultValue((PointerByReference)this.pointer, (int)index);
    }

    public String getGlobalParameterName(int index) {
        Pointer p = OpenMMLibrary.OpenMM_ATMForce_getGlobalParameterName((PointerByReference)this.pointer, (int)index);
        if (p == null) {
            return null;
        }
        return p.getString(0L);
    }

    public int getNumEnergyParameterDerivatives() {
        return OpenMMLibrary.OpenMM_ATMForce_getNumEnergyParameterDerivatives((PointerByReference)this.pointer);
    }

    public int getNumForces() {
        return OpenMMLibrary.OpenMM_ATMForce_getNumForces((PointerByReference)this.pointer);
    }

    public int getNumGlobalParameters() {
        return OpenMMLibrary.OpenMM_ATMForce_getNumGlobalParameters((PointerByReference)this.pointer);
    }

    public int getNumParticles() {
        return OpenMMLibrary.OpenMM_ATMForce_getNumParticles((PointerByReference)this.pointer);
    }

    public void getParticleParameters(int index, OpenMM_Vec3 displacement1, OpenMM_Vec3 displacement0) {
        OpenMMLibrary.OpenMM_ATMForce_getParticleParameters((PointerByReference)this.pointer, (int)index, (OpenMM_Vec3)displacement1, (OpenMM_Vec3)displacement0);
    }

    public void getPerturbationEnergy(Context context, DoubleByReference u0, DoubleByReference u1, DoubleByReference energy) {
        OpenMMLibrary.OpenMM_ATMForce_getPerturbationEnergy((PointerByReference)this.pointer, (PointerByReference)context.getPointer(), (DoubleByReference)u0, (DoubleByReference)u1, (DoubleByReference)energy);
    }

    public void getPerturbationEnergy(Context context, DoubleBuffer u0, DoubleBuffer u1, DoubleBuffer energy) {
        OpenMMLibrary.OpenMM_ATMForce_getPerturbationEnergy((PointerByReference)this.pointer, (PointerByReference)context.getPointer(), (DoubleBuffer)u0, (DoubleBuffer)u1, (DoubleBuffer)energy);
    }

    public void setEnergyFunction(String energy) {
        OpenMMLibrary.OpenMM_ATMForce_setEnergyFunction((PointerByReference)this.pointer, (String)energy);
    }

    public void setEnergyFunction(Pointer energy) {
        OpenMMLibrary.OpenMM_ATMForce_setEnergyFunction((PointerByReference)this.pointer, (Pointer)energy);
    }

    public void setGlobalParameterDefaultValue(int index, double defaultValue) {
        OpenMMLibrary.OpenMM_ATMForce_setGlobalParameterDefaultValue((PointerByReference)this.pointer, (int)index, (double)defaultValue);
    }

    public void setGlobalParameterName(int index, String name) {
        OpenMMLibrary.OpenMM_ATMForce_setGlobalParameterName((PointerByReference)this.pointer, (int)index, (String)name);
    }

    public void setGlobalParameterName(int index, Pointer name) {
        OpenMMLibrary.OpenMM_ATMForce_setGlobalParameterName((PointerByReference)this.pointer, (int)index, (Pointer)name);
    }

    public void setParticleParameters(int index, OpenMM_Vec3 displacement1, OpenMM_Vec3 displacement0) {
        OpenMMLibrary.OpenMM_ATMForce_setParticleParameters((PointerByReference)this.pointer, (int)index, (OpenMM_Vec3)displacement1, (OpenMM_Vec3)displacement0);
    }

    public void updateParametersInContext(Context context) {
        if (context.hasContextPointer()) {
            OpenMMLibrary.OpenMM_ATMForce_updateParametersInContext((PointerByReference)this.pointer, (PointerByReference)context.getPointer());
        }
    }

    @Override
    public boolean usesPeriodicBoundaryConditions() {
        int pbc = OpenMMLibrary.OpenMM_ATMForce_usesPeriodicBoundaryConditions((PointerByReference)this.pointer);
        return pbc == 1;
    }
}

