/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import java.util.Enumeration;
import javax.media.j3d.Background;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Clip;
import javax.media.j3d.Fog;
import javax.media.j3d.Group;
import javax.media.j3d.Light;
import javax.media.j3d.Locale;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Soundscape;
import javax.media.j3d.ViewPlatform;
import javax.vecmath.Color3f;

public class Leafer {
    static final int LIGHTS = 0;
    static final int BOUNDINGLEAF = 1;
    static final int VIEWPLAT = 2;
    static final int SHAPE = 3;
    static final int UNLINKABLE = 9;

    public static void clean(Locale l, int leafType) {
        try {
            Enumeration e = l.getAllBranchGraphs();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o instanceof Locale) {
                    Leafer.clean((Locale)o, leafType);
                    continue;
                }
                if (o instanceof SceneGraphObject) {
                    Leafer.clean((SceneGraphObject)o, leafType);
                    continue;
                }
                System.out.println(o + " unknown and in tree");
            }
        }
        catch (CapabilityNotSetException capabilityNotSetException) {
            // empty catch block
        }
    }

    public static void clean(SceneGraphObject sgo, int leafType) {
        if (sgo instanceof Group) {
            try {
                Enumeration e = ((Group)sgo).getAllChildren();
                while (e.hasMoreElements()) {
                    Leafer.clean((SceneGraphObject)e.nextElement(), leafType);
                }
            }
            catch (CapabilityNotSetException capabilityNotSetException) {}
        } else {
            switch (leafType) {
                case 0: {
                    if (!(sgo instanceof Light)) break;
                    ((Light)sgo).setEnable(false);
                    break;
                }
            }
        }
    }

    public static boolean has(Locale l, int leafType) {
        try {
            Enumeration e = l.getAllBranchGraphs();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o instanceof Locale) {
                    return Leafer.has((Locale)o, leafType);
                }
                if (o instanceof SceneGraphObject) {
                    return Leafer.has((SceneGraphObject)o, leafType);
                }
                System.out.println(o + " unknown and in tree");
            }
        }
        catch (CapabilityNotSetException capabilityNotSetException) {
            // empty catch block
        }
        return false;
    }

    public static boolean has(SceneGraphObject sgo, int leafType) {
        if (sgo instanceof Group) {
            try {
                Enumeration e = ((Group)sgo).getAllChildren();
                boolean hasIt = false;
                while (e.hasMoreElements()) {
                    hasIt |= Leafer.has((SceneGraphObject)e.nextElement(), leafType);
                }
                return hasIt;
            }
            catch (CapabilityNotSetException e) {
                ((Group)sgo).setCapability(12);
                return Leafer.has(sgo, leafType);
            }
        }
        switch (leafType) {
            case 0: {
                if (!(sgo instanceof Light)) break;
                Color3f c = new Color3f();
                ((Light)sgo).getColor(c);
                System.out.println(c);
                System.out.println(sgo + " found");
                return true;
            }
            case 1: {
                if (!(sgo instanceof BoundingLeaf)) break;
                return true;
            }
            case 2: {
                if (!(sgo instanceof ViewPlatform)) break;
                return true;
            }
            case 3: {
                if (!(sgo instanceof Shape3D)) break;
                return true;
            }
            case 9: {
                return sgo instanceof Background | sgo instanceof Behavior | sgo instanceof Clip | sgo instanceof Fog | sgo instanceof Soundscape | sgo instanceof ViewPlatform;
            }
        }
        return false;
    }
}

