/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import com.sun.j3d.audioengines.javasound.JavaSoundMixer;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.AudioDevice3D;
import javax.media.j3d.AuralAttributes;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Group;
import javax.media.j3d.Locale;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.PickRay;
import javax.media.j3d.PointSound;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Soundscape;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;
import org.jdesktop.j3d.loaders.vrml97.impl.AudioClip;
import org.jdesktop.j3d.loaders.vrml97.impl.Background;
import org.jdesktop.j3d.loaders.vrml97.impl.BaseNode;
import org.jdesktop.j3d.loaders.vrml97.impl.ContentNegotiator;
import org.jdesktop.j3d.loaders.vrml97.impl.DirectionalLight;
import org.jdesktop.j3d.loaders.vrml97.impl.Evagation;
import org.jdesktop.j3d.loaders.vrml97.impl.Field;
import org.jdesktop.j3d.loaders.vrml97.impl.Fog;
import org.jdesktop.j3d.loaders.vrml97.impl.FrameCounter;
import org.jdesktop.j3d.loaders.vrml97.impl.GroupBase;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.MFNode;
import org.jdesktop.j3d.loaders.vrml97.impl.NavigationInfo;
import org.jdesktop.j3d.loaders.vrml97.impl.Node;
import org.jdesktop.j3d.loaders.vrml97.impl.NumFormat;
import org.jdesktop.j3d.loaders.vrml97.impl.RGroup;
import org.jdesktop.j3d.loaders.vrml97.impl.RoutePrinter;
import org.jdesktop.j3d.loaders.vrml97.impl.SFBool;
import org.jdesktop.j3d.loaders.vrml97.impl.Scene;
import org.jdesktop.j3d.loaders.vrml97.impl.SceneTransform;
import org.jdesktop.j3d.loaders.vrml97.impl.Script;
import org.jdesktop.j3d.loaders.vrml97.impl.SimTicker;
import org.jdesktop.j3d.loaders.vrml97.impl.SphereSensor;
import org.jdesktop.j3d.loaders.vrml97.impl.Time;
import org.jdesktop.j3d.loaders.vrml97.impl.TimeSensor;
import org.jdesktop.j3d.loaders.vrml97.impl.TouchSensor;
import org.jdesktop.j3d.loaders.vrml97.impl.TransformBuf;
import org.jdesktop.j3d.loaders.vrml97.impl.TreePrinter;
import org.jdesktop.j3d.loaders.vrml97.impl.Viewpoint;
import org.jdesktop.j3d.loaders.vrml97.impl.WorldInfo;
import vrml.InvalidEventInException;
import vrml.InvalidEventOutException;
import vrml.InvalidVRMLSyntaxException;

public class Browser {
    String name = "Java3D VRML'97 Browser";
    String version = "unknown";
    String description;
    float speed;
    float frameRate;
    Canvas3D canvas;
    VirtualUniverse universe;
    Locale locale;
    PhysicalBody body;
    PhysicalEnvironment environment;
    View view;
    AudioDevice3D audioDevice;
    BranchGroup browserRoot;
    javax.media.j3d.DirectionalLight browserDirLight;
    AmbientLight browserAmbLight;
    Evagation evagation;
    SimTicker simTicker;
    FrameCounter frameCount;
    BranchGroup browserSoundAtts;
    BranchGroup browserLightGroup;
    RGroup browserBackgroundSlot;
    RGroup browserFogSlot;
    Stack viewpointStack = null;
    Stack navigationInfoStack = null;
    Stack fogStack = null;
    Stack backgroundStack = null;
    Viewpoint defViewpoint;
    NavigationInfo defNavInfo;
    SphereSensor sceneExaminer;
    Background defBackground;
    Fog defFog;
    WorldInfo defWorldInfo;
    Loader loader;
    BranchGroup curScene;
    SceneTransform curSceneT;
    BoundingSphere sceneBounds;
    Vector viewpointList;
    Vector sharedGroups;
    Vector timeSensors;
    Vector visibilitySensors;
    Vector touchSensors;
    Vector audioClips;
    Viewpoint initViewpoint;
    NavigationInfo initNavInfo;
    Background initBackground;
    Fog initFog;
    WorldInfo initWorldInfo;
    NavigationInfo curNavInfo;
    Background curBackground;
    Fog curFog;
    Viewpoint curViewpoint;
    WorldInfo curWorldInfo;
    TransformGroup curViewGroup;
    TransformGroup curImplGroup;
    BranchGroup curImplGroupBranch;
    ViewPlatform curViewPlatform;
    TransformBuf pendingTransforms = new TransformBuf();
    boolean simTickEnable = false;
    boolean resetOnNextFrame = false;
    boolean stopped = false;
    boolean soundinited = false;
    double eventTime;
    PickRay pickRay = new PickRay();
    SceneGraphPath[] stuffPicked;
    Transform3D identity = new Transform3D();
    RoutePrinter routePrinter = new RoutePrinter();
    TreePrinter treePrinter = new TreePrinter();
    static boolean printRoutes = false;
    int routeDepth = 0;
    int numTris = 0;
    NumFormat numFormat = new NumFormat();
    int numFrames = 0;
    int numSimTicks = 0;
    double renderTime = 0.0;
    double routeTime = 0.0;
    double frameStartTime = 0.0;
    double netStartTime = 0.0;
    double start;
    static long memUsage;
    static long memLowLimit;
    static boolean debug;
    static boolean debug2;
    boolean timing;
    boolean pickEcho;
    double attachTime;
    boolean checkDelay;
    double relTimeBase = 0.0;
    Vector debugVec = new Vector();
    Container container;
    BoundingLeaf defBoundingLeaf;
    static Browser instance;
    int vi = 0;

    public Browser(Canvas3D vc3d) {
        this.canvas = vc3d;
        this.browserInit();
    }

    public Browser() {
        this.canvas = new Canvas3D(null);
        this.browserInit();
    }

    void browserInit() {
        this.loader = new Loader(this);
        this.timing = this.loader.timing;
        printRoutes = this.loader.printRoutes;
        debug = this.loader.debug;
        this.initBrowserObjs();
        this.loadDefaults();
    }

    void initBrowserObjs() {
        instance = this;
        this.loader = new Loader(this);
        this.fogStack = new Stack();
        this.viewpointStack = new Stack();
        this.backgroundStack = new Stack();
        this.navigationInfoStack = new Stack();
        this.defViewpoint = new Viewpoint(this.loader);
        this.defNavInfo = new NavigationInfo(this.loader);
        this.defBackground = new Background(this.loader);
        this.defWorldInfo = new WorldInfo(this.loader);
        this.defViewpoint.initImpl();
        this.defNavInfo.initImpl();
        this.defBackground.initImpl();
        this.defWorldInfo.initImpl();
        this.universe = new VirtualUniverse();
        this.locale = new Locale(this.universe);
        this.body = new PhysicalBody();
        this.environment = new PhysicalEnvironment();
        this.view = new View();
        this.view.addCanvas3D(this.canvas);
        this.view.setPhysicalBody(this.body);
        this.view.setPhysicalEnvironment(this.environment);
        this.browserRoot = new RGroup();
        this.curSceneT = new SceneTransform(this.loader);
        this.curSceneT.initImpl();
        this.evagation = new Evagation(this);
        this.evagation.setSchedulingBoundingLeaf(this.loader.infiniteBoundingLeaf);
        this.browserRoot.addChild((javax.media.j3d.Node)this.evagation);
        this.simTicker = new SimTicker(this);
        this.simTicker.setSchedulingBoundingLeaf(this.loader.infiniteBoundingLeaf);
        this.browserRoot.addChild((javax.media.j3d.Node)this.simTicker);
        this.browserBackgroundSlot = new RGroup();
        this.browserBackgroundSlot.addChild((javax.media.j3d.Node)this.defBackground.getBackgroundImpl());
        this.browserRoot.addChild((javax.media.j3d.Node)this.browserBackgroundSlot);
        this.browserFogSlot = new RGroup();
        this.browserRoot.addChild((javax.media.j3d.Node)this.browserFogSlot);
        this.browserRoot.addChild(this.defViewpoint.getImplNode());
        this.locale.addBranchGraph(this.browserRoot);
        this.browserAmbLight = new AmbientLight(true, new Color3f(0.2f, 0.2f, 0.2f));
        this.browserAmbLight.setCapability(13);
        this.browserDirLight = new javax.media.j3d.DirectionalLight();
        this.browserDirLight.setColor(new Color3f(0.8f, 0.8f, 0.8f));
        this.browserDirLight.setCapability(13);
        this.browserDirLight.setInfluencingBounds(this.loader.infiniteBounds);
        this.browserLightGroup = new RGroup();
        this.browserLightGroup.addChild((javax.media.j3d.Node)this.browserDirLight);
        this.browserLightGroup.addChild((javax.media.j3d.Node)this.browserAmbLight);
        AuralAttributes aa = new AuralAttributes();
        aa.setFrequencyScaleFactor(0.1f);
        Soundscape sc = new Soundscape(this.loader.infiniteBoundingLeaf.getRegion(), aa);
        this.browserSoundAtts = new RGroup();
        this.browserSoundAtts.addChild((javax.media.j3d.Node)sc);
        this.browserRoot.addChild((javax.media.j3d.Node)this.browserSoundAtts);
        this.audioDevice = new JavaSoundMixer(this.environment);
        this.audioDevice.initialize();
        this.environment.setAudioDevice((AudioDevice)this.audioDevice);
    }

    void loadDefaults() {
        this.curViewpoint = this.defViewpoint;
        this.curNavInfo = this.defNavInfo;
        this.curBackground = this.defBackground;
        this.initViewpoint = null;
        this.initNavInfo = null;
        this.initBackground = null;
        this.initFog = null;
        try {
            this.browserFogSlot.detach();
            while (this.browserFogSlot.numChildren() > 0) {
                this.browserFogSlot.removeChild(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.browserFogSlot = new RGroup();
        this.browserRoot.addChild((javax.media.j3d.Node)this.browserFogSlot);
        this.browserBackgroundSlot.removeChild(0);
        this.browserBackgroundSlot.addChild((javax.media.j3d.Node)this.defBackground.getBackgroundImpl());
        this.updateView();
    }

    public synchronized void loadURL(String[] urlString, String[] parameter) throws InvalidVRMLSyntaxException, IOException, MalformedURLException {
        URL worldURL;
        block7: {
            worldURL = null;
            URL cb = null;
            this.simTickEnable = false;
            this.simTicker.setEnable(false);
            System.gc();
            urlString[0] = urlString[0].replace('\\', '/');
            try {
                worldURL = new URL(urlString[0]);
            }
            catch (MalformedURLException murle) {
                if (murle.getMessage().indexOf("no protocol") < 0) break block7;
                try {
                    if (this.container instanceof Applet) {
                        cb = ((Applet)this.container).getCodeBase();
                    }
                    worldURL = new URL(cb, urlString[0]);
                }
                catch (MalformedURLException murle2) {
                    murle2.printStackTrace();
                }
            }
        }
        this.loader.setWorldURL(null, worldURL);
        ContentNegotiator cn = new ContentNegotiator(worldURL);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream((byte[])cn.getContent());
            this.doParse(bais);
        }
        catch (NullPointerException npe) {
            throw new IOException();
        }
        this.loadFinalize();
    }

    public void loadStringAsVrml(String sourceVrml) {
        this.simTickEnable = false;
        this.simTicker.setEnable(false);
        ByteArrayInputStream bais = new ByteArrayInputStream(sourceVrml.getBytes());
        this.doParse(bais);
        this.loadFinalize();
    }

    void doParse(InputStream is) {
        this.clear();
        if (this.loader.debug) {
            System.out.println("locale before scene is added:");
            this.browserRoot.detach();
            this.treePrinter.print((SceneGraphObject)this.browserRoot);
            this.locale.addBranchGraph(this.browserRoot);
            System.out.println();
        }
        this.curScene = new RGroup();
        this.curSceneT = new SceneTransform(this.loader);
        this.curSceneT.initImpl();
        this.sceneExaminer = new SphereSensor(this.loader);
        this.sceneExaminer.autoSpinFrameWait.setValue(1);
        MFNode curSceneNodes = (MFNode)this.curSceneT.getField("addChildren");
        curSceneNodes.addValue(this.sceneExaminer);
        this.curScene.addChild((javax.media.j3d.Node)this.curSceneT.impl);
        Scene scene = null;
        try {
            scene = this.loader.load(is);
        }
        catch (Exception e) {
            this.containerMessage(this.container, e.toString());
            this.clear();
        }
        Enumeration e = scene.objects.elements();
        while (e.hasMoreElements()) {
            BaseNode node = (BaseNode)e.nextElement();
            if (node == null) continue;
            if (debug) {
                System.out.println("Adding to browser " + node.toStringId());
            }
            node.updateParent((javax.media.j3d.Node)this.curSceneT.impl);
            javax.media.j3d.Node implNode = node.getImplNode();
            if (node instanceof GroupBase) {
                this.debugVec.addElement(node);
            }
            if (node instanceof Viewpoint && implNode != null) {
                this.curScene.addChild(implNode);
                continue;
            }
            if (implNode == null) continue;
            implNode.setCapability(3);
            implNode.setCapability(11);
            if (debug) {
                System.out.println("curScene: " + this.curScene);
            }
            if (debug) {
                System.out.println("Adding to scene " + implNode);
            }
            this.curSceneT.impl.addChild(implNode);
            if (!(node instanceof DirectionalLight)) continue;
            javax.media.j3d.DirectionalLight dirLight = ((DirectionalLight)node).dirLight;
            dirLight.addScope((Group)this.curSceneT.impl);
        }
        this.curSceneT.impl.setCapability(6);
        this.curSceneT.impl.setCapability(1);
        this.curSceneT.impl.setPickable(true);
        this.viewpointList = scene.viewpoints;
        if (scene.viewpoints.size() > 0) {
            this.initViewpoint = (Viewpoint)scene.viewpoints.elementAt(0);
        }
        if (scene.navInfos.size() > 0) {
            this.initNavInfo = (NavigationInfo)scene.navInfos.elementAt(0);
        }
        if (scene.backgrounds.size() > 0) {
            this.initBackground = (Background)scene.backgrounds.elementAt(0);
        }
        if (scene.fogs.size() > 0) {
            this.initFog = (Fog)scene.fogs.elementAt(0);
        }
        this.timeSensors = scene.timeSensors;
        this.visibilitySensors = scene.visibilitySensors;
        this.touchSensors = scene.touchSensors;
        this.sharedGroups = scene.sharedGroups;
        this.audioClips = scene.audioClips;
        this.numTris = scene.numTris;
        this.curWorldInfo = scene.worldInfo != null ? scene.worldInfo : this.defWorldInfo;
        this.name = this.curWorldInfo.title.getValue();
        this.description = this.curWorldInfo.info.get1Value(0);
        if (debug) {
            System.out.println("Parsed scene makes J3D scene graph:");
            this.treePrinter.print((SceneGraphObject)this.curScene);
        }
        if (debug) {
            System.out.println("Locale already has " + this.locale.numBranchGraphs());
            this.browserRoot.detach();
            this.treePrinter.print((SceneGraphObject)this.browserRoot);
            this.locale.addBranchGraph(this.browserRoot);
        }
        this.locale.addBranchGraph(this.curScene);
        this.cleanUp();
        if (debug || this.timing) {
            System.out.println("Scene contains " + this.numTris + " triangles");
        }
        if (debug) {
            System.out.println("Load completed");
        }
    }

    protected void clear() {
        if (debug) {
            System.out.println("Browser:clear()");
        }
        if (this.curScene != null) {
            this.curScene.detach();
        }
        this.curScene = null;
        this.loadDefaults();
        this.numTris = 0;
        this.loader.clear();
        this.disableSounds();
        this.viewpointList = null;
        this.timeSensors = null;
        this.visibilitySensors = null;
        this.touchSensors = null;
        this.audioClips = null;
        this.viewpointStack.removeAllElements();
        this.navigationInfoStack.removeAllElements();
        this.fogStack.removeAllElements();
        this.backgroundStack.removeAllElements();
        this.evagation.resetViewpoint();
        this.debugVec = new Vector();
        this.cleanUp();
        this.audioDevice = new JavaSoundMixer(this.environment);
        this.audioDevice.initialize();
        this.environment.setAudioDevice((AudioDevice)this.audioDevice);
    }

    void loadFinalize() {
        SFBool set_bind;
        int i;
        for (i = 0; i < this.timeSensors.size(); ++i) {
            ((TimeSensor)this.timeSensors.elementAt(i)).doneParse();
        }
        if (printRoutes) {
            for (i = 0; i < this.touchSensors.size(); ++i) {
                this.routePrinter.printRoutes((TouchSensor)this.touchSensors.elementAt(i));
            }
        }
        if (this.initFog != null) {
            set_bind = (SFBool)this.initFog.getEventIn("bind");
            set_bind.setValue(true);
        }
        if (this.initBackground != null) {
            set_bind = (SFBool)this.initBackground.getEventIn("bind");
            set_bind.setValue(true);
        }
        if (this.initNavInfo != null) {
            set_bind = (SFBool)this.initNavInfo.getEventIn("bind");
            set_bind.setValue(true);
        }
        if (this.initViewpoint != null) {
            set_bind = (SFBool)this.initViewpoint.getEventIn("bind");
            set_bind.setValue(true);
        }
        this.simTickEnable = true;
        this.simTicker.setEnable(true);
        this.sceneBounds = (BoundingSphere)this.curSceneT.impl.getBounds();
        if (this.sceneBounds.getRadius() == 0.0) {
            this.sceneBounds.setRadius(1.0);
            this.curScene.setBounds((Bounds)this.sceneBounds);
        }
        this.curSceneT.setSceneBounds(this.sceneBounds);
        this.sceneExaminer.spinKick.setValue((float)this.sceneBounds.getRadius() / 2.0f);
        if (this.viewpointList.size() == 0) {
            this.curViewpoint.frameObject(this.sceneBounds);
        }
        this.querySounds();
        this.frameCountAdd();
        this.initTiming();
        this.resetViewpoint();
    }

    synchronized void querySounds() {
        for (int i = 0; i < this.audioClips.size(); ++i) {
            AudioClip cl = (AudioClip)this.audioClips.elementAt(i);
            PointSound s = cl.sound.soundImpl;
            MediaContainer mc = cl.impl;
            s.setSoundData(mc);
            cl.setDuration((double)s.getDuration() / 1000.0);
        }
        int numChannels = this.audioDevice.getTotalChannels();
        if (debug) {
            System.out.println("audioDevice has " + numChannels + "channels");
        }
    }

    void frameCountAdd() {
        if (this.browserRoot != null) {
            Enumeration e = this.browserRoot.getAllChildren();
            int ind = 0;
            try {
                while (e.hasMoreElements() && e.nextElement() != this.frameCount.rHandle) {
                    ++ind;
                }
                if (this.browserRoot.getChild(ind) == this.frameCount.rHandle) {
                    this.browserRoot.removeChild(ind);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.frameCount = new FrameCounter(this, 4, "soundSync");
            this.frameCount.setSchedulingBoundingLeaf(this.loader.infiniteBoundingLeaf);
            this.browserRoot.addChild((javax.media.j3d.Node)this.frameCount.rHandle);
        }
    }

    void frameCountCallback(FrameCounter b) {
        if (b.name.equals("soundSync")) {
            this.querySounds();
        }
    }

    protected void addViewpoint(Viewpoint viewpoint) {
        if (this.initViewpoint == null) {
            this.initViewpoint = viewpoint;
        }
        this.viewpointList.addElement(viewpoint);
    }

    void updateView() {
        if (debug) {
            System.out.println("updateView");
        }
        this.evagation.resetViewpoint();
        this.curImplGroupBranch = this.curViewpoint.impl;
        this.curImplGroup = this.curViewpoint.implOrient;
        this.curViewGroup = this.curViewpoint.implBrowser;
        this.curViewPlatform = this.curViewpoint.implViewPlatform;
        this.curViewGroup.setTransform(this.identity);
        this.curViewPlatform.setActivationRadius(2112.0f);
        this.view.setFieldOfView((double)this.curViewpoint.fieldOfView.value);
        double frontClip = this.curNavInfo.avatarSize.mfloat.length > 0 ? (double)this.curNavInfo.avatarSize.mfloat[0] / 2.0 : 0.125;
        this.view.setFrontClipDistance(frontClip);
        double backClip = (double)this.curNavInfo.visibilityLimit.value > 0.0 ? (double)this.curNavInfo.visibilityLimit.value : frontClip * 2999.0;
        this.view.setBackClipDistance(backClip);
        this.browserDirLight.setEnable(this.curNavInfo.headlight.value);
        this.browserAmbLight.setEnable(this.curNavInfo.headlight.value);
        this.browserLightGroup.detach();
        this.curViewGroup.addChild((javax.media.j3d.Node)this.browserLightGroup);
        this.view.attachViewPlatform(this.curViewPlatform);
        this.view.setPhysicalBody(this.body);
        this.view.setPhysicalEnvironment(this.environment);
        if (this.timing) {
            this.start = Time.getNow();
        }
        this.evagation.setViewGroup(this.curViewGroup);
        try {
            float s = 1.6f / this.curNavInfo.avatarSize.mfloat[1];
            this.curSceneT.scale.setValue(s, s, s);
        }
        catch (NullPointerException npe) {
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            // empty catch block
        }
        this.cleanUp();
    }

    void updateBackground() {
        this.browserBackgroundSlot.removeChild(0);
        this.browserBackgroundSlot.addChild((javax.media.j3d.Node)this.curBackground.getBackgroundImpl());
    }

    void updateFog() {
        try {
            this.browserFogSlot.detach();
            while (this.browserFogSlot.numChildren() > 0) {
                this.browserFogSlot.removeChild(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.browserFogSlot = new RGroup();
        this.browserRoot.addChild((javax.media.j3d.Node)this.browserFogSlot);
        this.browserFogSlot.addChild((javax.media.j3d.Node)this.curFog.getFogImpl());
    }

    void viewChanged(Viewpoint changedView) {
        if (changedView == this.curViewpoint) {
            this.view.setFieldOfView((double)this.curViewpoint.fieldOfView.value);
        }
    }

    public void setViewpoint(int vi) {
        if (this.viewpointList.size() > 0) {
            Viewpoint viewpoint = (Viewpoint)this.viewpointList.elementAt(vi);
            SFBool set_bind = (SFBool)viewpoint.getEventIn("bind");
            set_bind.setValue(true);
        }
    }

    public void resetViewpoint() {
        this.updateView();
    }

    public String[] getViewpointDescriptions() {
        String[] vd = new String[this.viewpointList.size()];
        for (int i = 0; i < this.viewpointList.size(); ++i) {
            Viewpoint cur = (Viewpoint)this.viewpointList.elementAt(i);
            vd[i] = cur.description.string == null || cur.description.string.equals("") ? "Viewpoint " + i : cur.description.string;
        }
        return vd;
    }

    void bindableChanged(Stack changedStack) {
        Fog newFog;
        if (debug) {
            System.out.println(this + "bindableChanged()" + changedStack);
        }
        if (changedStack == this.viewpointStack) {
            Viewpoint newViewpoint = (Viewpoint)this.viewpointStack.peek();
            if (newViewpoint != null && newViewpoint != this.curViewpoint) {
                if (debug) {
                    System.out.println(newViewpoint + " bound");
                }
                this.curViewpoint = newViewpoint;
                this.updateView();
            }
        } else if (changedStack == this.navigationInfoStack) {
            NavigationInfo newNavInfo = (NavigationInfo)this.navigationInfoStack.peek();
            if (newNavInfo != this.curNavInfo && newNavInfo != null) {
                this.curNavInfo = newNavInfo;
                this.updateView();
            }
        } else if (changedStack == this.backgroundStack) {
            Background newBackground = (Background)this.backgroundStack.peek();
            if (newBackground != this.curBackground && newBackground != null) {
                this.curBackground = newBackground;
                this.updateBackground();
            }
        } else if (changedStack == this.fogStack && (newFog = (Fog)this.fogStack.peek()) != this.curFog && newFog != null) {
            this.curFog = newFog;
            this.updateFog();
        }
    }

    void preRender() {
        if (this.timing) {
            this.frameStartTime = Time.getNow();
            if (this.checkDelay) {
                double delay = this.frameStartTime - this.attachTime;
                System.out.println("Attach to render delay = " + this.numFormat.format(delay, 2) + " seconds");
            }
        }
        try {
            this.simTick();
        }
        catch (Exception e0) {
            e0.printStackTrace();
        }
    }

    void postRender() {
        if (this.timing) {
            double now = Time.getNow();
            double elapsed = now - this.frameStartTime;
            this.renderTime += elapsed;
            if (elapsed < 0.0) {
                System.out.println("Negative elaspsed time for frame: " + this.numFormat.format(elapsed, 2) + " seconds");
                this.renderTime = -1.0;
            }
            if (this.checkDelay) {
                System.out.println("Time to render first frame = " + this.numFormat.format(elapsed, 2) + " seconds");
                this.checkDelay = false;
            }
        }
        ++this.numFrames;
        if (this.timing && this.numFrames % 10 == 0) {
            this.outputTiming();
        }
        if (this.resetOnNextFrame) {
            this.resetTiming();
            this.resetOnNextFrame = false;
        }
    }

    void initTiming() {
        Time.setSystemInitTime();
        this.resetTiming();
    }

    void resetTiming() {
        double now;
        this.netStartTime = now = Time.getNow();
        this.renderTime = 0.0;
        this.routeTime = 0.0;
        this.numFrames = 0;
        this.numSimTicks = 0;
    }

    double relativeTime(double timeVal) {
        if (this.relTimeBase == 0.0) {
            this.relTimeBase = timeVal;
        }
        return timeVal - this.relTimeBase;
    }

    double beginRoute() {
        if (this.routeDepth++ == 0) {
            this.eventTime = Time.getNow();
        }
        return this.eventTime;
    }

    void beginRoute(double now) {
        if (this.routeDepth++ == 0) {
            this.eventTime = now;
        }
    }

    double eventTime() {
        return this.eventTime;
    }

    void endRoute() {
        --this.routeDepth;
    }

    void simTick() {
        Enumeration e;
        double now = Time.getNow();
        ++this.numSimTicks;
        this.pendingTransforms.startBatchLoading();
        this.beginRoute(now);
        if (this.timeSensors != null) {
            e = this.timeSensors.elements();
            while (e.hasMoreElements()) {
                TimeSensor ts = (TimeSensor)e.nextElement();
                if (!ts.enabled.value) continue;
                ts.simTick(Time.getNow());
            }
        }
        if (this.audioClips != null) {
            e = this.audioClips.elements();
            while (e.hasMoreElements()) {
                AudioClip clip = (AudioClip)e.nextElement();
                if (clip.sound == null) continue;
                clip.simTick(now);
            }
        }
        this.evagation.simTick(now);
        this.pendingTransforms.stopBatchLoading();
        for (int i = 0; i < this.pendingTransforms.size; ++i) {
            this.pendingTransforms.array[i].updateTransform();
            this.pendingTransforms.array[i] = null;
        }
        this.pendingTransforms.size = 0;
        this.endRoute();
        this.routeTime += Time.getNow() - now;
    }

    public void outputTiming() {
        if (this.numFrames > 0 && this.timing) {
            double now = Time.getNow();
            double elapsed = now - this.netStartTime;
            double netTrisPerSec = (double)(this.numTris * this.numFrames) / (1000.0 * elapsed);
            double trisPerSec = (double)(this.numTris * this.numFrames) / (1000.0 * this.renderTime);
            System.out.print(this.numFormat.format(elapsed, 1) + " seconds " + this.numFrames + " frames " + "overall: " + this.numFormat.format(netTrisPerSec, 1) + "K tris/sec");
            if (this.renderTime > 0.0) {
                System.out.println(" render: " + this.numFormat.format(trisPerSec, 1) + "K tris/sec");
            } else {
                System.out.println(" render: ???");
            }
            if (this.routeTime > 0.0) {
                System.out.println(this.numFormat.format(this.routeTime, 2) + " seconds updating nodes (" + this.numFormat.format(this.routeTime * 100.0 / elapsed, 1) + "%) " + this.numSimTicks + " ticks " + this.numFormat.format(this.routeTime * 1000.0 / (double)this.numSimTicks, 1) + "ms/tick");
            }
        }
        this.resetOnNextFrame = true;
    }

    void disableSounds() {
        if (this.audioClips != null) {
            Enumeration e = this.audioClips.elements();
            while (e.hasMoreElements()) {
                AudioClip clip = (AudioClip)e.nextElement();
                if (clip.sound == null) continue;
                clip.sound.setEnable(false);
            }
        }
    }

    void enableSounds() {
        if (this.audioClips != null) {
            Enumeration e = this.audioClips.elements();
            while (e.hasMoreElements()) {
                AudioClip clip = (AudioClip)e.nextElement();
                if (clip.sound == null) continue;
                clip.sound.setEnable(true);
            }
        }
    }

    public void shutDown() {
        this.outputTiming();
        this.disableSounds();
        System.exit(0);
    }

    public Canvas3D getCanvas3D() {
        return this.canvas;
    }

    public void createVrmlFromURL(String[] url, BaseNode node, String event) throws InvalidVRMLSyntaxException {
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public float getCurrentSpeed() {
        return this.speed;
    }

    public float getCurrentFrameRate() {
        return this.frameRate;
    }

    public String getWorldURL() {
        if (this.loader.worldURL != null) {
            return this.loader.worldURL.toString();
        }
        return new String("NULL worldURL");
    }

    public void replaceWorld(BaseNode[] nodes) {
    }

    public BaseNode[] createVrmlFromString(String vrmlSyntax) throws InvalidVRMLSyntaxException {
        return null;
    }

    protected void setDefTable(Hashtable t) {
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void addRoute(BaseNode fromNode, String fromEventOut, BaseNode toNode, String toEventIn) {
        fromEventOut = Field.baseName(fromEventOut);
        toEventIn = Field.baseName(toEventIn);
        this.loader.connect(fromNode, fromEventOut, toNode, toEventIn, true);
    }

    public void deleteRoute(BaseNode fromNode, String fromEventOut, BaseNode toNode, String toEventIn) {
        fromEventOut = Field.baseName(fromEventOut);
        toEventIn = Field.baseName(toEventIn);
        Field fromField = fromNode instanceof Script ? ((Script)fromNode).getField(fromEventOut) : ((Node)fromNode).getField(fromEventOut);
        if (!fromField.isEventOut()) {
            throw new InvalidEventOutException();
        }
        Field toField = toNode instanceof Script ? ((Script)toNode).getField(toEventIn) : ((Node)toNode).getField(toEventIn);
        if (!toField.isEventIn()) {
            throw new InvalidEventInException();
        }
        fromField.deleteConnection(toField);
    }

    public void processEvent(AWTEvent evt) {
        this.evagation.processEvent(evt);
    }

    public void startRender() {
        if (this.stopped) {
            this.canvas.startRenderer();
            this.enableSounds();
        }
        this.stopped = false;
    }

    public void stopRender() {
        if (!this.stopped) {
            this.canvas.stopRenderer();
            this.disableSounds();
        }
        this.stopped = true;
    }

    public void cleanUp() {
        long mem = Runtime.getRuntime().freeMemory();
        long tot = Runtime.getRuntime().totalMemory();
        if (mem < memLowLimit) {
            if (debug) {
                System.out.println("Memory usage: " + mem + " of " + tot + " left");
            }
            if (debug) {
                System.out.println("Taking out trash...");
            }
            System.gc();
            memUsage = Runtime.getRuntime().freeMemory() - mem;
            if (debug) {
                System.out.println("Reclaimed " + memUsage + " bytes.");
            }
            if ((memLowLimit -= 1000000L) < 500000L) {
                memLowLimit = 500000L;
            }
        }
    }

    public URL getURL() {
        return this.loader.worldURL;
    }

    byte[] getBytes(String URLstring) {
        byte[] buf = new byte[1];
        try {
            URL fu = new URL(URLstring);
            ContentNegotiator cn = new ContentNegotiator(fu);
            buf = (byte[])cn.getContent();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return buf;
    }

    byte[] getRelBytes(String relURL) {
        String fullURL = this.loader.worldURLBaseName + relURL;
        byte[] buf = this.getBytes(fullURL);
        return buf;
    }

    int count(Enumeration e) {
        int c = 0;
        while (e.hasMoreElements()) {
            ++c;
            e.nextElement();
        }
        return c;
    }

    public void removeCanvas3D(Canvas3D can) {
        this.view.removeCanvas3D(can);
    }

    public void addCanvas3D(Canvas3D can) {
        this.view.addCanvas3D(can);
    }

    public void setAWTContainer(Container container) {
        this.container = container;
    }

    void containerMessage(Container c, String mesg) {
        if (c instanceof Applet) {
            ((Applet)c).showStatus(mesg);
        } else if (c instanceof Frame) {
            ((Frame)c).setTitle(mesg);
        }
    }

    static Browser getBrowser() {
        return instance;
    }

    public void setAutoSmooth(boolean s) {
        this.loader.autoSmooth = s;
    }

    static {
        memLowLimit = 800000L;
    }
}

