/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.jopenmm;

import com.sun.jna.Platform;
import edu.uiowa.jopenmm.OpenMMLibrary;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class OpenMMUtils {
    private static boolean init = false;
    private static String JNA_LIBRARY_PATH = "";
    private static String OPENMM_LIB_DIR = "";
    private static String OPENMM_PLUGIN_DIR = "";

    public static synchronized void init() {
        if (init) {
            return;
        }
        init = true;
        try {
            JarFile jarFile = OpenMMUtils.jarForClass(OpenMMLibrary.class, null);
            String os = Platform.isMac() ? "darwin" : (Platform.isLinux() ? "linux_x64" : "win_x64");
            String directory = "lib/" + os;
            Path path = Files.createTempDirectory("openmm", new FileAttribute[0]);
            File toDir = path.toFile();
            OPENMM_LIB_DIR = toDir.getAbsolutePath() + "/" + os;
            OpenMMUtils.copyResourcesToDirectory(jarFile, directory, OPENMM_LIB_DIR);
            JNA_LIBRARY_PATH = System.getProperty("jna.library.path", "");
            JNA_LIBRARY_PATH = !JNA_LIBRARY_PATH.equalsIgnoreCase("") ? OPENMM_LIB_DIR + File.pathSeparator + JNA_LIBRARY_PATH : OPENMM_LIB_DIR;
            System.setProperty("jna.library.path", JNA_LIBRARY_PATH);
            OPENMM_PLUGIN_DIR = OPENMM_LIB_DIR + "/plugins";
        }
        catch (Exception e) {
            System.err.println(" Exception configuring OpenMM: " + e.toString());
        }
    }

    public static String getLibDirectory() {
        return OPENMM_LIB_DIR;
    }

    public static String getPluginDirectory() {
        return OPENMM_PLUGIN_DIR;
    }

    private static JarFile jarForClass(Class<?> clazz, JarFile defaultJar) {
        String path = "/" + clazz.getName().replace('.', '/') + ".class";
        URL jarUrl = clazz.getResource(path);
        if (jarUrl == null) {
            return defaultJar;
        }
        String url = jarUrl.toString();
        int bang = url.indexOf("!");
        String JAR_URI_PREFIX = "jar:file:";
        if (url.startsWith(JAR_URI_PREFIX) && bang != -1) {
            try {
                return new JarFile(url.substring(JAR_URI_PREFIX.length(), bang));
            }
            catch (IOException e) {
                throw new IllegalStateException("Error loading jar file.", e);
            }
        }
        return defaultJar;
    }

    private static void copyResourcesToDirectory(JarFile fromJar, String jarDir, String destDir) throws IOException {
        Enumeration<JarEntry> entries = fromJar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(jarDir + "/") || entry.isDirectory()) continue;
            File dest = new File(destDir + "/" + entry.getName().substring(jarDir.length() + 1));
            File parent = dest.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            FileOutputStream out = new FileOutputStream(dest);
            InputStream in = fromJar.getInputStream(entry);
            try {
                int s;
                byte[] buffer = new byte[8192];
                while ((s = in.read(buffer)) > 0) {
                    out.write(buffer, 0, s);
                }
            }
            catch (IOException e) {
                throw new IOException("Could not copy asset from jar file", e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

