/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.jopenmm;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;

public class OpenMMDrudeLibrary
implements Library {
    public static final String JNA_LIBRARY_NAME = "OpenMMDrude";
    public static final NativeLibrary JNA_NATIVE_LIB = NativeLibrary.getInstance((String)"OpenMMDrude");
    public static final double OpenMM_NmPerAngstrom = 0.1;
    public static final double OpenMM_AngstromsPerNm = 10.0;
    public static final double OpenMM_PsPerFs = 0.001;
    public static final double OpenMM_FsPerPs = 1000.0;
    public static final double OpenMM_KJPerKcal = 4.184;
    public static final double OpenMM_KcalPerKJ = 0.2390057361376673;
    public static final double OpenMM_RadiansPerDegree = Math.PI / 180;
    public static final double OpenMM_DegreesPerRadian = 57.29577951308232;
    public static final double OpenMM_SigmaPerVdwRadius = 1.7817974362806785;

    public static native PointerByReference OpenMM_3D_DoubleArray_create(int var0, int var1, int var2);

    public static native void OpenMM_3D_DoubleArray_set(PointerByReference var0, int var1, int var2, PointerByReference var3);

    public static native void OpenMM_3D_DoubleArray_destroy(PointerByReference var0);

    public static native PointerByReference OpenMM_DrudeIntegrator_create(double var0);

    public static native void OpenMM_DrudeIntegrator_destroy(PointerByReference var0);

    public static native void OpenMM_DrudeIntegrator_step(PointerByReference var0, int var1);

    public static native double OpenMM_DrudeIntegrator_getDrudeTemperature(PointerByReference var0);

    public static native void OpenMM_DrudeIntegrator_setDrudeTemperature(PointerByReference var0, double var1);

    public static native double OpenMM_DrudeIntegrator_getMaxDrudeDistance(PointerByReference var0);

    public static native void OpenMM_DrudeIntegrator_setMaxDrudeDistance(PointerByReference var0, double var1);

    public static native void OpenMM_DrudeIntegrator_setRandomNumberSeed(PointerByReference var0, int var1);

    public static native int OpenMM_DrudeIntegrator_getRandomNumberSeed(PointerByReference var0);

    public static native PointerByReference OpenMM_DrudeSCFIntegrator_create(double var0);

    public static native void OpenMM_DrudeSCFIntegrator_destroy(PointerByReference var0);

    public static native double OpenMM_DrudeSCFIntegrator_getMinimizationErrorTolerance(PointerByReference var0);

    public static native void OpenMM_DrudeSCFIntegrator_setMinimizationErrorTolerance(PointerByReference var0, double var1);

    public static native void OpenMM_DrudeSCFIntegrator_step(PointerByReference var0, int var1);

    public static native PointerByReference OpenMM_DrudeForce_create();

    public static native void OpenMM_DrudeForce_destroy(PointerByReference var0);

    public static native int OpenMM_DrudeForce_getNumParticles(PointerByReference var0);

    public static native int OpenMM_DrudeForce_getNumScreenedPairs(PointerByReference var0);

    public static native int OpenMM_DrudeForce_addParticle(PointerByReference var0, int var1, int var2, int var3, int var4, int var5, double var6, double var8, double var10, double var12);

    public static native void OpenMM_DrudeForce_getParticleParameters(PointerByReference var0, int var1, IntBuffer var2, IntBuffer var3, IntBuffer var4, IntBuffer var5, IntBuffer var6, DoubleBuffer var7, DoubleBuffer var8, DoubleBuffer var9, DoubleBuffer var10);

    public static native void OpenMM_DrudeForce_getParticleParameters(PointerByReference var0, int var1, IntByReference var2, IntByReference var3, IntByReference var4, IntByReference var5, IntByReference var6, DoubleByReference var7, DoubleByReference var8, DoubleByReference var9, DoubleByReference var10);

    public static native void OpenMM_DrudeForce_setParticleParameters(PointerByReference var0, int var1, int var2, int var3, int var4, int var5, int var6, double var7, double var9, double var11, double var13);

    public static native int OpenMM_DrudeForce_addScreenedPair(PointerByReference var0, int var1, int var2, double var3);

    public static native void OpenMM_DrudeForce_getScreenedPairParameters(PointerByReference var0, int var1, IntBuffer var2, IntBuffer var3, DoubleBuffer var4);

    public static native void OpenMM_DrudeForce_getScreenedPairParameters(PointerByReference var0, int var1, IntByReference var2, IntByReference var3, DoubleByReference var4);

    public static native void OpenMM_DrudeForce_setScreenedPairParameters(PointerByReference var0, int var1, int var2, int var3, double var4);

    public static native void OpenMM_DrudeForce_updateParametersInContext(PointerByReference var0, PointerByReference var1);

    public static native void OpenMM_DrudeForce_setUsesPeriodicBoundaryConditions(PointerByReference var0, int var1);

    public static native int OpenMM_DrudeForce_usesPeriodicBoundaryConditions(PointerByReference var0);

    public static native PointerByReference OpenMM_DrudeLangevinIntegrator_create(double var0, double var2, double var4, double var6, double var8);

    public static native void OpenMM_DrudeLangevinIntegrator_destroy(PointerByReference var0);

    public static native double OpenMM_DrudeLangevinIntegrator_getTemperature(PointerByReference var0);

    public static native void OpenMM_DrudeLangevinIntegrator_setTemperature(PointerByReference var0, double var1);

    public static native double OpenMM_DrudeLangevinIntegrator_getFriction(PointerByReference var0);

    public static native void OpenMM_DrudeLangevinIntegrator_setFriction(PointerByReference var0, double var1);

    public static native double OpenMM_DrudeLangevinIntegrator_getDrudeFriction(PointerByReference var0);

    public static native void OpenMM_DrudeLangevinIntegrator_setDrudeFriction(PointerByReference var0, double var1);

    public static native void OpenMM_DrudeLangevinIntegrator_step(PointerByReference var0, int var1);

    public static native double OpenMM_DrudeLangevinIntegrator_computeSystemTemperature(PointerByReference var0);

    public static native double OpenMM_DrudeLangevinIntegrator_computeDrudeTemperature(PointerByReference var0);

    public static native PointerByReference OpenMM_DrudeNoseHooverIntegrator_create(double var0, double var2, double var4, double var6, double var8, int var10, int var11, int var12);

    public static native void OpenMM_DrudeNoseHooverIntegrator_destroy(PointerByReference var0);

    public static native double OpenMM_DrudeNoseHooverIntegrator_getMaxDrudeDistance(PointerByReference var0);

    public static native void OpenMM_DrudeNoseHooverIntegrator_setMaxDrudeDistance(PointerByReference var0, double var1);

    public static native double OpenMM_DrudeNoseHooverIntegrator_computeDrudeKineticEnergy(PointerByReference var0);

    public static native double OpenMM_DrudeNoseHooverIntegrator_computeTotalKineticEnergy(PointerByReference var0);

    public static native double OpenMM_DrudeNoseHooverIntegrator_computeSystemTemperature(PointerByReference var0);

    public static native double OpenMM_DrudeNoseHooverIntegrator_computeDrudeTemperature(PointerByReference var0);

    static {
        Native.register(OpenMMDrudeLibrary.class, (NativeLibrary)JNA_NATIVE_LIB);
    }

    public static class OpenMM_DrudeIntegrator
    extends PointerType {
        public OpenMM_DrudeIntegrator(Pointer address) {
            super(address);
        }

        public OpenMM_DrudeIntegrator() {
        }
    }

    public static class OpenMM_DoubleArray
    extends PointerType {
        public OpenMM_DoubleArray(Pointer address) {
            super(address);
        }

        public OpenMM_DoubleArray() {
        }
    }

    public static class OpenMM_DrudeSCFIntegrator
    extends PointerType {
        public OpenMM_DrudeSCFIntegrator(Pointer address) {
            super(address);
        }

        public OpenMM_DrudeSCFIntegrator() {
        }
    }

    public static class OpenMM_DrudeNoseHooverIntegrator
    extends PointerType {
        public OpenMM_DrudeNoseHooverIntegrator(Pointer address) {
            super(address);
        }

        public OpenMM_DrudeNoseHooverIntegrator() {
        }
    }

    public static class OpenMM_DrudeForce
    extends PointerType {
        public OpenMM_DrudeForce(Pointer address) {
            super(address);
        }

        public OpenMM_DrudeForce() {
        }
    }

    public static class OpenMM_3D_DoubleArray
    extends PointerType {
        public OpenMM_3D_DoubleArray(Pointer address) {
            super(address);
        }

        public OpenMM_3D_DoubleArray() {
        }
    }

    public static class OpenMM_DrudeLangevinIntegrator
    extends PointerType {
        public OpenMM_DrudeLangevinIntegrator(Pointer address) {
            super(address);
        }

        public OpenMM_DrudeLangevinIntegrator() {
        }
    }

    public static class OpenMM_Context
    extends PointerType {
        public OpenMM_Context(Pointer address) {
            super(address);
        }

        public OpenMM_Context() {
        }
    }
}

