/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.event.ChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;

public class ChemObject
implements Serializable,
IChemObject,
Cloneable {
    private static final long serialVersionUID = 2798134548764323328L;
    private List<IChemObjectListener> chemObjectListeners;
    private Map<Object, Object> properties;
    private int flags;
    private String identifier;
    private boolean doNotification = true;

    public ChemObject() {
        this.chemObjectListeners = null;
        this.properties = null;
        this.identifier = null;
    }

    public ChemObject(IChemObject chemObject) {
        this.flags = chemObject.flags();
        this.identifier = chemObject.getID();
    }

    private List<IChemObjectListener> lazyChemObjectListeners() {
        if (this.chemObjectListeners == null) {
            this.chemObjectListeners = new ArrayList<IChemObjectListener>();
        }
        return this.chemObjectListeners;
    }

    public void addListener(IChemObjectListener col) {
        List<IChemObjectListener> listeners = this.lazyChemObjectListeners();
        if (!listeners.contains(col)) {
            listeners.add(col);
        }
    }

    public int getListenerCount() {
        if (this.chemObjectListeners == null) {
            return 0;
        }
        return this.lazyChemObjectListeners().size();
    }

    public void removeListener(IChemObjectListener col) {
        if (this.chemObjectListeners == null) {
            return;
        }
        List<IChemObjectListener> listeners = this.lazyChemObjectListeners();
        if (listeners.contains(col)) {
            listeners.remove(col);
        }
    }

    public void notifyChanged() {
        if (this.getNotification() && this.getListenerCount() > 0) {
            List<IChemObjectListener> listeners = this.lazyChemObjectListeners();
            for (IChemObjectListener listener : listeners) {
                listener.stateChanged((IChemObjectChangeEvent)new ChemObjectChangeEvent(this));
            }
        }
    }

    public void notifyChanged(IChemObjectChangeEvent evt) {
        if (this.getNotification() && this.getListenerCount() > 0) {
            List<IChemObjectListener> listeners = this.lazyChemObjectListeners();
            for (IChemObjectListener listener : listeners) {
                listener.stateChanged(evt);
            }
        }
    }

    private Map<Object, Object> lazyProperties() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<Object, Object>(4);
        }
        return this.properties;
    }

    public void setProperty(Object description, Object property) {
        this.lazyProperties().put(description, property);
        this.notifyChanged();
    }

    public void removeProperty(Object description) {
        if (this.properties != null) {
            boolean changed;
            boolean bl = changed = this.properties.remove(description) != null;
            if (this.properties.isEmpty()) {
                this.properties = null;
            }
            if (changed) {
                this.notifyChanged();
            }
        }
    }

    public <T> T getProperty(Object description) {
        if (this.properties == null) {
            return null;
        }
        Object value = this.lazyProperties().get(description);
        return (T)value;
    }

    public <T> T getProperty(Object description, Class<T> c) {
        Object value = this.lazyProperties().get(description);
        if (c.isInstance(value)) {
            Object typed = value;
            return (T)typed;
        }
        if (value != null) {
            throw new IllegalArgumentException("attempted to access a property of incorrect type, expected " + c.getSimpleName() + " got " + value.getClass().getSimpleName());
        }
        return null;
    }

    public Map<Object, Object> getProperties() {
        return this.properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.properties);
    }

    public Object clone() throws CloneNotSupportedException {
        ChemObject clone = (ChemObject)super.clone();
        clone.flags = this.getFlagValue();
        if (this.properties != null) {
            clone.properties = new HashMap<Object, Object>(this.getProperties());
        }
        clone.chemObjectListeners = null;
        return clone;
    }

    public boolean compare(Object object) {
        if (!(object instanceof IChemObject)) {
            return false;
        }
        ChemObject chemObj = (ChemObject)object;
        return Objects.equals(this.identifier, chemObj.identifier);
    }

    public String getID() {
        return this.identifier;
    }

    public void setID(String identifier) {
        this.identifier = identifier;
        this.notifyChanged();
    }

    private boolean isPowerOfTwo(int num) {
        return num == 1 || (num & num - 1) == 0;
    }

    public void setFlag(int mask, boolean value) {
        if (mask > Short.MAX_VALUE || !this.isPowerOfTwo(mask)) {
            throw new IllegalArgumentException("setFlag() must be provided a valid CDKConstant and not used for custom properties");
        }
        this.flags = value ? (this.flags |= mask) : (this.flags &= ~mask);
        this.notifyChanged();
    }

    public boolean getFlag(int mask) {
        return (this.flags & mask) != 0;
    }

    public Integer getFlagValue() {
        return this.flags;
    }

    public void set(int flags) {
        this.flags |= flags;
    }

    public boolean is(int flags) {
        return (this.flags & flags) == flags;
    }

    public void clear(int flags) {
        this.flags &= ~flags;
    }

    public int flags() {
        return this.flags;
    }

    public void setProperties(Map<Object, Object> properties) {
        this.properties = null;
        if (properties != null) {
            this.addProperties(properties);
        }
    }

    public void addProperties(Map<Object, Object> properties) {
        if (properties == null) {
            return;
        }
        this.lazyProperties().putAll(properties);
        this.notifyChanged();
    }

    public void setFlags(boolean[] flagsNew) {
        for (int i = 0; i < flagsNew.length; ++i) {
            this.setFlag(CDKConstants.FLAG_MASKS[i], flagsNew[i]);
        }
        this.notifyChanged();
    }

    public boolean[] getFlags() {
        boolean[] flagArray = new boolean[14];
        for (int i = 0; i < CDKConstants.FLAG_MASKS.length; ++i) {
            int mask = CDKConstants.FLAG_MASKS[i];
            flagArray[i] = this.getFlag(mask);
        }
        return flagArray;
    }

    public Object shallowCopy() {
        Object copy = null;
        try {
            copy = super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return copy;
    }

    public IChemObjectBuilder getBuilder() {
        return DefaultChemObjectBuilder.getInstance();
    }

    public void setNotification(boolean bool) {
        this.doNotification = bool;
    }

    public boolean getNotification() {
        return this.doNotification;
    }
}

