/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.interfaces;

import java.util.Objects;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IElectronContainer;

public interface IBond
extends IElectronContainer {
    public Iterable<IAtom> atoms();

    public void setAtoms(IAtom[] var1);

    public IAtom getBegin();

    public IAtom getEnd();

    public int getIndex();

    public IAtomContainer getContainer();

    public int getAtomCount();

    public IAtom getAtom(int var1);

    @Deprecated
    public IAtom getConnectedAtom(IAtom var1);

    public IAtom getOther(IAtom var1);

    public IAtom[] getConnectedAtoms(IAtom var1);

    default public boolean contains(IAtom atom) {
        for (int i = 0; i < this.getAtomCount(); ++i) {
            if (!Objects.equals(this.getAtom(i), atom)) continue;
            return true;
        }
        return false;
    }

    default public IAtom getConnectedAtom(IBond other) {
        for (int i = 0; i < this.getAtomCount(); ++i) {
            IAtom atom = this.getAtom(i);
            if (!other.contains(atom)) continue;
            return atom;
        }
        return null;
    }

    public void setAtom(IAtom var1, int var2);

    public Order getOrder();

    public void setOrder(Order var1);

    public Stereo getStereo();

    public void setStereo(Stereo var1);

    public Display getDisplay();

    public void setDisplay(Display var1);

    public Point2d get2DCenter();

    public Point3d get3DCenter();

    public boolean compare(Object var1);

    public boolean isConnectedTo(IBond var1);

    public boolean isAromatic();

    public void setIsAromatic(boolean var1);

    public boolean isInRing();

    public void setIsInRing(boolean var1);

    @Override
    public IBond clone() throws CloneNotSupportedException;

    public static enum Display {
        Solid,
        Dash,
        Hash,
        Bold,
        Wavy,
        Dot,
        WedgedHashBegin,
        WedgedHashEnd,
        WedgeBegin,
        WedgeEnd,
        ArrowBeg,
        ArrowEnd;

    }

    public static enum Stereo {
        NONE,
        UP,
        UP_INVERTED,
        DOWN,
        DOWN_INVERTED,
        UP_OR_DOWN,
        UP_OR_DOWN_INVERTED,
        E_OR_Z,
        E,
        Z,
        E_Z_BY_COORDINATES;

    }

    public static enum Order {
        SINGLE(1),
        DOUBLE(2),
        TRIPLE(3),
        QUADRUPLE(4),
        QUINTUPLE(5),
        SEXTUPLE(6),
        UNSET(0);

        private final Integer bondedElectronPairs;

        private Order(Integer bondedElectronPairs) {
            this.bondedElectronPairs = bondedElectronPairs;
        }

        public Integer numeric() {
            return this.bondedElectronPairs;
        }
    }
}

