/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.Alpha;
import org.jogamp.java3d.RotPosScalePathInterpolator;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.PathInterpolatorState;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Quat4f;

public class RotPosScalePathInterpolatorState
extends PathInterpolatorState {
    private Point3f[] positions;
    private Quat4f[] quats;
    private float[] scales;

    public RotPosScalePathInterpolatorState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeConstructorParams(DataOutput out) throws IOException {
        super.writeConstructorParams(out);
        this.positions = new Point3f[this.knots.length];
        this.quats = new Quat4f[this.knots.length];
        this.scales = new float[this.knots.length];
        int i = 0;
        while (i < this.positions.length) {
            this.positions[i] = new Point3f();
            this.quats[i] = new Quat4f();
            ++i;
        }
        ((RotPosScalePathInterpolator)this.node).getPositions(this.positions);
        ((RotPosScalePathInterpolator)this.node).getQuats(this.quats);
        ((RotPosScalePathInterpolator)this.node).getScales(this.scales);
        i = 0;
        while (i < this.positions.length) {
            this.control.writePoint3f(out, this.positions[i]);
            this.control.writeQuat4f(out, this.quats[i]);
            out.writeFloat(this.scales[i]);
            ++i;
        }
    }

    @Override
    public void readConstructorParams(DataInput in) throws IOException {
        super.readConstructorParams(in);
        this.positions = new Point3f[this.knots.length];
        this.quats = new Quat4f[this.knots.length];
        this.scales = new float[this.knots.length];
        int i = 0;
        while (i < this.positions.length) {
            this.positions[i] = this.control.readPoint3f(in);
            this.quats[i] = this.control.readQuat4f(in);
            this.scales[i] = in.readFloat();
            ++i;
        }
    }

    @Override
    public SceneGraphObject createNode(Class j3dClass) {
        Object[] objectArray = new Object[7];
        objectArray[2] = new Transform3D();
        objectArray[3] = this.knots;
        objectArray[4] = this.quats;
        objectArray[5] = this.positions;
        objectArray[6] = this.scales;
        return this.createNode(j3dClass, new Class[]{Alpha.class, TransformGroup.class, Transform3D.class, this.knots.getClass(), this.quats.getClass(), this.positions.getClass(), this.scales.getClass()}, objectArray);
    }

    @Override
    protected SceneGraphObject createNode() {
        return new RotPosScalePathInterpolator(null, null, new Transform3D(), this.knots, this.quats, this.positions, this.scales);
    }
}

