/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.picking;

import java.util.ArrayList;
import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.BoundingPolytope;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.CompressedGeometry;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.IndexedGeometryArray;
import org.jogamp.java3d.IndexedLineArray;
import org.jogamp.java3d.IndexedLineStripArray;
import org.jogamp.java3d.IndexedPointArray;
import org.jogamp.java3d.IndexedQuadArray;
import org.jogamp.java3d.IndexedTriangleArray;
import org.jogamp.java3d.IndexedTriangleFanArray;
import org.jogamp.java3d.IndexedTriangleStripArray;
import org.jogamp.java3d.LineArray;
import org.jogamp.java3d.LineStripArray;
import org.jogamp.java3d.Link;
import org.jogamp.java3d.Morph;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.PickBounds;
import org.jogamp.java3d.PickCone;
import org.jogamp.java3d.PickConeRay;
import org.jogamp.java3d.PickConeSegment;
import org.jogamp.java3d.PickCylinder;
import org.jogamp.java3d.PickCylinderRay;
import org.jogamp.java3d.PickCylinderSegment;
import org.jogamp.java3d.PickPoint;
import org.jogamp.java3d.PickRay;
import org.jogamp.java3d.PickSegment;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.PointArray;
import org.jogamp.java3d.QuadArray;
import org.jogamp.java3d.SceneGraphPath;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Switch;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.TriangleArray;
import org.jogamp.java3d.TriangleFanArray;
import org.jogamp.java3d.TriangleStripArray;
import org.jogamp.java3d.internal.Distance;
import org.jogamp.java3d.utils.geometry.Primitive;
import org.jogamp.java3d.utils.picking.PickIntersection;
import org.jogamp.vecmath.Point2d;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Point4d;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Vector3d;
import org.jogamp.vecmath.Vector4d;

public class PickResult {
    public static final int SHAPE3D = 1;
    public static final int MORPH = 2;
    public static final int PRIMITIVE = 4;
    public static final int LINK = 8;
    public static final int GROUP = 16;
    public static final int TRANSFORM_GROUP = 32;
    public static final int BRANCH_GROUP = 64;
    public static final int SWITCH = 128;
    static boolean debug = false;
    private boolean firstIntersectOnly = false;
    private SceneGraphPath pickedSceneGraphPath = null;
    private Node pickedNode = null;
    private GeometryArray[] geometryArrays = null;
    private Shape3D[] compressGeomShape3Ds = null;
    private Transform3D localToVWorld = null;
    private PickShape pickShape = null;
    private int pickShapeType = -1;
    private Vector3d pickShapeDir = null;
    private Point3d pickShapeStart = null;
    private Point3d pickShapeEnd = null;
    private Bounds pickShapeBounds = null;
    static final Point3d zeroPnt = new Point3d();
    ArrayList intersections = null;
    static final double FUZZ = 1.0E-6;
    static final int PICK_SHAPE_RAY = 1;
    static final int PICK_SHAPE_SEGMENT = 2;
    static final int PICK_SHAPE_POINT = 3;
    static final int PICK_SHAPE_BOUNDING_BOX = 4;
    static final int PICK_SHAPE_BOUNDING_SPHERE = 5;
    static final int PICK_SHAPE_BOUNDING_POLYTOPE = 6;
    static final int PICK_SHAPE_CYLINDER = 7;
    static final int PICK_SHAPE_CONE = 8;
    static final double EPS = 1.0E-13;

    PickResult() {
    }

    public PickResult(SceneGraphPath sgp, PickShape ps) {
        this.pickedSceneGraphPath = sgp;
        this.pickedNode = sgp.getObject();
        this.localToVWorld = sgp.getTransform();
        this.pickShape = ps;
        this.initPickShape();
    }

    public PickResult(Node pn, Transform3D l2vw, PickShape ps) {
        if (!(pn instanceof Shape3D) && !(pn instanceof Morph)) {
            throw new IllegalArgumentException();
        }
        this.pickedNode = pn;
        this.localToVWorld = l2vw;
        this.pickShape = ps;
        this.initPickShape();
    }

    void initPickShape() {
        if (this.pickShape instanceof PickRay) {
            if (this.pickShapeStart == null) {
                this.pickShapeStart = new Point3d();
            }
            if (this.pickShapeDir == null) {
                this.pickShapeDir = new Vector3d();
            }
            ((PickRay)this.pickShape).get(this.pickShapeStart, this.pickShapeDir);
            this.pickShapeType = 1;
        } else if (this.pickShape instanceof PickSegment) {
            if (this.pickShapeStart == null) {
                this.pickShapeStart = new Point3d();
            }
            if (this.pickShapeEnd == null) {
                this.pickShapeEnd = new Point3d();
            }
            if (this.pickShapeDir == null) {
                this.pickShapeDir = new Vector3d();
            }
            ((PickSegment)this.pickShape).get(this.pickShapeStart, this.pickShapeEnd);
            this.pickShapeDir.set(this.pickShapeEnd.x - this.pickShapeStart.x, this.pickShapeEnd.y - this.pickShapeStart.y, this.pickShapeEnd.z - this.pickShapeStart.z);
            this.pickShapeType = 2;
        } else if (this.pickShape instanceof PickBounds) {
            this.pickShapeBounds = ((PickBounds)this.pickShape).get();
            if (this.pickShapeBounds instanceof BoundingBox) {
                this.pickShapeType = 4;
            } else if (this.pickShapeBounds instanceof BoundingSphere) {
                this.pickShapeType = 5;
            } else if (this.pickShapeBounds instanceof BoundingPolytope) {
                this.pickShapeType = 6;
            }
        } else {
            if (this.pickShape instanceof PickPoint) {
                throw new RuntimeException("PickPoint doesn't make sense for geometry-based picking. Java 3D doesn't have spatial information of the surface. Should use PickBounds with BoundingSphere and set radius to a epsilon tolerance.");
            }
            if (this.pickShape instanceof PickCylinder) {
                this.pickShapeType = 7;
            } else if (this.pickShape instanceof PickCone) {
                this.pickShapeType = 8;
            } else {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
    }

    public SceneGraphPath getSceneGraphPath() {
        return this.pickedSceneGraphPath;
    }

    public Transform3D getLocalToVworld() {
        return this.localToVWorld;
    }

    public GeometryArray getGeometryArray() {
        if (this.geometryArrays == null) {
            this.storeGeometry();
        }
        return this.geometryArrays[0];
    }

    public GeometryArray[] getGeometryArrays() {
        if (this.geometryArrays == null) {
            this.storeGeometry();
        }
        return this.geometryArrays;
    }

    public int numGeometryArrays() {
        if (this.geometryArrays == null) {
            this.storeGeometry();
        }
        return this.geometryArrays.length;
    }

    public int numCompressedGeometryShape3Ds() {
        if (this.geometryArrays == null) {
            this.storeGeometry();
        }
        if (this.compressGeomShape3Ds == null) {
            return 0;
        }
        return this.compressGeomShape3Ds.length;
    }

    public Shape3D[] getCompressedGeometryShape3Ds() {
        if (this.geometryArrays == null) {
            this.storeGeometry();
        }
        if (this.compressGeomShape3Ds == null) {
            return null;
        }
        return this.compressGeomShape3Ds;
    }

    public PickShape getPickShape() {
        return this.pickShape;
    }

    public void setFirstIntersectOnly(boolean flag) {
        this.firstIntersectOnly = flag;
    }

    public boolean getFirstPickEnable() {
        return this.firstIntersectOnly;
    }

    public int numIntersections() {
        if (this.intersections == null) {
            this.generateIntersections();
        }
        return this.intersections.size();
    }

    public PickIntersection getIntersection(int index) {
        if (this.intersections == null) {
            this.generateIntersections();
        }
        return (PickIntersection)this.intersections.get(index);
    }

    public PickIntersection getClosestIntersection(Point3d pt) {
        PickIntersection pi = null;
        PickIntersection curPi = null;
        Point3d curPt = null;
        double minDist = Double.MAX_VALUE;
        double curDist = 0.0;
        if (pt == null) {
            return null;
        }
        if (this.intersections == null) {
            this.generateIntersections();
        }
        int i = 0;
        while (i < this.intersections.size()) {
            curPi = this.getIntersection(i);
            if (curPi != null && (curPt = curPi.getPointCoordinatesVW()) != null && (curDist = pt.distance(curPt)) < minDist) {
                pi = curPi;
                minDist = curDist;
            }
            ++i;
        }
        return pi;
    }

    public String toString() {
        String rt = new String("PickResult: sgp:" + this.pickedSceneGraphPath + "\n");
        if (this.pickedNode != null) {
            rt = String.valueOf(rt) + " node:" + this.pickedNode;
        }
        if (this.intersections == null) {
            this.generateIntersections();
        }
        if (this.intersections.size() > 0) {
            int i = 0;
            while (i < this.intersections.size()) {
                rt = String.valueOf(rt) + "\n";
                rt = String.valueOf(rt) + ((PickIntersection)this.intersections.get(i)).toString2();
                ++i;
            }
        }
        return rt;
    }

    private void storeGeometry() {
        if (this.pickedNode instanceof Morph) {
            this.geometryArrays = new GeometryArray[1];
            this.geometryArrays[0] = ((Morph)this.pickedNode).getGeometryArray(0);
        } else if (this.pickedNode instanceof Shape3D) {
            Shape3D shape = (Shape3D)this.pickedNode;
            ArrayList<Geometry> geoArrays = new ArrayList<Geometry>();
            int k = 0;
            while (k < shape.numGeometries()) {
                Geometry geometry = shape.getGeometry(k);
                if (geometry instanceof CompressedGeometry) {
                    Shape3D[] sa = ((CompressedGeometry)geometry).decompress();
                    if (sa != null) {
                        int j = 0;
                        while (j < sa.length) {
                            int i = 0;
                            while (i < sa[j].numGeometries()) {
                                geoArrays.add(sa[j].getGeometry(i));
                                ++i;
                            }
                            ++j;
                        }
                    }
                    if (this.compressGeomShape3Ds == null) {
                        this.compressGeomShape3Ds = sa;
                    } else {
                        Shape3D[] save = this.compressGeomShape3Ds;
                        int newLength = save.length + sa.length;
                        this.compressGeomShape3Ds = new Shape3D[newLength];
                        System.arraycopy(save, 0, this.compressGeomShape3Ds, 0, save.length);
                        System.arraycopy(sa, 0, this.compressGeomShape3Ds, save.length, sa.length);
                    }
                } else if (geometry instanceof GeometryArray) {
                    geoArrays.add(geometry);
                }
                ++k;
            }
            this.geometryArrays = new GeometryArray[geoArrays.size()];
            int i = 0;
            while (i < geoArrays.size()) {
                this.geometryArrays[i] = (GeometryArray)geoArrays.get(i);
                ++i;
            }
        }
        if (this.geometryArrays == null) {
            if (this.pickedNode instanceof Shape3D) {
                Shape3D shape3D = (Shape3D)this.pickedNode;
            }
            throw new RuntimeException("Type of the picked node is not supported");
        }
    }

    public Node getObject() {
        if (this.pickedNode == null) {
            this.storeNode();
        }
        return this.pickedNode;
    }

    void setObject(Node n) {
        this.pickedNode = n;
    }

    public Node getNode(int flags) {
        if (this.pickedNode == null) {
            this.storeNode();
        }
        if (this.pickedNode instanceof Shape3D && (flags & 1) != 0) {
            if (debug) {
                System.out.println("Shape3D found");
            }
            return this.pickedNode;
        }
        if (this.pickedNode instanceof Morph && (flags & 2) != 0) {
            if (debug) {
                System.out.println("Morph found");
            }
            return this.pickedNode;
        }
        if (this.pickedSceneGraphPath == null) {
            return null;
        }
        int j = this.pickedSceneGraphPath.nodeCount() - 1;
        while (j >= 0) {
            Node pNode = this.pickedSceneGraphPath.getNode(j);
            if (debug) {
                System.out.println("looking at node " + pNode);
            }
            if (pNode instanceof Primitive && (flags & 4) != 0) {
                if (debug) {
                    System.out.println("Primitive found");
                }
                return pNode;
            }
            if (pNode instanceof Link && (flags & 8) != 0) {
                if (debug) {
                    System.out.println("Link found");
                }
                return pNode;
            }
            if (pNode instanceof Switch && (flags & 0x80) != 0) {
                if (debug) {
                    System.out.println("Switch found");
                }
                return pNode;
            }
            if (pNode instanceof TransformGroup && (flags & 0x20) != 0) {
                if (debug) {
                    System.out.println("xform group found");
                }
                return pNode;
            }
            if (pNode instanceof BranchGroup && (flags & 0x40) != 0) {
                if (debug) {
                    System.out.println("Branch group found");
                }
                return pNode;
            }
            if (pNode instanceof Group && (flags & 0x10) != 0) {
                if (debug) {
                    System.out.println("Group found");
                }
                return pNode;
            }
            --j;
        }
        return null;
    }

    void storeNode() {
        if (this.pickedSceneGraphPath == null) {
            throw new RuntimeException("SceneGraphPath missing");
        }
        this.pickedNode = this.pickedSceneGraphPath.getObject();
    }

    boolean generateIntersections() {
        if (this.geometryArrays == null) {
            this.storeGeometry();
        }
        this.intersections = new ArrayList();
        int hits = 0;
        int i = 0;
        while (i < this.geometryArrays.length) {
            if (this.intersect(i, this.firstIntersectOnly)) {
                if (this.firstIntersectOnly) {
                    return true;
                }
                ++hits;
            }
            ++i;
        }
        return hits > 0;
    }

    final boolean intersect(int geomIndex, boolean firstpick) {
        int i;
        GeometryArray geom = this.geometryArrays[geomIndex];
        int numPts = geom.getVertexCount();
        double[] doubleData = null;
        float[] floatData = null;
        Point3d[] p3dData = null;
        Point3f[] p3fData = null;
        int vformat = geom.getVertexFormat();
        boolean retFlag = false;
        if ((vformat & 0x80) == 0) {
            doubleData = new double[numPts * 3];
            geom.getCoordinates(0, doubleData);
        } else if ((vformat & 0x100) == 0) {
            doubleData = geom.getCoordRefDouble();
            if (doubleData == null && (floatData = geom.getCoordRefFloat()) == null && (p3fData = geom.getCoordRef3f()) == null) {
                p3dData = geom.getCoordRef3d();
            }
        } else {
            floatData = geom.getInterleavedVertices();
        }
        Point3d[] pnts = new Point3d[numPts];
        if (debug) {
            System.out.println("localToVWorld = " + this.localToVWorld);
        }
        if ((vformat & 0x100) == 0) {
            if (doubleData != null) {
                int offset = 0;
                i = 0;
                while (i < numPts) {
                    pnts[i] = new Point3d();
                    pnts[i].x = doubleData[offset++];
                    pnts[i].y = doubleData[offset++];
                    pnts[i].z = doubleData[offset++];
                    this.localToVWorld.transform(pnts[i]);
                    ++i;
                }
            } else if (floatData != null) {
                int offset = 0;
                i = 0;
                while (i < numPts) {
                    pnts[i] = new Point3d();
                    pnts[i].x = floatData[offset++];
                    pnts[i].y = floatData[offset++];
                    pnts[i].z = floatData[offset++];
                    this.localToVWorld.transform(pnts[i]);
                    ++i;
                }
            } else if (p3fData != null) {
                i = 0;
                while (i < numPts) {
                    pnts[i] = new Point3d();
                    pnts[i].set((Tuple3f)p3fData[i]);
                    this.localToVWorld.transform(pnts[i]);
                    ++i;
                }
            } else {
                i = 0;
                while (i < numPts) {
                    pnts[i] = new Point3d();
                    pnts[i].set((Tuple3d)p3dData[i]);
                    this.localToVWorld.transform(pnts[i]);
                    ++i;
                }
            }
        } else {
            int offset = 0;
            if ((vformat & 4) == 4) {
                offset += 3;
            } else if ((vformat & 0xC) == 12) {
                offset += 4;
            }
            if ((vformat & 2) != 0) {
                offset += 3;
            }
            if ((vformat & 0x20) == 32) {
                offset += 2 * geom.getTexCoordSetCount();
            } else if ((vformat & 0x40) == 64) {
                offset += 3 * geom.getTexCoordSetCount();
            }
            int stride = offset + 3;
            i = 0;
            while (i < numPts) {
                pnts[i] = new Point3d();
                pnts[i].x = floatData[offset];
                pnts[i].y = floatData[offset + 1];
                pnts[i].z = floatData[offset + 2];
                this.localToVWorld.transform(pnts[i]);
                offset += stride;
                ++i;
            }
        }
        PickIntersection pi = new PickIntersection(this, geom);
        if (geom instanceof PointArray) {
            retFlag = this.intersectPA((PointArray)geom, geomIndex, pnts, firstpick, pi);
        } else if (geom instanceof IndexedPointArray) {
            pi.iGeom = (IndexedGeometryArray)geom;
            retFlag = this.intersectIPA((IndexedPointArray)geom, geomIndex, pnts, firstpick, pi);
        } else if (geom instanceof LineArray) {
            retFlag = this.intersectLA((LineArray)geom, geomIndex, pnts, firstpick, pi);
        } else if (geom instanceof LineStripArray) {
            retFlag = this.intersectLSA((LineStripArray)geom, geomIndex, pnts, firstpick, pi);
        } else if (geom instanceof IndexedLineArray) {
            pi.iGeom = (IndexedGeometryArray)geom;
            retFlag = this.intersectILA((IndexedLineArray)geom, geomIndex, pnts, firstpick, pi);
        } else if (geom instanceof IndexedLineStripArray) {
            pi.iGeom = (IndexedGeometryArray)geom;
            retFlag = this.intersectILSA((IndexedLineStripArray)geom, geomIndex, pnts, firstpick, pi);
        } else if (geom instanceof TriangleArray) {
            retFlag = this.intersectTA((TriangleArray)geom, geomIndex, pnts, firstpick, pi);
        } else if (geom instanceof TriangleStripArray) {
            retFlag = this.intersectTSA((TriangleStripArray)geom, geomIndex, pnts, firstpick, pi);
        } else if (geom instanceof TriangleFanArray) {
            retFlag = this.intersectTFA((TriangleFanArray)geom, geomIndex, pnts, firstpick, pi);
        } else if (geom instanceof IndexedTriangleArray) {
            pi.iGeom = (IndexedGeometryArray)geom;
            retFlag = this.intersectITA((IndexedTriangleArray)geom, geomIndex, pnts, firstpick, pi);
        } else if (geom instanceof IndexedTriangleStripArray) {
            pi.iGeom = (IndexedGeometryArray)geom;
            retFlag = this.intersectITSA((IndexedTriangleStripArray)geom, geomIndex, pnts, firstpick, pi);
        } else if (geom instanceof IndexedTriangleFanArray) {
            pi.iGeom = (IndexedGeometryArray)geom;
            retFlag = this.intersectITFA((IndexedTriangleFanArray)geom, geomIndex, pnts, firstpick, pi);
        } else if (geom instanceof QuadArray) {
            retFlag = this.intersectQA((QuadArray)geom, geomIndex, pnts, firstpick, pi);
        } else if (geom instanceof IndexedQuadArray) {
            pi.iGeom = (IndexedGeometryArray)geom;
            retFlag = this.intersectIQA((IndexedQuadArray)geom, geomIndex, pnts, firstpick, pi);
        } else {
            throw new RuntimeException("incorrect class type");
        }
        return retFlag;
    }

    boolean intersectPoint(int[] vertidx, int[] coordidx, int geomIndex, Point3d[] pnts, PickIntersection pi) {
        Point3d[] point = new Point3d[]{pnts[coordidx[0]]};
        if (debug) {
            System.out.println("intersect point, point = " + point[0]);
        }
        boolean intersect = false;
        switch (this.pickShapeType) {
            case 1: {
                intersect = PickResult.intersectPntAndRay(point[0], this.pickShapeStart, this.pickShapeDir, pi);
                break;
            }
            case 2: {
                if (!PickResult.intersectPntAndRay(point[0], this.pickShapeStart, this.pickShapeDir, pi) || !(pi.getDistance() <= 1.0)) break;
                intersect = true;
                break;
            }
            case 4: {
                intersect = ((BoundingBox)this.pickShapeBounds).intersect(point[0]);
                pi.setPointCoordinatesVW(point[0]);
                break;
            }
            case 5: {
                intersect = ((BoundingSphere)this.pickShapeBounds).intersect(point[0]);
                pi.setPointCoordinatesVW(point[0]);
                break;
            }
            case 6: {
                intersect = ((BoundingPolytope)this.pickShapeBounds).intersect(point[0]);
                pi.setPointCoordinatesVW(point[0]);
                break;
            }
            case 7: {
                intersect = PickResult.intersectCylinder(point[0], (PickCylinder)this.pickShape, pi);
                break;
            }
            case 8: {
                intersect = PickResult.intersectCone(point[0], (PickCone)this.pickShape, pi);
            }
        }
        if (intersect) {
            PickIntersection newpi = new PickIntersection(this, pi.geom);
            newpi.iGeom = pi.iGeom;
            newpi.setDistance(pi.distance);
            newpi.setPointCoordinatesVW(pi.getPointCoordinatesVW());
            newpi.setGeomIndex(geomIndex);
            newpi.setVertexIndices(vertidx);
            newpi.setPrimitiveCoordinatesVW(point);
            this.intersections.add(newpi);
            return true;
        }
        return false;
    }

    boolean intersectLine(int[] vertidx, int[] coordidx, int geomIndex, Point3d[] pnts, PickIntersection pi) {
        Point3d[] linePts = new Point3d[]{pnts[coordidx[0]], pnts[coordidx[1]]};
        boolean intersect = false;
        switch (this.pickShapeType) {
            case 1: {
                intersect = PickResult.intersectLineAndRay(linePts[0], linePts[1], this.pickShapeStart, this.pickShapeDir, pi);
                break;
            }
            case 2: {
                if (!PickResult.intersectLineAndRay(linePts[0], linePts[1], this.pickShapeStart, this.pickShapeDir, pi) || !(pi.getDistance() <= 1.0)) break;
                intersect = true;
                break;
            }
            case 4: {
                intersect = PickResult.intersectBoundingBox(linePts, (BoundingBox)this.pickShapeBounds);
                pi.setPointCoordinatesVW(zeroPnt);
                break;
            }
            case 5: {
                intersect = PickResult.intersectBoundingSphere(linePts, (BoundingSphere)this.pickShapeBounds);
                pi.setPointCoordinatesVW(zeroPnt);
                break;
            }
            case 6: {
                intersect = PickResult.intersectBoundingPolytope(linePts, (BoundingPolytope)this.pickShapeBounds);
                pi.setPointCoordinatesVW(zeroPnt);
                break;
            }
            case 7: {
                intersect = PickResult.intersectCylinder(linePts, (PickCylinder)this.pickShape, pi);
                break;
            }
            case 8: {
                intersect = PickResult.intersectCone(linePts, (PickCone)this.pickShape, pi);
            }
        }
        if (intersect) {
            PickIntersection newpi = new PickIntersection(this, pi.geom);
            newpi.iGeom = pi.iGeom;
            newpi.setDistance(pi.distance);
            newpi.setPointCoordinatesVW(pi.getPointCoordinatesVW());
            newpi.setGeomIndex(geomIndex);
            newpi.setVertexIndices(vertidx);
            newpi.setPrimitiveCoordinatesVW(linePts);
            this.intersections.add(newpi);
            return true;
        }
        return false;
    }

    boolean intersectTri(int[] vertidx, int[] coordidx, int geomIndex, Point3d[] pnts, PickIntersection pi) {
        Point3d[] triPts = new Point3d[]{pnts[coordidx[0]], pnts[coordidx[1]], pnts[coordidx[2]]};
        boolean intersect = false;
        switch (this.pickShapeType) {
            case 1: {
                intersect = PickResult.intersectRay(triPts, (PickRay)this.pickShape, pi);
                break;
            }
            case 2: {
                intersect = PickResult.intersectSegment(triPts, (PickSegment)this.pickShape, pi);
                break;
            }
            case 4: {
                intersect = PickResult.intersectBoundingBox(triPts, (BoundingBox)this.pickShapeBounds);
                pi.setPointCoordinatesVW(zeroPnt);
                break;
            }
            case 5: {
                intersect = PickResult.intersectBoundingSphere(triPts, (BoundingSphere)this.pickShapeBounds);
                pi.setPointCoordinatesVW(zeroPnt);
                break;
            }
            case 6: {
                intersect = PickResult.intersectBoundingPolytope(triPts, (BoundingPolytope)this.pickShapeBounds);
                pi.setPointCoordinatesVW(zeroPnt);
                break;
            }
            case 7: {
                intersect = PickResult.intersectCylinder(triPts, (PickCylinder)this.pickShape, pi);
                break;
            }
            case 8: {
                intersect = PickResult.intersectCone(triPts, (PickCone)this.pickShape, pi);
            }
        }
        if (intersect) {
            PickIntersection newpi = new PickIntersection(this, pi.geom);
            newpi.iGeom = pi.iGeom;
            newpi.setDistance(pi.distance);
            newpi.setPointCoordinatesVW(pi.getPointCoordinatesVW());
            newpi.setGeomIndex(geomIndex);
            newpi.setVertexIndices(vertidx);
            newpi.setPrimitiveCoordinatesVW(triPts);
            this.intersections.add(newpi);
            return true;
        }
        return false;
    }

    boolean intersectQuad(int[] vertidx, int[] coordidx, int geomIndex, Point3d[] pnts, PickIntersection pi) {
        Point3d[] quadPts = new Point3d[]{pnts[coordidx[0]], pnts[coordidx[1]], pnts[coordidx[2]], pnts[coordidx[3]]};
        boolean intersect = false;
        switch (this.pickShapeType) {
            case 1: {
                intersect = PickResult.intersectRay(quadPts, (PickRay)this.pickShape, pi);
                break;
            }
            case 2: {
                intersect = PickResult.intersectSegment(quadPts, (PickSegment)this.pickShape, pi);
                break;
            }
            case 4: {
                intersect = PickResult.intersectBoundingBox(quadPts, (BoundingBox)this.pickShapeBounds);
                pi.setPointCoordinatesVW(zeroPnt);
                break;
            }
            case 5: {
                intersect = PickResult.intersectBoundingSphere(quadPts, (BoundingSphere)this.pickShapeBounds);
                pi.setPointCoordinatesVW(zeroPnt);
                break;
            }
            case 6: {
                intersect = PickResult.intersectBoundingPolytope(quadPts, (BoundingPolytope)this.pickShapeBounds);
                pi.setPointCoordinatesVW(zeroPnt);
                break;
            }
            case 7: {
                intersect = PickResult.intersectCylinder(quadPts, (PickCylinder)this.pickShape, pi);
                break;
            }
            case 8: {
                intersect = PickResult.intersectCone(quadPts, (PickCone)this.pickShape, pi);
            }
        }
        if (intersect) {
            PickIntersection newpi = new PickIntersection(this, pi.geom);
            newpi.iGeom = pi.iGeom;
            newpi.setDistance(pi.distance);
            newpi.setPointCoordinatesVW(pi.getPointCoordinatesVW());
            newpi.setGeomIndex(geomIndex);
            newpi.setVertexIndices(vertidx);
            newpi.setPrimitiveCoordinatesVW(quadPts);
            this.intersections.add(newpi);
            return true;
        }
        return false;
    }

    boolean intersectPA(PointArray geom, int geomIndex, Point3d[] pnts, boolean firstpick, PickIntersection pi) {
        if (debug) {
            System.out.println("intersect: PointArray");
        }
        int[] pntVertIdx = new int[1];
        int numint = 0;
        int i = 0;
        while (i < pnts.length) {
            pntVertIdx[0] = i;
            if (this.intersectPoint(pntVertIdx, pntVertIdx, geomIndex, pnts, pi)) {
                ++numint;
                if (firstpick) {
                    return true;
                }
            }
            ++i;
        }
        return numint > 0;
    }

    boolean intersectIPA(IndexedPointArray geom, int geomIndex, Point3d[] pnts, boolean firstpick, PickIntersection pi) {
        if (debug) {
            System.out.println("intersect: IndexedPointArray");
        }
        int[] pntVertIdx = new int[1];
        int[] pntCoordIdx = new int[1];
        int numint = 0;
        int indexCount = geom.getIndexCount();
        int i = 0;
        while (i < indexCount) {
            pntVertIdx[0] = i;
            pntCoordIdx[0] = geom.getCoordinateIndex(i);
            if (this.intersectPoint(pntVertIdx, pntCoordIdx, geomIndex, pnts, pi)) {
                ++numint;
                if (firstpick) {
                    return true;
                }
            }
            ++i;
        }
        return numint > 0;
    }

    boolean intersectLA(LineArray geom, int geomIndex, Point3d[] pnts, boolean firstpick, PickIntersection pi) {
        if (debug) {
            System.out.println("intersect: LineArray");
        }
        int[] lineVertIdx = new int[2];
        int numint = 0;
        int i = 0;
        while (i < pnts.length) {
            lineVertIdx[0] = i++;
            lineVertIdx[1] = i++;
            if (!this.intersectLine(lineVertIdx, lineVertIdx, geomIndex, pnts, pi)) continue;
            ++numint;
            if (!firstpick) continue;
            return true;
        }
        return numint > 0;
    }

    boolean intersectLSA(LineStripArray geom, int geomIndex, Point3d[] pnts, boolean firstpick, PickIntersection pi) {
        int numint = 0;
        int[] stripVertexCounts = new int[geom.getNumStrips()];
        geom.getStripVertexCounts(stripVertexCounts);
        int stripStart = 0;
        if (debug) {
            System.out.println("intersect: LineStripArray");
        }
        int[] lineVertIdx = new int[2];
        int i = 0;
        while (i < stripVertexCounts.length) {
            lineVertIdx[0] = stripStart;
            int end = stripStart + stripVertexCounts[i];
            int j = stripStart + 1;
            while (j < end) {
                lineVertIdx[1] = j;
                if (this.intersectLine(lineVertIdx, lineVertIdx, geomIndex, pnts, pi)) {
                    ++numint;
                    if (firstpick) {
                        return true;
                    }
                }
                lineVertIdx[0] = lineVertIdx[1];
                ++j;
            }
            stripStart += stripVertexCounts[i];
            ++i;
        }
        return numint > 0;
    }

    boolean intersectILA(IndexedLineArray geom, int geomIndex, Point3d[] pnts, boolean firstpick, PickIntersection pi) {
        int numint = 0;
        int indexCount = geom.getIndexCount();
        if (debug) {
            System.out.println("intersect: IndexedLineArray");
        }
        int[] lineVertIdx = new int[2];
        int[] lineCoordIdx = new int[2];
        int i = 0;
        while (i < indexCount) {
            lineVertIdx[0] = i;
            lineCoordIdx[0] = geom.getCoordinateIndex(i++);
            lineVertIdx[1] = i;
            lineCoordIdx[1] = geom.getCoordinateIndex(i++);
            if (!this.intersectLine(lineVertIdx, lineCoordIdx, geomIndex, pnts, pi)) continue;
            ++numint;
            if (!firstpick) continue;
            return true;
        }
        return numint > 0;
    }

    boolean intersectILSA(IndexedLineStripArray geom, int geomIndex, Point3d[] pnts, boolean firstpick, PickIntersection pi) {
        if (debug) {
            System.out.println("intersect: IndexedLineStripArray");
        }
        int[] lineVertIdx = new int[2];
        int[] lineCoordIdx = new int[2];
        int numint = 0;
        int[] stripVertexCounts = new int[geom.getNumStrips()];
        geom.getStripIndexCounts(stripVertexCounts);
        int stripStart = 0;
        int i = 0;
        while (i < stripVertexCounts.length) {
            lineVertIdx[0] = stripStart;
            lineCoordIdx[0] = geom.getCoordinateIndex(stripStart);
            int end = stripStart + stripVertexCounts[i];
            int j = stripStart + 1;
            while (j < end) {
                lineVertIdx[1] = j;
                lineCoordIdx[1] = geom.getCoordinateIndex(j);
                if (this.intersectLine(lineVertIdx, lineCoordIdx, geomIndex, pnts, pi)) {
                    ++numint;
                    if (firstpick) {
                        return true;
                    }
                }
                lineVertIdx[0] = lineVertIdx[1];
                lineCoordIdx[0] = lineCoordIdx[1];
                ++j;
            }
            stripStart += stripVertexCounts[i];
            ++i;
        }
        return numint > 0;
    }

    boolean intersectTA(TriangleArray geom, int geomIndex, Point3d[] pnts, boolean firstpick, PickIntersection pi) {
        if (debug) {
            System.out.println("intersect: TriangleArray");
        }
        int[] triVertIdx = new int[3];
        int numint = 0;
        int i = 0;
        while (i < pnts.length) {
            triVertIdx[0] = i++;
            triVertIdx[1] = i++;
            triVertIdx[2] = i++;
            if (!this.intersectTri(triVertIdx, triVertIdx, geomIndex, pnts, pi)) continue;
            ++numint;
            if (!firstpick) continue;
            return true;
        }
        return numint > 0;
    }

    boolean intersectITA(IndexedTriangleArray geom, int geomIndex, Point3d[] pnts, boolean firstpick, PickIntersection pi) {
        if (debug) {
            System.out.println("intersect: IndexedTriangleArray");
        }
        int[] triVertIdx = new int[3];
        int[] triCoordIdx = new int[3];
        int numint = 0;
        int indexCount = geom.getIndexCount();
        int i = 0;
        while (i < indexCount) {
            triVertIdx[0] = i;
            triCoordIdx[0] = geom.getCoordinateIndex(i++);
            triVertIdx[1] = i;
            triCoordIdx[1] = geom.getCoordinateIndex(i++);
            triVertIdx[2] = i;
            triCoordIdx[2] = geom.getCoordinateIndex(i++);
            if (!this.intersectTri(triVertIdx, triCoordIdx, geomIndex, pnts, pi)) continue;
            ++numint;
            if (!firstpick) continue;
            return true;
        }
        return numint > 0;
    }

    boolean intersectTSA(TriangleStripArray geom, int geomIndex, Point3d[] pnts, boolean firstpick, PickIntersection pi) {
        if (debug) {
            System.out.println("intersect: TriangleStripArray");
        }
        int numint = 0;
        int[] stripVertexCounts = new int[geom.getNumStrips()];
        geom.getStripVertexCounts(stripVertexCounts);
        int stripStart = 0;
        int[] triVertIdx = new int[3];
        int i = 0;
        while (i < stripVertexCounts.length) {
            int start = stripStart;
            boolean ccw = true;
            triVertIdx[0] = start++;
            triVertIdx[1] = start++;
            int end = start + stripVertexCounts[i] - 2;
            int j = start;
            while (j < end) {
                triVertIdx[2] = j;
                if (this.intersectTri(triVertIdx, triVertIdx, geomIndex, pnts, pi)) {
                    ++numint;
                    if (firstpick) {
                        return true;
                    }
                }
                triVertIdx[0] = triVertIdx[1];
                triVertIdx[1] = triVertIdx[2];
                ++j;
            }
            stripStart += stripVertexCounts[i];
            ++i;
        }
        return numint > 0;
    }

    boolean intersectITSA(IndexedTriangleStripArray geom, int geomIndex, Point3d[] pnts, boolean firstpick, PickIntersection pi) {
        if (debug) {
            System.out.println("intersect: IndexedTriangleStripArray");
        }
        int numint = 0;
        int[] stripVertexCounts = new int[geom.getNumStrips()];
        geom.getStripIndexCounts(stripVertexCounts);
        int stripStart = 0;
        int[] triVertIdx = new int[3];
        int[] triCoordIdx = new int[3];
        int i = 0;
        while (i < stripVertexCounts.length) {
            int start = stripStart;
            boolean ccw = true;
            triCoordIdx[0] = geom.getCoordinateIndex(start);
            triVertIdx[0] = start++;
            triCoordIdx[1] = geom.getCoordinateIndex(start);
            triVertIdx[1] = start++;
            int end = start + stripVertexCounts[i] - 2;
            int j = start;
            while (j < end) {
                if (ccw) {
                    triVertIdx[2] = j;
                    triCoordIdx[2] = geom.getCoordinateIndex(j);
                } else {
                    triVertIdx[1] = j;
                    triCoordIdx[1] = geom.getCoordinateIndex(j);
                }
                if (this.intersectTri(triVertIdx, triCoordIdx, geomIndex, pnts, pi)) {
                    ++numint;
                    if (firstpick) {
                        return true;
                    }
                }
                if (ccw) {
                    triVertIdx[0] = triVertIdx[1];
                    triCoordIdx[0] = triCoordIdx[1];
                    ccw = false;
                } else {
                    triVertIdx[0] = triVertIdx[2];
                    triCoordIdx[0] = triCoordIdx[2];
                    ccw = true;
                }
                ++j;
            }
            stripStart += stripVertexCounts[i];
            ++i;
        }
        return numint > 0;
    }

    boolean intersectTFA(TriangleFanArray geom, int geomIndex, Point3d[] pnts, boolean firstpick, PickIntersection pi) {
        if (debug) {
            System.out.println("intersect: TriangleFanArray");
        }
        int numint = 0;
        int[] stripVertexCounts = new int[geom.getNumStrips()];
        geom.getStripVertexCounts(stripVertexCounts);
        int fanStart = 0;
        int[] triVertIdx = new int[3];
        int i = 0;
        while (i < stripVertexCounts.length) {
            int start = fanStart;
            triVertIdx[0] = start++;
            triVertIdx[1] = start++;
            int end = start + stripVertexCounts[i] - 2;
            int j = start;
            while (j < end) {
                triVertIdx[2] = j;
                if (this.intersectTri(triVertIdx, triVertIdx, geomIndex, pnts, pi)) {
                    ++numint;
                    if (firstpick) {
                        return true;
                    }
                }
                triVertIdx[1] = triVertIdx[2];
                ++j;
            }
            fanStart += stripVertexCounts[i];
            ++i;
        }
        return numint > 0;
    }

    boolean intersectITFA(IndexedTriangleFanArray geom, int geomIndex, Point3d[] pnts, boolean firstpick, PickIntersection pi) {
        if (debug) {
            System.out.println("intersect: IndexedTriangleFanArray");
        }
        int numint = 0;
        int[] stripVertexCounts = new int[geom.getNumStrips()];
        geom.getStripIndexCounts(stripVertexCounts);
        int fanStart = 0;
        int[] triVertIdx = new int[3];
        int[] triCoordIdx = new int[3];
        int i = 0;
        while (i < stripVertexCounts.length) {
            int start = fanStart;
            triCoordIdx[0] = geom.getCoordinateIndex(start);
            triVertIdx[0] = start++;
            triCoordIdx[1] = geom.getCoordinateIndex(start);
            triVertIdx[1] = start++;
            int end = start + stripVertexCounts[i] - 2;
            int j = start;
            while (j < end) {
                triVertIdx[2] = j;
                triCoordIdx[2] = geom.getCoordinateIndex(j);
                if (this.intersectTri(triVertIdx, triCoordIdx, geomIndex, pnts, pi)) {
                    ++numint;
                    if (firstpick) {
                        return true;
                    }
                }
                triVertIdx[1] = triVertIdx[2];
                triCoordIdx[1] = triCoordIdx[2];
                ++j;
            }
            fanStart += stripVertexCounts[i];
            ++i;
        }
        return numint > 0;
    }

    boolean intersectQA(QuadArray geom, int geomIndex, Point3d[] pnts, boolean firstpick, PickIntersection pi) {
        if (debug) {
            System.out.println("intersect: QuadArray");
        }
        int[] quadVertIdx = new int[4];
        int numint = 0;
        int i = 0;
        while (i < pnts.length) {
            quadVertIdx[0] = i++;
            quadVertIdx[1] = i++;
            quadVertIdx[2] = i++;
            quadVertIdx[3] = i++;
            if (!this.intersectQuad(quadVertIdx, quadVertIdx, geomIndex, pnts, pi)) continue;
            ++numint;
            if (!firstpick) continue;
            return true;
        }
        return numint > 0;
    }

    final boolean intersectIQA(IndexedQuadArray geom, int geomIndex, Point3d[] pnts, boolean firstpick, PickIntersection pi) {
        if (debug) {
            System.out.println("intersect: IndexedQuadArray");
        }
        int[] quadVertIdx = new int[4];
        int[] quadCoordIdx = new int[4];
        int numint = 0;
        int indexCount = geom.getIndexCount();
        int i = 0;
        while (i < indexCount) {
            quadVertIdx[0] = i;
            quadCoordIdx[0] = geom.getCoordinateIndex(i++);
            quadVertIdx[1] = i;
            quadCoordIdx[1] = geom.getCoordinateIndex(i++);
            quadVertIdx[2] = i;
            quadCoordIdx[2] = geom.getCoordinateIndex(i++);
            quadVertIdx[3] = i;
            quadCoordIdx[3] = geom.getCoordinateIndex(i++);
            if (!this.intersectQuad(quadVertIdx, quadCoordIdx, geomIndex, pnts, pi)) continue;
            ++numint;
            if (!firstpick) continue;
            return true;
        }
        return numint > 0;
    }

    static boolean intersectBoundingBox(Point3d[] coordinates, BoundingBox box) {
        int[] out = new int[6];
        Point3d lower = new Point3d();
        Point3d upper = new Point3d();
        box.getLower(lower);
        box.getUpper(upper);
        int i = 0;
        while (i < 6) {
            out[i] = 0;
            ++i;
        }
        i = 0;
        while (i < coordinates.length) {
            if (coordinates[i].x >= lower.x && coordinates[i].x <= upper.x && coordinates[i].y >= lower.y && coordinates[i].y <= upper.y && coordinates[i].z >= lower.z && coordinates[i].z <= upper.z) {
                return true;
            }
            if (coordinates[i].x < lower.x) {
                out[0] = out[0] + 1;
            }
            if (coordinates[i].y < lower.y) {
                out[1] = out[1] + 1;
            }
            if (coordinates[i].z < lower.z) {
                out[2] = out[2] + 1;
            }
            if (coordinates[i].x > upper.x) {
                out[3] = out[3] + 1;
            }
            if (coordinates[i].y > upper.y) {
                out[4] = out[4] + 1;
            }
            if (coordinates[i].z > upper.z) {
                out[5] = out[5] + 1;
            }
            ++i;
        }
        if (out[0] == coordinates.length || out[1] == coordinates.length || out[2] == coordinates.length || out[3] == coordinates.length || out[4] == coordinates.length || out[5] == coordinates.length) {
            return false;
        }
        Point3d[] pCoor = new Point3d[4];
        i = 0;
        while (i < 4) {
            pCoor[i] = new Point3d();
            ++i;
        }
        pCoor[0].set(lower.x, lower.y, lower.z);
        pCoor[1].set(lower.x, lower.y, upper.z);
        pCoor[2].set(lower.x, upper.y, upper.z);
        pCoor[3].set(lower.x, upper.y, lower.z);
        if (PickResult.intersectPolygon(pCoor, coordinates, false)) {
            return true;
        }
        pCoor[0].set(upper.x, lower.y, lower.z);
        pCoor[1].set(upper.x, upper.y, lower.z);
        pCoor[2].set(upper.x, upper.y, upper.z);
        pCoor[3].set(upper.x, lower.y, upper.z);
        if (PickResult.intersectPolygon(pCoor, coordinates, false)) {
            return true;
        }
        pCoor[0].set(upper.x, lower.y, upper.z);
        pCoor[1].set(lower.x, lower.y, upper.z);
        pCoor[2].set(lower.x, lower.y, lower.z);
        pCoor[3].set(upper.x, lower.y, lower.z);
        if (PickResult.intersectPolygon(pCoor, coordinates, false)) {
            return true;
        }
        pCoor[0].set(upper.x, upper.y, upper.z);
        pCoor[1].set(upper.x, upper.y, lower.z);
        pCoor[2].set(lower.x, upper.y, lower.z);
        pCoor[3].set(lower.x, upper.y, upper.z);
        if (PickResult.intersectPolygon(pCoor, coordinates, false)) {
            return true;
        }
        pCoor[0].set(upper.x, upper.y, upper.z);
        pCoor[1].set(lower.x, upper.y, upper.z);
        pCoor[2].set(lower.x, lower.y, upper.z);
        pCoor[3].set(upper.x, lower.y, upper.z);
        if (PickResult.intersectPolygon(pCoor, coordinates, false)) {
            return true;
        }
        pCoor[0].set(upper.x, upper.y, lower.z);
        pCoor[1].set(upper.x, lower.y, lower.z);
        pCoor[2].set(lower.x, lower.y, lower.z);
        pCoor[3].set(lower.x, upper.y, lower.z);
        return PickResult.intersectPolygon(pCoor, coordinates, false);
    }

    static boolean intersectBoundingSphere(Point3d[] coordinates, BoundingSphere sphere) {
        Vector3d tempV3D = new Vector3d();
        Point3d center = new Point3d();
        sphere.getCenter(center);
        double radius = sphere.getRadius();
        int i = 0;
        while (i < coordinates.length) {
            tempV3D.x = coordinates[i].x - center.x;
            tempV3D.y = coordinates[i].y - center.y;
            tempV3D.z = coordinates[i].z - center.z;
            if (tempV3D.length() <= radius) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < coordinates.length) {
            boolean esFlag = i < coordinates.length - 1 ? PickResult.edgeIntersectSphere(sphere, coordinates[i], coordinates[i + 1]) : PickResult.edgeIntersectSphere(sphere, coordinates[i], coordinates[0]);
            if (esFlag) {
                return true;
            }
            ++i;
        }
        if (coordinates.length < 3) {
            return false;
        }
        Vector3d vec0 = new Vector3d();
        Vector3d vec1 = new Vector3d();
        Vector3d pNrm = new Vector3d();
        Vector3d pa = new Vector3d();
        Point3d q = new Point3d();
        i = 0;
        while (i < coordinates.length - 1) {
            vec0.x = coordinates[i + 1].x - coordinates[i].x;
            vec0.y = coordinates[i + 1].y - coordinates[i].y;
            vec0.z = coordinates[i + 1].z - coordinates[i++].z;
            if (vec0.length() > 0.0) break;
        }
        int j = i;
        while (j < coordinates.length - 1) {
            vec1.x = coordinates[j + 1].x - coordinates[j].x;
            vec1.y = coordinates[j + 1].y - coordinates[j].y;
            vec1.z = coordinates[j + 1].z - coordinates[j].z;
            if (vec1.length() > 0.0) break;
            ++j;
        }
        if (j == coordinates.length - 1) {
            return false;
        }
        pNrm.cross(vec0, vec1);
        double nLenSq = pNrm.lengthSquared();
        if (nLenSq == 0.0) {
            return false;
        }
        pa.x = coordinates[0].x - center.x;
        pa.y = coordinates[0].y - center.y;
        pa.z = coordinates[0].z - center.z;
        double pNrmDotPa = pNrm.dot(pa);
        double pqLen = Math.sqrt(pNrmDotPa * pNrmDotPa / nLenSq);
        if (pqLen > radius) {
            return false;
        }
        double tq = pNrmDotPa / nLenSq;
        q.x = center.x + tq * pNrm.x;
        q.y = center.y + tq * pNrm.y;
        q.z = center.z + tq * pNrm.z;
        return PickResult.pointIntersectPolygon2D(pNrm, coordinates, q);
    }

    static boolean intersectBoundingPolytope(Point3d[] coordinates, BoundingPolytope polytope) {
        int j;
        boolean debug = false;
        double distanceSign = -1.0;
        Point4d tP4d = new Point4d();
        Vector4d[] planes = new Vector4d[polytope.getNumPlanes()];
        int i = 0;
        while (i < planes.length) {
            planes[i] = new Vector4d();
            ++i;
        }
        polytope.getPlanes(planes);
        if (coordinates.length == 2) {
            throw new RuntimeException("TODO: must make polytope.intersect(coordinates[0], coordinates[1], tP4d) public!");
        }
        if (debug) {
            System.out.println("The value of the input vertices are: ");
            i = 0;
            while (i < coordinates.length) {
                System.out.println("The " + i + " th vertex is: " + coordinates[i]);
                ++i;
            }
            System.out.println("The value of the input bounding Polytope's planes =");
            i = 0;
            while (i < planes.length) {
                System.out.println("The " + i + " th plane is: " + planes[i]);
                ++i;
            }
        }
        double[] centers = new double[]{0.8, 0.9, 1.1, 1.2};
        boolean intersection = true;
        boolean PreTest = false;
        if (PreTest) {
            int i2 = 0;
            while (i2 < coordinates.length) {
                int j2 = 0;
                while (j2 < planes.length) {
                    if (!(planes[j2].x * coordinates[i2].x + planes[j2].y * coordinates[i2].y + planes[j2].z * coordinates[i2].z <= distanceSign * planes[j2].w)) {
                        intersection = false;
                        break;
                    }
                    intersection = true;
                    ++j2;
                }
                if (intersection) {
                    return true;
                }
                ++i2;
            }
        }
        int numberCols = planes.length + 2 + coordinates.length + 1;
        int numberRows = 1 + coordinates.length;
        double[][] problemTableau = new double[numberRows][numberCols];
        int i3 = 0;
        while (i3 < planes.length) {
            j = 0;
            while (j < coordinates.length) {
                problemTableau[j][i3] = -1.0 * (planes[i3].x * coordinates[j].x + planes[i3].y * coordinates[j].y + planes[i3].z * coordinates[j].z);
                ++j;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < coordinates.length) {
            problemTableau[i3][planes.length] = -1.0;
            problemTableau[i3][planes.length + 1] = 1.0;
            j = 0;
            while (j < coordinates.length) {
                problemTableau[i3][j + planes.length + 2] = i3 == j ? 1.0 : 0.0;
                problemTableau[i3][numberCols - 1] = centers[i3];
                ++j;
            }
            ++i3;
        }
        int j3 = 0;
        while (j3 < planes.length) {
            problemTableau[numberRows - 1][j3] = distanceSign * planes[j3].w;
            ++j3;
        }
        problemTableau[numberRows - 1][planes.length] = 1.0;
        problemTableau[numberRows - 1][planes.length + 1] = -1.0;
        j3 = 0;
        while (j3 < coordinates.length) {
            problemTableau[numberRows - 1][planes.length + 2 + j3] = 0.0;
            ++j3;
        }
        if (debug) {
            System.out.println("The value of the problem tableau is: ");
            i3 = 0;
            while (i3 < problemTableau.length) {
                j = 0;
                while (j < problemTableau[0].length) {
                    System.out.print(String.valueOf(problemTableau[i3][j]) + "  ");
                    ++j;
                }
                System.out.println();
                ++i3;
            }
        }
        double distance = PickResult.generalStandardSimplexSolver(problemTableau, Double.NEGATIVE_INFINITY);
        if (debug) {
            System.out.println("The value returned by the general standard simplex = " + distance);
        }
        return distance != Double.POSITIVE_INFINITY;
    }

    static double generalStandardSimplexSolver(double[][] problemTableau, double stopingValue) {
        boolean debug = false;
        int numRow = problemTableau.length;
        int numCol = problemTableau[0].length;
        boolean optimal = false;
        boolean count = false;
        if (debug) {
            System.out.println("The number of rows is : " + numRow);
            System.out.println("The number of columns is : " + numCol);
        }
        while (!optimal) {
            double element;
            if (debug) {
                System.out.println("input problem tableau is:");
                int k = 0;
                while (k < numRow) {
                    int j = 0;
                    while (j < numCol) {
                        System.out.println("kth, jth value is:" + k + " " + j + " : " + problemTableau[k][j]);
                        ++j;
                    }
                    ++k;
                }
            }
            int i = 0;
            double maxElement = 0.0;
            int pivotColIndex = -1;
            while (i < numCol - 1) {
                element = problemTableau[numRow - 1][i];
                if (element < maxElement) {
                    maxElement = element;
                    pivotColIndex = i;
                }
                ++i;
            }
            if (pivotColIndex == -1) {
                optimal = true;
            }
            if (optimal) continue;
            double prevRatio = Double.POSITIVE_INFINITY;
            double ratio = 0.0;
            int pivotRowIndex = -1;
            i = 0;
            while (i < numRow - 1) {
                element = problemTableau[i][pivotColIndex];
                double endElement = problemTableau[i][numCol - 1];
                if (element == 0.0) {
                    if (debug) {
                        System.out.println("Division by zero has occurred");
                        System.out.println("Within the linear program solver");
                        System.out.println("Ignoring the zero as a potential pivot");
                    }
                } else if (element < 0.0 || endElement < 0.0) {
                    if (debug) {
                        System.out.println("Ignoring cases where element is negative");
                        System.out.println("The value of element is: " + element);
                        System.out.println("The value of end Element is: " + endElement);
                    }
                } else {
                    ratio = endElement / element;
                    if (debug) {
                        System.out.println("The value of element is: " + element);
                        System.out.println("The value of endElement is: " + endElement);
                        System.out.println("The value of ratio is: " + ratio);
                        System.out.println("The value of prevRatio is: " + prevRatio);
                        System.out.println("Value of ratio <= prevRatio is :" + (ratio <= prevRatio));
                    }
                    if (ratio <= prevRatio) {
                        if (debug) {
                            System.out.println("updating prevRatio with ratio");
                        }
                        prevRatio = ratio;
                        pivotRowIndex = i;
                    }
                }
                ++i;
            }
            if (pivotRowIndex == -1) {
                if (debug) {
                    System.out.println("UNABLE TO FIND SOLUTION");
                    System.out.println("The system is infeasable or unbounded");
                }
                return Double.POSITIVE_INFINITY;
            }
            double pivotValue = problemTableau[pivotRowIndex][pivotColIndex];
            if (debug) {
                System.out.println("The value of row index is: " + pivotRowIndex);
                System.out.println("The value of col index is: " + pivotColIndex);
                System.out.println("The value of pivotValue is: " + pivotValue);
            }
            i = 0;
            while (i < numCol) {
                problemTableau[pivotRowIndex][i] = problemTableau[pivotRowIndex][i] / pivotValue;
                ++i;
            }
            i = 0;
            while (i < numRow) {
                if (i != pivotRowIndex) {
                    double multiplier = problemTableau[i][pivotColIndex];
                    int j = 0;
                    while (j < numCol) {
                        problemTableau[i][j] = problemTableau[i][j] - multiplier * problemTableau[pivotRowIndex][j];
                        ++j;
                    }
                }
                ++i;
            }
        }
        return problemTableau[numRow - 1][numCol - 1];
    }

    static boolean edgeIntersectSphere(BoundingSphere sphere, Point3d start, Point3d end) {
        Vector3d ab = new Vector3d();
        Vector3d ap = new Vector3d();
        Point3d center = new Point3d();
        sphere.getCenter(center);
        double radius = sphere.getRadius();
        ab.x = end.x - start.x;
        ab.y = end.y - start.y;
        ab.z = end.z - start.z;
        ap.x = center.x - start.x;
        ap.y = center.y - start.y;
        ap.z = center.z - start.z;
        double abDotAp = ab.dot(ap);
        if (abDotAp < 0.0) {
            return false;
        }
        double abLenSq = ab.lengthSquared();
        double acLenSq = abDotAp * abDotAp / abLenSq;
        if (acLenSq < abLenSq) {
            return false;
        }
        double radiusSq = radius * radius;
        double apLenSq = ap.lengthSquared();
        return apLenSq - acLenSq <= radiusSq;
    }

    static double det2D(Point2d a, Point2d b, Point2d p) {
        return (p.x - a.x) * (a.y - b.y) + (a.y - p.y) * (a.x - b.x);
    }

    static boolean pointIntersectPolygon2D(Vector3d normal, Point3d[] coord, Point3d point) {
        Point2d[] coord2D = new Point2d[coord.length];
        Point2d pnt = new Point2d();
        double absNrmX = Math.abs(normal.x);
        double absNrmY = Math.abs(normal.y);
        double absNrmZ = Math.abs(normal.z);
        int axis = absNrmX > absNrmY ? 0 : 1;
        if (axis == 0) {
            if (absNrmX < absNrmZ) {
                axis = 2;
            }
        } else if (axis == 1 && absNrmY < absNrmZ) {
            axis = 2;
        }
        int i = 0;
        while (i < coord.length) {
            coord2D[i] = new Point2d();
            switch (axis) {
                case 0: {
                    coord2D[i].x = coord[i].y;
                    coord2D[i].y = coord[i].z;
                    break;
                }
                case 1: {
                    coord2D[i].x = coord[i].x;
                    coord2D[i].y = coord[i].z;
                    break;
                }
                case 2: {
                    coord2D[i].x = coord[i].x;
                    coord2D[i].y = coord[i].y;
                }
            }
            ++i;
        }
        switch (axis) {
            case 0: {
                pnt.x = point.y;
                pnt.y = point.z;
                break;
            }
            case 1: {
                pnt.x = point.x;
                pnt.y = point.z;
                break;
            }
            case 2: {
                pnt.x = point.x;
                pnt.y = point.y;
            }
        }
        int j = 0;
        while (j < coord.length) {
            if (j < coord.length - 1) {
                if (!(PickResult.det2D(coord2D[j], coord2D[j + 1], pnt) > 0.0)) {
                    return false;
                }
            } else if (!(PickResult.det2D(coord2D[j], coord2D[0], pnt) > 0.0)) {
                return false;
            }
            ++j;
        }
        return true;
    }

    static boolean edgeIntersectPlane(Vector3d normal, Point3d pnt, Point3d start, Point3d end, Point3d iPnt) {
        Vector3d tempV3d = new Vector3d();
        Vector3d direction = new Vector3d();
        tempV3d.set((Tuple3d)pnt);
        double pD = normal.dot(tempV3d);
        direction.x = end.x - start.x;
        direction.y = end.y - start.y;
        direction.z = end.z - start.z;
        double pNrmDotrDir = normal.dot(direction);
        if (pNrmDotrDir == 0.0) {
            return false;
        }
        tempV3d.set((Tuple3d)start);
        double tr = (pD - normal.dot(tempV3d)) / pNrmDotrDir;
        if (tr < 0.0 || tr > 1.0) {
            return false;
        }
        iPnt.x = start.x + tr * direction.x;
        iPnt.y = start.y + tr * direction.y;
        iPnt.z = start.z + tr * direction.z;
        return true;
    }

    static boolean edgeIntersectPolygon2D(Vector3d normal, Point3d[] coord, Point3d[] seg) {
        Point2d[] coord2D = new Point2d[coord.length];
        Point2d[] seg2D = new Point2d[2];
        double absNrmX = Math.abs(normal.x);
        double absNrmY = Math.abs(normal.y);
        double absNrmZ = Math.abs(normal.z);
        int axis = absNrmX > absNrmY ? 0 : 1;
        if (axis == 0) {
            if (absNrmX < absNrmZ) {
                axis = 2;
            }
        } else if (axis == 1 && absNrmY < absNrmZ) {
            axis = 2;
        }
        int i = 0;
        while (i < coord.length) {
            coord2D[i] = new Point2d();
            switch (axis) {
                case 0: {
                    coord2D[i].x = coord[i].y;
                    coord2D[i].y = coord[i].z;
                    break;
                }
                case 1: {
                    coord2D[i].x = coord[i].x;
                    coord2D[i].y = coord[i].z;
                    break;
                }
                case 2: {
                    coord2D[i].x = coord[i].x;
                    coord2D[i].y = coord[i].y;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 2) {
            seg2D[i] = new Point2d();
            switch (axis) {
                case 0: {
                    seg2D[i].x = seg[i].y;
                    seg2D[i].y = seg[i].z;
                    break;
                }
                case 1: {
                    seg2D[i].x = seg[i].x;
                    seg2D[i].y = seg[i].z;
                    break;
                }
                case 2: {
                    seg2D[i].x = seg[i].x;
                    seg2D[i].y = seg[i].y;
                }
            }
            ++i;
        }
        boolean[][] pntTest = new boolean[2][coord.length];
        int j = 0;
        while (j < coord.length) {
            i = 0;
            while (i < 2) {
                pntTest[i][j] = j < coord.length - 1 ? PickResult.det2D(coord2D[j], coord2D[j + 1], seg2D[i]) < 0.0 : PickResult.det2D(coord2D[j], coord2D[0], seg2D[i]) < 0.0;
                ++i;
            }
            if (!pntTest[0][j] && !pntTest[1][j]) {
                return false;
            }
            ++j;
        }
        boolean testFlag = true;
        i = 0;
        while (i < coord.length) {
            if (!pntTest[0][i]) {
                testFlag = false;
                break;
            }
            ++i;
        }
        if (testFlag) {
            return true;
        }
        testFlag = true;
        i = 0;
        while (i < coord.length) {
            if (!pntTest[1][i]) {
                testFlag = false;
                break;
            }
            ++i;
        }
        if (testFlag) {
            return true;
        }
        int cnt = 0;
        i = 0;
        while (i < coord.length) {
            if (PickResult.det2D(seg2D[0], seg2D[1], coord2D[i]) < 0.0) {
                ++cnt;
            }
            ++i;
        }
        return cnt != 0 && cnt != coord.length;
    }

    static boolean intersectPolygon(Point3d[] coord1, Point3d[] coord2, boolean doTrivialTest) {
        Vector3d vec0 = new Vector3d();
        Vector3d vec1 = new Vector3d();
        Vector3d pNrm = new Vector3d();
        int i = 0;
        while (i < coord1.length - 1) {
            vec0.x = coord1[i + 1].x - coord1[i].x;
            vec0.y = coord1[i + 1].y - coord1[i].y;
            vec0.z = coord1[i + 1].z - coord1[i++].z;
            if (vec0.length() > 0.0) break;
        }
        int j = i;
        while (j < coord1.length - 1) {
            vec1.x = coord1[j + 1].x - coord1[j].x;
            vec1.y = coord1[j + 1].y - coord1[j].y;
            vec1.z = coord1[j + 1].z - coord1[j].z;
            if (vec1.length() > 0.0) break;
            ++j;
        }
        if (j == coord1.length - 1) {
            return false;
        }
        pNrm.cross(vec0, vec1);
        if (pNrm.length() == 0.0) {
            return false;
        }
        j = 0;
        Point3d[] seg = new Point3d[]{new Point3d(), new Point3d()};
        i = 0;
        while (i < coord2.length) {
            boolean epFlag = i < coord2.length - 1 ? PickResult.edgeIntersectPlane(pNrm, coord1[0], coord2[i], coord2[i + 1], seg[j]) : PickResult.edgeIntersectPlane(pNrm, coord1[0], coord2[i], coord2[0], seg[j]);
            if (epFlag && ++j > 1) break;
            ++i;
        }
        if (j == 0) {
            return false;
        }
        if (coord2.length < 3) {
            return PickResult.pointIntersectPolygon2D(pNrm, coord1, seg[0]);
        }
        return PickResult.edgeIntersectPolygon2D(pNrm, coord1, seg);
    }

    static final boolean isNonZero(double v) {
        return v > 1.0E-13 || v < -1.0E-13;
    }

    static boolean intersectRay(Point3d[] coordinates, PickRay ray, PickIntersection pi) {
        Point3d origin = new Point3d();
        Vector3d direction = new Vector3d();
        ray.get(origin, direction);
        boolean result = PickResult.intersectRayOrSegment(coordinates, direction, origin, pi, false);
        return result;
    }

    static boolean intersectRayOrSegment(Point3d[] coordinates, Vector3d direction, Point3d origin, PickIntersection pi, boolean isSegment) {
        Vector3d vec0 = new Vector3d();
        Vector3d vec1 = new Vector3d();
        Vector3d pNrm = new Vector3d();
        double pD = 0.0;
        double pNrmDotrDir = 0.0;
        boolean isIntersect = false;
        int k = 0;
        int l = 0;
        int i = 0;
        while (i < coordinates.length) {
            l = i != coordinates.length - 1 ? i + 1 : 0;
            vec0.x = coordinates[l].x - coordinates[i].x;
            vec0.y = coordinates[l].y - coordinates[i].y;
            vec0.z = coordinates[l].z - coordinates[i].z;
            if (vec0.length() > 0.0) break;
            ++i;
        }
        int j = l;
        while (j < coordinates.length) {
            k = j != coordinates.length - 1 ? j + 1 : 0;
            vec1.x = coordinates[k].x - coordinates[j].x;
            vec1.y = coordinates[k].y - coordinates[j].y;
            vec1.z = coordinates[k].z - coordinates[j].z;
            if (vec1.length() > 0.0) break;
            ++j;
        }
        pNrm.cross(vec0, vec1);
        if (vec1.length() == 0.0 || pNrm.length() == 0.0) {
            k = l == 0 ? coordinates.length - 1 : l - 1;
            isIntersect = PickResult.intersectLineAndRay(coordinates[l], coordinates[k], origin, direction, pi);
            return isIntersect;
        }
        pNrmDotrDir = pNrm.dot(direction);
        if (pNrmDotrDir == 0.0) {
            i = 0;
            while (i < coordinates.length) {
                k = i != coordinates.length - 1 ? i + 1 : 0;
                if (PickResult.intersectLineAndRay(coordinates[i], coordinates[k], origin, direction, pi)) {
                    isIntersect = true;
                    break;
                }
                ++i;
            }
            return isIntersect;
        }
        Vector3d tempV3d = new Vector3d();
        tempV3d.set((Tuple3d)coordinates[0]);
        pD = pNrm.dot(tempV3d);
        tempV3d.set((Tuple3d)origin);
        double dist = (pD - pNrm.dot(tempV3d)) / pNrmDotrDir;
        if (dist < -1.0E-13 || isSegment && dist > 1.0000000000001) {
            return false;
        }
        Point3d iPnt = new Point3d();
        iPnt.x = origin.x + direction.x * dist;
        iPnt.y = origin.y + direction.y * dist;
        iPnt.z = origin.z + direction.z * dist;
        double absNrmX = Math.abs(pNrm.x);
        double absNrmY = Math.abs(pNrm.y);
        double absNrmZ = Math.abs(pNrm.z);
        double lastSign = 0.0;
        Point3d p0 = coordinates[coordinates.length - 1];
        Point3d p1 = coordinates[0];
        isIntersect = true;
        if (absNrmX > absNrmY) {
            if (absNrmX < absNrmZ) {
                i = 0;
                while (i < coordinates.length) {
                    p0 = coordinates[i];
                    p1 = i != coordinates.length - 1 ? coordinates[i + 1] : coordinates[0];
                    double sign = (iPnt.y - p0.y) * (p1.x - p0.x) - (iPnt.x - p0.x) * (p1.y - p0.y);
                    if (PickResult.isNonZero(sign)) {
                        if (sign * lastSign < 0.0) {
                            isIntersect = false;
                            break;
                        }
                        lastSign = sign;
                    } else {
                        double t = p1.y - p0.y;
                        if (PickResult.isNonZero(t)) {
                            isIntersect = (t = (iPnt.y - p0.y) / t) > -1.0E-13 && t < 1.0000000000001;
                            break;
                        }
                        t = p1.x - p0.x;
                        if (PickResult.isNonZero(t)) {
                            isIntersect = (t = (iPnt.x - p0.x) / t) > -1.0E-13 && t < 1.0000000000001;
                            break;
                        }
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < coordinates.length) {
                    p0 = coordinates[i];
                    p1 = i != coordinates.length - 1 ? coordinates[i + 1] : coordinates[0];
                    double sign = (iPnt.y - p0.y) * (p1.z - p0.z) - (iPnt.z - p0.z) * (p1.y - p0.y);
                    if (PickResult.isNonZero(sign)) {
                        if (sign * lastSign < 0.0) {
                            isIntersect = false;
                            break;
                        }
                        lastSign = sign;
                    } else {
                        double t = p1.y - p0.y;
                        if (PickResult.isNonZero(t)) {
                            isIntersect = (t = (iPnt.y - p0.y) / t) > -1.0E-13 && t < 1.0000000000001;
                            break;
                        }
                        t = p1.z - p0.z;
                        if (PickResult.isNonZero(t)) {
                            isIntersect = (t = (iPnt.z - p0.z) / t) > -1.0E-13 && t < 1.0000000000001;
                            break;
                        }
                    }
                    ++i;
                }
            }
        } else if (absNrmY < absNrmZ) {
            i = 0;
            while (i < coordinates.length) {
                p0 = coordinates[i];
                p1 = i != coordinates.length - 1 ? coordinates[i + 1] : coordinates[0];
                double sign = (iPnt.y - p0.y) * (p1.x - p0.x) - (iPnt.x - p0.x) * (p1.y - p0.y);
                if (PickResult.isNonZero(sign)) {
                    if (sign * lastSign < 0.0) {
                        isIntersect = false;
                        break;
                    }
                    lastSign = sign;
                } else {
                    double t = p1.y - p0.y;
                    if (PickResult.isNonZero(t)) {
                        isIntersect = (t = (iPnt.y - p0.y) / t) > -1.0E-13 && t < 1.0000000000001;
                        break;
                    }
                    t = p1.x - p0.x;
                    if (PickResult.isNonZero(t)) {
                        isIntersect = (t = (iPnt.x - p0.x) / t) > -1.0E-13 && t < 1.0000000000001;
                        break;
                    }
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < coordinates.length) {
                p0 = coordinates[i];
                p1 = i != coordinates.length - 1 ? coordinates[i + 1] : coordinates[0];
                double sign = (iPnt.x - p0.x) * (p1.z - p0.z) - (iPnt.z - p0.z) * (p1.x - p0.x);
                if (PickResult.isNonZero(sign)) {
                    if (sign * lastSign < 0.0) {
                        isIntersect = false;
                        break;
                    }
                    lastSign = sign;
                } else {
                    double t = p1.x - p0.x;
                    if (PickResult.isNonZero(t)) {
                        isIntersect = (t = (iPnt.x - p0.x) / t) > -1.0E-13 && t < 1.0000000000001;
                        break;
                    }
                    t = p1.z - p0.z;
                    if (PickResult.isNonZero(t)) {
                        isIntersect = (t = (iPnt.z - p0.z) / t) > -1.0E-13 && t < 1.0000000000001;
                        break;
                    }
                }
                ++i;
            }
        }
        if (isIntersect) {
            pi.setDistance(dist * direction.length());
            pi.setPointCoordinatesVW(iPnt);
        }
        return isIntersect;
    }

    static boolean intersectSegment(Point3d[] coordinates, PickSegment segment, PickIntersection pi) {
        Point3d start = new Point3d();
        Point3d end = new Point3d();
        Vector3d direction = new Vector3d();
        segment.get(start, end);
        direction.x = end.x - start.x;
        direction.y = end.y - start.y;
        direction.z = end.z - start.z;
        boolean result = PickResult.intersectRayOrSegment(coordinates, direction, start, pi, true);
        return result;
    }

    static boolean inside(Point3d[] coordinates, PickPoint point, int ccw) {
        Vector3d vec0 = new Vector3d();
        Vector3d vec1 = new Vector3d();
        Vector3d pNrm = new Vector3d();
        double pD = 0.0;
        Vector3d tempV3d = new Vector3d();
        double pNrmDotrDir = 0.0;
        Point3d location = new Point3d();
        point.get(location);
        int i = 0;
        while (i < coordinates.length - 1) {
            vec0.x = coordinates[i + 1].x - coordinates[i].x;
            vec0.y = coordinates[i + 1].y - coordinates[i].y;
            vec0.z = coordinates[i + 1].z - coordinates[i++].z;
            if (vec0.length() > 0.0) break;
        }
        int j = i;
        while (j < coordinates.length - 1) {
            vec1.x = coordinates[j + 1].x - coordinates[j].x;
            vec1.y = coordinates[j + 1].y - coordinates[j].y;
            vec1.z = coordinates[j + 1].z - coordinates[j].z;
            if (vec1.length() > 0.0) break;
            ++j;
        }
        if (j == coordinates.length - 1) {
            return false;
        }
        if (ccw == 1) {
            pNrm.cross(vec0, vec1);
        } else {
            pNrm.cross(vec1, vec0);
        }
        if (pNrm.length() == 0.0) {
            return false;
        }
        tempV3d.set((Tuple3d)coordinates[0]);
        pD = pNrm.dot(tempV3d);
        tempV3d.set((Tuple3d)location);
        return !(pD - pNrm.dot(tempV3d) > 0.0);
    }

    static boolean intersectPntAndPnt(Point3d pnt1, Point3d pnt2, PickIntersection pi) {
        if (pnt1.x == pnt2.x && pnt1.y == pnt2.y && pnt1.z == pnt2.z) {
            pi.setPointCoordinatesVW(pnt1);
            pi.setDistance(0.0);
            return true;
        }
        return false;
    }

    static boolean intersectPntAndRay(Point3d pnt, Point3d ori, Vector3d dir, PickIntersection pi) {
        double temp;
        double dist;
        int flag = 0;
        if (dir.x != 0.0) {
            flag = 0;
            dist = (pnt.x - ori.x) / dir.x;
        } else if (dir.y != 0.0) {
            if (pnt.x != ori.x) {
                return false;
            }
            flag = 1;
            dist = (pnt.y - ori.y) / dir.y;
        } else if (dir.z != 0.0) {
            if (pnt.x != ori.x || pnt.y != ori.y) {
                return false;
            }
            flag = 2;
            dist = (pnt.z - ori.z) / dir.z;
        } else {
            return false;
        }
        if (dist < 0.0) {
            return false;
        }
        if (flag == 0 && (pnt.y < (temp = ori.y + dist * dir.y) - Double.MIN_VALUE || pnt.y > temp + Double.MIN_VALUE)) {
            return false;
        }
        if (flag < 2 && (pnt.z < (temp = ori.z + dist * dir.z) - Double.MIN_VALUE || pnt.z > temp + Double.MIN_VALUE)) {
            return false;
        }
        pi.setPointCoordinatesVW(pnt);
        pi.setDistance(dist);
        return true;
    }

    static boolean intersectLineAndRay(Point3d start, Point3d end, Point3d ori, Vector3d dir, PickIntersection pi) {
        Vector3d lDir = new Vector3d(end.x - start.x, end.y - start.y, end.z - start.z);
        double m00 = lDir.x;
        double m11 = -dir.y;
        double m10 = lDir.y;
        double m01 = -dir.x;
        double dmt = m00 * m11 - m10 * m01;
        if (dmt == 0.0) {
            boolean isIntersect = false;
            if (lDir.x == 0.0 && lDir.y == 0.0 && lDir.z == 0.0 && (isIntersect = PickResult.intersectPntAndRay(start, ori, dir, pi))) {
                pi.setPointCoordinatesVW(start);
                pi.setDistance(0.0);
            }
            return isIntersect;
        }
        double tmp1 = 1.0 / dmt;
        double mInv00 = tmp1 * m11;
        double mInv01 = tmp1 * -m01;
        double mInv10 = tmp1 * -m10;
        double mInv11 = tmp1 * m00;
        tmp1 = ori.x - start.x;
        double tmp2 = ori.y - start.y;
        double t = mInv00 * tmp1 + mInv01 * tmp2;
        double s = mInv10 * tmp1 + mInv11 * tmp2;
        if (s < 0.0) {
            return false;
        }
        if (t < 0.0 || t > 1.0) {
            return false;
        }
        tmp1 = ori.z + s * dir.z;
        tmp2 = start.z + t * lDir.z;
        if (tmp1 < tmp2 - Double.MIN_VALUE || tmp1 > tmp2 + Double.MIN_VALUE) {
            return false;
        }
        double dist = s;
        pi.setDistance(dist);
        Point3d iPnt = new Point3d();
        iPnt.scaleAdd(s, (Tuple3d)dir, (Tuple3d)ori);
        pi.setPointCoordinatesVW(iPnt);
        return true;
    }

    static boolean intersectCylinder(Point3d[] coordinates, PickCylinder cyl, PickIntersection pi) {
        Point3d origin = new Point3d();
        Point3d end = new Point3d();
        Vector3d direction = new Vector3d();
        Point3d iPnt1 = new Point3d();
        Point3d iPnt2 = new Point3d();
        Vector3d originToIpnt = new Vector3d();
        cyl.getOrigin(origin);
        cyl.getDirection(direction);
        double radius = cyl.getRadius();
        if (cyl instanceof PickCylinderSegment) {
            ((PickCylinderSegment)cyl).getEnd(end);
        }
        if (coordinates.length > 2 && (cyl instanceof PickCylinderRay ? PickResult.intersectRay(coordinates, new PickRay(origin, direction), pi) : PickResult.intersectSegment(coordinates, new PickSegment(origin, end), pi))) {
            return true;
        }
        int i = 0;
        while (i < coordinates.length - 1) {
            double sqDistToEdge = cyl instanceof PickCylinderSegment ? Distance.segmentToSegment(origin, end, coordinates[i], coordinates[i + 1], iPnt1, iPnt2, null) : Distance.rayToSegment(origin, direction, coordinates[i], coordinates[i + 1], iPnt1, iPnt2, null);
            if (sqDistToEdge <= radius * radius) {
                pi.setPointCoordinatesVW(iPnt2);
                originToIpnt.sub((Tuple3d)iPnt1, (Tuple3d)origin);
                pi.setDistance(originToIpnt.length());
                return true;
            }
            ++i;
        }
        return false;
    }

    static boolean intersectCone(Point3d[] coordinates, PickCone cone, PickIntersection pi) {
        Point3d origin = new Point3d();
        Point3d end = new Point3d();
        Vector3d direction = new Vector3d();
        Vector3d originToIpnt = new Vector3d();
        Point3d iPnt1 = new Point3d();
        Point3d iPnt2 = new Point3d();
        Vector3d vector = new Vector3d();
        cone.getOrigin(origin);
        cone.getDirection(direction);
        if (cone instanceof PickConeSegment) {
            ((PickConeSegment)cone).getEnd(end);
        }
        if (coordinates.length > 2 && (cone instanceof PickConeRay ? PickResult.intersectRay(coordinates, new PickRay(origin, direction), pi) : PickResult.intersectSegment(coordinates, new PickSegment(origin, end), pi))) {
            return true;
        }
        int i = 0;
        while (i < coordinates.length - 1) {
            double sqDistToEdge = cone instanceof PickConeSegment ? Distance.segmentToSegment(origin, end, coordinates[i], coordinates[i + 1], iPnt1, iPnt2, null) : Distance.rayToSegment(origin, direction, coordinates[i], coordinates[i + 1], iPnt1, iPnt2, null);
            originToIpnt.sub((Tuple3d)iPnt1, (Tuple3d)origin);
            double distance = originToIpnt.length();
            double radius = Math.tan(cone.getSpreadAngle()) * distance;
            if (sqDistToEdge <= radius * radius) {
                pi.setPointCoordinatesVW(iPnt2);
                pi.setDistance(distance);
                return true;
            }
            ++i;
        }
        return false;
    }

    static boolean intersectCylinder(Point3d pt, PickCylinder cyl, PickIntersection pi) {
        double sqDist;
        Point3d origin = new Point3d();
        Point3d end = new Point3d();
        Vector3d direction = new Vector3d();
        Point3d iPnt = new Point3d();
        Vector3d originToIpnt = new Vector3d();
        cyl.getOrigin(origin);
        cyl.getDirection(direction);
        double radius = cyl.getRadius();
        if (cyl instanceof PickCylinderSegment) {
            ((PickCylinderSegment)cyl).getEnd(end);
            sqDist = Distance.pointToSegment(pt, origin, end, iPnt, null);
        } else {
            sqDist = Distance.pointToRay(pt, origin, direction, iPnt, null);
        }
        if (sqDist <= radius * radius) {
            pi.setPointCoordinatesVW(pt);
            originToIpnt.sub((Tuple3d)iPnt, (Tuple3d)origin);
            pi.setDistance(originToIpnt.length());
            return true;
        }
        return false;
    }

    static boolean intersectCone(Point3d pt, PickCone cone, PickIntersection pi) {
        double sqDist;
        Point3d origin = new Point3d();
        Point3d end = new Point3d();
        Vector3d direction = new Vector3d();
        Point3d iPnt = new Point3d();
        Vector3d originToIpnt = new Vector3d();
        cone.getOrigin(origin);
        cone.getDirection(direction);
        if (cone instanceof PickConeSegment) {
            ((PickConeSegment)cone).getEnd(end);
            sqDist = Distance.pointToSegment(pt, origin, end, iPnt, null);
        } else {
            sqDist = Distance.pointToRay(pt, origin, direction, iPnt, null);
        }
        originToIpnt.sub((Tuple3d)iPnt, (Tuple3d)origin);
        double distance = originToIpnt.length();
        double radius = Math.tan(cone.getSpreadAngle()) * distance;
        if (sqDist <= radius * radius) {
            pi.setPointCoordinatesVW(pt);
            pi.setDistance(distance);
            return true;
        }
        return false;
    }
}

