/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.aromaticity;

import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

final class PiBondModel
extends ElectronDonation {
    PiBondModel() {
    }

    @Override
    int[] contribution(IAtomContainer container) {
        int n = container.getAtomCount();
        int[] electrons = new int[n];
        int[] piBonds = new int[n];
        for (IBond bond : container.bonds()) {
            int u = container.indexOf(bond.getBegin());
            int v = container.indexOf(bond.getEnd());
            if (bond.getOrder() != IBond.Order.DOUBLE || !bond.isInRing()) continue;
            int n2 = u;
            piBonds[n2] = piBonds[n2] + 1;
            int n3 = v;
            piBonds[n3] = piBonds[n3] + 1;
        }
        for (int i = 0; i < n; ++i) {
            electrons[i] = piBonds[i] == 1 ? 1 : -1;
        }
        return electrons;
    }
}

