/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.stereo.generic;

import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.math.FovHVHalves;
import com.jogamp.math.Vec3f;
import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.opengl.util.stereo.EyeParameter;
import com.jogamp.opengl.util.stereo.StereoDevice;
import com.jogamp.opengl.util.stereo.StereoDeviceConfig;
import com.jogamp.opengl.util.stereo.StereoDeviceFactory;
import com.jogamp.opengl.util.stereo.StereoUtil;
import com.jogamp.opengl.util.stereo.generic.GenericStereoDeviceConfig;
import jogamp.opengl.util.stereo.DistortionMesh;
import jogamp.opengl.util.stereo.GenericStereoDevice;

public class GenericStereoDeviceFactory
extends StereoDeviceFactory {
    private boolean isValid = true;

    public static GenericStereoDeviceConfig createMono(String string, DimensionImmutable dimensionImmutable, float[] fArray, Vec3f vec3f) {
        float f = fArray[1] / 2.0f;
        return new GenericStereoDeviceConfig(string, GenericStereoDeviceConfig.ShutterType.RollingTopToBottom, dimensionImmutable, fArray, new DimensionImmutable[]{dimensionImmutable}, f, 0.0f, new int[]{0}, new EyeParameter[]{new EyeParameter(0, vec3f, FovHVHalves.byFovyRadianAndAspect(0.7853982f, 1.6f), 0.0f, 0.0f, 0.0f)}, 0, null, 0, 0, 0);
    }

    public static GenericStereoDeviceConfig createStereoSBS(String string, DimensionImmutable dimensionImmutable, float[] fArray, float f, float f2, Vec3f vec3f) {
        float f3 = fArray[1] / 2.0f;
        Dimension dimension = new Dimension(dimensionImmutable.getWidth() / 2, dimensionImmutable.getHeight());
        float[] fArray2 = StereoUtil.getHorizPupilCenterFromLeft(fArray[0], f);
        float f4 = StereoUtil.getVertPupilCenterFromTop(fArray[1], f3);
        float f5 = (float)dimension.getWidth() / (float)dimension.getHeight();
        FovHVHalves fovHVHalves = FovHVHalves.byFovyRadianAndAspect(f2 * ((float)Math.PI / 180), f4, f5, fArray2[0]);
        FovHVHalves fovHVHalves2 = FovHVHalves.byFovyRadianAndAspect(f2 * ((float)Math.PI / 180), f4, f5, fArray2[1]);
        return new GenericStereoDeviceConfig(string, GenericStereoDeviceConfig.ShutterType.RollingTopToBottom, dimensionImmutable, fArray, new DimensionImmutable[]{dimension, dimension}, f3, f, new int[]{0, 1}, new EyeParameter[]{new EyeParameter(0, vec3f, fovHVHalves, f / 2.0f, 0.0f, 0.01f), new EyeParameter(1, vec3f, fovHVHalves2, -f / 2.0f, 0.0f, 0.01f)}, 0, null, 0, 0, 0);
    }

    public static GenericStereoDeviceConfig createStereoSBSLense(String string, DimensionImmutable dimensionImmutable, float[] fArray, float f, float f2, DimensionImmutable dimensionImmutable2, Vec3f vec3f) {
        DistortionMesh.Producer producer;
        block3: {
            producer = null;
            try {
                producer = (DistortionMesh.Producer)ReflectionUtil.createInstance("jogamp.opengl.oculusvr.stereo.lense.DistortionMeshProducer", GenericStereoDevice.class.getClassLoader());
            }
            catch (Throwable throwable) {
                if (!StereoDevice.DEBUG) break block3;
                System.err.println("Caught: " + throwable.getMessage());
                throwable.printStackTrace();
            }
        }
        if (null == producer) {
            return null;
        }
        float f3 = fArray[1] / 2.0f;
        float[] fArray2 = StereoUtil.getHorizPupilCenterFromLeft(fArray[0], f);
        float f4 = StereoUtil.getVertPupilCenterFromTop(fArray[1], f3);
        float f5 = (float)dimensionImmutable2.getWidth() / (float)dimensionImmutable2.getHeight();
        FovHVHalves fovHVHalves = FovHVHalves.byFovyRadianAndAspect(f2 * ((float)Math.PI / 180), f4, f5, fArray2[0]);
        FovHVHalves fovHVHalves2 = FovHVHalves.byFovyRadianAndAspect(f2 * ((float)Math.PI / 180), f4, f5, fArray2[1]);
        return new GenericStereoDeviceConfig(string, GenericStereoDeviceConfig.ShutterType.RollingTopToBottom, dimensionImmutable, fArray, new DimensionImmutable[]{dimensionImmutable2, dimensionImmutable2}, f3, f, new int[]{0, 1}, new EyeParameter[]{new EyeParameter(0, vec3f, fovHVHalves, f / 2.0f, 0.0f, 0.01f), new EyeParameter(1, vec3f, fovHVHalves2, -f / 2.0f, 0.0f, 0.01f)}, 0, producer, 7, 7, 1);
    }

    public static boolean isAvailable() {
        return true;
    }

    @Override
    protected final StereoDevice createDeviceImpl(int n, StereoDeviceConfig stereoDeviceConfig, boolean bl) {
        return new GenericStereoDevice(this, n, stereoDeviceConfig);
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public final void shutdown() {
        if (this.isValid) {
            this.isValid = false;
        }
    }
}

