/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.GLArrayDataEditable;
import com.jogamp.opengl.util.GLArrayDataWrapper;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.lang.reflect.Constructor;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import jogamp.opengl.util.GLArrayHandler;
import jogamp.opengl.util.GLFixedArrayHandler;
import jogamp.opengl.util.glsl.GLSLArrayHandler;

public class GLArrayDataClient
extends GLArrayDataWrapper
implements GLArrayDataEditable {
    public static final float DEFAULT_GROWTH_FACTOR = 1.618f;
    protected final int initElemCount;
    protected final GLArrayHandler glArrayHandler;
    protected final boolean usesGLSL;
    protected float growthFactor;
    private boolean isValidated = false;
    protected boolean bufferEnabled;
    protected boolean bufferWritten;
    protected boolean enableBufferAlways;
    protected ShaderState shaderState;

    public static GLArrayDataClient createFixed(int n, int n2, int n3, boolean bl, int n4) throws GLException {
        return new GLArrayDataClient(null, n, n2, n3, bl, 0, null, n4, 1.618f, 0, false, GLFixedArrayHandler.class, 0, 0L, 0, 0, false);
    }

    public static GLArrayDataClient createFixed(int n, int n2, int n3, boolean bl, int n4, Buffer buffer) throws GLException {
        return new GLArrayDataClient(null, n, n2, n3, bl, n4, buffer, n2 * n2, 1.618f, 0, false, GLFixedArrayHandler.class, 0, 0L, 0, 0, false);
    }

    public static GLArrayDataClient createGLSL(String string, int n, int n2, boolean bl, int n3) throws GLException {
        return new GLArrayDataClient(string, -1, n, n2, bl, 0, null, n3, 1.618f, 0, true, GLSLArrayHandler.class, 0, 0L, 0, 0, true);
    }

    public static GLArrayDataClient createGLSL(String string, int n, int n2, boolean bl, int n3, Buffer buffer) throws GLException {
        return new GLArrayDataClient(string, -1, n, n2, bl, n3, buffer, n * n, 1.618f, 0, true, GLSLArrayHandler.class, 0, 0L, 0, 0, true);
    }

    @Override
    public void associate(Object object, boolean bl) {
        if (object instanceof ShaderState) {
            this.shaderState = bl ? (ShaderState)object : null;
        }
    }

    @Override
    public final boolean isVBOWritten() {
        return this.bufferWritten;
    }

    @Override
    public final boolean enabled() {
        return this.bufferEnabled;
    }

    @Override
    public final void setVBOWritten(boolean bl) {
        this.bufferWritten = 0 == this.mappedElemCount ? bl : true;
    }

    @Override
    public void destroy(GL gL) {
        this.clear(gL);
        super.destroy(gL);
    }

    @Override
    public void clear(GL gL) {
        this.seal(gL, false);
        this.clear();
    }

    @Override
    public void seal(GL gL, boolean bl) {
        this.seal(bl);
        this.enableBuffer(gL, bl);
    }

    @Override
    public void enableBuffer(GL gL, boolean bl) {
        if (this.enableBufferAlways || this.bufferEnabled != bl) {
            if (bl) {
                this.checkSeal(true);
                this.init_vbo(gL);
            }
            this.glArrayHandler.enableState(gL, bl, this.usesGLSL ? this.shaderState : null);
            this.bufferEnabled = bl;
        }
    }

    @Override
    public boolean bindBuffer(GL gL, boolean bl) {
        if (bl) {
            this.checkSeal(true);
            this.init_vbo(gL);
        }
        return this.glArrayHandler.bindBuffer(gL, bl);
    }

    @Override
    public void setEnableAlways(boolean bl) {
        this.enableBufferAlways = bl;
    }

    @Override
    public void clear() {
        if (this.buffer != null) {
            this.buffer.clear();
        }
        this.sealed = false;
        this.bufferEnabled = false;
        this.bufferWritten = 0 != this.mappedElemCount;
    }

    @Override
    public void seal(boolean bl) {
        if (this.sealed == bl) {
            return;
        }
        this.sealed = bl;
        boolean bl2 = this.bufferWritten = 0 != this.mappedElemCount;
        if (bl) {
            if (null != this.buffer) {
                this.buffer.flip();
            }
        } else if (null != this.buffer) {
            this.buffer.position(this.buffer.limit());
            this.buffer.limit(this.buffer.capacity());
        }
    }

    @Override
    public void rewind() {
        if (this.buffer != null) {
            this.buffer.rewind();
        }
    }

    @Override
    public void padding(int n) {
        if (this.buffer == null || this.sealed) {
            return;
        }
        while (n < this.strideB) {
            Buffers.putb(this.buffer, (byte)0);
            ++n;
        }
    }

    @Override
    public void put(Buffer buffer) {
        if (this.sealed) {
            return;
        }
        this.growIfNeeded(buffer.remaining());
        Buffers.put(this.buffer, buffer);
    }

    @Override
    public void putb(byte by) {
        if (this.sealed) {
            return;
        }
        this.growIfNeeded(1);
        Buffers.putb(this.buffer, by);
    }

    @Override
    public void put3b(byte by, byte by2, byte by3) {
        if (this.sealed) {
            return;
        }
        this.growIfNeeded(3);
        Buffers.put3b(this.buffer, by, by2, by3);
    }

    @Override
    public void put4b(byte by, byte by2, byte by3, byte by4) {
        if (this.sealed) {
            return;
        }
        this.growIfNeeded(4);
        Buffers.put4b(this.buffer, by, by2, by3, by4);
    }

    @Override
    public void putb(byte[] byArray, int n, int n2) {
        if (this.sealed) {
            return;
        }
        this.growIfNeeded(n2);
        Buffers.putb(this.buffer, byArray, n, n2);
    }

    @Override
    public void puts(short s) {
        if (this.sealed) {
            return;
        }
        this.growIfNeeded(1);
        Buffers.puts(this.buffer, s);
    }

    @Override
    public void put3s(short s, short s2, short s3) {
        if (this.sealed) {
            return;
        }
        this.growIfNeeded(3);
        Buffers.put3s(this.buffer, s, s2, s3);
    }

    @Override
    public void put4s(short s, short s2, short s3, short s4) {
        if (this.sealed) {
            return;
        }
        this.growIfNeeded(4);
        Buffers.put4s(this.buffer, s, s2, s3, s4);
    }

    @Override
    public void puts(short[] sArray, int n, int n2) {
        if (this.sealed) {
            return;
        }
        this.growIfNeeded(n2);
        Buffers.puts(this.buffer, sArray, n, n2);
    }

    @Override
    public void puti(int n) {
        if (this.sealed) {
            return;
        }
        this.growIfNeeded(1);
        Buffers.puti(this.buffer, n);
    }

    @Override
    public void put3i(int n, int n2, int n3) {
        if (this.sealed) {
            return;
        }
        this.growIfNeeded(3);
        Buffers.put3i(this.buffer, n, n2, n3);
    }

    @Override
    public void put4i(int n, int n2, int n3, int n4) {
        if (this.sealed) {
            return;
        }
        this.growIfNeeded(4);
        Buffers.put4i(this.buffer, n, n2, n3, n4);
    }

    @Override
    public void puti(int[] nArray, int n, int n2) {
        if (this.sealed) {
            return;
        }
        this.growIfNeeded(n2);
        Buffers.puti(this.buffer, nArray, n, n2);
    }

    @Override
    public void putx(int n) {
        this.puti(n);
    }

    @Override
    public void putf(float f) {
        if (this.sealed) {
            return;
        }
        this.growIfNeeded(1);
        Buffers.putf(this.buffer, f);
    }

    @Override
    public void put3f(float f, float f2, float f3) {
        if (this.sealed) {
            return;
        }
        this.growIfNeeded(3);
        Buffers.put3f(this.buffer, f, f2, f3);
    }

    @Override
    public void put4f(float f, float f2, float f3, float f4) {
        if (this.sealed) {
            return;
        }
        this.growIfNeeded(4);
        Buffers.put4f(this.buffer, f, f2, f3, f4);
    }

    @Override
    public void putf(float[] fArray, int n, int n2) {
        if (this.sealed) {
            return;
        }
        this.growIfNeeded(n2);
        Buffers.putf(this.buffer, fArray, n, n2);
    }

    @Override
    public String toString() {
        return "GLArrayDataClient[" + this.name + ", index " + this.index + ", location " + this.location + ", isVertexAttribute " + this.isVertexAttr + ", usesGLSL " + this.usesGLSL + ", usesShaderState " + (null != this.shaderState) + ", dataType 0x" + Integer.toHexString(this.compType) + ", bufferClazz " + this.compClazz + ", compsPerElem " + this.compsPerElement + ", stride " + this.strideB + "b " + this.strideL + "c, initElemCount " + this.initElemCount + ", mappedElemCount " + this.mappedElemCount + ", " + this.elemStatsToString() + ", bufferEnabled " + this.bufferEnabled + ", bufferWritten " + this.bufferWritten + ", buffer " + this.buffer + ", alive " + this.alive + "]";
    }

    public int compsToElemCount(int n) {
        return (n + this.compsPerElement - 1) / this.compsPerElement;
    }

    public final boolean growIfNeeded(int n) {
        if (null == this.buffer || this.buffer.remaining() < n) {
            if (0 != this.mappedElemCount) {
                throw new GLException("Mapped buffer can't grow. Insufficient storage size: Needed " + n + " components, mappedElementCount " + this.mappedElemCount + ", has mapped buffer " + this.buffer + "; " + this);
            }
            if (null == this.buffer) {
                int n2 = this.compsToElemCount(n);
                return this.reserve(Math.max(this.initElemCount, n2));
            }
            int n3 = this.buffer.capacity();
            int n4 = this.compsToElemCount(n3 + n);
            int n5 = this.compsToElemCount((int)((float)n3 * this.growthFactor + 0.5f));
            int n6 = Math.max(n5, n4);
            return this.reserve(n6);
        }
        return false;
    }

    public final boolean reserve(int n) {
        int n2;
        if (!this.alive || this.sealed) {
            throw new GLException("Invalid state: " + this);
        }
        int n3 = this.buffer != null ? this.buffer.capacity() : 0;
        if ((n2 = (n += n / this.compsPerElement * (this.strideL - this.compsPerElement)) * this.compsPerElement) <= n3) {
            return false;
        }
        Buffer buffer = this.buffer;
        if (this.compClazz == ByteBuffer.class) {
            ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(n2);
            if (buffer != null) {
                buffer.flip();
                byteBuffer.put((ByteBuffer)buffer);
            }
            this.buffer = byteBuffer;
        } else if (this.compClazz == ShortBuffer.class) {
            ShortBuffer shortBuffer = Buffers.newDirectShortBuffer(n2);
            if (buffer != null) {
                buffer.flip();
                shortBuffer.put((ShortBuffer)buffer);
            }
            this.buffer = shortBuffer;
        } else if (this.compClazz == IntBuffer.class) {
            IntBuffer intBuffer = Buffers.newDirectIntBuffer(n2);
            if (buffer != null) {
                buffer.flip();
                intBuffer.put((IntBuffer)buffer);
            }
            this.buffer = intBuffer;
        } else if (this.compClazz == FloatBuffer.class) {
            FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(n2);
            if (buffer != null) {
                buffer.flip();
                floatBuffer.put((FloatBuffer)buffer);
            }
            this.buffer = floatBuffer;
        } else {
            throw new GLException("Given Buffer Class not supported: " + this.compClazz + ":\n\t" + this);
        }
        if (DEBUG) {
            System.err.println("*** Size: Reserve: comps: " + this.compsPerElement + ", " + n3 / this.compsPerElement + "/" + n3 + " -> " + n2 / this.compsPerElement + "/" + n2 + "; " + buffer + " -> " + this.buffer + "; " + this);
        }
        return true;
    }

    protected final void checkSeal(boolean bl) throws GLException {
        if (!this.alive) {
            throw new GLException("Invalid state: " + this);
        }
        if (this.sealed != bl) {
            if (bl) {
                throw new GLException("Not Sealed yet, seal first:\n\t" + this);
            }
            throw new GLException("Already Sealed, can't modify VBO:\n\t" + this);
        }
    }

    protected GLArrayDataClient(String string, int n, int n2, int n3, boolean bl, int n4, Buffer buffer, int n5, float f, int n6, boolean bl2, Class<? extends GLArrayHandler> clazz, int n7, long l, int n8, int n9, boolean bl3) throws GLException {
        super(string, n, n2, n3, bl, n4, buffer, n6, bl2, n7, l, n8, n9);
        if (0 < n6 && 0 < n5) {
            throw new IllegalArgumentException("mappedElementCount:=" + n6 + " specified, but passing non zero initialElementSize");
        }
        this.initElemCount = n5;
        this.growthFactor = f;
        try {
            Constructor<? extends GLArrayHandler> constructor = clazz.getConstructor(GLArrayDataEditable.class);
            this.glArrayHandler = constructor.newInstance(this);
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not ctor " + clazz.getName() + "(" + this.getClass().getName() + ")", exception);
        }
        this.usesGLSL = bl3;
        this.sealed = false;
        this.bufferEnabled = false;
        this.enableBufferAlways = false;
        boolean bl4 = this.bufferWritten = 0 != n6;
        if (null == this.buffer && n5 > 0) {
            this.reserve(n5);
        }
    }

    protected void init_vbo(GL gL) {
        if (!this.isValidated) {
            this.isValidated = true;
            this.validate(gL.getGLProfile(), true);
        }
    }

    public GLArrayDataClient(GLArrayDataClient gLArrayDataClient) {
        super(gLArrayDataClient);
        this.initElemCount = gLArrayDataClient.initElemCount;
        if (null != gLArrayDataClient.glArrayHandler) {
            Class<?> clazz = gLArrayDataClient.glArrayHandler.getClass();
            try {
                Constructor<?> constructor = clazz.getConstructor(GLArrayDataEditable.class);
                this.glArrayHandler = (GLArrayHandler)constructor.newInstance(this);
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not ctor " + clazz.getName() + "(" + this.getClass().getName() + ")", exception);
            }
        } else {
            this.glArrayHandler = null;
        }
        this.usesGLSL = gLArrayDataClient.usesGLSL;
        this.growthFactor = gLArrayDataClient.growthFactor;
        this.isValidated = gLArrayDataClient.isValidated;
        this.bufferEnabled = gLArrayDataClient.bufferEnabled;
        this.bufferWritten = gLArrayDataClient.bufferWritten;
        this.enableBufferAlways = gLArrayDataClient.enableBufferAlways;
        this.shaderState = gLArrayDataClient.shaderState;
    }

    public float getGrowthFactor() {
        return this.growthFactor;
    }

    public void setGrowthFactor(float f) {
        this.growthFactor = Math.max(1.0f, f);
    }
}

