/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.egl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.ElementBuffer;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;

public class EGLClientPixmapHI {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] EGLClientPixmapHI_size = new int[]{16, 16, 16, 16, 16, 16, 16, 24, 24, 24};
    private static final int[] pData_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] iWidth_offset = new int[]{4, 4, 4, 4, 4, 4, 4, 8, 8, 8};
    private static final int[] iHeight_offset = new int[]{8, 8, 8, 8, 8, 8, 8, 12, 12, 12};
    private static final int[] iStride_offset = new int[]{12, 12, 12, 12, 12, 12, 12, 16, 16, 16};

    public static boolean usesNativeCode() {
        return false;
    }

    public static int size() {
        return EGLClientPixmapHI_size[mdIdx];
    }

    public static EGLClientPixmapHI create() {
        return EGLClientPixmapHI.create(Buffers.newDirectByteBuffer(EGLClientPixmapHI.size()));
    }

    public static EGLClientPixmapHI create(ByteBuffer byteBuffer) {
        return new EGLClientPixmapHI(byteBuffer);
    }

    public static EGLClientPixmapHI derefPointer(long l) {
        return EGLClientPixmapHI.create(ElementBuffer.derefPointer(EGLClientPixmapHI.size(), l, 1).getByteBuffer());
    }

    EGLClientPixmapHI(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[EGLClientPixmapHI.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public final ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public final long getDirectBufferAddress() {
        return this.accessor.getDirectBufferAddress();
    }

    public final long getPData() {
        return PointerBuffer.wrap(this.getBuffer(), pData_offset[mdIdx], 1).get(0);
    }

    public final int getIWidth() {
        return this.accessor.getIntAt(iWidth_offset[mdIdx]);
    }

    public final int getIHeight() {
        return this.accessor.getIntAt(iHeight_offset[mdIdx]);
    }

    public final int getIStride() {
        return this.accessor.getIntAt(iStride_offset[mdIdx]);
    }
}

