/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.util;

import com.jogamp.common.av.AudioFormat;
import com.jogamp.openal.AL;
import com.jogamp.openal.ALExt;

public class ALHelpers {
    public static final String AL_SOFT_buffer_samples = "AL_SOFT_buffer_samples";
    public static final String AL_SOFT_events = "AL_SOFT_events";
    public static final String AL_EXT_MCFORMATS = "AL_EXT_MCFORMATS";
    public static final String AL_EXT_FLOAT32 = "AL_EXT_FLOAT32";
    public static final String AL_EXT_DOUBLE = "AL_EXT_DOUBLE";
    public static final String ALC_EXT_thread_local_context = "ALC_EXT_thread_local_context";
    public static final String ALC_ENUMERATION_EXT = "ALC_ENUMERATION_EXT";
    public static final String ALC_ENUMERATE_ALL_EXT = "ALC_ENUMERATE_ALL_EXT";
    public static final String ALC_EXT_debug = "ALC_EXT_debug";
    public static final String AL_EXT_debug = "AL_EXT_debug";
    public static final String ALC_SOFT_system_events = "ALC_SOFT_system_events";

    public static AudioFormat getAudioFormat(int n, int n2, int n3, int n4, int n5) {
        if (0 == n || 0 == n2 || 0 == n3 || 0 == n4 || 0 == n5) {
            return null;
        }
        int n6 = ALHelpers.getALChannelLayoutChannelCount(n);
        if (0 == n6) {
            return null;
        }
        boolean bl = ALHelpers.isALSampleTypeSigned(n2);
        boolean bl2 = ALHelpers.isALSampleTypeFixed(n2);
        return new AudioFormat(n4, n5, n6, bl, bl2, false, true);
    }

    public static int getALFormat(AudioFormat audioFormat, AL aL, ALExt aLExt) {
        int n = ALHelpers.getDefaultALChannelLayout(audioFormat.channelCount);
        int n2 = ALHelpers.getALSampleType(audioFormat.sampleSize, audioFormat.signed, audioFormat.fixedP);
        if (0 != n && 0 != n2) {
            return ALHelpers.getALFormat(n, n2, aL, aLExt);
        }
        return 0;
    }

    public static int getALFormat(AudioFormat audioFormat, AL aL, ALExt aLExt, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n = ALHelpers.getDefaultALChannelLayout(audioFormat.channelCount);
        int n2 = ALHelpers.getALSampleType(audioFormat.sampleSize, audioFormat.signed, audioFormat.fixedP);
        int n3 = 0 != n && 0 != n2 ? ALHelpers.getALFormat(n, n2, aL, aLExt, bl, bl2, bl3, bl4) : 0;
        return n3;
    }

    public static final int getALFormat(int n, int n2, AL aL, ALExt aLExt) {
        boolean bl = aL.alIsExtensionPresent(AL_SOFT_buffer_samples);
        boolean bl2 = aL.alIsExtensionPresent(AL_EXT_MCFORMATS);
        boolean bl3 = aL.alIsExtensionPresent(AL_EXT_FLOAT32);
        boolean bl4 = aL.alIsExtensionPresent(AL_EXT_DOUBLE);
        return ALHelpers.getALFormat(n, n2, aL, aLExt, bl, bl2, bl3, bl4);
    }

    public static final int getALFormat(int n, int n2, AL aL, ALExt aLExt, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n3 = 0;
        if (bl) {
            if (n2 == 5121 || n2 == 5120) {
                if (n == 5376) {
                    n3 = 4352;
                } else if (n == 5377) {
                    n3 = 4354;
                } else if (n == 5379) {
                    n3 = 4612;
                } else if (n == 5380) {
                    n3 = 4618;
                } else if (n == 5381) {
                    n3 = 4621;
                } else if (n == 5382) {
                    n3 = 4624;
                }
            } else if (n2 == 5123 || n2 == 5122) {
                if (n == 5376) {
                    n3 = 4353;
                } else if (n == 5377) {
                    n3 = 4355;
                } else if (n == 5379) {
                    n3 = 4613;
                } else if (n == 5380) {
                    n3 = 4619;
                } else if (n == 5381) {
                    n3 = 4622;
                } else if (n == 5382) {
                    n3 = 4625;
                }
            } else if (n2 == 5129 || n2 == 5128 || n2 == 5125 || n2 == 5124 || n2 == 5126 || n2 == 5127) {
                if (n == 5376) {
                    n3 = 65552;
                } else if (n == 5377) {
                    n3 = 65553;
                } else if (n == 5379) {
                    n3 = 4614;
                } else if (n == 5380) {
                    n3 = 4620;
                } else if (n == 5381) {
                    n3 = 4623;
                } else if (n == 5382) {
                    n3 = 4626;
                }
            }
            if (n3 != 0 && !aLExt.alIsBufferFormatSupportedSOFT(n3)) {
                n3 = 0;
            }
            if (n3 == 0) {
                if (n == 5376) {
                    n3 = 65552;
                } else if (n == 5377) {
                    n3 = 65553;
                } else if (n == 5379) {
                    n3 = 4614;
                } else if (n == 5380) {
                    n3 = 4620;
                } else if (n == 5381) {
                    n3 = 4623;
                } else if (n == 5382) {
                    n3 = 4626;
                }
                if (n3 != 0 && !aLExt.alIsBufferFormatSupportedSOFT(n3)) {
                    n3 = 0;
                }
            }
            if (n3 == 0) {
                if (n == 5376) {
                    n3 = 4353;
                } else if (n == 5377) {
                    n3 = 4355;
                } else if (n == 5379) {
                    n3 = 4613;
                } else if (n == 5380) {
                    n3 = 4619;
                } else if (n == 5381) {
                    n3 = 4622;
                } else if (n == 5382) {
                    n3 = 4625;
                }
                if (n3 != 0 && !aLExt.alIsBufferFormatSupportedSOFT(n3)) {
                    n3 = 0;
                }
            }
            if (n3 == 0) {
                if (n == 5376) {
                    n3 = 4352;
                } else if (n == 5377) {
                    n3 = 4354;
                } else if (n == 5379) {
                    n3 = 4612;
                } else if (n == 5380) {
                    n3 = 4618;
                } else if (n == 5381) {
                    n3 = 4621;
                } else if (n == 5382) {
                    n3 = 4624;
                }
                if (n3 != 0 && !aLExt.alIsBufferFormatSupportedSOFT(n3)) {
                    n3 = 0;
                }
            }
            return n3;
        }
        if (n2 == 5121) {
            if (n == 5376) {
                n3 = 4352;
            } else if (n == 5377) {
                n3 = 4354;
            } else if (bl2) {
                if (n == 5379) {
                    n3 = 4612;
                } else if (n == 5380) {
                    n3 = 4618;
                } else if (n == 5381) {
                    n3 = 4621;
                } else if (n == 5382) {
                    n3 = 4624;
                }
            }
        } else if (n2 == 5122) {
            if (n == 5376) {
                n3 = 4353;
            } else if (n == 5377) {
                n3 = 4355;
            } else if (bl2) {
                if (n == 5379) {
                    n3 = 4613;
                } else if (n == 5380) {
                    n3 = 4619;
                } else if (n == 5381) {
                    n3 = 4622;
                } else if (n == 5382) {
                    n3 = 4625;
                }
            }
        } else if (n2 == 5126 && bl3) {
            if (n == 5376) {
                n3 = 65552;
            } else if (n == 5377) {
                n3 = 65553;
            } else if (bl2) {
                if (n == 5379) {
                    n3 = 4614;
                } else if (n == 5380) {
                    n3 = 4620;
                } else if (n == 5381) {
                    n3 = 4623;
                } else if (n == 5382) {
                    n3 = 4626;
                }
            }
        } else if (n2 == 5127 && bl4) {
            if (n == 5376) {
                n3 = 65554;
            } else if (n == 5377) {
                n3 = 65555;
            }
        }
        if (n3 == -1) {
            n3 = 0;
        }
        return n3;
    }

    public static final int getDefaultALChannelLayout(int n) {
        switch (n) {
            case 1: {
                return 5376;
            }
            case 2: {
                return 5377;
            }
            case 4: {
                return 5379;
            }
            case 6: {
                return 5380;
            }
            case 7: {
                return 5381;
            }
            case 8: {
                return 5382;
            }
        }
        return 0;
    }

    public static final String alChannelLayoutName(int n) {
        switch (n) {
            case 5376: {
                return "Mono";
            }
            case 5377: {
                return "Stereo";
            }
            case 5378: {
                return "Rear";
            }
            case 5379: {
                return "Quad";
            }
            case 5380: {
                return "5.1";
            }
            case 5381: {
                return "6.1";
            }
            case 5382: {
                return "7.1";
            }
        }
        return "Unknown AL-Channel-Layout 0x" + Integer.toHexString(n);
    }

    public static final int getALChannelLayoutChannelCount(int n) {
        switch (n) {
            case 5376: {
                return 1;
            }
            case 5377: {
                return 2;
            }
            case 5378: {
                return 2;
            }
            case 5379: {
                return 4;
            }
            case 5380: {
                return 6;
            }
            case 5381: {
                return 7;
            }
            case 5382: {
                return 8;
            }
        }
        return 0;
    }

    public static final int getALSampleType(int n, boolean bl, boolean bl2) {
        if (bl2) {
            if (bl) {
                switch (n) {
                    case 8: {
                        return 5120;
                    }
                    case 16: {
                        return 5122;
                    }
                    case 32: {
                        return 5124;
                    }
                }
            } else {
                switch (n) {
                    case 8: {
                        return 5121;
                    }
                    case 16: {
                        return 5123;
                    }
                    case 32: {
                        return 5125;
                    }
                }
            }
        } else if (bl) {
            switch (n) {
                case 32: {
                    return 5126;
                }
                case 64: {
                    return 5127;
                }
            }
        }
        return 0;
    }

    public static final String alSampleTypeName(int n) {
        switch (n) {
            case 5120: {
                return "s8";
            }
            case 5121: {
                return "u8";
            }
            case 5122: {
                return "s16";
            }
            case 5123: {
                return "u16";
            }
            case 5124: {
                return "s32";
            }
            case 5125: {
                return "u32";
            }
            case 5126: {
                return "f32";
            }
            case 5127: {
                return "f64";
            }
        }
        return "Unknown AL-Type 0x" + Integer.toHexString(n);
    }

    public static final boolean isALSampleTypeSigned(int n) {
        switch (n) {
            case 5120: 
            case 5122: 
            case 5124: 
            case 5126: 
            case 5127: {
                return true;
            }
        }
        return false;
    }

    public static final boolean isALSampleTypeFixed(int n) {
        switch (n) {
            case 5120: 
            case 5121: 
            case 5122: 
            case 5123: 
            case 5124: 
            case 5125: {
                return true;
            }
        }
        return false;
    }

    public static final int sizeOfALSampleType(int n) throws IllegalArgumentException {
        switch (n) {
            case 5120: 
            case 5121: {
                return 1;
            }
            case 5122: 
            case 5123: {
                return 2;
            }
            case 5124: 
            case 5125: 
            case 5126: {
                return 4;
            }
            case 5127: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Unknown al-type 0x" + Integer.toHexString(n));
    }

    public static final int samplesToByteCount(int n, int n2, int n3) throws IllegalArgumentException {
        switch (n2) {
            case 5376: {
                n *= 1;
                break;
            }
            case 5377: {
                n *= 2;
                break;
            }
            case 5378: {
                n *= 2;
                break;
            }
            case 5379: {
                n *= 4;
                break;
            }
            case 5380: {
                n *= 6;
                break;
            }
            case 5381: {
                n *= 7;
                break;
            }
            case 5382: {
                n *= 8;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown al-channel-layout 0x" + Integer.toHexString(n2));
            }
        }
        switch (n3) {
            case 5120: 
            case 5121: {
                break;
            }
            case 5122: 
            case 5123: {
                n *= 2;
                break;
            }
            case 5124: 
            case 5125: 
            case 5126: {
                n *= 4;
                break;
            }
            case 5127: {
                n *= 8;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown al-type 0x" + Integer.toHexString(n3));
            }
        }
        return n;
    }

    public static final int bytesToSampleCount(int n, int n2, int n3) {
        return n / ALHelpers.samplesToByteCount(1, n2, n3);
    }

    public static final String alSourceStateString(int n) {
        switch (n) {
            case 4113: {
                return "initial";
            }
            case 4114: {
                return "playing";
            }
            case 4115: {
                return "paused";
            }
            case 4116: {
                return "stopped";
            }
        }
        return "invalid";
    }
}

