/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.sound3d;

import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.sound3d.AudioSystem3D;

public final class Device {
    private String name;
    private ALCdevice alDev;

    public Device(String string) {
        this.name = string;
        this.alDev = null;
        this.open();
    }

    public String getName() {
        return this.name;
    }

    public ALCdevice getALDevice() {
        return this.alDev;
    }

    public int getALCError() {
        return AudioSystem3D.alc.alcGetError(this.alDev);
    }

    public boolean isValid() {
        return null != this.alDev;
    }

    public boolean isDebugAvail() {
        return AudioSystem3D.alc.alcIsExtensionPresent(this.alDev, "ALC_EXT_debug");
    }

    public boolean open() {
        if (null == this.alDev) {
            this.alDev = AudioSystem3D.alc.alcOpenDevice(this.name);
            if (null != this.alDev && null == this.name) {
                this.name = AudioSystem3D.alc.alcGetString(this.alDev, 4101);
            }
        }
        return this.isValid();
    }

    public void close() {
        if (null != this.alDev) {
            AudioSystem3D.alc.alcCloseDevice(this.alDev);
            this.alDev = null;
        }
    }

    public String toString() {
        String string = null != this.alDev ? "0x" + Integer.toHexString(this.alDev.hashCode()) : "null";
        return "ALDevice[this 0x" + Integer.toHexString(this.hashCode()) + ", name '" + this.name + "', alDev " + string + "]";
    }
}

