/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.sound3d;

import com.jogamp.common.util.locks.Lock;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALException;
import com.jogamp.openal.sound3d.AudioSystem3D;
import com.jogamp.openal.sound3d.Device;

public final class Context {
    private final RecursiveLock lock = LockFactory.createRecursiveLock();
    private final Device device;
    private volatile ALCcontext alCtx;
    private boolean threadContextLocked;
    public final boolean hasALC_thread_local_context;
    private static final ThreadLocal<Context> currentContext = new ThreadLocal();

    public Context(ALCcontext aLCcontext, Device device) {
        boolean bl;
        this.device = device;
        this.alCtx = aLCcontext;
        if (this.makeCurrent(false)) {
            bl = AudioSystem3D.alc.alcIsExtensionPresent(null, "ALC_EXT_thread_local_context") || AudioSystem3D.alc.alcIsExtensionPresent(device.getALDevice(), "ALC_EXT_thread_local_context");
            this.release(false);
        } else {
            bl = false;
        }
        this.hasALC_thread_local_context = bl;
    }

    public Context(Device device, int[] nArray) {
        this(Context.createImpl(device.getALDevice(), nArray), device);
    }

    private static ALCcontext createImpl(ALCdevice aLCdevice, int[] nArray) {
        if (null != nArray && nArray.length > 0) {
            return AudioSystem3D.alc.alcCreateContext(aLCdevice, nArray, 0);
        }
        return AudioSystem3D.alc.alcCreateContext(aLCdevice, null);
    }

    public boolean isDebugAvail() {
        return AudioSystem3D.al.alIsExtensionPresent("AL_EXT_debug");
    }

    public boolean create(int[] nArray) {
        this.lock.lock();
        try {
            if (null == this.alCtx) {
                this.alCtx = Context.createImpl(this.device.getALDevice(), nArray);
                boolean bl = null != this.alCtx;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recreate(int[] nArray) {
        this.lock.lock();
        try {
            boolean bl = this == Context.getCurrentContext();
            this.destroyImpl();
            this.alCtx = Context.createImpl(this.device.getALDevice(), nArray);
            if (null != this.alCtx) {
                if (bl) {
                    boolean bl2 = this.makeCurrentImpl();
                    return bl2;
                }
                boolean bl3 = false;
                return bl3;
            }
            boolean bl4 = false;
            return bl4;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ALCcontext getALContext() {
        return this.alCtx;
    }

    public boolean isValid() {
        return null != this.alCtx;
    }

    public int getALCError() {
        return this.device.getALCError();
    }

    public void destroy() {
        this.lock.lock();
        try {
            this.destroyImpl();
            if (currentContext.get() == this) {
                currentContext.set(null);
            }
            while (this.lock.getHoldCount() > 1) {
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void destroyImpl() {
        if (null != this.alCtx) {
            if (this.threadContextLocked) {
                AudioSystem3D.alExt.alcSetThreadContext(null);
            } else {
                AudioSystem3D.alc.alcMakeContextCurrent(null);
            }
            AudioSystem3D.alc.alcDestroyContext(this.alCtx);
            this.alCtx = null;
        }
    }

    public static Context getCurrentContext() {
        return currentContext.get();
    }

    public int getLockCount() {
        return this.lock.getHoldCount();
    }

    public boolean tryMakeCurrent(boolean bl, long l) throws RuntimeException {
        return this.makeCurrentImpl(false, bl, l);
    }

    public boolean makeCurrent(boolean bl) throws ALException {
        return this.makeCurrentImpl(true, bl, Lock.TIMEOUT);
    }

    private boolean makeCurrentImpl(boolean bl, boolean bl2, long l) throws RuntimeException {
        try {
            if (this.lock.tryLock(l)) {
                if (null == this.alCtx) {
                    this.lock.unlock();
                    if (bl2) {
                        throw new ALException("Invalid " + this);
                    }
                    return false;
                }
                Context context = Context.getCurrentContext();
                if (context != null) {
                    if (context == this) {
                        return true;
                    }
                    this.lock.unlock();
                    if (bl2) {
                        throw new ALException("Current thread " + Thread.currentThread() + " holds another " + context + " while claiming this " + this);
                    }
                    return false;
                }
                boolean bl3 = this.makeCurrentImpl();
                if (bl3) {
                    currentContext.set(this);
                } else {
                    this.lock.unlock();
                    if (bl2) {
                        throw new ALException("Context make current failed " + this);
                    }
                }
                return bl3;
            }
            if (bl) {
                throw new RuntimeException("Waited " + l + "ms for: " + this.lock.toString() + " - " + Thread.currentThread().getName());
            }
            return false;
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    private boolean makeCurrentImpl() {
        if (this.hasALC_thread_local_context) {
            this.threadContextLocked = true;
            return AudioSystem3D.alExt.alcSetThreadContext(this.alCtx);
        }
        this.threadContextLocked = false;
        return AudioSystem3D.alc.alcMakeContextCurrent(this.alCtx);
    }

    public boolean release(boolean bl) throws ALException {
        if (!this.lock.isOwner(Thread.currentThread())) {
            if (bl) {
                throw new ALException("Context not held on current thread " + Thread.currentThread() + ", " + this);
            }
            return false;
        }
        if (this.lock.getHoldCount() == 1) {
            boolean bl2 = this.threadContextLocked ? AudioSystem3D.alExt.alcSetThreadContext(null) : AudioSystem3D.alc.alcMakeContextCurrent(null);
            if (bl2) {
                currentContext.set(null);
            } else {
                if (bl) {
                    throw new ALException("Context release failed " + this);
                }
                return false;
            }
        }
        this.lock.unlock();
        return true;
    }

    public void suspend() {
        AudioSystem3D.alc.alcSuspendContext(this.alCtx);
    }

    public Device getDevice() {
        return this.device;
    }

    public String toString() {
        String string = null != this.alCtx ? "0x" + Integer.toHexString(this.alCtx.hashCode()) : "null";
        return "ALContext[this 0x" + Integer.toHexString(this.hashCode()) + ", alCtx " + string + " lockCount " + this.lock.getHoldCount() + ", on " + this.device + "]";
    }
}

