/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.javafx;

import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.Capabilities;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.NativeWindowHolder;
import com.jogamp.nativewindow.SurfaceUpdatedListener;
import com.jogamp.nativewindow.WindowClosingProtocol;
import com.jogamp.nativewindow.javafx.JFXAccessor;
import com.jogamp.nativewindow.util.Insets;
import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.newt.Display;
import com.jogamp.newt.Window;
import com.jogamp.newt.util.EDTUtil;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.stage.WindowEvent;
import jogamp.newt.Debug;
import jogamp.newt.javafx.JFXEDTUtil;

public class NewtCanvasJFX
extends Canvas
implements NativeWindowHolder,
WindowClosingProtocol {
    private static final boolean DEBUG = Debug.debug("Window");
    private static final boolean USE_JFX_EDT = PropertyAccess.getBooleanProperty("jogamp.newt.javafx.UseJFXEDT", true, true);
    private volatile javafx.stage.Window parentWindow = null;
    private volatile AbstractGraphicsScreen screen = null;
    private WindowClosingProtocol.WindowClosingMode newtChildClosingMode = WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE;
    private WindowClosingProtocol.WindowClosingMode closingMode = WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE;
    private final Rectangle clientArea = new Rectangle();
    private volatile JFXNativeWindow nativeWindow = null;
    private volatile Window newtChild = null;
    private volatile boolean newtChildReady = false;
    private volatile boolean postSetSize = false;
    private volatile boolean postSetPos = false;
    private final EventHandler<WindowEvent> windowClosingListener = new EventHandler<WindowEvent>(){

        public final void handle(WindowEvent windowEvent) {
            if (DEBUG) {
                System.err.println("NewtCanvasJFX.Event.DISPOSE, " + windowEvent + ", closeOp " + (Object)((Object)NewtCanvasJFX.this.closingMode));
            }
            if (WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE == NewtCanvasJFX.this.closingMode) {
                NewtCanvasJFX.this.destroy();
            } else {
                windowEvent.consume();
            }
        }
    };
    private final EventHandler<WindowEvent> windowShownListener = new EventHandler<WindowEvent>(){

        public final void handle(WindowEvent windowEvent) {
            if (DEBUG) {
                System.err.println("NewtCanvasJFX.Event.SHOWN, " + windowEvent);
            }
            NewtCanvasJFX.this.repaintAction(true);
        }
    };
    private final ChangeListener<javafx.stage.Window> sceneWindowChangeListener = new ChangeListener<javafx.stage.Window>(){

        public void changed(ObservableValue<? extends javafx.stage.Window> observableValue, javafx.stage.Window window, javafx.stage.Window window2) {
            if (DEBUG) {
                System.err.println("NewtCanvasJFX.Event.Window, " + window + " -> " + window2);
            }
            if (NewtCanvasJFX.this.updateParentWindowAndScreen()) {
                NewtCanvasJFX.this.repaintAction(NewtCanvasJFX.this.isVisible());
            }
        }
    };

    public NewtCanvasJFX(Window window) {
        this.updateParentWindowAndScreen();
        ChangeListener<Number> changeListener = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                if (DEBUG) {
                    System.err.println("NewtCanvasJFX.Event.Size, " + number.doubleValue() + " -> " + number2.doubleValue() + ", has " + NewtCanvasJFX.this.getWidth() + "x" + NewtCanvasJFX.this.getHeight());
                }
                NewtCanvasJFX.this.updateSizeCheck((int)NewtCanvasJFX.this.getWidth(), (int)NewtCanvasJFX.this.getHeight());
                NewtCanvasJFX.this.repaintAction(NewtCanvasJFX.this.isVisible());
            }
        };
        this.widthProperty().addListener((ChangeListener)changeListener);
        this.heightProperty().addListener((ChangeListener)changeListener);
        this.visibleProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (DEBUG) {
                    System.err.println("NewtCanvasJFX.Event.Visible, " + bl + " -> " + bl2 + ", has " + NewtCanvasJFX.this.isVisible());
                }
                NewtCanvasJFX.this.repaintAction(bl2);
            }
        });
        this.sceneProperty().addListener((ChangeListener)new ChangeListener<Scene>(){

            public void changed(ObservableValue<? extends Scene> observableValue, Scene scene, Scene scene2) {
                if (DEBUG) {
                    System.err.println("NewtCanvasJFX.Event.Scene, " + scene + " -> " + scene2 + ", has " + NewtCanvasJFX.this.getScene());
                    if (null != scene2) {
                        javafx.stage.Window window = scene2.getWindow();
                        System.err.println("NewtCanvasJFX.Event.Scene window " + window + " (showing " + (null != window ? (Comparable<Boolean>)Boolean.valueOf(window.isShowing()) : (Comparable<Boolean>)Integer.valueOf(0)) + ")");
                    }
                }
                if (NewtCanvasJFX.this.updateParentWindowAndScreen()) {
                    NewtCanvasJFX.this.repaintAction(NewtCanvasJFX.this.isVisible());
                }
            }
        });
        if (null != window) {
            this.setNEWTChild(window);
        }
    }

    private final void repaintAction(boolean bl) {
        if (bl && this.validateNative(true) && this.newtChildReady) {
            if (this.postSetSize) {
                this.newtChild.setSize(this.clientArea.getWidth(), this.clientArea.getHeight());
                this.postSetSize = false;
            }
            if (this.postSetPos) {
                this.newtChild.setPosition(this.clientArea.getX(), this.clientArea.getY());
                this.postSetPos = false;
            }
            this.newtChild.windowRepaint(0, 0, this.clientArea.getWidth(), this.clientArea.getHeight());
        }
    }

    private final void updatePosSizeCheck() {
        Bounds bounds = this.localToScene(this.getBoundsInLocal());
        this.updatePosCheck((int)bounds.getMinX(), (int)bounds.getMinY());
        this.updateSizeCheck((int)this.getWidth(), (int)this.getHeight());
    }

    private final void updatePosCheck(int n, int n2) {
        boolean bl;
        Rectangle rectangle = this.clientArea;
        boolean bl2 = bl = n != rectangle.getX() || n2 != rectangle.getY();
        if (bl) {
            this.clientArea.setX(n);
            this.clientArea.setY(n2);
        }
        if (DEBUG) {
            long l = this.newtChildReady ? this.newtChild.getSurfaceHandle() : 0L;
            System.err.println("NewtCanvasJFX.updatePosCheck: posChanged " + bl + ", (" + Thread.currentThread().getName() + "): newtChildReady " + this.newtChildReady + ", " + this.clientArea.getX() + "/" + this.clientArea.getY() + " " + this.clientArea.getWidth() + "x" + this.clientArea.getHeight() + " - surfaceHandle 0x" + Long.toHexString(l));
        }
        if (bl) {
            if (this.newtChildReady) {
                this.newtChild.setPosition(this.clientArea.getX(), this.clientArea.getY());
            } else {
                this.postSetPos = true;
            }
        }
    }

    private final void updateSizeCheck(int n, int n2) {
        boolean bl;
        Rectangle rectangle = this.clientArea;
        boolean bl2 = bl = n != rectangle.getWidth() || n2 != rectangle.getHeight();
        if (bl) {
            this.clientArea.setWidth(n);
            this.clientArea.setHeight(n2);
        }
        if (DEBUG) {
            long l = this.newtChildReady ? this.newtChild.getSurfaceHandle() : 0L;
            System.err.println("NewtCanvasJFX.updateSizeCheck: sizeChanged " + bl + ", (" + Thread.currentThread().getName() + "): newtChildReady " + this.newtChildReady + ", " + this.clientArea.getX() + "/" + this.clientArea.getY() + " " + this.clientArea.getWidth() + "x" + this.clientArea.getHeight() + " - surfaceHandle 0x" + Long.toHexString(l));
        }
        if (bl) {
            if (this.newtChildReady) {
                this.newtChild.setSize(this.clientArea.getWidth(), this.clientArea.getHeight());
            } else {
                this.postSetSize = true;
            }
        }
    }

    private boolean updateParentWindowAndScreen() {
        Scene scene = this.getScene();
        if (null != scene) {
            javafx.stage.Window window = scene.getWindow();
            if (DEBUG) {
                System.err.println("NewtCanvasJFX.updateParentWindowAndScreen: Scene " + scene + ", Window " + window + " (showing " + (null != window ? (Comparable<Boolean>)Boolean.valueOf(window.isShowing()) : (Comparable<Boolean>)Integer.valueOf(0)) + ")");
            }
            if (window != this.parentWindow) {
                this.destroyImpl(false);
            }
            this.parentWindow = window;
            if (null != window) {
                this.screen = JFXAccessor.getScreen(JFXAccessor.getDevice(this.parentWindow), -1);
                this.parentWindow.addEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, this.windowClosingListener);
                this.parentWindow.addEventHandler(WindowEvent.WINDOW_SHOWN, this.windowShownListener);
                return true;
            }
            scene.windowProperty().addListener(this.sceneWindowChangeListener);
        } else {
            if (DEBUG) {
                System.err.println("NewtCanvasJFX.updateParentWindowAndScreen: Null Scene");
            }
            if (null != this.parentWindow) {
                this.destroyImpl(false);
            }
        }
        return false;
    }

    public void destroy() {
        this.destroyImpl(true);
    }

    private void destroyImpl(boolean bl) {
        if (DEBUG) {
            System.err.println("NewtCanvasJFX.dispose: (has parent " + (null != this.parentWindow) + ", hasNative " + (null != this.nativeWindow) + ",\n\t" + this.newtChild);
        }
        if (null != this.newtChild) {
            if (DEBUG) {
                System.err.println("NewtCanvasJFX.dispose.1: EDTUtil cur " + this.newtChild.getScreen().getDisplay().getEDTUtil());
            }
            if (null != this.nativeWindow) {
                this.configureNewtChild(false);
                this.newtChild.setVisible(false);
                this.newtChild.reparentWindow(null, -1, -1, 0);
            }
            if (bl) {
                this.newtChild.destroy();
                this.newtChild = null;
            }
        }
        if (null != this.parentWindow) {
            this.parentWindow.getScene().windowProperty().removeListener(this.sceneWindowChangeListener);
            this.parentWindow.removeEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, this.windowClosingListener);
            this.parentWindow.removeEventHandler(WindowEvent.WINDOW_SHOWN, this.windowShownListener);
            this.parentWindow = null;
        }
        if (null != this.screen) {
            this.screen.getDevice().close();
            this.screen = null;
        }
        this.nativeWindow = null;
    }

    private final boolean validateNative(boolean bl) {
        if (null != this.nativeWindow) {
            return true;
        }
        if (null == this.parentWindow) {
            return false;
        }
        this.updatePosSizeCheck();
        if (0 >= this.clientArea.getWidth() || 0 >= this.clientArea.getHeight()) {
            return false;
        }
        long l = JFXAccessor.getWindowHandle(this.parentWindow);
        if (0L == l) {
            return false;
        }
        this.screen.getDevice().open();
        int n = JFXAccessor.getNativeVisualID(this.screen.getDevice(), l);
        boolean bl2 = NativeWindowFactory.isNativeVisualIDValidForProcessing(n);
        if (DEBUG) {
            System.err.println("NewtCanvasJFX.validateNative() windowHandle 0x" + Long.toHexString(l) + ", visualID 0x" + Integer.toHexString(n) + ", valid " + bl2);
        }
        if (bl2) {
            Capabilities capabilities = new Capabilities();
            GraphicsConfigurationFactory graphicsConfigurationFactory = GraphicsConfigurationFactory.getFactory(this.screen.getDevice(), capabilities);
            AbstractGraphicsConfiguration abstractGraphicsConfiguration = graphicsConfigurationFactory.chooseGraphicsConfiguration(capabilities, capabilities, null, this.screen, n);
            if (DEBUG) {
                System.err.println("NewtCanvasJFX.validateNative() factory: " + graphicsConfigurationFactory + ", windowHandle 0x" + Long.toHexString(l) + ", visualID 0x" + Integer.toHexString(n) + ", chosen config: " + abstractGraphicsConfiguration);
            }
            if (null == abstractGraphicsConfiguration) {
                throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
            }
            this.nativeWindow = new JFXNativeWindow(abstractGraphicsConfiguration, l);
            if (bl) {
                this.reparentWindow(true);
            }
        }
        return null != this.nativeWindow;
    }

    public Window setNEWTChild(Window window) {
        Window window2 = this.newtChild;
        if (DEBUG) {
            System.err.println("NewtCanvasJFX.setNEWTChild.0: win " + NewtCanvasJFX.newtWinHandleToHexString(window2) + " -> " + NewtCanvasJFX.newtWinHandleToHexString(window));
        }
        if (null != this.newtChild) {
            this.reparentWindow(false);
            this.newtChild = null;
        }
        this.newtChild = window;
        if (null != this.newtChild && this.validateNative(false)) {
            this.reparentWindow(true);
        }
        return window2;
    }

    private void reparentWindow(boolean bl) {
        if (null == this.newtChild) {
            return;
        }
        if (DEBUG) {
            System.err.println("NewtCanvasJFX.reparentWindow.0: add=" + bl + ", win " + NewtCanvasJFX.newtWinHandleToHexString(this.newtChild) + ", EDTUtil: cur " + this.newtChild.getScreen().getDisplay().getEDTUtil());
        }
        this.newtChild.setFocusAction(null);
        if (bl) {
            Display display;
            EDTUtil eDTUtil;
            assert (null != this.nativeWindow && null != this.parentWindow);
            this.updatePosSizeCheck();
            int n = this.clientArea.getX();
            int n2 = this.clientArea.getY();
            int n3 = this.clientArea.getWidth();
            int n4 = this.clientArea.getHeight();
            if (USE_JFX_EDT && !((eDTUtil = (display = this.newtChild.getScreen().getDisplay()).getEDTUtil()) instanceof JFXEDTUtil)) {
                JFXEDTUtil jFXEDTUtil = new JFXEDTUtil(display);
                if (DEBUG) {
                    System.err.println("NewtCanvasJFX.reparentWindow.1: replacing EDTUtil " + eDTUtil + " -> " + jFXEDTUtil);
                }
                jFXEDTUtil.start();
                display.setEDTUtil(jFXEDTUtil);
            }
            this.newtChild.setSize(n3, n4);
            this.newtChild.reparentWindow(this.nativeWindow, n, n2, 2);
            this.newtChild.setPosition(n, n2);
            this.newtChild.setVisible(true);
            this.configureNewtChild(true);
            this.newtChild.sendWindowEvent(100);
        } else {
            this.configureNewtChild(false);
            this.newtChild.setVisible(false);
            this.newtChild.reparentWindow(null, -1, -1, 0);
        }
        if (DEBUG) {
            System.err.println("NewtCanvasJFX.reparentWindow.X: add=" + bl + ", win " + NewtCanvasJFX.newtWinHandleToHexString(this.newtChild) + ", EDTUtil: cur " + this.newtChild.getScreen().getDisplay().getEDTUtil());
        }
    }

    private void configureNewtChild(boolean bl) {
        this.newtChildReady = bl;
        if (null != this.newtChild) {
            this.newtChild.setKeyboardFocusHandler(null);
            if (bl) {
                this.newtChildClosingMode = this.newtChild.setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode.DO_NOTHING_ON_CLOSE);
            } else {
                this.newtChild.setFocusAction(null);
                this.newtChild.setDefaultCloseOperation(this.newtChildClosingMode);
            }
        }
    }

    public Window getNEWTChild() {
        return this.newtChild;
    }

    @Override
    public NativeWindow getNativeWindow() {
        return this.nativeWindow;
    }

    @Override
    public NativeSurface getNativeSurface() {
        return this.nativeWindow;
    }

    @Override
    public WindowClosingProtocol.WindowClosingMode getDefaultCloseOperation() {
        return this.closingMode;
    }

    @Override
    public WindowClosingProtocol.WindowClosingMode setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode windowClosingMode) {
        WindowClosingProtocol.WindowClosingMode windowClosingMode2 = this.closingMode;
        this.closingMode = windowClosingMode;
        return windowClosingMode2;
    }

    boolean isParent() {
        return null != this.newtChild;
    }

    boolean isFullscreen() {
        return null != this.newtChild && this.newtChild.isFullscreen();
    }

    private final void requestFocusNEWTChild() {
        if (this.newtChildReady) {
            this.newtChild.setFocusAction(null);
            this.newtChild.requestFocus();
        }
    }

    public void requestFocus() {
        NewtCanvasJFX.super.requestFocus();
        this.requestFocusNEWTChild();
    }

    static String newtWinHandleToHexString(Window window) {
        return null != window ? NewtCanvasJFX.toHexString(window.getWindowHandle()) : "nil";
    }

    static String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    private class JFXNativeWindow
    implements NativeWindow {
        private final AbstractGraphicsConfiguration config;
        private final long nativeWindowHandle;
        private final InsetsImmutable insets;

        public JFXNativeWindow(AbstractGraphicsConfiguration abstractGraphicsConfiguration, long l) {
            this.config = abstractGraphicsConfiguration;
            this.nativeWindowHandle = l;
            this.insets = new Insets(0, 0, 0, 0);
        }

        @Override
        public RecursiveLock getLock() {
            return null;
        }

        @Override
        public int lockSurface() throws NativeWindowException, RuntimeException {
            return 3;
        }

        @Override
        public void unlockSurface() {
        }

        @Override
        public boolean isSurfaceLockedByOtherThread() {
            return false;
        }

        @Override
        public Thread getSurfaceLockOwner() {
            return null;
        }

        @Override
        public boolean surfaceSwap() {
            return false;
        }

        @Override
        public void addSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        }

        @Override
        public void addSurfaceUpdatedListener(int n, SurfaceUpdatedListener surfaceUpdatedListener) throws IndexOutOfBoundsException {
        }

        @Override
        public void removeSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        }

        @Override
        public long getSurfaceHandle() {
            return 0L;
        }

        @Override
        public int getX() {
            return NewtCanvasJFX.this.clientArea.getX();
        }

        @Override
        public int getY() {
            return NewtCanvasJFX.this.clientArea.getY();
        }

        @Override
        public int getWidth() {
            return this.getSurfaceWidth();
        }

        @Override
        public int getHeight() {
            return this.getSurfaceHeight();
        }

        @Override
        public final Rectangle getBounds() {
            return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }

        @Override
        public final Rectangle getSurfaceBounds() {
            return new Rectangle(this.getX(), this.getY(), this.getSurfaceWidth(), this.getSurfaceHeight());
        }

        @Override
        public final int[] convertToWindowUnits(int[] nArray) {
            return nArray;
        }

        @Override
        public final int[] convertToPixelUnits(int[] nArray) {
            return nArray;
        }

        @Override
        public int getSurfaceWidth() {
            return NewtCanvasJFX.this.clientArea.getWidth();
        }

        @Override
        public int getSurfaceHeight() {
            return NewtCanvasJFX.this.clientArea.getHeight();
        }

        @Override
        public final NativeSurface getNativeSurface() {
            return this;
        }

        @Override
        public AbstractGraphicsConfiguration getGraphicsConfiguration() {
            return this.config;
        }

        @Override
        public long getDisplayHandle() {
            return this.config.getScreen().getDevice().getHandle();
        }

        @Override
        public int getScreenIndex() {
            return this.config.getScreen().getIndex();
        }

        @Override
        public void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
        }

        @Override
        public void destroy() {
        }

        @Override
        public NativeWindow getParent() {
            return null;
        }

        @Override
        public long getWindowHandle() {
            return this.nativeWindowHandle;
        }

        @Override
        public InsetsImmutable getInsets() {
            return this.insets;
        }

        @Override
        public Point getLocationOnScreen(Point point) {
            Point point2 = NativeWindowFactory.getLocationOnScreen(this);
            if (null != point) {
                return point.translate(point2);
            }
            return point2;
        }

        @Override
        public boolean hasFocus() {
            return NewtCanvasJFX.this.isFocused();
        }
    }
}

