/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.awt;

import com.jogamp.common.nio.Buffers;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Hashtable;

public final class DirectDataBufferInt
extends DataBuffer {
    private final ByteBuffer dataBytes;
    private final IntBuffer dataInts;
    private final ByteBuffer[] bankdataBytes;
    private final IntBuffer[] bankdataInts;

    public static BufferedImageInt createBufferedImage(int n, int n2, int n3, Point point, Hashtable<?, ?> hashtable) {
        int[] nArray;
        boolean bl;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        switch (n3) {
            case 2: {
                n8 = 32;
                n7 = 0xFF0000;
                n6 = 65280;
                n5 = 255;
                n4 = -16777216;
                bl = false;
                break;
            }
            case 3: {
                n8 = 32;
                n7 = 0xFF0000;
                n6 = 65280;
                n5 = 255;
                n4 = -16777216;
                bl = true;
                break;
            }
            case 1: {
                n8 = 24;
                n7 = 0xFF0000;
                n6 = 65280;
                n5 = 255;
                n4 = 0;
                bl = false;
                break;
            }
            case 4: {
                n8 = 24;
                n7 = 255;
                n6 = 65280;
                n5 = 0xFF0000;
                n4 = 0;
                bl = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported imageType, must be [INT_ARGB, INT_ARGB_PRE, INT_RGB, INT_BGR], has " + n3);
            }
        }
        DirectColorModel directColorModel = new DirectColorModel(colorSpace, n8, n7, n6, n5, n4, bl, 3);
        if (0 != n4) {
            nArray = new int[4];
            nArray[3] = n4;
        } else {
            nArray = new int[]{n7, n6, n5};
        }
        DirectDataBufferInt directDataBufferInt = new DirectDataBufferInt(n * n2);
        if (null == point) {
            point = new Point(0, 0);
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(directDataBufferInt.getDataType(), n, n2, n, nArray);
        DirectWritableRaster directWritableRaster = new DirectWritableRaster((SampleModel)singlePixelPackedSampleModel, directDataBufferInt, point);
        return new BufferedImageInt(n3, directColorModel, directDataBufferInt, directWritableRaster, hashtable);
    }

    public DirectDataBufferInt(int n) {
        super(3, n);
        this.dataBytes = Buffers.newDirectByteBuffer(n * 4);
        this.dataInts = this.dataBytes.asIntBuffer();
        this.bankdataBytes = new ByteBuffer[1];
        this.bankdataInts = new IntBuffer[1];
        this.bankdataBytes[0] = this.dataBytes;
        this.bankdataInts[0] = this.dataInts;
    }

    public DirectDataBufferInt(int n, int n2) {
        super(3, n, n2);
        this.bankdataBytes = new ByteBuffer[n2];
        this.bankdataInts = new IntBuffer[n2];
        for (int i = 0; i < n2; ++i) {
            this.bankdataBytes[i] = Buffers.newDirectByteBuffer(n * 4);
            this.bankdataInts[i] = this.bankdataBytes[i].asIntBuffer();
        }
        this.dataBytes = this.bankdataBytes[0];
        this.dataInts = this.bankdataInts[0];
    }

    public DirectDataBufferInt(ByteBuffer byteBuffer, int n) {
        super(3, n);
        this.dataBytes = Buffers.nativeOrder(byteBuffer);
        this.dataInts = this.dataBytes.asIntBuffer();
        this.bankdataBytes = new ByteBuffer[1];
        this.bankdataInts = new IntBuffer[1];
        this.bankdataBytes[0] = this.dataBytes;
        this.bankdataInts[0] = this.dataInts;
    }

    public IntBuffer getData() {
        return this.dataInts;
    }

    public ByteBuffer getDataBytes() {
        return this.dataBytes;
    }

    public IntBuffer getData(int n) {
        return this.bankdataInts[n];
    }

    public ByteBuffer getDataBytes(int n) {
        return this.bankdataBytes[n];
    }

    @Override
    public int getElem(int n) {
        return this.dataInts.get(n + this.offset);
    }

    @Override
    public int getElem(int n, int n2) {
        return this.bankdataInts[n].get(n2 + this.offsets[n]);
    }

    @Override
    public void setElem(int n, int n2) {
        this.dataInts.put(n + this.offset, n2);
    }

    @Override
    public void setElem(int n, int n2, int n3) {
        this.bankdataInts[n].put(n2 + this.offsets[n], n3);
    }

    public static class DirectWritableRaster
    extends WritableRaster {
        protected DirectWritableRaster(SampleModel sampleModel, DirectDataBufferInt directDataBufferInt, Point point) {
            super(sampleModel, directDataBufferInt, point);
        }
    }

    public static class BufferedImageInt
    extends BufferedImage {
        final int customImageType;
        final DirectDataBufferInt dataBuffer;

        public BufferedImageInt(int n, ColorModel colorModel, DirectDataBufferInt directDataBufferInt, WritableRaster writableRaster, Hashtable<?, ?> hashtable) {
            super(colorModel, writableRaster, false, hashtable);
            this.customImageType = n;
            this.dataBuffer = directDataBufferInt;
        }

        public int getCustomType() {
            return this.customImageType;
        }

        public DirectDataBufferInt getDataBuffer() {
            return this.dataBuffer;
        }

        @Override
        public String toString() {
            return "BufferedImageInt@" + Integer.toHexString(this.hashCode()) + ": custom/internal type = " + this.customImageType + "/" + this.getType() + " " + this.getColorModel() + " " + this.getRaster();
        }
    }
}

