/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.math.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.math.Matrix4f;
import com.jogamp.math.Quaternion;
import com.jogamp.math.Ray;
import com.jogamp.math.Recti;
import com.jogamp.math.Vec3f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.Frustum;
import com.jogamp.math.util.SyncAction;
import com.jogamp.math.util.SyncBuffer;
import com.jogamp.math.util.SyncMatrices4f;
import com.jogamp.math.util.SyncMatrix4f;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class PMVMatrix4f {
    public static final int MODIFIED_PROJECTION = 1;
    public static final int MODIFIED_MODELVIEW = 2;
    public static final int MODIFIED_TEXTURE = 4;
    public static final int MODIFIED_ALL = 7;
    public static final int INVERSE_MODELVIEW = 2;
    public static final int INVERSE_TRANSPOSED_MODELVIEW = 4;
    public static final int FRUSTUM = 8;
    public static final int PREMUL_PMV = 16;
    public static final int PREMUL_PMVI = 32;
    public static final int MANUAL_BITS = 56;
    protected final Matrix4f matP;
    protected final Matrix4f matMv;
    protected final Matrix4f matTex;
    private final Matrix4f matMvi;
    private final Matrix4f matMvit;
    private static final int mP_offset = 0;
    private static final int mMv_offset = 16;
    private final int mMvi_offset;
    private final int mMvit_offset;
    private final int mTex_offset;
    private final float[] matrixStore;
    private final SyncMatrix4f syncP;
    private final SyncMatrix4f syncMv;
    private final SyncMatrix4f syncT;
    private final SyncMatrix4f syncMvi;
    private final SyncMatrix4f syncMvit;
    private final SyncMatrices4f syncP_Mv;
    private final SyncMatrices4f syncP_Mv_Mvi;
    private final SyncMatrices4f syncP_Mv_Mvi_Mvit;
    protected final Matrix4f mat4Tmp1;
    private Matrix4f mat4Tmp2;
    private int modifiedBits = 7;
    private int dirtyBits = 0;
    private final int requestBits;
    private Matrix4f matPMv;
    private Matrix4f matPMvi;
    private boolean matPMviOK;
    private Frustum frustum;

    public PMVMatrix4f() {
        this(0);
    }

    public PMVMatrix4f(int n) {
        FloatBuffer floatBuffer;
        FloatBuffer floatBuffer2;
        int n2 = 0;
        if (0 != (n & 6)) {
            n2 |= 2;
        }
        if (0 != (n & 4)) {
            n2 |= 4;
        }
        this.requestBits = n2;
        n2 = 3;
        this.matP = new Matrix4f();
        this.matMv = new Matrix4f();
        this.matTex = new Matrix4f();
        if (0 != (this.requestBits & 2)) {
            this.matMvi = new Matrix4f();
            this.mMvi_offset = 32;
            ++n2;
        } else {
            this.matMvi = null;
            this.mMvi_offset = -1;
        }
        if (0 != (this.requestBits & 4)) {
            this.matMvit = new Matrix4f();
            this.mMvit_offset = 48;
            ++n2;
        } else {
            this.matMvit = null;
            this.mMvit_offset = -1;
        }
        this.mTex_offset = (n2 - 1) * 16;
        this.matrixStore = new float[n2 * 16];
        FloatBuffer floatBuffer3 = Buffers.slice2Float(this.matrixStore, 0, 16);
        this.syncP = new SyncBuffer0(this.matP, floatBuffer3);
        FloatBuffer floatBuffer4 = Buffers.slice2Float(this.matrixStore, 16, 16);
        this.syncMv = new SyncBuffer1(this.matMv, floatBuffer4, 16);
        FloatBuffer floatBuffer5 = Buffers.slice2Float(this.matrixStore, 0, 32);
        this.syncP_Mv = new SyncBufferN(new Matrix4f[]{this.matP, this.matMv}, floatBuffer5, 0);
        FloatBuffer floatBuffer6 = Buffers.slice2Float(this.matrixStore, this.mTex_offset, 16);
        this.syncT = new SyncBuffer1(this.matTex, floatBuffer6, this.mTex_offset);
        if (null != this.matMvi) {
            floatBuffer2 = Buffers.slice2Float(this.matrixStore, this.mMvi_offset, 16);
            floatBuffer = Buffers.slice2Float(this.matrixStore, 0, 48);
            this.syncMvi = new SyncBuffer1U(this.matMvi, floatBuffer2, this.mMvi_offset);
            this.syncP_Mv_Mvi = new SyncBufferNU(new Matrix4f[]{this.matP, this.matMv, this.matMvi}, floatBuffer, 0);
        } else {
            this.syncMvi = null;
            this.syncP_Mv_Mvi = null;
        }
        if (null != this.matMvit) {
            floatBuffer2 = Buffers.slice2Float(this.matrixStore, this.mMvit_offset, 16);
            floatBuffer = Buffers.slice2Float(this.matrixStore, 0, 64);
            this.syncMvit = new SyncBuffer1U(this.matMvit, floatBuffer2, this.mMvit_offset);
            this.syncP_Mv_Mvi_Mvit = new SyncBufferNU(new Matrix4f[]{this.matP, this.matMv, this.matMvi, this.matMvit}, floatBuffer, 0);
        } else {
            this.syncMvit = null;
            this.syncP_Mv_Mvi_Mvit = null;
        }
        this.mat4Tmp1 = new Matrix4f();
        this.mat4Tmp2 = null;
        this.matPMv = null;
        this.matPMvi = null;
        this.matPMviOK = false;
        this.frustum = null;
        this.reset();
    }

    public void reset() {
        this.matP.loadIdentity();
        this.matMv.loadIdentity();
        this.matTex.loadIdentity();
        this.modifiedBits = 7;
        this.dirtyBits = this.requestBits | 0x38;
    }

    protected final Matrix4f getTmp2Mat() {
        if (null == this.mat4Tmp2) {
            this.mat4Tmp2 = new Matrix4f();
        }
        return this.mat4Tmp2;
    }

    public final Matrix4f getT() {
        return this.matTex;
    }

    public final SyncMatrix4f getSyncT() {
        return this.syncT;
    }

    public final Matrix4f getP() {
        return this.matP;
    }

    public final SyncMatrix4f getSyncP() {
        return this.syncP;
    }

    public final Matrix4f getMv() {
        return this.matMv;
    }

    public final SyncMatrix4f getSyncMv() {
        return this.syncMv;
    }

    public final SyncMatrices4f getSyncPMv() {
        return this.syncP_Mv;
    }

    public final Matrix4f getMvi() {
        if (0 == (2 & this.requestBits)) {
            throw new IllegalArgumentException("Not requested in ctor");
        }
        this.updateImpl(false);
        return this.matMvi;
    }

    public final SyncMatrix4f getSyncMvi() {
        if (0 == (2 & this.requestBits)) {
            throw new IllegalArgumentException("Not requested in ctor");
        }
        return this.syncMvi;
    }

    public final Matrix4f getMvit() {
        if (0 == (4 & this.requestBits)) {
            throw new IllegalArgumentException("Not requested in ctor");
        }
        this.updateImpl(false);
        return this.matMvit;
    }

    public final SyncMatrix4f getSyncMvit() {
        if (0 == (4 & this.requestBits)) {
            throw new IllegalArgumentException("Not requested in ctor");
        }
        return this.syncMvit;
    }

    public final SyncMatrices4f getSyncPMvMvi() {
        if (0 == (2 & this.requestBits)) {
            throw new IllegalArgumentException("Not requested in ctor");
        }
        return this.syncP_Mv_Mvi;
    }

    public final SyncMatrices4f getSyncPMvMviMvit() {
        if (0 == (4 & this.requestBits)) {
            throw new IllegalArgumentException("Not requested in ctor");
        }
        return this.syncP_Mv_Mvi_Mvit;
    }

    public final Matrix4f getMulPMv(Matrix4f matrix4f) {
        return matrix4f.mul(this.matP, this.matMv);
    }

    public final Matrix4f getMulMvP(Matrix4f matrix4f) {
        return matrix4f.mul(this.matMv, this.matP);
    }

    public final Vec4f mulWithMv(Vec4f vec4f, Vec4f vec4f2) {
        return this.matMv.mulVec4f(vec4f, vec4f2);
    }

    public final Vec4f mulWithMv(Vec4f vec4f) {
        return this.matMv.mulVec4f(vec4f);
    }

    public final Vec3f mulWithMv(Vec3f vec3f, Vec3f vec3f2) {
        return this.matMv.mulVec3f(vec3f, vec3f2);
    }

    public final PMVMatrix4f loadMv(float[] fArray, int n) {
        this.matMv.load(fArray, n);
        this.setModelviewDirty();
        return this;
    }

    public final PMVMatrix4f loadMv(FloatBuffer floatBuffer) {
        int n = floatBuffer.position();
        this.matMv.load(floatBuffer);
        this.setModelviewDirty();
        floatBuffer.position(n);
        return this;
    }

    public final PMVMatrix4f loadMv(Matrix4f matrix4f) {
        this.matMv.load(matrix4f);
        this.setModelviewDirty();
        return this;
    }

    public final PMVMatrix4f loadMv(Quaternion quaternion) {
        this.matMv.setToRotation(quaternion);
        this.setModelviewDirty();
        return this;
    }

    public final PMVMatrix4f loadP(float[] fArray, int n) {
        this.matP.load(fArray, n);
        this.setProjectionDirty();
        return this;
    }

    public final PMVMatrix4f loadP(FloatBuffer floatBuffer) {
        int n = floatBuffer.position();
        this.matP.load(floatBuffer);
        this.setProjectionDirty();
        floatBuffer.position(n);
        return this;
    }

    public final PMVMatrix4f loadP(Matrix4f matrix4f) {
        this.matP.load(matrix4f);
        this.setProjectionDirty();
        return this;
    }

    public final PMVMatrix4f loadP(Quaternion quaternion) {
        this.matP.setToRotation(quaternion);
        this.setProjectionDirty();
        return this;
    }

    public final PMVMatrix4f loadT(float[] fArray, int n) {
        this.matTex.load(fArray, n);
        this.setTextureDirty();
        return this;
    }

    public final PMVMatrix4f loadT(FloatBuffer floatBuffer) {
        int n = floatBuffer.position();
        this.matTex.load(floatBuffer);
        this.setTextureDirty();
        floatBuffer.position(n);
        return this;
    }

    public final PMVMatrix4f loadT(Matrix4f matrix4f) {
        this.matTex.load(matrix4f);
        this.setTextureDirty();
        return this;
    }

    public final PMVMatrix4f loadT(Quaternion quaternion) {
        this.matTex.setToRotation(quaternion);
        this.setTextureDirty();
        return this;
    }

    public final PMVMatrix4f loadMvIdentity() {
        this.matMv.loadIdentity();
        this.setModelviewDirty();
        return this;
    }

    public final PMVMatrix4f loadPIdentity() {
        this.matP.loadIdentity();
        this.setProjectionDirty();
        return this;
    }

    public final PMVMatrix4f loadTIdentity() {
        this.matTex.loadIdentity();
        this.setTextureDirty();
        return this;
    }

    public final PMVMatrix4f mulMv(Matrix4f matrix4f) {
        this.matMv.mul(matrix4f);
        this.setModelviewDirty();
        return this;
    }

    public final PMVMatrix4f mulP(Matrix4f matrix4f) {
        this.matP.mul(matrix4f);
        this.setProjectionDirty();
        return this;
    }

    public final PMVMatrix4f mulT(Matrix4f matrix4f) {
        this.matTex.mul(matrix4f);
        this.setTextureDirty();
        return this;
    }

    public final PMVMatrix4f translateMv(float f, float f2, float f3) {
        return this.mulMv(this.mat4Tmp1.setToTranslation(f, f2, f3));
    }

    public final PMVMatrix4f translateMv(Vec3f vec3f) {
        return this.mulMv(this.mat4Tmp1.setToTranslation(vec3f));
    }

    public final PMVMatrix4f translateP(float f, float f2, float f3) {
        return this.mulP(this.mat4Tmp1.setToTranslation(f, f2, f3));
    }

    public final PMVMatrix4f translateP(Vec3f vec3f) {
        return this.mulP(this.mat4Tmp1.setToTranslation(vec3f));
    }

    public final PMVMatrix4f scaleMv(float f, float f2, float f3) {
        return this.mulMv(this.mat4Tmp1.setToScale(f, f2, f3));
    }

    public final PMVMatrix4f scaleMv(Vec3f vec3f) {
        return this.mulMv(this.mat4Tmp1.setToScale(vec3f));
    }

    public final PMVMatrix4f scaleP(float f, float f2, float f3) {
        return this.mulP(this.mat4Tmp1.setToScale(f, f2, f3));
    }

    public final PMVMatrix4f scaleP(Vec3f vec3f) {
        return this.mulP(this.mat4Tmp1.setToScale(vec3f));
    }

    public final PMVMatrix4f rotateMv(float f, float f2, float f3, float f4) {
        return this.mulMv(this.mat4Tmp1.setToRotationAxis(f, f2, f3, f4));
    }

    public final PMVMatrix4f rotateMv(float f, Vec3f vec3f) {
        return this.mulMv(this.mat4Tmp1.setToRotationAxis(f, vec3f));
    }

    public final PMVMatrix4f rotateMv(Quaternion quaternion) {
        return this.mulMv(this.mat4Tmp1.setToRotation(quaternion));
    }

    public final PMVMatrix4f rotateP(float f, float f2, float f3, float f4) {
        return this.mulP(this.mat4Tmp1.setToRotationAxis(f, f2, f3, f4));
    }

    public final PMVMatrix4f rotateP(float f, Vec3f vec3f) {
        return this.mulP(this.mat4Tmp1.setToRotationAxis(f, vec3f));
    }

    public final PMVMatrix4f rotateP(Quaternion quaternion) {
        return this.mulP(this.mat4Tmp1.setToRotation(quaternion));
    }

    public final PMVMatrix4f popMv() {
        this.matMv.pop();
        this.setModelviewDirty();
        return this;
    }

    public final PMVMatrix4f popP() {
        this.matP.pop();
        this.setProjectionDirty();
        return this;
    }

    public final PMVMatrix4f popT() {
        this.matTex.pop();
        this.setTextureDirty();
        return this;
    }

    public final PMVMatrix4f pushMv() {
        this.matMv.push();
        return this;
    }

    public final PMVMatrix4f pushP() {
        this.matP.push();
        return this;
    }

    public final PMVMatrix4f pushT() {
        this.matTex.push();
        return this;
    }

    public final void orthoP(float f, float f2, float f3, float f4, float f5, float f6) {
        this.mulP(this.mat4Tmp1.setToOrtho(f, f2, f3, f4, f5, f6));
    }

    public final void frustumP(float f, float f2, float f3, float f4, float f5, float f6) throws IllegalArgumentException {
        this.mulP(this.mat4Tmp1.setToFrustum(f, f2, f3, f4, f5, f6));
    }

    public final PMVMatrix4f perspectiveP(float f, float f2, float f3, float f4) throws IllegalArgumentException {
        this.mulP(this.mat4Tmp1.setToPerspective(f, f2, f3, f4));
        return this;
    }

    public final PMVMatrix4f lookAtP(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3) {
        this.mulP(this.mat4Tmp1.setToLookAt(vec3f, vec3f2, vec3f3, this.getTmp2Mat()));
        return this;
    }

    public final boolean mapObjToWin(Vec3f vec3f, Recti recti, Vec3f vec3f2) {
        return Matrix4f.mapObjToWin(vec3f, this.matMv, this.matP, recti, vec3f2);
    }

    public final boolean mapWinToObj(float f, float f2, float f3, Recti recti, Vec3f vec3f) {
        return Matrix4f.mapWinToObj(f, f2, f3, this.getPMvi(), recti, vec3f);
    }

    public boolean mapWinToObj4(float f, float f2, float f3, float f4, Recti recti, float f5, float f6, Vec4f vec4f) {
        return Matrix4f.mapWinToObj4(f, f2, f3, f4, this.getPMvi(), recti, f5, f6, vec4f);
    }

    public final boolean mapWinToRay(float f, float f2, float f3, float f4, Recti recti, Ray ray) {
        return Matrix4f.mapWinToRay(f, f2, f3, f4, this.getPMvi(), recti, ray);
    }

    public StringBuilder toString(StringBuilder stringBuilder, String string) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        boolean bl = 0 != (0x10 & this.dirtyBits);
        boolean bl2 = null != this.matPMv;
        boolean bl3 = 0 != (0x20 & this.dirtyBits);
        boolean bl4 = null != this.matPMvi;
        boolean bl5 = 0 != (8 & this.dirtyBits);
        boolean bl6 = null != this.frustum;
        boolean bl7 = 0 != (2 & this.dirtyBits);
        boolean bl8 = 0 != (2 & this.requestBits);
        boolean bl9 = 0 != (4 & this.dirtyBits);
        boolean bl10 = 0 != (4 & this.requestBits);
        boolean bl11 = 0 != (1 & this.modifiedBits);
        boolean bl12 = 0 != (2 & this.modifiedBits);
        boolean bl13 = 0 != (4 & this.modifiedBits);
        int n = 3;
        stringBuilder.append("PMVMatrix4f[modified[P ").append(bl11).append(", Mv ").append(bl12).append(", T ").append(bl13);
        stringBuilder.append("], dirty/used[PMv ").append(bl).append("/").append(bl2).append(", Pmvi ").append(bl3).append("/").append(bl4).append(", Frustum ").append(bl5).append("/").append(bl6);
        stringBuilder.append("], dirty/req[Mvi ").append(bl7).append("/").append(bl8).append(", Mvit ").append(bl9).append("/").append(bl10).append("]").append(System.lineSeparator());
        stringBuilder.append(", Projection").append(System.lineSeparator());
        this.matP.toString(stringBuilder, null, string);
        stringBuilder.append(", Modelview").append(System.lineSeparator());
        this.matMv.toString(stringBuilder, null, string);
        stringBuilder.append(", Texture").append(System.lineSeparator());
        this.matTex.toString(stringBuilder, null, string);
        if (null != this.matPMv) {
            stringBuilder.append(", P * Mv").append(System.lineSeparator());
            this.matPMv.toString(stringBuilder, null, string);
            ++n;
        }
        if (null != this.matPMvi) {
            stringBuilder.append(", P * Mv").append(System.lineSeparator());
            this.matPMvi.toString(stringBuilder, null, string);
            ++n;
        }
        if (bl8) {
            stringBuilder.append(", Inverse Modelview").append(System.lineSeparator());
            this.matMvi.toString(stringBuilder, null, string);
            ++n;
        }
        if (bl10) {
            stringBuilder.append(", Inverse Transposed Modelview").append(System.lineSeparator());
            this.matMvit.toString(stringBuilder, null, string);
            ++n;
        }
        int n2 = 1;
        if (null != this.mat4Tmp2) {
            ++n2;
        }
        stringBuilder.append(", matrices " + n + " + " + n2 + " temp = " + (n + n2) + "]");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null, "%10.5f").toString();
    }

    public final int getModifiedBits(boolean bl) {
        int n = this.modifiedBits;
        if (bl) {
            this.modifiedBits = 0;
        }
        return n;
    }

    public final int getDirtyBits() {
        return this.dirtyBits;
    }

    public final boolean isReqDirty() {
        return 0 != (this.requestBits & this.dirtyBits);
    }

    public final void setModelviewDirty() {
        this.dirtyBits |= this.requestBits | 0x38;
        this.modifiedBits |= 2;
    }

    public final void setProjectionDirty() {
        this.dirtyBits |= 0x38;
        this.modifiedBits |= 1;
    }

    public final void setTextureDirty() {
        this.modifiedBits |= 4;
    }

    public final int getReqBits() {
        return this.requestBits;
    }

    public final Matrix4f getPMv() {
        if (0 != (this.dirtyBits & 0x10)) {
            if (null == this.matPMv) {
                this.matPMv = new Matrix4f();
            }
            this.matPMv.mul(this.matP, this.matMv);
            this.dirtyBits &= 0xFFFFFFEF;
        }
        return this.matPMv;
    }

    public final Matrix4f getPMvi() {
        if (0 != (this.dirtyBits & 0x20)) {
            if (null == this.matPMvi) {
                this.matPMvi = new Matrix4f();
            }
            Matrix4f matrix4f = this.getPMv();
            this.matPMviOK = this.matPMvi.invert(matrix4f);
            this.dirtyBits &= 0xFFFFFFDF;
        }
        return this.matPMviOK ? this.matPMvi : null;
    }

    public final Frustum getFrustum() {
        if (0 != (this.dirtyBits & 8)) {
            if (null == this.frustum) {
                this.frustum = new Frustum();
            }
            this.frustum.setFromMat(this.getPMv());
            this.dirtyBits &= 0xFFFFFFF7;
        }
        return this.frustum;
    }

    public final boolean update() {
        return this.updateImpl(true);
    }

    private final boolean updateImpl(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = 0 != this.modifiedBits;
        if (bl) {
            this.modifiedBits = 0;
        }
        if (0 != (this.requestBits & (this.dirtyBits & 6))) {
            if (!this.matMvi.invert(this.matMv)) {
                throw new RuntimeException("Invalid source Mv matrix, can't compute inverse");
            }
            this.dirtyBits &= 0xFFFFFFFD;
            bl2 = true;
        }
        if (0 != (this.requestBits & (this.dirtyBits & 4))) {
            this.matMvit.transpose(this.matMvi);
            this.dirtyBits &= 0xFFFFFFFB;
            bl2 = true;
        }
        return bl2;
    }

    private final class SyncBuffer0
    extends PMVSyncBuffer {
        private final SyncAction action;

        public SyncBuffer0(Matrix4f matrix4f, FloatBuffer floatBuffer) {
            super(matrix4f, floatBuffer);
            this.action = new SyncAction(){

                @Override
                public void sync() {
                    SyncBuffer0.this.mat.get(PMVMatrix4f.this.matrixStore);
                }
            };
        }

        @Override
        public SyncAction getAction() {
            return this.action;
        }
    }

    private final class SyncBuffer1
    extends PMVSyncBuffer {
        private final int offset;
        private final SyncAction action;

        public SyncBuffer1(Matrix4f matrix4f, FloatBuffer floatBuffer, int n) {
            super(matrix4f, floatBuffer);
            this.action = new SyncAction(){

                @Override
                public void sync() {
                    SyncBuffer1.this.mat.get(PMVMatrix4f.this.matrixStore, SyncBuffer1.this.offset);
                }
            };
            this.offset = n;
        }

        @Override
        public SyncAction getAction() {
            return this.action;
        }
    }

    private final class SyncBufferN
    extends PMVSyncBufferN {
        private final int offset;
        private final SyncAction action;

        public SyncBufferN(Matrix4f[] matrix4fArray, FloatBuffer floatBuffer, int n) {
            super(matrix4fArray, floatBuffer);
            this.action = new SyncAction(){

                @Override
                public void sync() {
                    int n = SyncBufferN.this.offset;
                    int n2 = 0;
                    while (n2 < SyncBufferN.this.mats.length) {
                        SyncBufferN.this.mats[n2].get(PMVMatrix4f.this.matrixStore, n);
                        ++n2;
                        n += 16;
                    }
                }
            };
            this.offset = n;
        }

        @Override
        public SyncAction getAction() {
            return this.action;
        }
    }

    private final class SyncBuffer1U
    extends PMVSyncBuffer {
        private final int offset;
        private final SyncAction action;

        public SyncBuffer1U(Matrix4f matrix4f, FloatBuffer floatBuffer, int n) {
            super(matrix4f, floatBuffer);
            this.action = new SyncAction(){

                @Override
                public void sync() {
                    PMVMatrix4f.this.updateImpl(true);
                    SyncBuffer1U.this.mat.get(PMVMatrix4f.this.matrixStore, SyncBuffer1U.this.offset);
                }
            };
            this.offset = n;
        }

        @Override
        public SyncAction getAction() {
            return this.action;
        }
    }

    private final class SyncBufferNU
    extends PMVSyncBufferN {
        private final int offset;
        private final SyncAction action;

        public SyncBufferNU(Matrix4f[] matrix4fArray, FloatBuffer floatBuffer, int n) {
            super(matrix4fArray, floatBuffer);
            this.action = new SyncAction(){

                @Override
                public void sync() {
                    PMVMatrix4f.this.updateImpl(true);
                    int n = SyncBufferNU.this.offset;
                    int n2 = 0;
                    while (n2 < SyncBufferNU.this.mats.length) {
                        SyncBufferNU.this.mats[n2].get(PMVMatrix4f.this.matrixStore, n);
                        ++n2;
                        n += 16;
                    }
                }
            };
            this.offset = n;
        }

        @Override
        public SyncAction getAction() {
            return this.action;
        }
    }

    private abstract class PMVSyncBufferN
    implements SyncMatrices4f {
        protected final Matrix4f[] mats;
        private final FloatBuffer fbuf;

        public PMVSyncBufferN(Matrix4f[] matrix4fArray, FloatBuffer floatBuffer) {
            this.mats = matrix4fArray;
            this.fbuf = floatBuffer;
        }

        @Override
        public final Buffer getBuffer() {
            return this.fbuf;
        }

        @Override
        public final SyncBuffer sync() {
            this.getAction().sync();
            return this;
        }

        @Override
        public final Buffer getSyncBuffer() {
            this.getAction().sync();
            return this.fbuf;
        }

        @Override
        public Matrix4f[] getMatrices() {
            return this.mats;
        }

        @Override
        public final FloatBuffer getSyncFloats() {
            this.getAction().sync();
            return this.fbuf;
        }
    }

    private abstract class PMVSyncBuffer
    implements SyncMatrix4f {
        protected final Matrix4f mat;
        private final FloatBuffer fbuf;

        public PMVSyncBuffer(Matrix4f matrix4f, FloatBuffer floatBuffer) {
            this.mat = matrix4f;
            this.fbuf = floatBuffer;
        }

        @Override
        public final Buffer getBuffer() {
            return this.fbuf;
        }

        @Override
        public final SyncBuffer sync() {
            this.getAction().sync();
            return this;
        }

        @Override
        public final Buffer getSyncBuffer() {
            this.getAction().sync();
            return this.fbuf;
        }

        @Override
        public final Matrix4f getMatrix() {
            return this.mat;
        }

        @Override
        public final FloatBuffer getSyncFloats() {
            this.getAction().sync();
            return this.fbuf;
        }
    }
}

