/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui.widgets;

import com.jogamp.common.av.PTS;
import com.jogamp.common.net.Uri;
import com.jogamp.common.os.Clock;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.ui.Group;
import com.jogamp.graph.ui.Scene;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.TooltipText;
import com.jogamp.graph.ui.layout.Alignment;
import com.jogamp.graph.ui.layout.BoxLayout;
import com.jogamp.graph.ui.layout.Gap;
import com.jogamp.graph.ui.layout.GridLayout;
import com.jogamp.graph.ui.layout.Padding;
import com.jogamp.graph.ui.shapes.BaseButton;
import com.jogamp.graph.ui.shapes.Button;
import com.jogamp.graph.ui.shapes.HUDShape;
import com.jogamp.graph.ui.shapes.Label;
import com.jogamp.graph.ui.shapes.MediaButton;
import com.jogamp.graph.ui.shapes.Rectangle;
import com.jogamp.graph.ui.widgets.RangeSlider;
import com.jogamp.graph.ui.widgets.Widget;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Vec2f;
import com.jogamp.math.Vec3f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventAdapter;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.av.GLMediaPlayerFactory;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import jogamp.graph.ui.TreeTool;

public class MediaPlayer
extends Widget {
    private static final boolean DEBUG = false;
    public static final Vec2f FixedSymSize = new Vec2f(0.0f, 1.0f);
    public static final Vec2f SymSpacing = new Vec2f(0.0f, 0.2f);
    public static final float CtrlButtonWidth = 1.0f;
    public static final float CtrlButtonHeight = 1.0f;
    public static final Vec4f CtrlCellCol = new Vec4f(0.0f, 0.0f, 0.0f, 0.0f);
    private static final float BorderSz = 0.01f;
    private static final float BorderSzS = 0.03f;
    private static final Vec4f BorderColor = new Vec4f(0.0f, 0.0f, 0.0f, 0.5f);
    private static final Vec4f BorderColorA = new Vec4f(0.0f, 0.0f, 0.5f, 0.5f);
    private static final float AlphaBlend = 0.3f;
    private static final float KnobScale = 2.0f;
    private static final float StillPlayerScale = 0.33333334f;
    private static final float ChapterTipScaleY = 5.0f;
    private static final float ToolTipScaleY = 0.6f;
    private final MediaButton mButton;

    public MediaPlayer(int n, Scene scene, final GLMediaPlayer gLMediaPlayer2, Uri uri, float f5, boolean bl, float f6, boolean bl2, List<Shape> list) {
        super(new BoxLayout(f5, 1.0f, Alignment.None));
        BaseButton baseButton;
        GLMediaPlayer gLMediaPlayer3;
        float f7;
        Font font = FontFactory.getDefaultFont();
        Font font2 = FontFactory.getSymbolsFont();
        if (null == font || null == font2) {
            this.mButton = null;
            return;
        }
        float f8 = scene.getZEpsilon(16);
        float f9 = f8 * 20.0f;
        int n2 = Math.max(list.size() + 14, 20);
        final float f10 = f7 = (f5 - 0.06f) / (float)n2;
        float f11 = f10 / 6.0f;
        final float f12 = 2.0f * f11;
        AtomicReference atomicReference = new AtomicReference();
        AtomicReference atomicReference2 = new AtomicReference();
        AtomicReference atomicReference3 = new AtomicReference();
        this.setName("mp.container");
        this.setBorderColor(BorderColor).setBorder(0.01f);
        this.setInteractive(true).setFixedARatioResize(true);
        this.mButton = new MediaButton(n, f5, 1.0f, gLMediaPlayer2);
        this.mButton.setName("mp.mButton").setInteractive(false);
        this.mButton.setPerp().setPressedColorMod(1.0f, 1.0f, 1.0f, 0.85f);
        this.mButton.setVerbose(false).addDefaultEventListener().setARatioLetterbox(bl, new Vec4f(1.0f, 1.0f, 1.0f, 1.0f));
        gLMediaPlayer2.setAudioVolume(0.0f);
        float f13 = f12 / f11;
        final RangeSlider rangeSlider = new RangeSlider(n, new Vec2f(f5 - f12, f11), f13, new Vec2f(0.0f, 100.0f), 1000.0f, 0.0f);
        float f14 = f12 / 2.0f;
        float f15 = (f12 - f11) * 0.5f;
        rangeSlider.setPaddding(new Padding(0.0f, f14, f10 - f15, f14));
        rangeSlider.getBar().setColor(0.3f, 0.3f, 0.3f, 0.7f);
        rangeSlider.getKnob().setColor(0.6f, 0.6f, 1.0f, 1.0f);
        rangeSlider.setActiveKnobColorMod(new Vec4f(0.1f, 0.1f, 1.0f, 1.0f));
        rangeSlider.move(0.0f, 0.0f, f8);
        rangeSlider.setName("mp.slider");
        Shape shape3 = new Group();
        float f16 = f5 / 4.0f;
        Button button = new Button(n, font, PTS.toTimeStr(0L), f16, 0.1f, 0.0f);
        button.setName("mp.stillTime").setInteractive(false);
        button.setLabelColor(0.2f, 0.2f, 0.2f, 1.0f);
        button.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        button.setSpacing(0.1f, 0.3f);
        button.setCorner(0.75f);
        button.moveTo(f5 / 2.0f - f16 / 2.0f, 0.0f, 0.0f);
        ((Group)shape3).addShape(button);
        if (bl2) {
            gLMediaPlayer3 = GLMediaPlayerFactory.createDefault();
            gLMediaPlayer3.setTextureMinMagFilter(new int[]{9729, 9729});
            gLMediaPlayer3.setTextureUnit(2);
            gLMediaPlayer3.addEventListener((gLMediaPlayer, eventMask, l) -> {
                if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Play)) {
                    gLMediaPlayer.pause(true);
                }
            });
            baseButton = new MediaButton(n, f5, 1.0f, gLMediaPlayer3);
            baseButton.setName("mp.stillMedia").setInteractive(false);
            baseButton.setPerp().setPressedColorMod(1.0f, 1.0f, 1.0f, 0.85f);
            ((MediaButton)baseButton).setVerbose(false).addDefaultEventListener().setARatioLetterbox(true, this.mButton.getARatioLetterboxBackColor());
            baseButton.moveTo(0.0f, 0.120000005f, 0.0f);
            ((Group)shape3).addShape(baseButton);
        } else {
            gLMediaPlayer3 = null;
            baseButton = null;
        }
        HUDShape hUDShape = new HUDShape(scene, bl2 ? f5 * 0.33333334f : f16 * 0.33333334f, bl2 ? 0.33333334f : 0.033333335f, n, rangeSlider, shape3);
        hUDShape.setVisible(false);
        scene.addShape(hUDShape);
        Runnable runnable = () -> MediaPlayer.lambda$new$1(gLMediaPlayer2, (MediaButton)baseButton, button, hUDShape);
        shape3 = new Button(n, font2, font2.getUTF16String("play_arrow"), font2.getUTF16String("pause"), 1.0f, 1.0f, f8);
        shape3.setName("mp.play");
        ((Button)shape3).setSpacing(SymSpacing, FixedSymSize).setPerp().setColor(CtrlCellCol);
        Button button2 = new Button(n, font, "audio\nund", 1.0f, 1.0f, f8);
        button2.setName("mp.audio_lang").setToggleable(false);
        button2.setPerp().setColor(CtrlCellCol);
        baseButton = new Button(n, font, "sub\nund", 1.0f, 1.0f, f8);
        baseButton.setName("mp.sub_lang").setToggleable(false);
        baseButton.setPerp().setColor(CtrlCellCol);
        Button button3 = new Button(n, font2, font2.getUTF16String("crop"), font2.getUTF16String("crop_free"), 1.0f, 1.0f, f8);
        button3.setSpacing(SymSpacing, FixedSymSize).setPerp().setColor(CtrlCellCol).setName("ar crop");
        gLMediaPlayer2.addEventListener((arg_0, arg_1, arg_2) -> this.lambda$new$3(button2, (Button)baseButton, rangeSlider, font, gLMediaPlayer2, f5, button3, bl2, scene, gLMediaPlayer3, runnable, (Button)shape3, arg_0, arg_1, arg_2));
        this.addShape(this.mButton);
        final boolean[] blArray = new boolean[]{false};
        final boolean[] blArray2 = new boolean[]{false};
        Label label = new Label(n, font2, f5 / 6.0f, font2.getUTF16String("music_off"));
        label.setName("mp.mute");
        float f17 = f5 / 6.0f;
        label.setColor(1.0f, 0.0f, 0.0f, 1.0f);
        label.setPaddding(new Padding(0.0f, 0.0f, 1.0f - f17, f5 - f17));
        label.setInteractive(false);
        label.setVisible(gLMediaPlayer2.isAudioMuted());
        this.addShape(label);
        final Group group = new Group(new BoxLayout());
        group.setName("mp.info").setInteractive(false);
        this.addShape(group.setVisible(false));
        Object object = font.getGlyphBounds("88:88 / 88:88:88 (88 %), playing (8.88x, vol 8.88), A/R 8.88, vid 8 (H264), aid 8 (eng, AC3), sid 8 (eng, HDMV_PGS)\nJogAmp's GraphUI Full-Feature Media Player Widget Rocks!");
        float f18 = ((AABBox)object).getHeight() / 2.0f;
        float f19 = f5 / (1.1f * ((AABBox)object).getWidth());
        final Label label2 = new Label(n, font, "88:88 / 88:88:88 (88 %), playing (8.88x, vol 8.88), A/R 8.88, vid 8 (H264), aid 8 (eng, AC3), sid 8 (eng, HDMV_PGS)\nJogAmp's GraphUI Full-Feature Media Player Widget Rocks!");
        label2.setName("mp.info.label");
        label2.setInteractive(false);
        label2.setColor(1.0f, 1.0f, 1.0f, 0.9f);
        label2.scale(f19, f19, 1.0f);
        float f20 = 0.5f * f18 * f19;
        final float f21 = 2.5f * f20 + ((AABBox)object).getHeight() * f19;
        label2.setPaddding(new Padding(0.0f, 0.0f, (1.0f - f21 + f20) / f19, 0.5f));
        Rectangle rectangle = new Rectangle(n & 0xFFFFFFFC, f5, f21, 0.0f);
        rectangle.setName("mp.info.blend").setInteractive(false);
        rectangle.setColor(0.0f, 0.0f, 0.0f, 0.3f);
        rectangle.setPaddding(new Padding(0.0f, 0.0f, 1.0f - f21, 0.0f));
        group.addShape(rectangle);
        group.addShape(label2);
        final Button button4 = new Button(n, font, MediaPlayer.getMultilineTime(Clock.currentMillis(), gLMediaPlayer2), 1.0f, 1.0f, f8);
        button4.setName("mp.time");
        button4.setPerp().setColor(CtrlCellCol);
        button4.setLabelColor(1.0f, 1.0f, 1.0f, 1.0f);
        scene.addGLEventListener(new GLEventAdapter(){
            long t0 = 0L;

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
                long l;
                GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
                if ((button4.isVisible() || label2.isVisible()) && (gLMediaPlayer2.getState() == GLMediaPlayer.State.Playing || gLMediaPlayer2.getState() == GLMediaPlayer.State.Paused) && null != gLAnimatorControl && (l = gLAnimatorControl.getTotalFPSDuration()) - this.t0 >= 333L) {
                    this.t0 = l;
                    int n = gLMediaPlayer2.getPTS().getCurrent();
                    int n2 = gLMediaPlayer2.getDuration();
                    label2.setText(MediaPlayer.getInfo(n, n2, gLMediaPlayer2, blArray2[0]));
                    button4.setText(MediaPlayer.getMultilineTime(n, n2));
                    rangeSlider.setValue(n);
                }
            }
        });
        rangeSlider.addChangeListener((rangeSlider2, f, f2, f3, f4, vec3f, mouseEvent) -> {
            int n = (int)Math.signum(f2 - f);
            int n2 = gLMediaPlayer2.getPTS().getCurrent();
            int n3 = Math.round(f2);
            int n4 = (int)Math.signum(n3 - n2);
            if (n == n4) {
                scene.invoke(false, gLAutoDrawable -> {
                    int n2 = gLMediaPlayer2.getDuration();
                    button4.setText(MediaPlayer.getMultilineTime(n3, n2));
                    gLMediaPlayer2.seek(n3);
                    return true;
                });
            }
        });
        object = new int[]{0};
        rangeSlider.addPeekListener((arg_0, arg_1, arg_2, arg_3, arg_4) -> MediaPlayer.lambda$new$7(hUDShape, f12, rangeSlider, button, bl2, (int[])object, scene, gLMediaPlayer3, arg_0, arg_1, arg_2, arg_3, arg_4));
        rangeSlider.addActivationListener(shape -> {
            if (shape.isActive()) {
                button.setText(PTS.toTimeStr(gLMediaPlayer2.getPTS().getCurrent(), false));
                hUDShape.setVisible(true);
            } else {
                hUDShape.setVisible(false);
            }
        });
        final Rectangle rectangle2 = new Rectangle(n & 0xFFFFFFFC, f5, f10, 0.0f);
        rectangle2.setName("ctrl.blend").setInteractive(false);
        rectangle2.setColor(0.0f, 0.0f, 0.0f, 0.3f);
        this.addShape(rectangle2.setVisible(false));
        this.addShape(rangeSlider.setVisible(false));
        final Group group2 = new Group(new GridLayout(f7, f10, Alignment.FillCenter, Gap.None, 1));
        group2.setName("ctrlGroup").setInteractive(false);
        group2.setPaddding(new Padding(0.0f, 0.03f, 0.0f, 0.03f));
        this.addShape(group2.setVisible(false));
        shape3.onToggle(shape -> {
            if (shape.isToggleOn()) {
                gLMediaPlayer2.setPlaySpeed(1.0f);
                gLMediaPlayer2.resume();
            } else {
                gLMediaPlayer2.pause(false);
            }
        });
        shape3.setToggle(true);
        group2.addShape(shape3);
        shape3.setTooltip(new TooltipText("Play/Pause", font, 0.6f));
        Button button5 = new Button(n, font2, font2.getUTF16String("skip_previous"), 1.0f, 1.0f, f8);
        button5.setName("back");
        button5.setSpacing(SymSpacing, FixedSymSize).setPerp().setColor(CtrlCellCol);
        button5.onClicked((shape, vec3f, mouseEvent) -> {
            int n = gLMediaPlayer2.getPTS().getCurrent();
            int n2 = 0;
            GLMediaPlayer.Chapter chapter = gLMediaPlayer2.getChapter(gLMediaPlayer2.getPTS().getCurrent());
            if (null != chapter) {
                GLMediaPlayer.Chapter chapter2;
                n2 = n > chapter.start + 5000 ? chapter.start : (null != (chapter2 = gLMediaPlayer2.getChapter(chapter.start - 1)) ? chapter2.start : 0);
            }
            gLMediaPlayer2.seek(n2);
        });
        group2.addShape(button5);
        button5.setTooltip(new TooltipText("Prev Chapter", font, 0.6f));
        button5 = new Button(n, font2, font2.getUTF16String("skip_next"), 1.0f, 1.0f, f8);
        button5.setName("next");
        button5.setSpacing(SymSpacing, FixedSymSize).setPerp().setColor(CtrlCellCol);
        button5.onClicked((shape, vec3f, mouseEvent) -> {
            GLMediaPlayer.Chapter chapter;
            int n = 0;
            GLMediaPlayer.Chapter chapter2 = gLMediaPlayer2.getChapter(gLMediaPlayer2.getPTS().getCurrent());
            n = null != chapter2 ? (null != (chapter = gLMediaPlayer2.getChapter(chapter2.end + 1)) ? chapter.start : chapter2.end) : (gLMediaPlayer2.getChapters().length > 0 ? 0 : gLMediaPlayer2.getPTS().getCurrent() * 1);
            gLMediaPlayer2.seek(n);
        });
        group2.addShape(button5);
        button5.setTooltip(new TooltipText("Next Chapter", font, 0.6f));
        button5 = new Button(n, font2, font2.getUTF16String("fast_rewind"), 1.0f, 1.0f, f8);
        button5.setName("rv-");
        button5.setSpacing(SymSpacing, FixedSymSize).setPerp().setColor(CtrlCellCol);
        button5.onClicked((shape, vec3f, mouseEvent) -> {
            float f = gLMediaPlayer2.getPlaySpeed();
            if (f <= 1.0f) {
                gLMediaPlayer2.setPlaySpeed(f / 2.0f);
            } else {
                gLMediaPlayer2.setPlaySpeed(f - 0.5f);
            }
        });
        group2.addShape(button5);
        button5.setTooltip(new TooltipText("replay speed: v <= 1 ? v/2 : v-0.5", font, 0.6f));
        button5 = new Button(n, font2, font2.getUTF16String("fast_forward"), 1.0f, 1.0f, f8);
        button5.setName("rv+");
        button5.setSpacing(SymSpacing, FixedSymSize).setPerp().setColor(CtrlCellCol);
        button5.onClicked((shape, vec3f, mouseEvent) -> {
            float f = gLMediaPlayer2.getPlaySpeed();
            if (1.0f > f && f + 0.5f > 1.0f) {
                gLMediaPlayer2.setPlaySpeed(1.0f);
            } else {
                gLMediaPlayer2.setPlaySpeed(f + 0.5f);
            }
        });
        group2.addShape(button5);
        button5.setTooltip(new TooltipText("replay speed: v+0.5", font, 0.6f));
        button5 = new Button(n, font2, font2.getUTF16String("replay_10"), 1.0f, 1.0f, f8);
        button5.setName("rew5");
        button5.setSpacing(SymSpacing, FixedSymSize).setPerp().setColor(CtrlCellCol);
        button5.onClicked((shape, vec3f, mouseEvent) -> gLMediaPlayer2.seek(gLMediaPlayer2.getPTS().getCurrent() - 10000));
        button5.addMouseListener(new Shape.MouseGestureAdapter(){

            @Override
            public void mouseWheelMoved(MouseEvent mouseEvent) {
                int n = gLMediaPlayer2.getPTS().getCurrent();
                int n2 = n + (int)(mouseEvent.getRotation()[1] * 10000.0f);
                gLMediaPlayer2.seek(n2);
            }
        });
        group2.addShape(button5);
        button5.setTooltip(new TooltipText("Replay 10s (+scroll)", font, 0.6f));
        button5 = new Button(n, font2, font2.getUTF16String("forward_10"), 1.0f, 1.0f, f8);
        button5.setName("fwd5");
        button5.setSpacing(SymSpacing, FixedSymSize).setPerp().setColor(CtrlCellCol);
        button5.onClicked((shape, vec3f, mouseEvent) -> gLMediaPlayer2.seek(gLMediaPlayer2.getPTS().getCurrent() + 10000));
        button5.addMouseListener(new Shape.MouseGestureAdapter(){

            @Override
            public void mouseWheelMoved(MouseEvent mouseEvent) {
                int n = gLMediaPlayer2.getPTS().getCurrent();
                int n2 = n + (int)(mouseEvent.getRotation()[1] * 10000.0f);
                gLMediaPlayer2.seek(n2);
            }
        });
        group2.addShape(button5);
        button5.setTooltip(new TooltipText("Forward 10s (+scroll)", font, 0.6f));
        button5 = new Button(n, font2, font2.getUTF16String("volume_up"), font2.getUTF16String("volume_mute"), 1.0f, 1.0f, f8);
        button5.setName("mute");
        button5.setSpacing(SymSpacing, FixedSymSize).setPerp().setColor(CtrlCellCol);
        Object object2 = new float[]{1.0f};
        button5.onToggle(arg_0 -> MediaPlayer.lambda$new$16(gLMediaPlayer2, (float[])object2, label, arg_0));
        button5.addMouseListener(new Shape.MouseGestureAdapter((float[])object2){
            final /* synthetic */ float[] val$volume;
            {
                this.val$volume = fArray;
            }

            @Override
            public void mouseWheelMoved(MouseEvent mouseEvent) {
                gLMediaPlayer2.setAudioVolume(gLMediaPlayer2.getAudioVolume() + mouseEvent.getRotation()[1] / 20.0f);
                this.val$volume[0] = gLMediaPlayer2.getAudioVolume();
            }
        });
        button5.setToggle(!gLMediaPlayer2.isAudioMuted());
        group2.addShape(button5);
        button5.setTooltip(new TooltipText("Volume (+scroll)", font, 0.6f));
        button2.onClicked((shape, vec3f, mouseEvent) -> {
            int n = gLMediaPlayer2.getNextAID();
            if (gLMediaPlayer2.getAID() != n) {
                gLMediaPlayer2.switchStream(gLMediaPlayer2.getVID(), n, gLMediaPlayer2.getSID());
            }
        });
        group2.addShape(button2);
        button2.setTooltip(new TooltipText("Audio Language", font, 0.6f));
        baseButton.onClicked((shape, vec3f, mouseEvent) -> {
            int n = gLMediaPlayer2.getNextSID();
            if (gLMediaPlayer2.getSID() != n) {
                gLMediaPlayer2.switchStream(gLMediaPlayer2.getVID(), gLMediaPlayer2.getAID(), n);
            }
        });
        group2.addShape(baseButton);
        baseButton.setTooltip(new TooltipText("Subtitle Language", font, 0.6f));
        group2.addShape(button4);
        for (int i = 11; i < n2 - 3 - list.size(); ++i) {
            object2 = new Button(n, font, " ", 1.0f, 1.0f, f8);
            ((Shape)object2).setName("ctrl_" + i);
            ((Button)object2).setSpacing(SymSpacing, FixedSymSize).setPerp().setColor(CtrlCellCol);
            group2.addShape((Shape)object2);
        }
        Iterator<Shape> iterator = new Button(n, font2, font2.getUTF16String("visibility"), font2.getUTF16String("visibility_off"), 1.0f, 1.0f, f8);
        ((Shape)((Object)iterator)).setName("hud");
        ((Button)((Object)iterator)).setSpacing(SymSpacing, FixedSymSize).setPerp().setColor(CtrlCellCol);
        ((Shape)((Object)iterator)).onToggle(shape -> {
            blArray[0] = shape.isToggleOn();
        });
        ((Shape)((Object)iterator)).setToggle(false);
        group2.addShape((Shape)((Object)iterator));
        ((Shape)((Object)iterator)).setTooltip(new TooltipText("Sticky HUD", font, 0.6f));
        iterator = (Iterator<Shape>)new boolean[]{!bl};
        button3.onToggle(arg_0 -> this.lambda$new$20((boolean[])iterator, arg_0));
        group2.addShape(button3);
        button3.setTooltip(new TooltipText("Letterbox Crop", font, 0.6f));
        iterator = new Button(n, font2, font2.getUTF16String("zoom_out_map"), font2.getUTF16String("zoom_in_map"), 1.0f, 1.0f, f8);
        ((Shape)((Object)iterator)).setName("zoom");
        ((Button)((Object)iterator)).setSpacing(SymSpacing, FixedSymSize).setPerp().setColor(CtrlCellCol);
        boolean bl3 = FloatUtil.isEqual(1.0f, f6);
        boolean bl4 = this.isDraggable();
        ((Shape)((Object)iterator)).onToggle(shape -> {
            if (shape.isToggleOn()) {
                if (bl3) {
                    this.setBorder(0.0f);
                    this.setDraggable(false);
                }
                AABBox aABBox = scene.getBounds();
                Group group = this.getParent();
                float f4 = aABBox.getWidth() * f6 / this.getScaledWidth();
                float f5 = aABBox.getHeight() * f6 / this.getScaledHeight();
                float f6 = Math.min(f4, f5);
                Label label = null;
                atomicReference2.set(this.getScale().copy());
                atomicReference3.set(this.getPosition().copy());
                if (null != group) {
                    label = new Label(n, font, f5 / 40.0f, "zoomed");
                    boolean bl3 = group.replaceShape(this, label);
                    if (bl3) {
                        this.scale(f6, f6, 1.0f);
                        this.moveTo(aABBox.getLow()).move(aABBox.getWidth() * (1.0f - f6) / 2.0f, aABBox.getHeight() * (1.0f - f6) / 2.0f, f9);
                        scene.addShape(this);
                    }
                } else {
                    this.scale(f6, f6, 1.0f);
                    this.moveTo(aABBox.getLow()).move(aABBox.getWidth() * (1.0f - f6) / 2.0f, aABBox.getHeight() * (1.0f - f6) / 2.0f, f9);
                }
                atomicReference.set(label);
            } else {
                if (bl3) {
                    this.setBorder(0.01f);
                    this.setDraggable(bl4);
                }
                Vec3f vec3f = atomicReference2.getAndSet(null);
                Vec3f vec3f2 = atomicReference3.getAndSet(null);
                Shape shape2 = atomicReference.getAndSet(null);
                if (null != shape2) {
                    Group group = shape2.getParent();
                    scene.removeShape(this);
                    if (null != vec3f) {
                        this.setScale(vec3f);
                    }
                    if (null != vec3f2) {
                        this.moveTo(vec3f2);
                    }
                    group.replaceShape(shape2, this);
                } else {
                    if (null != vec3f) {
                        this.setScale(vec3f);
                    }
                    if (null != vec3f2) {
                        this.moveTo(vec3f2);
                    }
                }
                if (null != shape2) {
                    scene.invoke(true, gLAutoDrawable -> {
                        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
                        shape2.destroy(gL2ES2, scene.getRenderer());
                        return true;
                    });
                }
            }
        });
        ((Shape)((Object)iterator)).setToggle(false);
        group2.addShape((Shape)((Object)iterator));
        ((Shape)((Object)iterator)).setTooltip(new TooltipText("Zoom", font, 0.6f));
        for (Shape shape4 : list) {
            group2.addShape(shape4);
        }
        this.enableTopLevelWidget(scene);
        this.addActivationListener(shape2 -> {
            if (this.isActive()) {
                this.setBorderColor(BorderColorA);
            } else {
                boolean bl = blArray[0];
                this.setBorderColor(BorderColor);
                rangeSlider.setVisible(bl);
                rectangle2.setVisible(bl);
                group2.setVisible(bl);
                group.setVisible(bl);
            }
        });
        this.addMouseListener(new Shape.MouseGestureAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Shape.EventInfo eventInfo = (Shape.EventInfo)mouseEvent.getAttachment();
                Vec3f vec3f = eventInfo.objPos;
                if (vec3f.y() > 1.0f - f21) {
                    blArray2[0] = !blArray2[0];
                    float f = label2.getScale().x();
                    float f2 = label2.getPadding().bottom * f;
                    float f3 = blArray2[0] ? f * 0.5f : f * 2.0f;
                    label2.setScale(f3, f3, 1.0f);
                    label2.setPaddding(new Padding(0.0f, 0.0f, f2 / f3, 0.5f));
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Shape.EventInfo eventInfo = (Shape.EventInfo)mouseEvent.getAttachment();
                Vec3f vec3f = eventInfo.objPos;
                boolean bl = blArray[0] || f10 + f12 > vec3f.y() || vec3f.y() > 1.0f - f21;
                rangeSlider.setVisible(bl);
                rectangle2.setVisible(bl);
                group2.setVisible(bl);
                group.setVisible(bl);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                MediaPlayer.this.mButton.setPressedColorMod(1.0f, 1.0f, 1.0f, 1.0f);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                MediaPlayer.this.mButton.setPressedColorMod(1.0f, 1.0f, 1.0f, 0.85f);
            }
        });
        TreeTool.forAll(this, shape -> {
            shape.setDraggable(false).setResizable(false);
            return false;
        });
        rangeSlider.getKnob().setDraggable(true);
    }

    public void setSubtitlesEnabled(boolean bl) {
        if (null != this.mButton) {
            this.mButton.setSubtitlesEnabled(bl);
        }
    }

    public void setSubtitleParams(Font font, float f, float f2, Alignment alignment) {
        if (null != this.mButton) {
            this.mButton.setSubtitleParams(font, f, f2, alignment);
        }
    }

    public void setSubtitleColor(Vec4f vec4f, float f) {
        if (null != this.mButton) {
            this.mButton.setSubtitleColor(vec4f, f);
        }
    }

    public static String getInfo(long l, GLMediaPlayer gLMediaPlayer, boolean bl) {
        return MediaPlayer.getInfo(gLMediaPlayer.getPTS().get(l), gLMediaPlayer.getDuration(), gLMediaPlayer, bl);
    }

    public static String getInfo(int n, int n2, GLMediaPlayer gLMediaPlayer, boolean bl) {
        GLMediaPlayer.Chapter chapter = gLMediaPlayer.getChapter(n);
        String string = null != chapter ? " - " + chapter.title : "";
        float f = (float)gLMediaPlayer.getWidth() / (float)gLMediaPlayer.getHeight();
        float f2 = (float)n / (float)n2;
        if (bl) {
            String string2 = String.format("%s / %s (%.0f %%), %s (%01.2fx, vol %1.2f), A/R %.2f, fps %02.1f, kbps %.2f", PTS.toTimeStr(n, false), PTS.toTimeStr(n2, false), Float.valueOf(f2 * 100.0f), gLMediaPlayer.getState().toString().toLowerCase(), Float.valueOf(gLMediaPlayer.getPlaySpeed()), Float.valueOf(gLMediaPlayer.getAudioVolume()), Float.valueOf(f), Float.valueOf(gLMediaPlayer.getFramerate()), Float.valueOf((float)gLMediaPlayer.getStreamBitrate() / 1000.0f));
            String string3 = String.format("video: id %d (%s), kbps %.2f, codec %s/'%s'", new Object[]{gLMediaPlayer.getVID(), gLMediaPlayer.getLang(gLMediaPlayer.getVID()), Float.valueOf((float)gLMediaPlayer.getVideoBitrate() / 1000.0f), gLMediaPlayer.getVideoCodecID(), gLMediaPlayer.getVideoCodec()});
            String string4 = String.format("audio: id %d/%s (%s/%s), kbps %.2f, codec %s/'%s'", new Object[]{gLMediaPlayer.getAID(), Arrays.toString(gLMediaPlayer.getAStreams()), gLMediaPlayer.getLang(gLMediaPlayer.getAID()), Arrays.toString(gLMediaPlayer.getALangs()), Float.valueOf((float)gLMediaPlayer.getAudioBitrate() / 1000.0f), gLMediaPlayer.getAudioCodecID(), gLMediaPlayer.getAudioCodec()});
            String string5 = String.format("sub  : id %d/%s (%s/%s), codec %s/'%s'", new Object[]{gLMediaPlayer.getSID(), Arrays.toString(gLMediaPlayer.getSStreams()), gLMediaPlayer.getLang(gLMediaPlayer.getSID()), Arrays.toString(gLMediaPlayer.getSLangs()), gLMediaPlayer.getSubtitleCodecID(), gLMediaPlayer.getSubtitleCodec()});
            return string2 + "\n" + string3 + "\n" + string4 + "\n" + string5 + "\n" + gLMediaPlayer.getTitle() + string;
        }
        String string6 = gLMediaPlayer.getVID() != -2 ? String.format((Locale)null, ", vid %d (%s)", new Object[]{gLMediaPlayer.getVID(), gLMediaPlayer.getVideoCodecID()}) : "";
        String string7 = gLMediaPlayer.getAID() != -2 ? String.format((Locale)null, ", aid %d (%s, %s)", new Object[]{gLMediaPlayer.getAID(), gLMediaPlayer.getLang(gLMediaPlayer.getAID()), gLMediaPlayer.getAudioCodecID()}) : "";
        String string8 = gLMediaPlayer.getSID() != -2 ? String.format((Locale)null, ", sid %d (%s, %s)", new Object[]{gLMediaPlayer.getSID(), gLMediaPlayer.getLang(gLMediaPlayer.getSID()), gLMediaPlayer.getSubtitleCodecID()}) : "";
        String string9 = String.format("%s / %s (%.0f %%), %s (%01.2fx, vol %1.2f), A/R %.2f%s%s%s", PTS.toTimeStr(n, false), PTS.toTimeStr(n2, false), Float.valueOf(f2 * 100.0f), gLMediaPlayer.getState().toString().toLowerCase(), Float.valueOf(gLMediaPlayer.getPlaySpeed()), Float.valueOf(gLMediaPlayer.getAudioVolume()), Float.valueOf(f), string6, string7, string8);
        return string9 + "\n" + gLMediaPlayer.getTitle() + string;
    }

    public static String getMultilineTime(long l, GLMediaPlayer gLMediaPlayer) {
        return MediaPlayer.getMultilineTime(gLMediaPlayer.getPTS().get(l), gLMediaPlayer.getDuration());
    }

    public static String getMultilineTime(int n, int n2) {
        float f = (float)n / (float)n2;
        return String.format("%.0f %%%n%s%n%s", Float.valueOf(f * 100.0f), PTS.toTimeStr(n, false), PTS.toTimeStr(n2, false));
    }

    private /* synthetic */ void lambda$new$20(boolean[] blArray, Shape shape) {
        blArray[0] = !blArray[0];
        this.mButton.setARatioLetterbox(!blArray[0], this.mButton.getARatioLetterboxBackColor());
    }

    private static /* synthetic */ void lambda$new$16(GLMediaPlayer gLMediaPlayer, float[] fArray, Label label, Shape shape) {
        if (shape.isToggleOn()) {
            gLMediaPlayer.setAudioVolume(fArray[0]);
        } else {
            gLMediaPlayer.setAudioVolume(0.0f);
        }
        label.setVisible(!shape.isToggleOn());
    }

    private static /* synthetic */ void lambda$new$7(HUDShape hUDShape, float f, RangeSlider rangeSlider, Button button, boolean bl, int[] nArray, Scene scene, GLMediaPlayer gLMediaPlayer, RangeSlider rangeSlider2, float f2, float f3, Vec3f vec3f, MouseEvent mouseEvent) {
        float f4 = Math.max(1000.0f, rangeSlider2.getRange() / 300.0f);
        int n = Math.round(f2 / 1000.0f) * 1000;
        Vec3f vec3f2 = new Vec3f(vec3f.x() - hUDShape.getClientSize().x() / 2.0f, f, vec3f.z() + rangeSlider.getPosition().z());
        hUDShape.moveToHUDPos(vec3f2);
        button.setText(PTS.toTimeStr(n, false));
        hUDShape.setVisible(true);
        if (bl && (float)Math.abs(nArray[0] - n) >= f4) {
            scene.invoke(false, gLAutoDrawable -> {
                gLMediaPlayer.seek(n);
                return true;
            });
            nArray[0] = n;
        }
    }

    private /* synthetic */ void lambda$new$3(Button button, Button button2, RangeSlider rangeSlider, Font font, GLMediaPlayer gLMediaPlayer, float f, Button button3, boolean bl, Scene scene, GLMediaPlayer gLMediaPlayer2, Runnable runnable, Button button4, final GLMediaPlayer gLMediaPlayer3, GLMediaPlayer.EventMask eventMask, long l) {
        if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Init)) {
            button.setText("audio\n" + gLMediaPlayer3.getLang(gLMediaPlayer3.getAID()));
            button2.setText("sub\n" + gLMediaPlayer3.getLang(gLMediaPlayer3.getSID()));
            rangeSlider.setMinMax(new Vec2f(0.0f, gLMediaPlayer3.getDuration()), 0.0f);
            System.err.println("Init " + gLMediaPlayer3.toString());
            for (GLMediaPlayer.Chapter chapter : gLMediaPlayer3.getChapters()) {
                Shape shape = rangeSlider.addMark(chapter.start, new Vec4f(0.9f, 0.9f, 0.9f, 0.5f));
                shape.setTooltip(new TooltipText(chapter.title + "\n@ " + PTS.toTimeStr(chapter.start, false) + ", duration " + PTS.toTimeStr(chapter.duration(), false), font, 5.0f));
            }
            float f2 = (float)gLMediaPlayer.getWidth() / (float)gLMediaPlayer.getHeight();
            if (FloatUtil.isZero(Math.abs(f - f2), 0.1f)) {
                button3.setVisible(false);
                System.err.println("AR Crop disabled: aratioPlayer " + f + ", aratioVideo " + f2 + ": " + gLMediaPlayer.getTitle());
            } else {
                System.err.println("AR Crop  enabled: aratioPlayer " + f + ", aratioVideo " + f2 + ": " + gLMediaPlayer.getTitle());
            }
            if (bl) {
                scene.invoke(false, gLAutoDrawable -> {
                    gLMediaPlayer2.stop();
                    gLMediaPlayer2.playStream(gLMediaPlayer.getUri(), gLMediaPlayer.getVID(), -2, -2, 1);
                    runnable.run();
                    return true;
                });
            }
        } else if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Play)) {
            button4.setToggle(true);
        } else if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.Pause)) {
            button4.setToggle(false);
        }
        if (eventMask.isSet(GLMediaPlayer.EventMask.Bit.EOS)) {
            GLMediaPlayer.StreamException streamException = gLMediaPlayer3.getStreamException();
            if (null != streamException) {
                System.err.println("MovieSimple State: Exception: " + streamException.getMessage());
            } else {
                new InterruptSource.Thread(){

                    @Override
                    public void run() {
                        gLMediaPlayer3.setPlaySpeed(1.0f);
                        gLMediaPlayer3.seek(0);
                        gLMediaPlayer3.resume();
                    }
                }.start();
            }
        }
    }

    private static /* synthetic */ void lambda$new$1(GLMediaPlayer gLMediaPlayer, MediaButton mediaButton, Button button, HUDShape hUDShape) {
        float f = (float)gLMediaPlayer.getWidth() / (float)gLMediaPlayer.getHeight();
        float f2 = f / 4.0f;
        float f3 = 0.1f;
        mediaButton.setSize(f, 1.0f);
        mediaButton.moveTo(0.0f, 0.120000005f, 0.0f);
        button.moveTo(f / 2.0f - f2 / 2.0f, 0.0f, 0.0f);
        hUDShape.setClientSize(f * 0.33333334f, 0.33333334f);
    }
}

