/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui;

import com.jogamp.common.util.StringUtil;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.ui.Scene;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.Tooltip;
import com.jogamp.graph.ui.shapes.Button;
import com.jogamp.math.Vec2f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.geom.plane.AffineTransform;

public class TooltipText
extends Tooltip {
    private final CharSequence tipText;
    private final Font tipFont;
    private final float scaleY;

    public TooltipText(CharSequence charSequence, Font font, Vec4f vec4f, Vec4f vec4f2, float f, long l, int n) {
        super(vec4f, vec4f2, l, n);
        this.tipText = charSequence;
        this.tipFont = font;
        this.scaleY = f;
    }

    public TooltipText(CharSequence charSequence, Font font, float f) {
        this(charSequence, font, null, null, f, 1000L, 2);
    }

    @Override
    public Shape createTip(Scene scene, AABBox aABBox) {
        float f = scene.getZEpsilon(16);
        AABBox aABBox2 = scene.getBounds();
        AffineTransform affineTransform = new AffineTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        AABBox aABBox3 = this.tipFont.getGlyphBounds(this.tipText, affineTransform, affineTransform2);
        float f2 = aABBox3.getHeight() * (1.0f + 0.5f / (float)StringUtil.getLineCount(this.tipText));
        float f3 = f2 / aABBox3.getHeight() - 1.0f;
        f2 = aABBox.getHeight() * this.scaleY * (1.0f + f3);
        float f4 = aABBox3.getWidth() * f2 / aABBox3.getHeight() * (1.0f - f3);
        if (f4 > aABBox2.getWidth() * 0.9f) {
            f4 = aABBox2.getWidth() * 0.9f;
            f2 = aABBox3.getHeight() * f4 / aABBox3.getWidth();
        } else if (f2 > aABBox2.getHeight() * 0.9f) {
            f2 = aABBox2.getHeight() * 0.9f;
            f4 = aABBox3.getWidth() * f2 / aABBox3.getHeight();
        }
        Vec2f vec2f = this.getTipMvPosition(scene, aABBox, f4, f2);
        Button button = (Button)new Button(this.renderModes, this.tipFont, this.tipText, f4, f2, f).moveTo(vec2f.x(), vec2f.y(), 100.0f * f).setColor(this.backColor).setInteractive(false);
        button.setLabelColor(this.frontColor);
        button.setSpacing(0.075f, f3);
        button.setCorner(0.75f);
        return button;
    }
}

