/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

public class Sorting {
    private Sorting() {
    }

    public static byte[] sort(byte[] x, Byte helper) {
        int i;
        int n = x.length;
        for (i = 2; i <= n; ++i) {
            Sorting.siftUp(x, i, helper);
        }
        for (i = n; i >= 2; --i) {
            helper.swap(x, 0, i - 1);
            Sorting.siftDown(x, i - 1, helper);
        }
        return x;
    }

    private static void siftUp(byte[] x, int c, Byte helper) {
        int p = c >> 1;
        while (p >= 1 && helper.comesBefore(x, p - 1, c - 1)) {
            helper.swap(x, p - 1, c - 1);
            c = p;
            p = c >> 1;
        }
    }

    private static void siftDown(byte[] x, int n, Byte helper) {
        int p = 1;
        int ca = 2;
        int cb = 3;
        while (ca <= n) {
            if (cb <= n && helper.comesBefore(x, ca - 1, cb - 1)) {
                if (!helper.comesBefore(x, p - 1, cb - 1)) break;
                helper.swap(x, p - 1, cb - 1);
                p = cb;
            } else {
                if (!helper.comesBefore(x, p - 1, ca - 1)) break;
                helper.swap(x, p - 1, ca - 1);
                p = ca;
            }
            ca = p << 1;
            cb = ca + 1;
        }
    }

    public static char[] sort(char[] x, Character helper) {
        int i;
        int n = x.length;
        for (i = 2; i <= n; ++i) {
            Sorting.siftUp(x, i, helper);
        }
        for (i = n; i >= 2; --i) {
            helper.swap(x, 0, i - 1);
            Sorting.siftDown(x, i - 1, helper);
        }
        return x;
    }

    private static void siftUp(char[] x, int c, Character helper) {
        int p = c >> 1;
        while (p >= 1 && helper.comesBefore(x, p - 1, c - 1)) {
            helper.swap(x, p - 1, c - 1);
            c = p;
            p = c >> 1;
        }
    }

    private static void siftDown(char[] x, int n, Character helper) {
        int p = 1;
        int ca = 2;
        int cb = 3;
        while (ca <= n) {
            if (cb <= n && helper.comesBefore(x, ca - 1, cb - 1)) {
                if (!helper.comesBefore(x, p - 1, cb - 1)) break;
                helper.swap(x, p - 1, cb - 1);
                p = cb;
            } else {
                if (!helper.comesBefore(x, p - 1, ca - 1)) break;
                helper.swap(x, p - 1, ca - 1);
                p = ca;
            }
            ca = p << 1;
            cb = ca + 1;
        }
    }

    public static short[] sort(short[] x, Short helper) {
        int i;
        int n = x.length;
        for (i = 2; i <= n; ++i) {
            Sorting.siftUp(x, i, helper);
        }
        for (i = n; i >= 2; --i) {
            helper.swap(x, 0, i - 1);
            Sorting.siftDown(x, i - 1, helper);
        }
        return x;
    }

    private static void siftUp(short[] x, int c, Short helper) {
        int p = c >> 1;
        while (p >= 1 && helper.comesBefore(x, p - 1, c - 1)) {
            helper.swap(x, p - 1, c - 1);
            c = p;
            p = c >> 1;
        }
    }

    private static void siftDown(short[] x, int n, Short helper) {
        int p = 1;
        int ca = 2;
        int cb = 3;
        while (ca <= n) {
            if (cb <= n && helper.comesBefore(x, ca - 1, cb - 1)) {
                if (!helper.comesBefore(x, p - 1, cb - 1)) break;
                helper.swap(x, p - 1, cb - 1);
                p = cb;
            } else {
                if (!helper.comesBefore(x, p - 1, ca - 1)) break;
                helper.swap(x, p - 1, ca - 1);
                p = ca;
            }
            ca = p << 1;
            cb = ca + 1;
        }
    }

    public static int[] sort(int[] x, Integer helper) {
        int i;
        int n = x.length;
        for (i = 2; i <= n; ++i) {
            Sorting.siftUp(x, i, helper);
        }
        for (i = n; i >= 2; --i) {
            helper.swap(x, 0, i - 1);
            Sorting.siftDown(x, i - 1, helper);
        }
        return x;
    }

    private static void siftUp(int[] x, int c, Integer helper) {
        int p = c >> 1;
        while (p >= 1 && helper.comesBefore(x, p - 1, c - 1)) {
            helper.swap(x, p - 1, c - 1);
            c = p;
            p = c >> 1;
        }
    }

    private static void siftDown(int[] x, int n, Integer helper) {
        int p = 1;
        int ca = 2;
        int cb = 3;
        while (ca <= n) {
            if (cb <= n && helper.comesBefore(x, ca - 1, cb - 1)) {
                if (!helper.comesBefore(x, p - 1, cb - 1)) break;
                helper.swap(x, p - 1, cb - 1);
                p = cb;
            } else {
                if (!helper.comesBefore(x, p - 1, ca - 1)) break;
                helper.swap(x, p - 1, ca - 1);
                p = ca;
            }
            ca = p << 1;
            cb = ca + 1;
        }
    }

    public static long[] sort(long[] x, Long helper) {
        int i;
        int n = x.length;
        for (i = 2; i <= n; ++i) {
            Sorting.siftUp(x, i, helper);
        }
        for (i = n; i >= 2; --i) {
            helper.swap(x, 0, i - 1);
            Sorting.siftDown(x, i - 1, helper);
        }
        return x;
    }

    private static void siftUp(long[] x, int c, Long helper) {
        int p = c >> 1;
        while (p >= 1 && helper.comesBefore(x, p - 1, c - 1)) {
            helper.swap(x, p - 1, c - 1);
            c = p;
            p = c >> 1;
        }
    }

    private static void siftDown(long[] x, int n, Long helper) {
        int p = 1;
        int ca = 2;
        int cb = 3;
        while (ca <= n) {
            if (cb <= n && helper.comesBefore(x, ca - 1, cb - 1)) {
                if (!helper.comesBefore(x, p - 1, cb - 1)) break;
                helper.swap(x, p - 1, cb - 1);
                p = cb;
            } else {
                if (!helper.comesBefore(x, p - 1, ca - 1)) break;
                helper.swap(x, p - 1, ca - 1);
                p = ca;
            }
            ca = p << 1;
            cb = ca + 1;
        }
    }

    public static float[] sort(float[] x, Float helper) {
        int i;
        int n = x.length;
        for (i = 2; i <= n; ++i) {
            Sorting.siftUp(x, i, helper);
        }
        for (i = n; i >= 2; --i) {
            helper.swap(x, 0, i - 1);
            Sorting.siftDown(x, i - 1, helper);
        }
        return x;
    }

    private static void siftUp(float[] x, int c, Float helper) {
        int p = c >> 1;
        while (p >= 1 && helper.comesBefore(x, p - 1, c - 1)) {
            helper.swap(x, p - 1, c - 1);
            c = p;
            p = c >> 1;
        }
    }

    private static void siftDown(float[] x, int n, Float helper) {
        int p = 1;
        int ca = 2;
        int cb = 3;
        while (ca <= n) {
            if (cb <= n && helper.comesBefore(x, ca - 1, cb - 1)) {
                if (!helper.comesBefore(x, p - 1, cb - 1)) break;
                helper.swap(x, p - 1, cb - 1);
                p = cb;
            } else {
                if (!helper.comesBefore(x, p - 1, ca - 1)) break;
                helper.swap(x, p - 1, ca - 1);
                p = ca;
            }
            ca = p << 1;
            cb = ca + 1;
        }
    }

    public static double[] sort(double[] x, Double helper) {
        int i;
        int n = x.length;
        for (i = 2; i <= n; ++i) {
            Sorting.siftUp(x, i, helper);
        }
        for (i = n; i >= 2; --i) {
            helper.swap(x, 0, i - 1);
            Sorting.siftDown(x, i - 1, helper);
        }
        return x;
    }

    private static void siftUp(double[] x, int c, Double helper) {
        int p = c >> 1;
        while (p >= 1 && helper.comesBefore(x, p - 1, c - 1)) {
            helper.swap(x, p - 1, c - 1);
            c = p;
            p = c >> 1;
        }
    }

    private static void siftDown(double[] x, int n, Double helper) {
        int p = 1;
        int ca = 2;
        int cb = 3;
        while (ca <= n) {
            if (cb <= n && helper.comesBefore(x, ca - 1, cb - 1)) {
                if (!helper.comesBefore(x, p - 1, cb - 1)) break;
                helper.swap(x, p - 1, cb - 1);
                p = cb;
            } else {
                if (!helper.comesBefore(x, p - 1, ca - 1)) break;
                helper.swap(x, p - 1, ca - 1);
                p = ca;
            }
            ca = p << 1;
            cb = ca + 1;
        }
    }

    public static <T> T[] sort(T[] x, Object<T> helper) {
        int i;
        int n = x.length;
        for (i = 2; i <= n; ++i) {
            Sorting.siftUp(x, i, helper);
        }
        for (i = n; i >= 2; --i) {
            helper.swap(x, 0, i - 1);
            Sorting.siftDown(x, i - 1, helper);
        }
        return x;
    }

    private static <T> void siftUp(T[] x, int c, Object<T> helper) {
        int p = c >> 1;
        while (p >= 1 && helper.comesBefore(x, p - 1, c - 1)) {
            helper.swap(x, p - 1, c - 1);
            c = p;
            p = c >> 1;
        }
    }

    private static <T> void siftDown(T[] x, int n, Object<T> helper) {
        int p = 1;
        int ca = 2;
        int cb = 3;
        while (ca <= n) {
            if (cb <= n && helper.comesBefore(x, ca - 1, cb - 1)) {
                if (!helper.comesBefore(x, p - 1, cb - 1)) break;
                helper.swap(x, p - 1, cb - 1);
                p = cb;
            } else {
                if (!helper.comesBefore(x, p - 1, ca - 1)) break;
                helper.swap(x, p - 1, ca - 1);
                p = ca;
            }
            ca = p << 1;
            cb = ca + 1;
        }
    }

    public static class Byte {
        public boolean comesBefore(byte[] x, int a, int b) {
            return x[a] < x[b];
        }

        public void swap(byte[] x, int a, int b) {
            byte t = x[a];
            x[a] = x[b];
            x[b] = t;
        }
    }

    public static class Character {
        public boolean comesBefore(char[] x, int a, int b) {
            return x[a] < x[b];
        }

        public void swap(char[] x, int a, int b) {
            char t = x[a];
            x[a] = x[b];
            x[b] = t;
        }
    }

    public static class Short {
        public boolean comesBefore(short[] x, int a, int b) {
            return x[a] < x[b];
        }

        public void swap(short[] x, int a, int b) {
            short t = x[a];
            x[a] = x[b];
            x[b] = t;
        }
    }

    public static class Integer {
        public boolean comesBefore(int[] x, int a, int b) {
            return x[a] < x[b];
        }

        public void swap(int[] x, int a, int b) {
            int t = x[a];
            x[a] = x[b];
            x[b] = t;
        }
    }

    public static class Long {
        public boolean comesBefore(long[] x, int a, int b) {
            return x[a] < x[b];
        }

        public void swap(long[] x, int a, int b) {
            long t = x[a];
            x[a] = x[b];
            x[b] = t;
        }
    }

    public static class Float {
        public boolean comesBefore(float[] x, int a, int b) {
            return x[a] < x[b];
        }

        public void swap(float[] x, int a, int b) {
            float t = x[a];
            x[a] = x[b];
            x[b] = t;
        }
    }

    public static class Double {
        public boolean comesBefore(double[] x, int a, int b) {
            return x[a] < x[b];
        }

        public void swap(double[] x, int a, int b) {
            double t = x[a];
            x[a] = x[b];
            x[b] = t;
        }
    }

    public static abstract class Object<T> {
        public abstract boolean comesBefore(T[] var1, int var2, int var3);

        public void swap(T[] x, int a, int b) {
            T t = x[a];
            x[a] = x[b];
            x[b] = t;
        }
    }
}

