/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Range
implements Externalizable {
    private static final long serialVersionUID = -155434844308312282L;
    int lb;
    int stride;
    int length;
    int ub;

    public Range() {
        this.lb = 0;
        this.stride = 1;
        this.length = 0;
        this.setUb();
    }

    public Range(int lb, int ub) {
        this.lb = lb;
        this.stride = 1;
        this.length = Math.max(ub - lb + 1, 0);
        this.setUb();
    }

    public Range(int lb, int ub, int stride) {
        if (stride < 1) {
            throw new IllegalArgumentException("Range(): stride = " + stride + " illegal");
        }
        this.lb = lb;
        this.stride = stride;
        this.length = Math.max((ub - lb + stride) / stride, 0);
        this.setUb();
    }

    public Range(Range range) {
        this.lb = range.lb;
        this.stride = range.stride;
        this.length = range.length;
        this.ub = range.ub;
    }

    public int lb() {
        return this.lb;
    }

    public int ub() {
        return this.ub;
    }

    public int stride() {
        return this.stride;
    }

    public int length() {
        return this.length;
    }

    public boolean contains(int value) {
        return this.lb <= value && value <= this.ub;
    }

    public boolean contains(Range range) {
        return this.lb <= range.lb && range.ub <= this.ub;
    }

    public Range subrange(int size, int rank) {
        if (size < 1) {
            throw new IllegalArgumentException("Range.subrange(): size = " + size + " illegal");
        }
        if (0 > rank || rank >= size) {
            throw new IllegalArgumentException("Range.subrange(): rank = " + rank + " illegal");
        }
        Range result = new Range();
        int sublen = this.length / size;
        int subrem = this.length % size;
        result.lb = rank < subrem ? this.lb + rank * ++sublen * this.stride : this.lb + (subrem + rank * sublen) * this.stride;
        result.stride = this.stride;
        result.length = sublen;
        result.setUb();
        return result;
    }

    public Range[] subranges(int size) {
        Range result_i;
        int i;
        if (size < 1) {
            throw new IllegalArgumentException("Range.subranges(): size = " + size + " illegal");
        }
        Range[] result = new Range[size];
        int sublen = this.length / size;
        int subrem = this.length % size;
        int x = this.lb;
        ++sublen;
        for (i = 0; i < subrem; ++i) {
            result_i = new Range();
            result_i.lb = x;
            x += sublen * this.stride;
            result_i.stride = this.stride;
            result_i.length = sublen;
            result_i.setUb();
            result[i] = result_i;
        }
        --sublen;
        for (i = subrem; i < size; ++i) {
            result_i = new Range();
            result_i.lb = x;
            x += sublen * this.stride;
            result_i.stride = this.stride;
            result_i.length = sublen;
            result_i.setUb();
            result[i] = result_i;
        }
        return result;
    }

    public Range chunk(int N1, int N2) {
        if (N1 < 0) {
            throw new IllegalArgumentException("Range.chunk(): N1 = " + N1 + " illegal");
        }
        if (N2 < 0) {
            throw new IllegalArgumentException("Range.chunk(): N2 = " + N2 + " illegal");
        }
        Range result = new Range();
        result.lb = this.lb + N1 * this.stride;
        result.stride = this.stride;
        result.length = Math.min(N2, Math.max(0, this.length - N1));
        result.setUb();
        return result;
    }

    public boolean equals(Object obj) {
        return obj instanceof Range && this.lb == ((Range)obj).lb && this.stride == ((Range)obj).stride && this.length == ((Range)obj).length;
    }

    public int hashCode() {
        return ((this.lb << 10) + this.stride << 10) + this.length;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.lb);
        b.append("..");
        b.append(this.ub);
        if (this.stride > 1) {
            b.append(';');
            b.append(this.stride);
        }
        return b.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.lb);
        out.writeInt(this.stride);
        out.writeInt(this.length);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.lb = in.readInt();
        this.stride = in.readInt();
        this.length = in.readInt();
        this.setUb();
    }

    private void setUb() {
        this.ub = this.lb + (this.length - 1) * this.stride;
    }
}

