/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

import edu.rit.util.Random;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

public class RandomSubset
implements Iterator<Integer> {
    private Random prng;
    private int N;
    private int M;
    private Helper helper;

    public RandomSubset(Random prng, int N) {
        this(prng, N, false);
    }

    public RandomSubset(Random prng, int N, boolean dense) {
        if (prng == null) {
            throw new NullPointerException("RandomSubset(): prng is null");
        }
        if (N < 0) {
            throw new IllegalArgumentException("RandomSubset(): N = " + N + " illegal");
        }
        this.prng = prng;
        this.N = N;
        this.helper = dense ? new DenseHelper(this) : new SparseHelper();
    }

    @Override
    public boolean hasNext() {
        return this.M < this.N;
    }

    @Override
    public Integer next() {
        if (this.M >= this.N) {
            throw new NoSuchElementException("RandomSubset.next(): No further elements");
        }
        this.helper.swapElements(this.M, this.M + this.prng.nextInt(this.N - this.M));
        ++this.M;
        return this.helper.getElement(this.M - 1);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public RandomSubset remove(int i) {
        if (0 > i || i >= this.N) {
            throw new IllegalArgumentException("RandomSubset.remove(): i = " + i + " illegal");
        }
        int j = this.helper.indexOf(i);
        if (j >= this.M) {
            this.helper.swapElements(this.M, j);
            ++this.M;
        }
        return this;
    }

    public void restart() {
        this.M = 0;
        this.helper.restart();
    }

    private class DenseHelper
    extends Helper {
        private int[] permutation;
        final /* synthetic */ RandomSubset this$0;

        public DenseHelper(RandomSubset randomSubset) {
            RandomSubset randomSubset2 = randomSubset;
            Objects.requireNonNull(randomSubset2);
            this.this$0 = randomSubset2;
            this.permutation = new int[this.this$0.N];
            this.restart();
        }

        @Override
        public int getElement(int i) {
            return this.permutation[i];
        }

        @Override
        public void setElement(int i, int value) {
            this.permutation[i] = value;
        }

        @Override
        public void swapElements(int i, int j) {
            int tmp = this.permutation[i];
            this.permutation[i] = this.permutation[j];
            this.permutation[j] = tmp;
        }

        @Override
        public int indexOf(int value) {
            int i = 0;
            while (this.permutation[i] != value) {
                ++i;
            }
            return i;
        }

        @Override
        public void restart() {
            for (int i = 0; i < this.this$0.N; ++i) {
                this.permutation[i] = i;
            }
        }
    }

    private static class SparseHelper
    extends Helper {
        private final HashMap<Integer, Integer> permutation = new HashMap();

        private SparseHelper() {
        }

        @Override
        public int getElement(int i) {
            Integer element = this.permutation.get(i);
            return element == null ? i : element;
        }

        @Override
        public void setElement(int i, int value) {
            if (value == i) {
                this.permutation.remove(i);
            } else {
                this.permutation.put(i, value);
            }
        }

        @Override
        public void swapElements(int i, int j) {
            int tmp = this.getElement(i);
            this.setElement(i, this.getElement(j));
            this.setElement(j, tmp);
        }

        @Override
        public int indexOf(int value) {
            for (Map.Entry<Integer, Integer> entry : this.permutation.entrySet()) {
                if (entry.getValue() != value) continue;
                return entry.getKey();
            }
            return value;
        }

        @Override
        public void restart() {
            this.permutation.clear();
        }
    }

    private static abstract class Helper {
        private Helper() {
        }

        public abstract int getElement(int var1);

        public abstract void setElement(int var1, int var2);

        public abstract void swapElements(int var1, int var2);

        public abstract int indexOf(int var1);

        public abstract void restart();
    }
}

