/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

import edu.rit.util.DefaultRandom;
import java.io.Serializable;
import java.lang.reflect.Constructor;

public abstract class Random
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static double D_2_POW_NEG_64;
    private static float F_2_POW_NEG_64;

    protected Random() {
    }

    public static Random getInstance(long seed) {
        String algorithm = System.getProperty("pj.prng");
        return algorithm == null ? new DefaultRandom(seed) : Random.getInstance(seed, algorithm);
    }

    public static Random getInstance(long seed, String algorithm) {
        try {
            Class<?> cl = Class.forName(algorithm);
            Constructor<?> ctor = cl.getConstructor(Long.TYPE);
            return (Random)ctor.newInstance(seed);
        }
        catch (Exception exc) {
            throw new TypeNotPresentException(algorithm, exc);
        }
    }

    public abstract void setSeed(long var1);

    public void skip() {
        this.next();
    }

    public void skip(long skip) {
        if (skip > 0L) {
            this.next(skip);
        }
    }

    public boolean nextBoolean() {
        return this.next() >= 0L;
    }

    public boolean nextBoolean(long skip) {
        if (skip <= 0L) {
            throw new IllegalArgumentException("Random.nextBoolean(): skip = " + skip + " illegal");
        }
        return this.next(skip) >= 0L;
    }

    public byte nextByte() {
        return (byte)this.next();
    }

    public byte nextByte(long skip) {
        if (skip <= 0L) {
            throw new IllegalArgumentException("Random.nextByte(): skip = " + skip + " illegal");
        }
        return (byte)this.next(skip);
    }

    public int nextUnsignedByte() {
        return (int)(this.next() & 0xFFL);
    }

    public int nextUnsignedByte(long skip) {
        if (skip <= 0L) {
            throw new IllegalArgumentException("Random.nextUnsignedByte(): skip = " + skip + " illegal");
        }
        return (int)(this.next(skip) & 0xFFL);
    }

    public char nextCharacter() {
        return (char)this.next();
    }

    public int nextCharacter(long skip) {
        if (skip <= 0L) {
            throw new IllegalArgumentException("Random.nextCharacter(): skip = " + skip + " illegal");
        }
        return (char)this.next(skip);
    }

    public short nextShort() {
        return (short)this.next();
    }

    public short nextShort(long skip) {
        if (skip <= 0L) {
            throw new IllegalArgumentException("Random.nextShort(): skip = " + skip + " illegal");
        }
        return (short)this.next(skip);
    }

    public int nextUnsignedShort() {
        return (int)(this.next() & 0xFFFFL);
    }

    public int nextUnsignedShort(long skip) {
        if (skip <= 0L) {
            throw new IllegalArgumentException("Random.nextUnsignedShort(): skip = " + skip + " illegal");
        }
        return (int)(this.next(skip) & 0xFFFFL);
    }

    public int nextInteger() {
        return (int)this.next();
    }

    public int nextInteger(long skip) {
        if (skip <= 0L) {
            throw new IllegalArgumentException("Random.nextInteger(): skip = " + skip + " illegal");
        }
        return (int)this.next(skip);
    }

    public int nextInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Random.nextInt(): n = " + n + " illegal");
        }
        return (int)Math.floor(this.nextDouble() * (double)n);
    }

    public int nextInt(int n, long skip) {
        if (n <= 0) {
            throw new IllegalArgumentException("Random.nextInt(): n = " + n + " illegal");
        }
        return (int)Math.floor(this.nextDouble(skip) * (double)n);
    }

    public long nextLong() {
        return this.next();
    }

    public long nextLong(long skip) {
        if (skip <= 0L) {
            throw new IllegalArgumentException("Random.nextLong(): skip = " + skip + " illegal");
        }
        return this.next(skip);
    }

    public float nextFloat() {
        return (float)this.next() * F_2_POW_NEG_64 + 0.5f;
    }

    public float nextFloat(long skip) {
        if (skip <= 0L) {
            throw new IllegalArgumentException("Random.nextFloat(): skip = " + skip + " illegal");
        }
        return (float)this.next(skip) * F_2_POW_NEG_64 + 0.5f;
    }

    public double nextDouble() {
        return (double)this.next() * D_2_POW_NEG_64 + 0.5;
    }

    public double nextDouble(long skip) {
        if (skip <= 0L) {
            throw new IllegalArgumentException("Random.nextDouble(): skip = " + skip + " illegal");
        }
        return (double)this.next(skip) * D_2_POW_NEG_64 + 0.5;
    }

    protected abstract long next();

    protected abstract long next(long var1);

    static {
        double x = 2.0;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        x *= x;
        D_2_POW_NEG_64 = 1.0 / x;
        F_2_POW_NEG_64 = (float)D_2_POW_NEG_64;
    }
}

