/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class LongRange
implements Externalizable {
    private static final long serialVersionUID = 9196521188817114486L;
    long lb;
    long stride;
    long length;
    long ub;

    public LongRange() {
        this.lb = 0L;
        this.stride = 1L;
        this.length = 0L;
        this.setUb();
    }

    public LongRange(long lb, long ub) {
        this.lb = lb;
        this.stride = 1L;
        this.length = Math.max(ub - lb + 1L, 0L);
        this.setUb();
    }

    public LongRange(long lb, long ub, long stride) {
        if (stride < 1L) {
            throw new IllegalArgumentException("LongRange(): stride = " + stride + " illegal");
        }
        this.lb = lb;
        this.stride = stride;
        this.length = Math.max((ub - lb + stride) / stride, 0L);
        this.setUb();
    }

    public LongRange(LongRange range) {
        this.lb = range.lb;
        this.stride = range.stride;
        this.length = range.length;
        this.ub = range.ub;
    }

    public long lb() {
        return this.lb;
    }

    public long ub() {
        return this.ub;
    }

    public long stride() {
        return this.stride;
    }

    public long length() {
        return this.length;
    }

    public boolean contains(long value) {
        return this.lb <= value && value <= this.ub;
    }

    public boolean contains(LongRange range) {
        return this.lb <= range.lb && range.ub <= this.ub;
    }

    public LongRange subrange(int size, int rank) {
        if (size < 1) {
            throw new IllegalArgumentException("LongRange.subrange(): size = " + size + " illegal");
        }
        if (0 > rank || rank >= size) {
            throw new IllegalArgumentException("LongRange.subrange(): rank = " + rank + " illegal");
        }
        LongRange result = new LongRange();
        long sublen = this.length / (long)size;
        int subrem = (int)(this.length % (long)size);
        result.lb = rank < subrem ? this.lb + (long)rank * ++sublen * this.stride : this.lb + ((long)subrem + (long)rank * sublen) * this.stride;
        result.stride = this.stride;
        result.length = sublen;
        result.setUb();
        return result;
    }

    public LongRange[] subranges(int size) {
        LongRange result_i;
        int i;
        if (size < 1) {
            throw new IllegalArgumentException("LongRange.subranges(): size = " + size + " illegal");
        }
        LongRange[] result = new LongRange[size];
        long sublen = this.length / (long)size;
        int subrem = (int)(this.length % (long)size);
        long x = this.lb;
        ++sublen;
        for (i = 0; i < subrem; ++i) {
            result_i = new LongRange();
            result_i.lb = x;
            x += sublen * this.stride;
            result_i.stride = this.stride;
            result_i.length = sublen;
            result_i.setUb();
            result[i] = result_i;
        }
        --sublen;
        for (i = subrem; i < size; ++i) {
            result_i = new LongRange();
            result_i.lb = x;
            x += sublen * this.stride;
            result_i.stride = this.stride;
            result_i.length = sublen;
            result_i.setUb();
            result[i] = result_i;
        }
        return result;
    }

    public LongRange chunk(long N1, long N2) {
        if (N1 < 0L) {
            throw new IllegalArgumentException("LongRange.chunk(): N1 = " + N1 + " illegal");
        }
        if (N2 < 0L) {
            throw new IllegalArgumentException("LongRange.chunk(): N2 = " + N2 + " illegal");
        }
        LongRange result = new LongRange();
        result.lb = this.lb + N1 * this.stride;
        result.stride = this.stride;
        result.length = Math.min(N2, Math.max(0L, this.length - N1));
        result.setUb();
        return result;
    }

    public boolean equals(Object obj) {
        return obj instanceof LongRange && this.lb == ((LongRange)obj).lb && this.stride == ((LongRange)obj).stride && this.length == ((LongRange)obj).length;
    }

    public int hashCode() {
        return (int)(((this.lb << 10) + this.stride << 10) + this.length);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.lb);
        b.append("..");
        b.append(this.ub);
        if (this.stride > 1L) {
            b.append(';');
            b.append(this.stride);
        }
        return b.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.lb);
        out.writeLong(this.stride);
        out.writeLong(this.length);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.lb = in.readLong();
        this.stride = in.readLong();
        this.length = in.readLong();
        this.setUb();
    }

    private void setUb() {
        this.ub = this.lb + (this.length - 1L) * this.stride;
    }
}

