/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.replica;

import edu.rit.mp.IntegerBuf;
import edu.rit.mp.buf.IntegerItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.reduction.IntegerOp;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class ReplicatedInteger
extends Number {
    private static final long serialVersionUID = 1L;
    private final IntegerOp myOp;
    private final AtomicInteger myValue;
    private final int myTag;
    private final Comm myComm;
    private final Receiver myReceiver;

    public ReplicatedInteger(IntegerOp op) {
        this(op, 0, 0, Comm.world());
    }

    public ReplicatedInteger(IntegerOp op, int initialValue) {
        this(op, initialValue, 0, Comm.world());
    }

    public ReplicatedInteger(IntegerOp op, int initialValue, int tag) {
        this(op, initialValue, tag, Comm.world());
    }

    public ReplicatedInteger(IntegerOp op, int initialValue, int tag, Comm comm) {
        if (op == null) {
            throw new NullPointerException("ReplicatedInteger(): op is null");
        }
        if (comm == null) {
            throw new NullPointerException("ReplicatedInteger(): comm is null");
        }
        this.myOp = op;
        this.myValue = new AtomicInteger(initialValue);
        this.myTag = tag;
        this.myComm = comm;
        this.myReceiver = new Receiver(this);
        this.myReceiver.setDaemon(true);
        this.myReceiver.start();
    }

    public int get() {
        return this.myValue.get();
    }

    public int reduce(int value) throws IOException {
        int newvalue;
        int oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = this.myValue.get(), newvalue = this.myOp.op(oldvalue, value))) {
        }
        if (newvalue != oldvalue) {
            this.myComm.floodSend(this.myTag, IntegerBuf.buffer(newvalue));
        }
        return newvalue;
    }

    public String toString() {
        return Integer.toString(this.get());
    }

    @Override
    public int intValue() {
        return this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    private class Receiver
    extends Thread {
        final /* synthetic */ ReplicatedInteger this$0;

        private Receiver(ReplicatedInteger replicatedInteger) {
            ReplicatedInteger replicatedInteger2 = replicatedInteger;
            Objects.requireNonNull(replicatedInteger2);
            this.this$0 = replicatedInteger2;
        }

        @Override
        public void run() {
            IntegerItemBuf buf = IntegerBuf.buffer();
            try {
                while (true) {
                    int newvalue;
                    int oldvalue;
                    this.this$0.myComm.floodReceive(this.this$0.myTag, buf);
                    while (!this.this$0.myValue.compareAndSet(oldvalue = this.this$0.myValue.get(), newvalue = this.this$0.myOp.op(oldvalue, buf.item))) {
                    }
                }
            }
            catch (Throwable exc) {
                exc.printStackTrace(System.err);
                return;
            }
        }
    }
}

