/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.replica;

import edu.rit.mp.BooleanBuf;
import edu.rit.mp.buf.BooleanItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.reduction.BooleanOp;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public class ReplicatedBoolean {
    private BooleanOp myOp;
    private AtomicBoolean myValue;
    private int myTag;
    private Comm myComm;
    private Receiver myReceiver;

    public ReplicatedBoolean(BooleanOp op) {
        this(op, false, 0, Comm.world());
    }

    public ReplicatedBoolean(BooleanOp op, boolean initialValue) {
        this(op, initialValue, 0, Comm.world());
    }

    public ReplicatedBoolean(BooleanOp op, boolean initialValue, int tag) {
        this(op, initialValue, tag, Comm.world());
    }

    public ReplicatedBoolean(BooleanOp op, boolean initialValue, int tag, Comm comm) {
        if (op == null) {
            throw new NullPointerException("ReplicatedBoolean(): op is null");
        }
        if (comm == null) {
            throw new NullPointerException("ReplicatedBoolean(): comm is null");
        }
        this.myOp = op;
        this.myValue = new AtomicBoolean(initialValue);
        this.myTag = tag;
        this.myComm = comm;
        this.myReceiver = new Receiver(this);
        this.myReceiver.setDaemon(true);
        this.myReceiver.start();
    }

    public boolean get() {
        return this.myValue.get();
    }

    public boolean reduce(boolean value) throws IOException {
        boolean newvalue;
        boolean oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = this.myValue.get(), newvalue = this.myOp.op(oldvalue, value))) {
        }
        if (newvalue != oldvalue) {
            this.myComm.floodSend(this.myTag, BooleanBuf.buffer(newvalue));
        }
        return newvalue;
    }

    public String toString() {
        return Boolean.toString(this.get());
    }

    private class Receiver
    extends Thread {
        final /* synthetic */ ReplicatedBoolean this$0;

        private Receiver(ReplicatedBoolean replicatedBoolean) {
            ReplicatedBoolean replicatedBoolean2 = replicatedBoolean;
            Objects.requireNonNull(replicatedBoolean2);
            this.this$0 = replicatedBoolean2;
        }

        @Override
        public void run() {
            BooleanItemBuf buf = BooleanBuf.buffer();
            try {
                while (true) {
                    boolean newvalue;
                    boolean oldvalue;
                    this.this$0.myComm.floodReceive(this.this$0.myTag, buf);
                    while (!this.this$0.myValue.compareAndSet(oldvalue = this.this$0.myValue.get(), newvalue = this.this$0.myOp.op(oldvalue, buf.item))) {
                    }
                }
            }
            catch (Throwable exc) {
                exc.printStackTrace(System.err);
                return;
            }
        }
    }
}

