/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.ShortOp;
import java.util.concurrent.atomic.AtomicInteger;

public class SharedShort
extends Number {
    private static final long serialVersionUID = 1L;
    private AtomicInteger myValue;

    public SharedShort() {
        this.myValue = new AtomicInteger();
    }

    public SharedShort(short initialValue) {
        this.myValue = new AtomicInteger(initialValue);
    }

    public short get() {
        return (short)this.myValue.get();
    }

    public void set(short value) {
        this.myValue.set(value);
    }

    public short getAndSet(short value) {
        return (short)this.myValue.getAndSet(value);
    }

    public boolean compareAndSet(short expect, short update) {
        return this.myValue.compareAndSet(expect, update);
    }

    public boolean weakCompareAndSet(short expect, short update) {
        return this.myValue.weakCompareAndSet(expect, update);
    }

    public short getAndIncrement() {
        short newvalue;
        short oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (short)this.myValue.get(), newvalue = (short)(oldvalue + 1))) {
        }
        return oldvalue;
    }

    public short getAndDecrement() {
        short newvalue;
        short oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (short)this.myValue.get(), newvalue = (short)(oldvalue - 1))) {
        }
        return oldvalue;
    }

    public short getAndAdd(short value) {
        short newvalue;
        short oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (short)this.myValue.get(), newvalue = (short)(oldvalue + value))) {
        }
        return oldvalue;
    }

    public short incrementAndGet() {
        short newvalue;
        short oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (short)this.myValue.get(), newvalue = (short)(oldvalue + 1))) {
        }
        return newvalue;
    }

    public short decrementAndGet() {
        short newvalue;
        short oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (short)this.myValue.get(), newvalue = (short)(oldvalue - 1))) {
        }
        return newvalue;
    }

    public short addAndGet(short value) {
        short newvalue;
        short oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (short)this.myValue.get(), newvalue = (short)(oldvalue + value))) {
        }
        return newvalue;
    }

    public short reduce(short value, ShortOp op) {
        short newvalue;
        short oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (short)this.myValue.get(), newvalue = op.op(oldvalue, value))) {
        }
        return newvalue;
    }

    public String toString() {
        return Integer.toString(this.get());
    }

    @Override
    public int intValue() {
        return this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }
}

