/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.IntegerOp;
import java.util.concurrent.atomic.AtomicInteger;

public class SharedInteger
extends Number {
    private static final long serialVersionUID = 1L;
    private AtomicInteger myValue;

    public SharedInteger() {
        this.myValue = new AtomicInteger();
    }

    public SharedInteger(int initialValue) {
        this.myValue = new AtomicInteger(initialValue);
    }

    public int get() {
        return this.myValue.get();
    }

    public void set(int value) {
        this.myValue.set(value);
    }

    public int getAndSet(int value) {
        return this.myValue.getAndSet(value);
    }

    public boolean compareAndSet(int expect, int update) {
        return this.myValue.compareAndSet(expect, update);
    }

    public boolean weakCompareAndSet(int expect, int update) {
        return this.myValue.weakCompareAndSet(expect, update);
    }

    public int getAndIncrement() {
        return this.myValue.getAndIncrement();
    }

    public int getAndDecrement() {
        return this.myValue.getAndDecrement();
    }

    public int getAndAdd(int value) {
        return this.myValue.getAndAdd(value);
    }

    public int incrementAndGet() {
        return this.myValue.incrementAndGet();
    }

    public int decrementAndGet() {
        return this.myValue.decrementAndGet();
    }

    public int addAndGet(int value) {
        return this.myValue.addAndGet(value);
    }

    public int reduce(int value, IntegerOp op) {
        int newvalue;
        int oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = this.myValue.get(), newvalue = op.op(oldvalue, value))) {
        }
        return newvalue;
    }

    public String toString() {
        return Integer.toString(this.get());
    }

    @Override
    public int intValue() {
        return this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }
}

