/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.FloatOp;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class SharedFloatArray {
    private AtomicIntegerArray myArray;

    public SharedFloatArray(int len) {
        this.myArray = new AtomicIntegerArray(len);
    }

    public SharedFloatArray(float[] array) {
        int n = array.length;
        int[] intarray = new int[n];
        for (int i = 0; i < n; ++i) {
            intarray[i] = Float.floatToIntBits(array[i]);
        }
        this.myArray = new AtomicIntegerArray(intarray);
    }

    public int length() {
        return this.myArray.length();
    }

    public float get(int i) {
        return Float.intBitsToFloat(this.myArray.get(i));
    }

    public void set(int i, float value) {
        this.myArray.set(i, Float.floatToIntBits(value));
    }

    public float getAndSet(int i, float value) {
        return Float.intBitsToFloat(this.myArray.getAndSet(i, Float.floatToIntBits(value)));
    }

    public boolean compareAndSet(int i, float expect, float update) {
        return this.myArray.compareAndSet(i, Float.floatToIntBits(expect), Float.floatToIntBits(update));
    }

    public boolean weakCompareAndSet(int i, float expect, float update) {
        return this.myArray.weakCompareAndSet(i, Float.floatToIntBits(expect), Float.floatToIntBits(update));
    }

    public float getAndIncrement(int i) {
        float oldvalue;
        float newvalue;
        int newvalueInt;
        int oldvalueInt;
        while (!this.myArray.compareAndSet(i, oldvalueInt = this.myArray.get(i), newvalueInt = Float.floatToIntBits(newvalue = (oldvalue = Float.intBitsToFloat(oldvalueInt)) + 1.0f))) {
        }
        return oldvalue;
    }

    public float getAndDecrement(int i) {
        float oldvalue;
        float newvalue;
        int newvalueInt;
        int oldvalueInt;
        while (!this.myArray.compareAndSet(i, oldvalueInt = this.myArray.get(i), newvalueInt = Float.floatToIntBits(newvalue = (oldvalue = Float.intBitsToFloat(oldvalueInt)) - 1.0f))) {
        }
        return oldvalue;
    }

    public float getAndAdd(int i, float value) {
        float oldvalue;
        float newvalue;
        int newvalueInt;
        int oldvalueInt;
        while (!this.myArray.compareAndSet(i, oldvalueInt = this.myArray.get(i), newvalueInt = Float.floatToIntBits(newvalue = (oldvalue = Float.intBitsToFloat(oldvalueInt)) + value))) {
        }
        return oldvalue;
    }

    public float incrementAndGet(int i) {
        float oldvalue;
        float newvalue;
        int newvalueInt;
        int oldvalueInt;
        while (!this.myArray.compareAndSet(i, oldvalueInt = this.myArray.get(i), newvalueInt = Float.floatToIntBits(newvalue = (oldvalue = Float.intBitsToFloat(oldvalueInt)) + 1.0f))) {
        }
        return newvalue;
    }

    public float decrementAndGet(int i) {
        float oldvalue;
        float newvalue;
        int newvalueInt;
        int oldvalueInt;
        while (!this.myArray.compareAndSet(i, oldvalueInt = this.myArray.get(i), newvalueInt = Float.floatToIntBits(newvalue = (oldvalue = Float.intBitsToFloat(oldvalueInt)) - 1.0f))) {
        }
        return newvalue;
    }

    public float addAndGet(int i, float value) {
        float oldvalue;
        float newvalue;
        int newvalueInt;
        int oldvalueInt;
        while (!this.myArray.compareAndSet(i, oldvalueInt = this.myArray.get(i), newvalueInt = Float.floatToIntBits(newvalue = (oldvalue = Float.intBitsToFloat(oldvalueInt)) + value))) {
        }
        return newvalue;
    }

    public float reduce(int i, float value, FloatOp op) {
        float oldvalue;
        float newvalue;
        int newvalueInt;
        int oldvalueInt;
        while (!this.myArray.compareAndSet(i, oldvalueInt = this.myArray.get(i), newvalueInt = Float.floatToIntBits(newvalue = op.op(oldvalue = Float.intBitsToFloat(oldvalueInt), value)))) {
        }
        return newvalue;
    }

    public void reduce(float[] src, FloatOp op) {
        this.reduce(0, src, 0, this.myArray.length(), op);
    }

    public void reduce(int dstoff, float[] src, int srcoff, int len, FloatOp op) {
        if (len < 0 || dstoff < 0 || dstoff + len > this.myArray.length() || srcoff < 0 || srcoff + len > src.length) {
            throw new IndexOutOfBoundsException();
        }
        while (len > 0) {
            float oldvalue;
            float newvalue;
            int newvalueInt;
            int oldvalueInt;
            while (!this.myArray.compareAndSet(dstoff, oldvalueInt = this.myArray.get(dstoff), newvalueInt = Float.floatToIntBits(newvalue = op.op(oldvalue = Float.intBitsToFloat(oldvalueInt), src[srcoff])))) {
            }
            ++dstoff;
            ++srcoff;
            --len;
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('[');
        int n = this.myArray.length();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(this.get(i));
        }
        b.append(']');
        return b.toString();
    }
}

