/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.BooleanOp;
import edu.rit.pj.reduction.ByteOp;
import edu.rit.pj.reduction.CharacterOp;
import edu.rit.pj.reduction.DoubleOp;
import edu.rit.pj.reduction.FloatOp;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.LongOp;
import edu.rit.pj.reduction.ObjectOp;
import edu.rit.pj.reduction.ShortOp;
import edu.rit.util.Range;

public class ReduceArrays {
    private ReduceArrays() {
    }

    public static void reduce(boolean[] src, Range srcRange, boolean[] dst, Range dstRange, BooleanOp op) {
        block6: {
            int dstUpper;
            int srcUpper;
            int dstStride;
            int srcStride;
            int dstLower;
            int srcLower;
            block5: {
                int len = Math.min(srcRange.length(), dstRange.length());
                if (len == 0) {
                    return;
                }
                srcLower = srcRange.lb();
                dstLower = dstRange.lb();
                srcStride = srcRange.stride();
                dstStride = dstRange.stride();
                srcUpper = srcLower + (len - 1) * srcStride;
                dstUpper = dstLower + (len - 1) * dstStride;
                if (0 > srcLower || srcUpper >= src.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): src indexes = 0.." + (src.length - 1) + ", srcRange = " + String.valueOf(srcRange));
                }
                if (0 > dstLower || dstUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): dst indexes = 0.." + (dst.length - 1) + ", dstRange = " + String.valueOf(dstRange));
                }
                if (src == dst && srcLower <= dstLower) break block5;
                int i = srcLower;
                int j = dstLower;
                while (i <= srcUpper) {
                    dst[j] = op.op(dst[j], src[i]);
                    i += srcStride;
                    j += dstStride;
                }
                break block6;
            }
            if (srcLower >= dstLower) break block6;
            int i = srcUpper;
            int j = dstUpper;
            while (i >= srcLower) {
                dst[j] = op.op(dst[j], src[i]);
                i -= srcStride;
                j -= dstStride;
            }
        }
    }

    public static void reduce(byte[] src, Range srcRange, byte[] dst, Range dstRange, ByteOp op) {
        block6: {
            int dstUpper;
            int srcUpper;
            int dstStride;
            int srcStride;
            int dstLower;
            int srcLower;
            block5: {
                int len = Math.min(srcRange.length(), dstRange.length());
                if (len == 0) {
                    return;
                }
                srcLower = srcRange.lb();
                dstLower = dstRange.lb();
                srcStride = srcRange.stride();
                dstStride = dstRange.stride();
                srcUpper = srcLower + (len - 1) * srcStride;
                dstUpper = dstLower + (len - 1) * dstStride;
                if (0 > srcLower || srcUpper >= src.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): src indexes = 0.." + (src.length - 1) + ", srcRange = " + String.valueOf(srcRange));
                }
                if (0 > dstLower || dstUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): dst indexes = 0.." + (dst.length - 1) + ", dstRange = " + String.valueOf(dstRange));
                }
                if (src == dst && srcLower <= dstLower) break block5;
                int i = srcLower;
                int j = dstLower;
                while (i <= srcUpper) {
                    dst[j] = op.op(dst[j], src[i]);
                    i += srcStride;
                    j += dstStride;
                }
                break block6;
            }
            if (srcLower >= dstLower) break block6;
            int i = srcUpper;
            int j = dstUpper;
            while (i >= srcLower) {
                dst[j] = op.op(dst[j], src[i]);
                i -= srcStride;
                j -= dstStride;
            }
        }
    }

    public static void reduce(char[] src, Range srcRange, char[] dst, Range dstRange, CharacterOp op) {
        block6: {
            int dstUpper;
            int srcUpper;
            int dstStride;
            int srcStride;
            int dstLower;
            int srcLower;
            block5: {
                int len = Math.min(srcRange.length(), dstRange.length());
                if (len == 0) {
                    return;
                }
                srcLower = srcRange.lb();
                dstLower = dstRange.lb();
                srcStride = srcRange.stride();
                dstStride = dstRange.stride();
                srcUpper = srcLower + (len - 1) * srcStride;
                dstUpper = dstLower + (len - 1) * dstStride;
                if (0 > srcLower || srcUpper >= src.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): src indexes = 0.." + (src.length - 1) + ", srcRange = " + String.valueOf(srcRange));
                }
                if (0 > dstLower || dstUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): dst indexes = 0.." + (dst.length - 1) + ", dstRange = " + String.valueOf(dstRange));
                }
                if (src == dst && srcLower <= dstLower) break block5;
                int i = srcLower;
                int j = dstLower;
                while (i <= srcUpper) {
                    dst[j] = op.op(dst[j], src[i]);
                    i += srcStride;
                    j += dstStride;
                }
                break block6;
            }
            if (srcLower >= dstLower) break block6;
            int i = srcUpper;
            int j = dstUpper;
            while (i >= srcLower) {
                dst[j] = op.op(dst[j], src[i]);
                i -= srcStride;
                j -= dstStride;
            }
        }
    }

    public static void reduce(double[] src, Range srcRange, double[] dst, Range dstRange, DoubleOp op) {
        block6: {
            int dstUpper;
            int srcUpper;
            int dstStride;
            int srcStride;
            int dstLower;
            int srcLower;
            block5: {
                int len = Math.min(srcRange.length(), dstRange.length());
                if (len == 0) {
                    return;
                }
                srcLower = srcRange.lb();
                dstLower = dstRange.lb();
                srcStride = srcRange.stride();
                dstStride = dstRange.stride();
                srcUpper = srcLower + (len - 1) * srcStride;
                dstUpper = dstLower + (len - 1) * dstStride;
                if (0 > srcLower || srcUpper >= src.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): src indexes = 0.." + (src.length - 1) + ", srcRange = " + String.valueOf(srcRange));
                }
                if (0 > dstLower || dstUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): dst indexes = 0.." + (dst.length - 1) + ", dstRange = " + String.valueOf(dstRange));
                }
                if (src == dst && srcLower <= dstLower) break block5;
                int i = srcLower;
                int j = dstLower;
                while (i <= srcUpper) {
                    dst[j] = op.op(dst[j], src[i]);
                    i += srcStride;
                    j += dstStride;
                }
                break block6;
            }
            if (srcLower >= dstLower) break block6;
            int i = srcUpper;
            int j = dstUpper;
            while (i >= srcLower) {
                dst[j] = op.op(dst[j], src[i]);
                i -= srcStride;
                j -= dstStride;
            }
        }
    }

    public static void reduce(float[] src, Range srcRange, float[] dst, Range dstRange, FloatOp op) {
        block6: {
            int dstUpper;
            int srcUpper;
            int dstStride;
            int srcStride;
            int dstLower;
            int srcLower;
            block5: {
                int len = Math.min(srcRange.length(), dstRange.length());
                if (len == 0) {
                    return;
                }
                srcLower = srcRange.lb();
                dstLower = dstRange.lb();
                srcStride = srcRange.stride();
                dstStride = dstRange.stride();
                srcUpper = srcLower + (len - 1) * srcStride;
                dstUpper = dstLower + (len - 1) * dstStride;
                if (0 > srcLower || srcUpper >= src.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): src indexes = 0.." + (src.length - 1) + ", srcRange = " + String.valueOf(srcRange));
                }
                if (0 > dstLower || dstUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): dst indexes = 0.." + (dst.length - 1) + ", dstRange = " + String.valueOf(dstRange));
                }
                if (src == dst && srcLower <= dstLower) break block5;
                int i = srcLower;
                int j = dstLower;
                while (i <= srcUpper) {
                    dst[j] = op.op(dst[j], src[i]);
                    i += srcStride;
                    j += dstStride;
                }
                break block6;
            }
            if (srcLower >= dstLower) break block6;
            int i = srcUpper;
            int j = dstUpper;
            while (i >= srcLower) {
                dst[j] = op.op(dst[j], src[i]);
                i -= srcStride;
                j -= dstStride;
            }
        }
    }

    public static void reduce(int[] src, Range srcRange, int[] dst, Range dstRange, IntegerOp op) {
        block6: {
            int dstUpper;
            int srcUpper;
            int dstStride;
            int srcStride;
            int dstLower;
            int srcLower;
            block5: {
                int len = Math.min(srcRange.length(), dstRange.length());
                if (len == 0) {
                    return;
                }
                srcLower = srcRange.lb();
                dstLower = dstRange.lb();
                srcStride = srcRange.stride();
                dstStride = dstRange.stride();
                srcUpper = srcLower + (len - 1) * srcStride;
                dstUpper = dstLower + (len - 1) * dstStride;
                if (0 > srcLower || srcUpper >= src.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): src indexes = 0.." + (src.length - 1) + ", srcRange = " + String.valueOf(srcRange));
                }
                if (0 > dstLower || dstUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): dst indexes = 0.." + (dst.length - 1) + ", dstRange = " + String.valueOf(dstRange));
                }
                if (src == dst && srcLower <= dstLower) break block5;
                int i = srcLower;
                int j = dstLower;
                while (i <= srcUpper) {
                    dst[j] = op.op(dst[j], src[i]);
                    i += srcStride;
                    j += dstStride;
                }
                break block6;
            }
            if (srcLower >= dstLower) break block6;
            int i = srcUpper;
            int j = dstUpper;
            while (i >= srcLower) {
                dst[j] = op.op(dst[j], src[i]);
                i -= srcStride;
                j -= dstStride;
            }
        }
    }

    public static void reduce(long[] src, Range srcRange, long[] dst, Range dstRange, LongOp op) {
        block6: {
            int dstUpper;
            int srcUpper;
            int dstStride;
            int srcStride;
            int dstLower;
            int srcLower;
            block5: {
                int len = Math.min(srcRange.length(), dstRange.length());
                if (len == 0) {
                    return;
                }
                srcLower = srcRange.lb();
                dstLower = dstRange.lb();
                srcStride = srcRange.stride();
                dstStride = dstRange.stride();
                srcUpper = srcLower + (len - 1) * srcStride;
                dstUpper = dstLower + (len - 1) * dstStride;
                if (0 > srcLower || srcUpper >= src.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): src indexes = 0.." + (src.length - 1) + ", srcRange = " + String.valueOf(srcRange));
                }
                if (0 > dstLower || dstUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): dst indexes = 0.." + (dst.length - 1) + ", dstRange = " + String.valueOf(dstRange));
                }
                if (src == dst && srcLower <= dstLower) break block5;
                int i = srcLower;
                int j = dstLower;
                while (i <= srcUpper) {
                    dst[j] = op.op(dst[j], src[i]);
                    i += srcStride;
                    j += dstStride;
                }
                break block6;
            }
            if (srcLower >= dstLower) break block6;
            int i = srcUpper;
            int j = dstUpper;
            while (i >= srcLower) {
                dst[j] = op.op(dst[j], src[i]);
                i -= srcStride;
                j -= dstStride;
            }
        }
    }

    public static void reduce(short[] src, Range srcRange, short[] dst, Range dstRange, ShortOp op) {
        block6: {
            int dstUpper;
            int srcUpper;
            int dstStride;
            int srcStride;
            int dstLower;
            int srcLower;
            block5: {
                int len = Math.min(srcRange.length(), dstRange.length());
                if (len == 0) {
                    return;
                }
                srcLower = srcRange.lb();
                dstLower = dstRange.lb();
                srcStride = srcRange.stride();
                dstStride = dstRange.stride();
                srcUpper = srcLower + (len - 1) * srcStride;
                dstUpper = dstLower + (len - 1) * dstStride;
                if (0 > srcLower || srcUpper >= src.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): src indexes = 0.." + (src.length - 1) + ", srcRange = " + String.valueOf(srcRange));
                }
                if (0 > dstLower || dstUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): dst indexes = 0.." + (dst.length - 1) + ", dstRange = " + String.valueOf(dstRange));
                }
                if (src == dst && srcLower <= dstLower) break block5;
                int i = srcLower;
                int j = dstLower;
                while (i <= srcUpper) {
                    dst[j] = op.op(dst[j], src[i]);
                    i += srcStride;
                    j += dstStride;
                }
                break block6;
            }
            if (srcLower >= dstLower) break block6;
            int i = srcUpper;
            int j = dstUpper;
            while (i >= srcLower) {
                dst[j] = op.op(dst[j], src[i]);
                i -= srcStride;
                j -= dstStride;
            }
        }
    }

    public static <DT, ST extends DT> void reduce(ST[] src, Range srcRange, DT[] dst, Range dstRange, ObjectOp<DT> op) {
        block6: {
            int dstUpper;
            int srcUpper;
            int dstStride;
            int srcStride;
            int dstLower;
            int srcLower;
            block5: {
                int len = Math.min(srcRange.length(), dstRange.length());
                if (len == 0) {
                    return;
                }
                srcLower = srcRange.lb();
                dstLower = dstRange.lb();
                srcStride = srcRange.stride();
                dstStride = dstRange.stride();
                srcUpper = srcLower + (len - 1) * srcStride;
                dstUpper = dstLower + (len - 1) * dstStride;
                if (0 > srcLower || srcUpper >= src.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): src indexes = 0.." + (src.length - 1) + ", srcRange = " + String.valueOf(srcRange));
                }
                if (0 > dstLower || dstUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): dst indexes = 0.." + (dst.length - 1) + ", dstRange = " + String.valueOf(dstRange));
                }
                if (src == dst && srcLower <= dstLower) break block5;
                int i = srcLower;
                int j = dstLower;
                while (i <= srcUpper) {
                    dst[j] = op.op(dst[j], src[i]);
                    i += srcStride;
                    j += dstStride;
                }
                break block6;
            }
            if (srcLower >= dstLower) break block6;
            int i = srcUpper;
            int j = dstUpper;
            while (i >= srcLower) {
                dst[j] = op.op(dst[j], src[i]);
                i -= srcStride;
                j -= dstStride;
            }
        }
    }

    public static void reduce(boolean[][] src, Range srcRowRange, Range srcColRange, boolean[][] dst, Range dstRowRange, Range dstColRange, BooleanOp op) {
        block6: {
            int dstRowUpper;
            int srcRowUpper;
            int dstRowStride;
            int srcRowStride;
            int dstRowLower;
            int srcRowLower;
            block5: {
                int len = Math.min(srcRowRange.length(), dstRowRange.length());
                if (len == 0) {
                    return;
                }
                srcRowLower = srcRowRange.lb();
                dstRowLower = dstRowRange.lb();
                srcRowStride = srcRowRange.stride();
                dstRowStride = dstRowRange.stride();
                srcRowUpper = srcRowLower + (len - 1) * srcRowStride;
                dstRowUpper = dstRowLower + (len - 1) * dstRowStride;
                if (0 > srcRowLower || srcRowUpper >= src.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): src row indexes = 0.." + (src.length - 1) + ", srcRowRange = " + String.valueOf(srcRowRange));
                }
                if (0 > dstRowLower || dstRowUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): dst row indexes = 0.." + (dst.length - 1) + ", dstRowRange = " + String.valueOf(dstRowRange));
                }
                if (src == dst && srcRowLower <= dstRowLower) break block5;
                int i = srcRowLower;
                int j = dstRowLower;
                while (i <= srcRowUpper) {
                    ReduceArrays.reduce(src[i], srcColRange, dst[j], dstColRange, op);
                    i += srcRowStride;
                    j += dstRowStride;
                }
                break block6;
            }
            if (srcRowLower >= dstRowLower) break block6;
            int i = srcRowUpper;
            int j = dstRowUpper;
            while (i >= srcRowLower) {
                ReduceArrays.reduce(src[i], srcColRange, dst[j], dstColRange, op);
                i -= srcRowStride;
                j -= dstRowStride;
            }
        }
    }

    public static void reduce(byte[][] src, Range srcRowRange, Range srcColRange, byte[][] dst, Range dstRowRange, Range dstColRange, ByteOp op) {
        block6: {
            int dstRowUpper;
            int srcRowUpper;
            int dstRowStride;
            int srcRowStride;
            int dstRowLower;
            int srcRowLower;
            block5: {
                int len = Math.min(srcRowRange.length(), dstRowRange.length());
                if (len == 0) {
                    return;
                }
                srcRowLower = srcRowRange.lb();
                dstRowLower = dstRowRange.lb();
                srcRowStride = srcRowRange.stride();
                dstRowStride = dstRowRange.stride();
                srcRowUpper = srcRowLower + (len - 1) * srcRowStride;
                dstRowUpper = dstRowLower + (len - 1) * dstRowStride;
                if (0 > srcRowLower || srcRowUpper >= src.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): src row indexes = 0.." + (src.length - 1) + ", srcRowRange = " + String.valueOf(srcRowRange));
                }
                if (0 > dstRowLower || dstRowUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): dst row indexes = 0.." + (dst.length - 1) + ", dstRowRange = " + String.valueOf(dstRowRange));
                }
                if (src == dst && srcRowLower <= dstRowLower) break block5;
                int i = srcRowLower;
                int j = dstRowLower;
                while (i <= srcRowUpper) {
                    ReduceArrays.reduce(src[i], srcColRange, dst[j], dstColRange, op);
                    i += srcRowStride;
                    j += dstRowStride;
                }
                break block6;
            }
            if (srcRowLower >= dstRowLower) break block6;
            int i = srcRowUpper;
            int j = dstRowUpper;
            while (i >= srcRowLower) {
                ReduceArrays.reduce(src[i], srcColRange, dst[j], dstColRange, op);
                i -= srcRowStride;
                j -= dstRowStride;
            }
        }
    }

    public static void reduce(char[][] src, Range srcRowRange, Range srcColRange, char[][] dst, Range dstRowRange, Range dstColRange, CharacterOp op) {
        block6: {
            int dstRowUpper;
            int srcRowUpper;
            int dstRowStride;
            int srcRowStride;
            int dstRowLower;
            int srcRowLower;
            block5: {
                int len = Math.min(srcRowRange.length(), dstRowRange.length());
                if (len == 0) {
                    return;
                }
                srcRowLower = srcRowRange.lb();
                dstRowLower = dstRowRange.lb();
                srcRowStride = srcRowRange.stride();
                dstRowStride = dstRowRange.stride();
                srcRowUpper = srcRowLower + (len - 1) * srcRowStride;
                dstRowUpper = dstRowLower + (len - 1) * dstRowStride;
                if (0 > srcRowLower || srcRowUpper >= src.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): src row indexes = 0.." + (src.length - 1) + ", srcRowRange = " + String.valueOf(srcRowRange));
                }
                if (0 > dstRowLower || dstRowUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): dst row indexes = 0.." + (dst.length - 1) + ", dstRowRange = " + String.valueOf(dstRowRange));
                }
                if (src == dst && srcRowLower <= dstRowLower) break block5;
                int i = srcRowLower;
                int j = dstRowLower;
                while (i <= srcRowUpper) {
                    ReduceArrays.reduce(src[i], srcColRange, dst[j], dstColRange, op);
                    i += srcRowStride;
                    j += dstRowStride;
                }
                break block6;
            }
            if (srcRowLower >= dstRowLower) break block6;
            int i = srcRowUpper;
            int j = dstRowUpper;
            while (i >= srcRowLower) {
                ReduceArrays.reduce(src[i], srcColRange, dst[j], dstColRange, op);
                i -= srcRowStride;
                j -= dstRowStride;
            }
        }
    }

    public static void reduce(double[][] src, Range srcRowRange, Range srcColRange, double[][] dst, Range dstRowRange, Range dstColRange, DoubleOp op) {
        block6: {
            int dstRowUpper;
            int srcRowUpper;
            int dstRowStride;
            int srcRowStride;
            int dstRowLower;
            int srcRowLower;
            block5: {
                int len = Math.min(srcRowRange.length(), dstRowRange.length());
                if (len == 0) {
                    return;
                }
                srcRowLower = srcRowRange.lb();
                dstRowLower = dstRowRange.lb();
                srcRowStride = srcRowRange.stride();
                dstRowStride = dstRowRange.stride();
                srcRowUpper = srcRowLower + (len - 1) * srcRowStride;
                dstRowUpper = dstRowLower + (len - 1) * dstRowStride;
                if (0 > srcRowLower || srcRowUpper >= src.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): src row indexes = 0.." + (src.length - 1) + ", srcRowRange = " + String.valueOf(srcRowRange));
                }
                if (0 > dstRowLower || dstRowUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): dst row indexes = 0.." + (dst.length - 1) + ", dstRowRange = " + String.valueOf(dstRowRange));
                }
                if (src == dst && srcRowLower <= dstRowLower) break block5;
                int i = srcRowLower;
                int j = dstRowLower;
                while (i <= srcRowUpper) {
                    ReduceArrays.reduce(src[i], srcColRange, dst[j], dstColRange, op);
                    i += srcRowStride;
                    j += dstRowStride;
                }
                break block6;
            }
            if (srcRowLower >= dstRowLower) break block6;
            int i = srcRowUpper;
            int j = dstRowUpper;
            while (i >= srcRowLower) {
                ReduceArrays.reduce(src[i], srcColRange, dst[j], dstColRange, op);
                i -= srcRowStride;
                j -= dstRowStride;
            }
        }
    }

    public static void reduce(float[][] src, Range srcRowRange, Range srcColRange, float[][] dst, Range dstRowRange, Range dstColRange, FloatOp op) {
        block6: {
            int dstRowUpper;
            int srcRowUpper;
            int dstRowStride;
            int srcRowStride;
            int dstRowLower;
            int srcRowLower;
            block5: {
                int len = Math.min(srcRowRange.length(), dstRowRange.length());
                if (len == 0) {
                    return;
                }
                srcRowLower = srcRowRange.lb();
                dstRowLower = dstRowRange.lb();
                srcRowStride = srcRowRange.stride();
                dstRowStride = dstRowRange.stride();
                srcRowUpper = srcRowLower + (len - 1) * srcRowStride;
                dstRowUpper = dstRowLower + (len - 1) * dstRowStride;
                if (0 > srcRowLower || srcRowUpper >= src.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): src row indexes = 0.." + (src.length - 1) + ", srcRowRange = " + String.valueOf(srcRowRange));
                }
                if (0 > dstRowLower || dstRowUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): dst row indexes = 0.." + (dst.length - 1) + ", dstRowRange = " + String.valueOf(dstRowRange));
                }
                if (src == dst && srcRowLower <= dstRowLower) break block5;
                int i = srcRowLower;
                int j = dstRowLower;
                while (i <= srcRowUpper) {
                    ReduceArrays.reduce(src[i], srcColRange, dst[j], dstColRange, op);
                    i += srcRowStride;
                    j += dstRowStride;
                }
                break block6;
            }
            if (srcRowLower >= dstRowLower) break block6;
            int i = srcRowUpper;
            int j = dstRowUpper;
            while (i >= srcRowLower) {
                ReduceArrays.reduce(src[i], srcColRange, dst[j], dstColRange, op);
                i -= srcRowStride;
                j -= dstRowStride;
            }
        }
    }

    public static void reduce(int[][] src, Range srcRowRange, Range srcColRange, int[][] dst, Range dstRowRange, Range dstColRange, IntegerOp op) {
        block6: {
            int dstRowUpper;
            int srcRowUpper;
            int dstRowStride;
            int srcRowStride;
            int dstRowLower;
            int srcRowLower;
            block5: {
                int len = Math.min(srcRowRange.length(), dstRowRange.length());
                if (len == 0) {
                    return;
                }
                srcRowLower = srcRowRange.lb();
                dstRowLower = dstRowRange.lb();
                srcRowStride = srcRowRange.stride();
                dstRowStride = dstRowRange.stride();
                srcRowUpper = srcRowLower + (len - 1) * srcRowStride;
                dstRowUpper = dstRowLower + (len - 1) * dstRowStride;
                if (0 > srcRowLower || srcRowUpper >= src.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): src row indexes = 0.." + (src.length - 1) + ", srcRowRange = " + String.valueOf(srcRowRange));
                }
                if (0 > dstRowLower || dstRowUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): dst row indexes = 0.." + (dst.length - 1) + ", dstRowRange = " + String.valueOf(dstRowRange));
                }
                if (src == dst && srcRowLower <= dstRowLower) break block5;
                int i = srcRowLower;
                int j = dstRowLower;
                while (i <= srcRowUpper) {
                    ReduceArrays.reduce(src[i], srcColRange, dst[j], dstColRange, op);
                    i += srcRowStride;
                    j += dstRowStride;
                }
                break block6;
            }
            if (srcRowLower >= dstRowLower) break block6;
            int i = srcRowUpper;
            int j = dstRowUpper;
            while (i >= srcRowLower) {
                ReduceArrays.reduce(src[i], srcColRange, dst[j], dstColRange, op);
                i -= srcRowStride;
                j -= dstRowStride;
            }
        }
    }

    public static void reduce(long[][] src, Range srcRowRange, Range srcColRange, long[][] dst, Range dstRowRange, Range dstColRange, LongOp op) {
        block6: {
            int dstRowUpper;
            int srcRowUpper;
            int dstRowStride;
            int srcRowStride;
            int dstRowLower;
            int srcRowLower;
            block5: {
                int len = Math.min(srcRowRange.length(), dstRowRange.length());
                if (len == 0) {
                    return;
                }
                srcRowLower = srcRowRange.lb();
                dstRowLower = dstRowRange.lb();
                srcRowStride = srcRowRange.stride();
                dstRowStride = dstRowRange.stride();
                srcRowUpper = srcRowLower + (len - 1) * srcRowStride;
                dstRowUpper = dstRowLower + (len - 1) * dstRowStride;
                if (0 > srcRowLower || srcRowUpper >= src.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): src row indexes = 0.." + (src.length - 1) + ", srcRowRange = " + String.valueOf(srcRowRange));
                }
                if (0 > dstRowLower || dstRowUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): dst row indexes = 0.." + (dst.length - 1) + ", dstRowRange = " + String.valueOf(dstRowRange));
                }
                if (src == dst && srcRowLower <= dstRowLower) break block5;
                int i = srcRowLower;
                int j = dstRowLower;
                while (i <= srcRowUpper) {
                    ReduceArrays.reduce(src[i], srcColRange, dst[j], dstColRange, op);
                    i += srcRowStride;
                    j += dstRowStride;
                }
                break block6;
            }
            if (srcRowLower >= dstRowLower) break block6;
            int i = srcRowUpper;
            int j = dstRowUpper;
            while (i >= srcRowLower) {
                ReduceArrays.reduce(src[i], srcColRange, dst[j], dstColRange, op);
                i -= srcRowStride;
                j -= dstRowStride;
            }
        }
    }

    public static void reduce(short[][] src, Range srcRowRange, Range srcColRange, short[][] dst, Range dstRowRange, Range dstColRange, ShortOp op) {
        block6: {
            int dstRowUpper;
            int srcRowUpper;
            int dstRowStride;
            int srcRowStride;
            int dstRowLower;
            int srcRowLower;
            block5: {
                int len = Math.min(srcRowRange.length(), dstRowRange.length());
                if (len == 0) {
                    return;
                }
                srcRowLower = srcRowRange.lb();
                dstRowLower = dstRowRange.lb();
                srcRowStride = srcRowRange.stride();
                dstRowStride = dstRowRange.stride();
                srcRowUpper = srcRowLower + (len - 1) * srcRowStride;
                dstRowUpper = dstRowLower + (len - 1) * dstRowStride;
                if (0 > srcRowLower || srcRowUpper >= src.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): src row indexes = 0.." + (src.length - 1) + ", srcRowRange = " + String.valueOf(srcRowRange));
                }
                if (0 > dstRowLower || dstRowUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): dst row indexes = 0.." + (dst.length - 1) + ", dstRowRange = " + String.valueOf(dstRowRange));
                }
                if (src == dst && srcRowLower <= dstRowLower) break block5;
                int i = srcRowLower;
                int j = dstRowLower;
                while (i <= srcRowUpper) {
                    ReduceArrays.reduce(src[i], srcColRange, dst[j], dstColRange, op);
                    i += srcRowStride;
                    j += dstRowStride;
                }
                break block6;
            }
            if (srcRowLower >= dstRowLower) break block6;
            int i = srcRowUpper;
            int j = dstRowUpper;
            while (i >= srcRowLower) {
                ReduceArrays.reduce(src[i], srcColRange, dst[j], dstColRange, op);
                i -= srcRowStride;
                j -= dstRowStride;
            }
        }
    }

    public static <DT, ST extends DT> void reduce(ST[][] src, Range srcRowRange, Range srcColRange, DT[][] dst, Range dstRowRange, Range dstColRange, ObjectOp<DT> op) {
        block6: {
            int dstRowUpper;
            int srcRowUpper;
            int dstRowStride;
            int srcRowStride;
            int dstRowLower;
            int srcRowLower;
            block5: {
                int len = Math.min(srcRowRange.length(), dstRowRange.length());
                if (len == 0) {
                    return;
                }
                srcRowLower = srcRowRange.lb();
                dstRowLower = dstRowRange.lb();
                srcRowStride = srcRowRange.stride();
                dstRowStride = dstRowRange.stride();
                srcRowUpper = srcRowLower + (len - 1) * srcRowStride;
                dstRowUpper = dstRowLower + (len - 1) * dstRowStride;
                if (0 > srcRowLower || srcRowUpper >= src.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): src row indexes = 0.." + (src.length - 1) + ", srcRowRange = " + String.valueOf(srcRowRange));
                }
                if (0 > dstRowLower || dstRowUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("ReduceArrays.reduce(): dst row indexes = 0.." + (dst.length - 1) + ", dstRowRange = " + String.valueOf(dstRowRange));
                }
                if (src == dst && srcRowLower <= dstRowLower) break block5;
                int i = srcRowLower;
                int j = dstRowLower;
                while (i <= srcRowUpper) {
                    ReduceArrays.reduce(src[i], srcColRange, dst[j], dstColRange, op);
                    i += srcRowStride;
                    j += dstRowStride;
                }
                break block6;
            }
            if (srcRowLower >= dstRowLower) break block6;
            int i = srcRowUpper;
            int j = dstRowUpper;
            while (i >= srcRowLower) {
                ReduceArrays.reduce(src[i], srcColRange, dst[j], dstColRange, op);
                i -= srcRowStride;
                j -= dstRowStride;
            }
        }
    }
}

