/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.job;

import edu.rit.mp.BooleanBuf;
import edu.rit.mp.buf.BooleanItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.WorkerIteration;
import edu.rit.pj.WorkerRegion;
import edu.rit.pj.WorkerTeam;
import edu.rit.pj.job.Job;
import edu.rit.pj.job.JobGenerator;
import edu.rit.util.Instance;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Scanner;

public class Runner {
    private static PrintStream stdout = System.out;
    private static PrintStream stderr = System.err;
    private static Comm world;
    private static int rank;
    private static WorkerTeam team;
    private static String generatorExpression;
    private static HashSet<Integer> omitted;
    private static JobGenerator generator;

    private Runner() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            Runner.usage();
        }
        Comm.init(args);
        world = Comm.world();
        rank = world.rank();
        team = new WorkerTeam();
        if (rank == team.masterRank()) {
            omitted = new HashSet();
            Scanner scanner = null;
            try {
                scanner = new Scanner(new File(args[0]));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (scanner != null) {
                while (scanner.hasNextLine()) {
                    String word;
                    Scanner linescanner = new Scanner(scanner.nextLine());
                    if (!linescanner.hasNext() || !(word = linescanner.next()).equals("***") || !linescanner.hasNext()) continue;
                    word = linescanner.next();
                    if (word.equals("Generator")) {
                        if (!linescanner.hasNext() || generatorExpression != null) continue;
                        generatorExpression = linescanner.next();
                        continue;
                    }
                    if (!word.equals("Job") || !linescanner.hasNextInt()) continue;
                    int jobnum = linescanner.nextInt();
                    if (!linescanner.hasNext() || !(word = linescanner.next()).equals("finished")) continue;
                    omitted.add(jobnum);
                }
                scanner.close();
            } else {
                generatorExpression = args[0];
            }
            if (generatorExpression == null) {
                stderr.printf("Runner: No job generator in checkpoint file %s%n", args[0]);
            } else {
                try {
                    generator = (JobGenerator)Instance.newInstance(generatorExpression);
                    stdout.printf("*** Generator %s%n", generatorExpression);
                    generator.omit(omitted);
                }
                catch (Throwable exc) {
                    stderr.printf("Runner: Could not create job generator %s%n", generatorExpression);
                    exc.printStackTrace(stderr);
                }
            }
        }
        BooleanItemBuf buf = BooleanBuf.buffer(generator != null);
        world.broadcast(team.masterRank(), buf);
        if (!buf.item) {
            System.exit(1);
        }
        team.execute(new WorkerRegion(){

            @Override
            public void run() throws Exception {
                this.execute(generator, new WorkerIteration<Job>(this){
                    {
                        Objects.requireNonNull(this$0);
                    }

                    @Override
                    public void sendTaskInput(Job job, Comm comm, int wRank, int tag) {
                        stdout.printf("*** Job %d started %s %s%n", job.getJobNumber(), new Date(), job.getDescription());
                    }

                    @Override
                    public void run(Job job) {
                        job.run();
                    }

                    @Override
                    public void receiveTaskOutput(Job job, Comm comm, int wRank, int tag) {
                        stdout.printf("*** Job %d finished %s%n", job.getJobNumber(), new Date());
                    }
                });
            }
        });
        if (rank == team.masterRank()) {
            stdout.printf("*** All jobs finished%n", new Object[0]);
        }
    }

    private static void usage() {
        stderr.println("Usage: java edu.rit.pj.job.Runner {<generator>|<file>}");
        stderr.println("<generator> = Job generator constructor expression");
        stderr.println("<file> = Checkpoint file name");
        System.exit(1);
    }
}

